/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.risksetting;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeBaseDataFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.data.rsa.formplugin.helper.ComboItemHelper;
import kd.data.rsa.formplugin.helper.FilterConditionHelper;
import kd.data.rsa.formplugin.risksetting.RiskGroupTreeListPlugin;
import kd.data.rsa.helper.OrgHelper;

public class RiskWorkList
extends RiskGroupTreeListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        String fieldName;
        super.filterContainerInit(args);
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        List schemeFilterColumnList = args.getFilterContainerInitEvent().getSchemeFilterColumns();
        List itemViewPerIds = OrgHelper.getPermOrgList((String)"rsa_riskwork", (String)"47150e89000000ac");
        Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)itemViewPerIds)});
        Map riskLevelMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_risklevel", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("apprange", "like", (Object)"%,2,%").and("enable", "=", (Object)"1")});
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilterColumn;
            List<ComboItem> comboItems;
            fieldName = filterColumn.getFieldName();
            if ("responsibledep.name".equals(fieldName)) {
                comboItems = ComboItemHelper.createComboItemList(orgMap.values());
                commonFilterColumn = (CommonFilterColumn)filterColumn;
                commonFilterColumn.setComboItems(comboItems);
            }
            if (!"risklevelid.name".equals(fieldName)) continue;
            comboItems = ComboItemHelper.createComboItemList(riskLevelMap.values());
            commonFilterColumn = (CommonFilterColumn)filterColumn;
            commonFilterColumn.setComboItems(comboItems);
        }
        for (FilterColumn filterColumn : schemeFilterColumnList) {
            fieldName = filterColumn.getFieldName();
            if (!"responsibledep.name".equals(fieldName)) continue;
            List<String> idStrList = orgMap.values().stream().map(dy -> dy.getString("id")).collect(Collectors.toList());
            SimpleFilterRow idSimpleFilterRow = FilterConditionHelper.createBasicSimpleFilterRow("id", CompareTypeEnum.IN, idStrList);
            FilterCondition idFilterCondition = FilterConditionHelper.createBasicFilterCondition(Collections.singletonList(idSimpleFilterRow));
            if (!(filterColumn instanceof SchemeBaseDataFilterColumn)) continue;
            SchemeBaseDataFilterColumn schemeBaseDataFilterColumn = (SchemeBaseDataFilterColumn)filterColumn;
            schemeBaseDataFilterColumn.setFilter(idFilterCondition);
        }
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        List orgIdList;
        super.setFilter(e);
        QFilter mainOrgQFilter = e.getMainOrgQFilter();
        if (mainOrgQFilter == null) {
            return;
        }
        Object value = mainOrgQFilter.getValue();
        if (value instanceof List && !(orgIdList = (List)value).isEmpty()) {
            List subOrgList = OrgHelper.getSubOrgList((List)orgIdList);
            QFilter orgFilter = new QFilter("responsibledep.id", "in", (Object)subOrgList);
            e.setMainOrgQFilter(orgFilter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("closeevent".equals(operateKey) && operationResult != null && operationResult.isSuccess()) {
            String pkId = null;
            Map billNos = operationResult.getBillNos();
            for (Object o : billNos.keySet()) {
                pkId = o.toString();
            }
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("rsa_closework");
            fsp.setCustomParam("pkid", (Object)pkId);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("new".equals(operateKey)) {
            String appId;
            ControlFilters controlFilters = ((IListView)this.getView()).getControlFilters();
            String dutyOrgIdStr = controlFilters.getFilter("responsibledep.id").stream().filter(idStr -> StringUtils.isNotEmpty((CharSequence)((String)idStr))).findFirst().orElse(null);
            if (StringUtils.isEmpty((CharSequence)dutyOrgIdStr)) {
                return;
            }
            Long dutyOrgId = Long.valueOf(dutyOrgIdStr);
            Long curUserId = RequestContext.get().getCurrUserId();
            int newRiskResult = PermissionServiceHelper.checkPermission((Long)curUserId, (Long)dutyOrgId, (String)(appId = AppMetadataCache.getAppInfo((String)"rsa").getAppId()), (String)"rsa_riskwork", (String)"47156aff000000ac");
            if (newRiskResult == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u98ce\u9669\u4e8b\u4ef6\u5355\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RiskWorkList_4", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if ("closeevent".equals(operateKey) && args.getListSelectedData().size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u5141\u8bb8\u5173\u95ed\u4e00\u4e2a\u98ce\u9669\u4e8b\u4ef6\u3002", (String)"RiskWorkList_1", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        if (BillOperationStatus.ADDNEW == e.getParameter().getBillStatus()) {
            List filter;
            ControlFilters controlFilters = ((IListView)this.getView()).getControlFilters();
            ITreeModel treeModel = this.getTreeModel();
            String currentNodeId = (String)treeModel.getCurrentNodeId();
            String rootId = treeModel.getRoot().getId();
            if (!rootId.equals(currentNodeId)) {
                e.getParameter().setCustomParam("group", (Object)currentNodeId);
            }
            if ((filter = controlFilters.getFilter("responsibledep.id")) != null && filter.size() == 1 && filter.get(0) != null && StringUtils.isNotEmpty((CharSequence)filter.get(0).toString())) {
                String orgId = filter.get(0).toString();
                e.getParameter().setCustomParam("responsibledep", (Object)orgId);
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("closeevent".equals(closedCallBackEvent.getActionId())) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                Map returnDataMap = (Map)closedCallBackEvent.getReturnData();
                Object pkId = returnDataMap.get("pkid");
                String closeExplain = returnDataMap.get("closeexplain").toString();
                DynamicObject riskWork = BusinessDataServiceHelper.loadSingle(pkId, (String)"rsa_riskwork");
                riskWork.set("closeexplain", (Object)closeExplain);
                riskWork.set("billstatus", (Object)"E");
                SaveServiceHelper.update((DynamicObject)riskWork);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5173\u95ed\u6210\u529f\u3002", (String)"RiskWorkList_3", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        } else {
            super.closedCallBack(closedCallBackEvent);
        }
    }
}

