/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.risksetting;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.data.rsa.enums.ScoreSumWayEnum;

public class WeightSettingFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(WeightSettingFormPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.init();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)"btnok", (CharSequence)key)) {
            if (!this.validate()) {
                return;
            }
            String scoreSumWay = (String)model.getValue("scoresumway");
            DynamicObjectCollection entryEntityDyCol = model.getEntryEntity("entryentity");
            List weightMapList = null;
            if (StringUtils.equals((CharSequence)"1", (CharSequence)scoreSumWay)) {
                weightMapList = entryEntityDyCol.stream().map(dy -> {
                    HashMap<String, Number> weightMap = new HashMap<String, Number>();
                    weightMap.put("evalUserId", dy.getLong("user_id"));
                    weightMap.put("evalWeight", dy.getInt("weight"));
                    return weightMap;
                }).collect(Collectors.toList());
            }
            if (StringUtils.equals((CharSequence)"4", (CharSequence)scoreSumWay)) {
                weightMapList = entryEntityDyCol.stream().map(dy -> {
                    HashMap<String, Object> weightMap = new HashMap<String, Object>();
                    weightMap.put("orgType", dy.getString("org"));
                    weightMap.put("evalWeight", dy.getInt("weight"));
                    return weightMap;
                }).collect(Collectors.toList());
            }
            String weightJson = JSON.toJSONString(weightMapList);
            pageCache.put("rollback", "0");
            view.returnDataToParent((Object)weightJson);
            view.close();
            return;
        }
        if (StringUtils.equals((CharSequence)"btncancel", (CharSequence)key)) {
            String weightJson = (String)model.getValue("weightjson_tag");
            pageCache.put("rollback", "1");
            view.returnDataToParent((Object)weightJson);
            view.close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        String rollback = pageCache.get("rollback");
        if (rollback == null) {
            String weightJson = (String)model.getValue("weightjson_tag");
            view.returnDataToParent((Object)weightJson);
        }
    }

    private void init() {
        List weightMapList;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String scoreSumWay = (String)view.getFormShowParameter().getCustomParam("scoresumway");
        if (StringUtils.isEmpty((CharSequence)scoreSumWay)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"WeightSettingFormPlugin_0", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            logger.error("[DATA-RSA] WeightSetting init error!");
            return;
        }
        String weightJson = (String)view.getFormShowParameter().getCustomParam("weightJson");
        if (StringUtils.isEmpty((CharSequence)weightJson)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"WeightSettingFormPlugin_0", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            logger.error("[DATA-RSA] WeightSetting init error!");
            return;
        }
        try {
            weightMapList = (List)JSON.parseObject((String)weightJson, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
            if (weightMapList.isEmpty()) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"WeightSettingFormPlugin_0", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                logger.error("[DATA-RSA] WeightSetting weightMapList isEmpty!");
                return;
            }
        }
        catch (Exception e) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"WeightSettingFormPlugin_0", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            logger.error("[DATA-RSA] WeightSetting Json parse error!", (Throwable)e);
            return;
        }
        model.setValue("scoresumway", (Object)scoreSumWay);
        model.setValue("weightjson_tag", (Object)weightJson);
        this.createEntryEntity(scoreSumWay, weightMapList);
    }

    private boolean validate() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntityDyCol = model.getEntryEntity("entryentity");
        if (entryEntityDyCol == null || entryEntityDyCol.isEmpty()) {
            return false;
        }
        Integer totalWeight = entryEntityDyCol.stream().map(dy -> (Integer)dy.get("weight")).reduce(0, Integer::sum);
        if (totalWeight < 100) {
            logger.error("[DATA-RSA] WeightSetting validate totalWeight under 100%!");
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bc4\u4f30\u6743\u91cd\u7684\u603b\u503c\u672a\u8fbe\u5230100%\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"WeightSettingFormPlugin_1", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (totalWeight > 100) {
            logger.error("[DATA-RSA] WeightSetting validate totalWeight over 100%!");
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bc4\u4f30\u6743\u91cd\u7684\u603b\u503c\u5df2\u8d85\u8fc7100%\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"WeightSettingFormPlugin_2", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void createEntryEntity(String scoreSumWay, List<Map<String, Object>> weightMapList) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (StringUtils.isEmpty((CharSequence)scoreSumWay)) {
            return;
        }
        if (StringUtils.equals((CharSequence)ScoreSumWayEnum.PERSON_WEIGHT.getCode(), (CharSequence)scoreSumWay)) {
            int size = weightMapList.size();
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", size);
            for (int i = 0; i < size; ++i) {
                Map<String, Object> weightMap = weightMapList.get(i);
                model.setValue("user", weightMap.get("evalUserId"), i);
                model.setValue("weight", weightMap.get("evalWeight"), i);
                model.setValue("key", (Object)"1", i);
            }
            model.endInit();
            view.updateView("entryentity");
            return;
        }
        if (StringUtils.equals((CharSequence)ScoreSumWayEnum.ORG_WEIGHT.getCode(), (CharSequence)scoreSumWay)) {
            int size = weightMapList.size();
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", size);
            for (int i = 0; i < size; ++i) {
                Map<String, Object> weightMap = weightMapList.get(i);
                model.setValue("org", weightMap.get("orgType"), i);
                model.setValue("weight", weightMap.get("evalWeight"), i);
                model.setValue("key", (Object)"2", i);
            }
            model.endInit();
            view.updateView("entryentity");
        }
    }
}

