/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.mservice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.rsa.enums.RiskNumericalUnitEnum;
import kd.data.rsa.utils.UnitConversionUtil;

public class RiskEventUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(RiskEventUpgradeService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("upgradeRiskEventSeq - info:").append(dbKey);
            String ret2 = RiskEventUpgradeService.upgradeRiskEventEntry();
            sb.append(ret2).append(System.lineSeparator());
            String ret1 = this.upgradeRiskEvent();
            sb.append(ret1).append(System.lineSeparator());
            result.setSuccess(true);
            sb.append("The upgradeRiskEvent execution was completed and the upgrade was successful!");
            result.setLog(sb.toString());
            logger.info("[DATA-RSA] " + sb);
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setEl("error");
            String msg = "upgradeRiskEvent upgrade failed! error:" + e.getMessage();
            result.setErrorInfo(msg);
            result.setLog(msg);
            logger.info("[DATA-RSA] " + msg);
        }
        return result;
    }

    private String upgradeRiskEvent() {
        logger.info("[DATA-RSA] UpgradeRiskEvent start.");
        if (!MetadataDao.checkNumber((String)"rsa_riskevent")) {
            return " ";
        }
        StringBuilder resultSb = new StringBuilder();
        try {
            String updateSql = "UPDATE t_rsa_riskevent SET fupper = '1' where fupper = ' ' ";
            DB.execute((DBRoute)DBRoute.of((String)"fias"), (String)updateSql);
        }
        catch (Exception ex) {
            resultSb.append("fail to updateData :").append(ex.getMessage()).append(System.lineSeparator());
            throw ex;
        }
        logger.info("[DATA-RSA] Upper update " + resultSb);
        return resultSb.toString();
    }

    public static String upgradeRiskEventEntry() {
        StringBuilder resultSb = new StringBuilder();
        try {
            if (!MetadataDao.checkNumber((String)"pa_analysisperiod") || !MetadataDao.checkNumber((String)"pa_fasindex")) {
                return " ";
            }
            String sql2 = "select fid, fname from t_bd_period_l where flocaleid = 'zh_CN' ";
            Map bdperiodMap = (Map)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)sql2, rs -> {
                HashMap<Long, String> resultMap = new HashMap<Long, String>(1000);
                while (rs.next()) {
                    resultMap.put(rs.getLong("fid"), rs.getString("fname"));
                }
                return resultMap;
            });
            String sql3 = "select fid, fname from t_pa_analysisperiod_l where flocaleid = 'zh_CN' ";
            Map analysisperiodMap = (Map)DB.query((DBRoute)DBRoute.of((String)"fias"), (String)sql3, rs -> {
                HashMap<Long, String> resultMap = new HashMap<Long, String>(1000);
                while (rs.next()) {
                    resultMap.put(rs.getLong("fid"), rs.getString("fname"));
                }
                return resultMap;
            });
            String sql4 = "select fid, fprecision from t_pa_fasindex";
            Map fasIndexMap = (Map)DB.query((DBRoute)DBRoute.of((String)"fias"), (String)sql4, rs -> {
                HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>(100);
                while (rs.next()) {
                    resultMap.put(rs.getLong("fid"), rs.getInt("fprecision"));
                }
                return resultMap;
            });
            String sql6 = "select fid, fgroupid from t_rsa_riskitem ";
            Map riskItemMap = (Map)DB.query((DBRoute)DBRoute.of((String)"fias"), (String)sql6, rs -> {
                HashMap<Long, Long> resultMap = new HashMap<Long, Long>(10);
                while (rs.next()) {
                    resultMap.put(rs.getLong("fid"), rs.getLong("fgroupid"));
                }
                return resultMap;
            });
            String insertSql = "insert into  t_rsa_datatraceability  (fid, friskriskitem, ffasindex, fdisplayperiod, ffasvalue, funit, ffasrang, fearlywarnlevel, finfluence, fentryid, fseq) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            String updateSql = "update t_rsa_riskevent set friskgroup = ?, fupper = ?  where fid = ?";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
            ArrayList<Object[]> riskEventParamList = new ArrayList<Object[]>(10);
            String sql5 = "select fid, friskitemid, ffasindexid, fperiodid, fvalue, fnumericalunit, frang, frisklevelid, finfluence, ftimetype from t_rsa_riskevent where fupper = ' ' ";
            try (DataSet ds = DB.queryDataSet((String)"RiskEventUpgradeService.upgradeRiskEventEntry", (DBRoute)DBRoute.of((String)"fias"), (String)sql5);){
                while (ds.hasNext()) {
                    Row riskEvent = ds.next();
                    String numeriCalunit = riskEvent.getString("fnumericalunit");
                    BigDecimal value = riskEvent.getBigDecimal("fvalue");
                    int precision = 0;
                    int n = precision = fasIndexMap.get(riskEvent.getLong("ffasindexid")) == null ? 0 : (Integer)fasIndexMap.get(riskEvent.getLong("ffasindexid"));
                    if (precision != 0) {
                        value = value.setScale(precision, RoundingMode.HALF_UP);
                    }
                    if (StringUtils.isNotEmpty((String)numeriCalunit) && !"0".equals(numeriCalunit)) {
                        value = UnitConversionUtil.conversion((BigDecimal)value, (int)precision, (RiskNumericalUnitEnum)RiskNumericalUnitEnum.getEnum((String)numeriCalunit));
                    }
                    String period = "bd_period".equals(riskEvent.getString("ftimetype")) ? (String)bdperiodMap.get(riskEvent.getLong("fperiodid")) : (String)analysisperiodMap.get(riskEvent.getLong("fperiodid"));
                    paramsList.add(new Object[]{riskEvent.get("fid"), riskEvent.get("friskitemid") == null ? Integer.valueOf(0) : riskEvent.get("friskitemid"), riskEvent.get("ffasindexid") == null ? Integer.valueOf(0) : riskEvent.get("ffasindexid"), period, value, numeriCalunit, riskEvent.get("frang"), riskEvent.get("frisklevelid") == null ? Integer.valueOf(0) : riskEvent.get("frisklevelid"), riskEvent.get("finfluence"), DBServiceHelper.genGlobalLongId(), 0});
                    if (riskItemMap.get(riskEvent.get("friskitemid")) == null) continue;
                    riskEventParamList.add(new Object[]{riskItemMap.get(riskEvent.get("friskitemid")), "1", riskEvent.get("fid")});
                }
            }
            var15_16 = null;
            try (TXHandle tx = TX.required((String)"kd/data/rsa/mservice/RiskEventUpgradeService");){
                try {
                    if (!paramsList.isEmpty()) {
                        DB.executeBatch((DBRoute)DBRoute.of((String)"fias"), (String)insertSql, paramsList);
                    }
                    if (!riskEventParamList.isEmpty()) {
                        DB.executeBatch((DBRoute)DBRoute.of((String)"fias"), (String)updateSql, riskEventParamList);
                    }
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                var15_16 = throwable;
                throw throwable;
            }
        }
        catch (Exception ex) {
            logger.info("[DATA-RSA] RiskeventEntry update error: " + ex.getMessage());
            resultSb.append("fail to updateData :").append(ex.getMessage()).append(System.lineSeparator());
            throw ex;
        }
        logger.info("[DATA-RSA] Upper update " + resultSb);
        return resultSb.toString();
    }
}

