/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.mservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class RiskLevelUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(RiskLevelUpgradeService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("upgradeRiskLevelSeq - info:").append(dbKey);
            String ret1 = this.upgradeRiskLevel();
            sb.append(ret1).append(System.lineSeparator());
            result.setSuccess(true);
            sb.append("The upgradeRiskLevelSeq execution was completed and the upgrade was successful!");
            result.setLog(sb.toString());
            logger.info("[DATA-RSA] " + sb);
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setEl("error");
            String msg = "upgradeRiskLevelSeq upgrade failed! error:" + e.getMessage();
            result.setErrorInfo(msg);
            result.setLog(msg);
            logger.info("[DATA-RSA] " + msg);
        }
        return result;
    }

    private String upgradeRiskLevel() {
        logger.info("[DATA-RSA] UpgradeRiskLevel start.");
        if (!MetadataDao.checkNumber((String)"rsa_risklevel")) {
            return " ";
        }
        StringBuilder resultSb = new StringBuilder();
        try {
            String sql = "select fid from t_rsa_risklevel where frisklevelseq = 0  and fapprange = ' '";
            List list = (List)DB.query((DBRoute)DBRoute.of((String)"fias"), (String)sql, rs -> {
                ArrayList<Long> ids = new ArrayList<Long>(10);
                while (rs.next()) {
                    Long id = rs.getLong(1);
                    ids.add(id);
                }
                return ids;
            });
            if (!list.isEmpty()) {
                Date date = new Date();
                String updateSql = "UPDATE t_rsa_risklevel SET fmodifytime=?, frisklevelseq=?, fapprange = ? WHERE fid=?";
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    paramsList.add(new Object[]{date, i + 1, ",1,", list.get(i)});
                }
                DB.executeBatch((DBRoute)DBRoute.of((String)"fias"), (String)updateSql, paramsList);
            }
        }
        catch (Exception ex) {
            resultSb.append("fail to updateData :").append(ex.getMessage()).append(System.lineSeparator());
            throw ex;
        }
        return resultSb.toString();
    }
}

