/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.mservice.fatvs;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.data.rsa.helper.RiskCheckStatisticsHelper;
import kd.data.rsa.model.RiskCheckFatvsStatisticsDTO;

public class SkillRunnableImpl
implements ISkillRunnable {
    private static final Log logger = LogFactory.getLog(SkillRunnableImpl.class);
    private final IAppCache cache = AppCache.get((String)"RSA");

    public SkillRunResult pullData(SkillRunContext skillRunContext) {
        SkillRunResult skillResult = skillRunContext.getSkillResult();
        String skillNum = skillRunContext.getSkillNum();
        logger.info("[DATA-RSA] SkillNum = " + skillNum);
        Date startTime = skillRunContext.getStartTime();
        Date endTime = skillRunContext.getEndTime();
        int currentMonth = Calendar.getInstance().get(2);
        RiskCheckFatvsStatisticsDTO riskStatisticsDto = (RiskCheckFatvsStatisticsDTO)this.cache.get("rsa_riskStatisticsDto_" + currentMonth, RiskCheckFatvsStatisticsDTO.class);
        if (riskStatisticsDto == null) {
            riskStatisticsDto = RiskCheckStatisticsHelper.getRiskStatisticsDto();
        }
        this.cache.put("rsa_riskStatisticsDto_" + currentMonth, (Object)riskStatisticsDto);
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        list.add(this.getParamMap(ResManager.loadKDString((String)"\u672c\u6708\u5df2\u626b\u63cf\u7684\u7ec4\u7ec7\u6570", (String)"SkillRunnableImpl_0", (String)"data-rsa-mservice", (Object[])new Object[0]), riskStatisticsDto.getMonthScanOrgCount().toString(), "byysmdzzs"));
        list.add(this.getParamMap(ResManager.loadKDString((String)"\u672c\u6708\u5df2\u626b\u63cf\u7684\u98ce\u9669\u6570", (String)"SkillRunnableImpl_1", (String)"data-rsa-mservice", (Object[])new Object[0]), riskStatisticsDto.getMonthScanRiskCount().toString(), "byysmdfxs"));
        list.add(this.getParamMap(ResManager.loadKDString((String)"\u672c\u6708\u5df2\u626b\u63cf\u7684\u98ce\u9669\u68c0\u67e5\u9879\u6570", (String)"SkillRunnableImpl_2", (String)"data-rsa-mservice", (Object[])new Object[0]), riskStatisticsDto.getMonthScanRiskItemCount().toString(), "byysmdfxjcxs"));
        list.add(this.getParamMap(ResManager.loadKDString((String)"\u672c\u6708\u53d1\u73b0\u7684\u98ce\u9669\u9884\u8b66\u6570", (String)"SkillRunnableImpl_3", (String)"data-rsa-mservice", (Object[])new Object[0]), riskStatisticsDto.getMonthScanRiskEventCount().toString(), "byfxdfxyjs"));
        list.add(this.getParamMap(ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u53d1\u73b0\u7684\u98ce\u9669\u9884\u8b66\u6570", (String)"SkillRunnableImpl_4", (String)"data-rsa-mservice", (Object[])new Object[0]), riskStatisticsDto.getYearScanRiskEventCount().toString(), "bnljfxdfxyjs"));
        logger.info("[DATA-RSA] StatisticsFatvs = " + riskStatisticsDto.toString());
        skillResult.setData(list);
        skillResult.setDate(skillRunContext.getStartTime());
        skillResult.setSkillNum(skillNum);
        skillResult.setFailCount(Integer.valueOf(0));
        skillResult.setTotalCount(RiskCheckStatisticsHelper.getRiskStatisticTotalCount((Date)startTime, (Date)endTime));
        return skillResult;
    }

    private Map<String, String> getParamMap(String name, String value, String number) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("name", name);
        paramMap.put("value", value);
        paramMap.put("valueType", "0");
        paramMap.put("number", number);
        return paramMap;
    }
}

