/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.ad;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class ADEditPlugin
extends MdrFormPlugin
implements BeforeF7SelectListener {
    Log logger = LogFactory.getLog(ADEditPlugin.class);
    private static final String ADENTRY = "adentry";
    private static final String ENTRYPICTURE = "entrypicture";
    private static final String STARTDATE = "entryenabledate";
    private static final String ENDDATE = "entryexpirydate";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"owner"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        QFilter qFilter = UserUtil.getOwnerIdsQFilter((String)"id");
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)qFilter);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("owner", UserUtil.getDefaultOwnerID());
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection dyObjectCollection = dataEntity.getDynamicObjectCollection("ADENTRY");
        for (int i = 0; i < dyObjectCollection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dyObjectCollection.get(i);
            Object entrypicture = dynamicObject.get(ENTRYPICTURE);
            dataEntity.set("picture" + (i + 1), entrypicture);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String filedName;
        super.propertyChanged(e);
        int index = this.getRowIndex(e);
        switch (filedName = e.getProperty().getName()) {
            case "entryenabledate": 
            case "entryexpirydate": {
                DynamicObject rowInfo = this.getRowInfo(ADENTRY, index);
                Date endDateStr = rowInfo.getDate(ENDDATE);
                Date startDateStr = rowInfo.getDate(STARTDATE);
                if (startDateStr == null || endDateStr == null || !endDateStr.before(startDateStr)) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u751f\u6548\u65f6\u95f4", (String)"ADEditPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            }
        }
        if (filedName.startsWith("picture")) {
            Object picture = this.getValue(filedName);
            String i = filedName.substring(filedName.length() - 1, filedName.length());
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ADENTRY);
            if (Integer.parseInt(i) > entryEntity.size()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u5206\u5f55\u540e\u518d\u91cd\u65b0\u4e0a\u4f20\u5e7f\u544a\u56fe\u7247", (String)"ADEditPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            }
            int j = Integer.parseInt(i) - 1;
            this.setValue(ENTRYPICTURE, picture, j);
        }
    }
}

