/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.bill.saleorder;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.util.CustomerSalerUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrListPlugin;

public class CustomerOrderListPlugin
extends MdrListPlugin {
    public void filterContainerInit(FilterContainerInitArgs e) {
        super.filterContainerInit(e);
        this.initOwnerFilterComboItem(e, "owner.name");
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (!this.isLookup()) {
            List fs = e.getQFilters();
            HashMap<String, QFilter> fsMap = new HashMap<String, QFilter>();
            for (QFilter f : fs) {
                if (f == null) continue;
                fsMap.put(f.getProperty(), f);
            }
            if (!fsMap.containsKey("owner.id")) {
                fs.add(this.createFilter(UserUtil.getOwnerIDs()));
            } else {
                fs.add(this.createFilter(((QFilter)fsMap.get("owner.id")).getValue()));
                fs.remove(fsMap.get("owner.id"));
            }
        }
    }

    private QFilter createFilter(Object owner) {
        Collection ownerIds = new HashSet<Object>();
        if (owner instanceof Collection) {
            ownerIds = (Collection)owner;
        } else {
            ownerIds.add(owner);
        }
        QFilter filter = null;
        Set subIds = new HashSet();
        HashSet allSubIds = new HashSet(32);
        for (Object ownerId : ownerIds) {
            Set regionIds;
            subIds = UserUtil.isSaler(ownerId) ? CustomerSalerUtil.queryCustomerPKBySaler(ownerId, (Object)UserUtil.getUserID()) : ((regionIds = UserUtil.queryUserRegions(ownerId)).isEmpty() ? CustomerUtil.getAuthSubsIds(ownerId) : CustomerUtil.queryCustomerByRegion(ownerId, (Object)regionIds));
            for (Object subId : subIds) {
                allSubIds.addAll(CustomerUtil.getAllAuthSubsIdsAndSelf(subId));
            }
            allSubIds.add(ownerId);
        }
        filter = new QFilter("owner", "in", allSubIds);
        return filter;
    }
}

