/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.bill.saleorder;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.util.DeliveryUtil;
import kd.drp.mdr.formplugin.MdrBaseMobPlugin;

public class DeliveryRecordEditMobPlugin
extends MdrBaseMobPlugin {
    public static final String SIGN = "sign";
    public static final String UNSIGN = "unsign";
    public static final String TB_DELIVER_DATE = "deliverdate";
    public static final String SIGNSTATUS = "signstatus";
    public static final String LOGISTICS = "logistics";
    public static final String LOGISTICSBILL = "logisticsbill";
    public static final String ORDER_LIST = "deliverydetail";
    public static final String TB_ITEM = "item";
    public static final String TB_UNIT = "unit";
    public static final String TB_QTY = "qty";
    public static final String TB_DELIVERED_QTY = "deliveredqty";
    public static final String TB_DELIVER_QTY = "deliverqty";
    public static final String TB_DELIVER_STANDARD_QTY = "deliverstandardqty";
    public static final String TB_SIGN_QTY = "signqty";
    public static final String TB_SIGN_STANDARD_QTY = "signstandardqty";
    public static final String TB_WAREHOUSE = "warehouse";
    public static final String TB_RECEIVEWAREHOUSE = "receivewarehouse";
    public static final String TB_FEEDBACK = "feedback";
    public static final String SOURCEBILLID = "sourcebillid";
    public static final String SOURCEBILLNUMBER = "sourcebillnumber";
    public static final String SOURCEBILLTYPE = "sourcebilltype";
    public static final String TB_COREBILLENTRYID = "corebillentryid";
    public static final String TB_SRCBILLID = "srcbillid";
    public static final String TB_MAINBILLID = "mainbillid";
    public static final String TB_MAINBILLENTRYID = "mainbillentryid";
    public static final String TB_SRCBILLENTRYID = "srcbillentryid";
    public static final String TB_SRCBILLNUMBER = "srcbillnumber";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{SIGN, UNSIGN});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "sign": {
                this.sign();
                break;
            }
            case "unsign": {
                this.unsign();
                break;
            }
            default: {
                throw new KDBizException(ResManager.loadKDString((String)"\u529f\u80fd\u6b63\u5728\u5f00\u53d1\u4e2d..", (String)"DeliveryRecordEditMobPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void unsign() {
        try (TXHandle h = TX.beginRequired();){
            try {
                Object deliveryRecordId = this.getModel().getDataEntity().getPkValue();
                DynamicObject deliveryRecord = BusinessDataServiceHelper.loadSingle((Object)deliveryRecordId, (String)"mdr_delivery_record");
                if (deliveryRecord == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u7b7e\u6536\u5931\u8d25\uff0c\u83b7\u53d6\u53d1\u8d27\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"DeliveryRecordEditMobPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                }
                DeliveryUtil.unSign((DynamicObject)deliveryRecord, (boolean)true);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u7b7e\u6536\u6210\u529f\uff01", (String)"DeliveryRecordEditMobPlugin_2", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        this.getModel().setDataChanged(false);
        this.getView().close();
    }

    private void sign() {
        if (this.getModel().getEntryRowCount(ORDER_LIST) <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7b7e\u6536\u5931\u8d25\uff0c\u83b7\u53d6\u53d1\u8d27\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"DeliveryRecordEditMobPlugin_3", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        try (TXHandle h = TX.beginRequired();){
            try {
                Object deliveryRecordId = this.getModel().getDataEntity().getPkValue();
                DynamicObject deliveryRecord = BusinessDataServiceHelper.loadSingle((Object)deliveryRecordId, (String)"bbc_delivery_record");
                if (deliveryRecord == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7b7e\u6536\u5931\u8d25\uff0c\u83b7\u53d6\u53d1\u8d27\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"DeliveryRecordEditMobPlugin_3", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                }
                DynamicObjectCollection deliveryDetails = deliveryRecord.getDynamicObjectCollection(ORDER_LIST);
                for (DynamicObject deliveryDetail : deliveryDetails) {
                    if (this.getModel().getEntryRowCount(ORDER_LIST) <= 0) continue;
                    for (int i = 0; i < this.getModel().getEntryRowCount(ORDER_LIST); ++i) {
                        DynamicObject rowDeliveryDetail = this.getModel().getEntryRowEntity(ORDER_LIST, i);
                        if (rowDeliveryDetail.get("id") == null || deliveryDetail.get("id") == null || !rowDeliveryDetail.get("id").equals(deliveryDetail.get("id"))) continue;
                        BigDecimal signQty = (BigDecimal)this.getModel().getValue(TB_SIGN_QTY, i);
                        Object feedback = this.getModel().getValue(TB_FEEDBACK, i);
                        deliveryDetail.set("signQty", (Object)signQty);
                        deliveryDetail.set(TB_FEEDBACK, feedback);
                    }
                }
                DeliveryUtil.sign((DynamicObject)deliveryRecord, (boolean)true);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7b7e\u6536\u6210\u529f", (String)"DeliveryRecordEditMobPlugin_4", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        this.getView().updateView(SIGNSTATUS);
        this.getModel().setDataChanged(false);
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object orderId = this.getView().getFormShowParameter().getCustomParam("orderId");
        Object orderType = this.getView().getFormShowParameter().getCustomParam("orderType");
        if ("dispatchOrder".equals(orderType)) {
            this.creatOrderByDispatchOrder(orderId);
        } else {
            this.creatOrderBySaleOrder(orderId);
        }
    }

    private void creatOrderBySaleOrder(Object orderId) {
        QFilter filer = new QFilter("id", "=", orderId);
        DynamicObject orderInfo = QueryServiceHelper.queryOne((String)"mdr_purorder", (String)"id,billno", (QFilter[])filer.toArray());
        if (orderInfo == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"DeliveryRecordEditMobPlugin_5", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(SOURCEBILLTYPE, (Object)"saleorder");
        filer = new QFilter("order", "=", orderId);
        DynamicObjectCollection orderEntryInfo = QueryServiceHelper.query((String)"mdr_saleorder_entry", (String)"id,item,unit,qty,deliveredqty,entrywarehouse,entryreceivewarehouse", (QFilter[])filer.toArray());
        IDataModel model = this.getModel();
        int i = 0;
        for (DynamicObject orderEntry : orderEntryInfo) {
            BigDecimal qty = orderEntry.getBigDecimal(TB_QTY);
            BigDecimal deliveredqty = orderEntry.getBigDecimal(TB_DELIVERED_QTY);
            BigDecimal toDeliveredqty = qty;
            if (toDeliveredqty == null) continue;
            if (deliveredqty != null) {
                toDeliveredqty = toDeliveredqty.subtract(deliveredqty);
            }
            if (BigDecimal.ZERO.compareTo(toDeliveredqty) >= 0) continue;
            model.createNewEntryRow(ORDER_LIST);
            model.setValue(TB_COREBILLENTRYID, orderEntry.get("id"), i);
            model.setValue(TB_ITEM, orderEntry.get(TB_ITEM), i);
            model.setValue(TB_UNIT, orderEntry.get(TB_UNIT), i);
            model.setValue(TB_QTY, (Object)qty, i);
            model.setValue(TB_DELIVERED_QTY, (Object)deliveredqty, i);
            model.setValue(TB_DELIVER_QTY, (Object)toDeliveredqty, i);
            model.setValue(TB_WAREHOUSE, orderEntry.get("entrywarehouse"), i);
            model.setValue(TB_RECEIVEWAREHOUSE, orderEntry.get("entryreceivewarehouse"), i);
            model.setValue(TB_SRCBILLID, orderId, i);
            model.setValue(TB_SRCBILLNUMBER, (Object)orderInfo.getString("billno"), i);
            model.setValue(TB_SRCBILLENTRYID, orderEntry.get("id"), i);
            model.setValue(TB_MAINBILLID, orderId, i);
            model.setValue(TB_MAINBILLENTRYID, orderEntry.get("id"), i);
            ++i;
        }
    }

    private void creatOrderByDispatchOrder(Object orderId) {
        QFilter filer = new QFilter("id", "=", orderId);
        DynamicObject orderInfo = QueryServiceHelper.queryOne((String)"mdr_dispatch_order", (String)"id,billno", (QFilter[])filer.toArray());
        if (orderInfo == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u8d27\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"DeliveryRecordEditMobPlugin_6", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(SOURCEBILLTYPE, (Object)"dispatchorder");
        filer = new QFilter("order", "=", orderId);
        DynamicObjectCollection orderEntryInfo = QueryServiceHelper.query((String)"mdr_dispatchorder_entry", (String)"id,item,unit,qty,deliveredqty,entrywarehouse,entryreceivewarehouse", (QFilter[])filer.toArray());
        IDataModel model = this.getModel();
        int i = 0;
        for (DynamicObject orderEntry : orderEntryInfo) {
            BigDecimal qty = orderEntry.getBigDecimal(TB_QTY);
            BigDecimal deliveredqty = orderEntry.getBigDecimal(TB_DELIVERED_QTY);
            BigDecimal toDeliveredqty = qty;
            if (toDeliveredqty == null) continue;
            if (deliveredqty != null) {
                toDeliveredqty = toDeliveredqty.subtract(deliveredqty);
            }
            if (BigDecimal.ZERO.compareTo(toDeliveredqty) >= 0) continue;
            model.createNewEntryRow(ORDER_LIST);
            model.setValue(TB_COREBILLENTRYID, orderEntry.get("id"), i);
            model.setValue(TB_ITEM, orderEntry.get(TB_ITEM), i);
            model.setValue(TB_UNIT, orderEntry.get(TB_UNIT), i);
            model.setValue(TB_QTY, (Object)qty, i);
            model.setValue(TB_DELIVERED_QTY, (Object)deliveredqty, i);
            model.setValue(TB_DELIVER_QTY, (Object)toDeliveredqty, i);
            model.setValue(TB_WAREHOUSE, orderEntry.get("entrywarehouse"), i);
            model.setValue(TB_RECEIVEWAREHOUSE, orderEntry.get("entryreceivewarehouse"), i);
            model.setValue(TB_SRCBILLID, orderId, i);
            model.setValue(TB_SRCBILLNUMBER, (Object)orderInfo.getString("billno"), i);
            model.setValue(TB_SRCBILLENTRYID, orderEntry.get("id"), i);
            model.setValue(TB_MAINBILLID, orderId, i);
            model.setValue(TB_MAINBILLENTRYID, orderEntry.get("id"), i);
            ++i;
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        boolean isView = this.isView();
        String sourcebilltype = this.getModel().getDataEntity().getString(SOURCEBILLTYPE);
        String signstatus = this.getModel().getDataEntity().getString(SIGNSTATUS);
        if (StringUtils.isNotEmpty((String)signstatus)) {
            DynamicObjectCollection orderEntryInfo = this.getModel().getDataEntity().getDynamicObjectCollection(ORDER_LIST);
            Map orderMap = DeliveryUtil.getOrdersMap((DynamicObject)this.getModel().getDataEntity(), (String)sourcebilltype, (String)"");
            if (orderEntryInfo != null) {
                DynamicObjectCollection entrys = new DynamicObjectCollection();
                Map entryMap = new HashMap(orderEntryInfo.size());
                for (int i = 0; i < orderEntryInfo.size(); ++i) {
                    DynamicObject deliverydetail = (DynamicObject)orderEntryInfo.get(i);
                    DynamicObject order = null;
                    order = "dispatchorder".equals(sourcebilltype) ? (DynamicObject)orderMap.get(deliverydetail.get(TB_SRCBILLID)) : (DynamicObject)orderMap.get(deliverydetail.get(TB_MAINBILLID));
                    if (order == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u8ba2\u5355\u5206\u5f55\u5931\u8d25\uff01", (String)"DeliveryRecordEditMobPlugin_8", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                    }
                    entrys = order.getDynamicObjectCollection("itementry");
                    entryMap = CommonUtils.collection2Map((String)"id", (List)entrys);
                    Long orderentryId = deliverydetail.getLong(TB_MAINBILLENTRYID);
                    DynamicObject orderEntry = (DynamicObject)entryMap.get(orderentryId);
                    BigDecimal qty = orderEntry.getBigDecimal(TB_QTY);
                    BigDecimal deliveredqty = (BigDecimal)orderEntry.get(TB_DELIVERED_QTY);
                    this.getModel().setValue(TB_QTY, (Object)qty, i);
                    this.getModel().setValue(TB_DELIVERED_QTY, (Object)deliveredqty, i);
                    this.getModel().setValue(TB_SIGN_QTY, ((DynamicObject)orderEntryInfo.get(i)).get(TB_DELIVER_QTY), i);
                    if (!"1".equals(signstatus)) continue;
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{TB_SIGN_QTY});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{TB_FEEDBACK});
                }
            }
            if (!isView) {
                if ("1".equals(signstatus)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{UNSIGN});
                    this.getView().setEnable(Boolean.FALSE, new String[]{LOGISTICSBILL});
                    this.getView().setEnable(Boolean.FALSE, new String[]{LOGISTICS});
                } else if ("0".equals(signstatus)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{SIGN});
                }
            }
            this.getModel().setDataChanged(false);
        }
    }
}

