/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.bill.saleorder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.ShortMessageUtil;
import kd.drp.mdr.common.WFXOrderType;
import kd.drp.mdr.common.handler.OrderOperateLogHandler;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.status.DispatchOrderConfirmStatus;
import kd.drp.mdr.common.status.SaleOrderConfirmStatus;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.OrderExportUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrListPlugin;

public class DispatchOrderListPlugin
extends MdrListPlugin {
    protected static final String TO_MODIFY = "privatemodify";
    protected static final String TO_EXPORT = "exportexcel";
    protected static final String SEND_AMOUNT_MSG = "sendamountmsg";
    protected static final String TO_INVALID = "invalid";
    protected static final String TO_VALID = "valid";
    protected static final String RE_FRESH = "refresh";
    protected static final String UNSUBMIT = "unsubmit";
    protected static final String UNAUDIT = "unaudit";
    protected static final String DELETE = "delete";
    protected static final String WITHDRAW = "withdraw";
    protected static final String TO_OPLOG = "oplog";
    protected static final String TO_SYNC = "tosync";

    public void setFilter(SetFilterEvent e) {
        if (!this.isLookup()) {
            this.createFilter(e);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs e) {
        super.filterContainerInit(e);
        String ownerFilterkey = "owner.name";
        List columns = e.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn column : columns) {
            if (!ownerFilterkey.equals(column.getFieldName())) continue;
            CommonFilterColumn col = (CommonFilterColumn)column;
            List comboItems = this.getOwnerComboItem();
            col.setComboItems(comboItems);
        }
        this.setWareHouseFilterComboItem(e, "warehouse.name");
    }

    private void createFilter(SetFilterEvent e) {
        ArrayList<Object> owners;
        List fs = e.getQFilters();
        Map fsMap = this.filter2Map(fs);
        QFilter f = (QFilter)fsMap.get("owner.id");
        if (null != f) {
            Object value = f.getValue();
            if (value instanceof List) {
                owners = (List)value;
            } else {
                owners = new ArrayList<Object>();
                owners.add(value);
            }
        } else {
            owners = this.getOwnerIDs();
        }
        fs.add(this.createSaleOrder((List<Object>)owners));
        QFilter warehouseFilter = new QFilter("-1", "=", (Object)1L);
        for (Object e2 : owners) {
            QFilter qFilter = new QFilter("user", "=", UserUtil.getUserID());
            qFilter.and("owner", "=", (Object)Long.parseLong(e2.toString()));
            qFilter.and("enable", "=", (Object)"1");
            DynamicObjectCollection wareHouses = QueryServiceHelper.query((String)"mdr_wareshouse_user_r", (String)"warehouse.id", (QFilter[])qFilter.toArray());
            QFilter ftemp = new QFilter("owner", "=", (Object)Long.parseLong(e2.toString()));
            if (wareHouses != null && wareHouses.size() > 0) {
                ArrayList<Object> ownerWarehouseIds = new ArrayList<Object>();
                for (DynamicObject wareHouse : wareHouses) {
                    ownerWarehouseIds.add(wareHouse.get("warehouse.id"));
                }
                ftemp.and("warehouse", "in", ownerWarehouseIds);
            }
            warehouseFilter.or(ftemp);
        }
        fs.add(warehouseFilter);
    }

    private QFilter createSaleOrder(List<Object> owners) {
        QFilter f = null;
        QFilter orFilter = null;
        for (Object owner : owners) {
            orFilter = SaleOrderUtil.getSaleOrderSalerFilter((Object)owner);
            if (f == null) {
                f = orFilter;
                continue;
            }
            f.or(orFilter);
        }
        return f;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        super.billListHyperLinkClick(e);
        e.setCancel(true);
        Object dispatchOrder = this.getListView().getFocusRowPkId();
        this.showDispatchOrderInfo(dispatchOrder, true);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        ListSelectedRow row = evt.getCurrentListSelectedRow();
        Object pk = null;
        if (row != null && (pk = row.getPrimaryKeyValue()) != null) {
            this.showDispatchOrderInfo(pk, true);
        }
        evt.setCancel(true);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "oplog": {
                Object id = this.getSelectedOrderId();
                ListShowParameter parameter = new ListShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setFormId("bos_list");
                parameter.setBillFormId("mdr_order_op_log");
                QFilter f = new QFilter("orderid", "=", (Object)Long.parseLong(id.toString()));
                f.and("ordertype", "=", (Object)"dispatchorder");
                ListFilterParameter listFilterParameter = new ListFilterParameter();
                listFilterParameter.setFilter(f);
                parameter.setListFilterParameter(listFilterParameter);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "invalid": {
                Object selectedOrderId = this.getSelectedOrderId();
                HashMap<String, Object> param = new HashMap<String, Object>();
                DynamicObject order = BusinessDataServiceHelper.loadSingle((Object)selectedOrderId, (String)"mdr_dispatch_order");
                if (!SaleOrderStatus.TEMP_SAVE.getFlagStr().equals(order.getString("orderstatus"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6682\u5b58\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u4f5c\u5e9f\uff01", (String)"DispatchOrderListPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                }
                param.put("orderid", selectedOrderId);
                this.showForm("mdr_saleorder_invalid", param, new CloseCallBack((IFormPlugin)this, TO_INVALID), ShowType.Modal);
                e.setCancel(true);
                break;
            }
            case "unsubmit": 
            case "unaudit": 
            case "delete": 
            case "withdraw": {
                Object[] selectedOrderIds = this.getSelectedOrderIds(false);
                String opMessage = OrderOperateLogHandler.getOpMessage((String)key);
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("message", opMessage);
                param.put("ids", selectedOrderIds);
                this.showForm("mdr_operate_confirm", param, new CloseCallBack((IFormPlugin)this, key), ShowType.Modal);
                e.setCancel(true);
                break;
            }
            case "valid": {
                Object selectedOrderId = this.getSelectedOrderId();
                String opMessage = OrderOperateLogHandler.getOpMessage((String)key);
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("message", opMessage);
                param.put("orderid", selectedOrderId);
                this.showForm("mdr_operate_confirm", param, new CloseCallBack((IFormPlugin)this, key), ShowType.Modal);
                e.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key = e.getOperateKey();
        if (this.getOperationResult(e)) {
            switch (key) {
                case "privatemodify": {
                    Object[] pk = this.getSelectedOrderIds(true);
                    this.showDispatchOrderInfo(pk[0], false);
                    break;
                }
                case "exportexcel": {
                    Object[] pks = this.getSelectedOrderIds(false);
                    OrderExportUtil.create((IFormView)this.getView()).export(pks, WFXOrderType.DISPATCH_ORDER);
                    break;
                }
                case "sendamountmsg": {
                    this.sendAmountMsg();
                    break;
                }
                case "tosync": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f", (String)"DispatchOrderListPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    protected Object getSelectedOrderId() {
        Object[] selectedOrderIds = this.getSelectedOrderIds(true);
        return selectedOrderIds[0];
    }

    protected void sendAmountMsg() {
        Object[] ids = this.getSelectedOrderIds(false);
        StringBuffer errorMsg = new StringBuffer();
        for (Object id : ids) {
            this.sendAmountMsg(id, errorMsg);
        }
        if (errorMsg.length() != 0) {
            throw new KDBizException(errorMsg.toString());
        }
        this.getView().showMessage(ResManager.loadKDString((String)"\u5e94\u6536\u77ed\u4fe1\u53d1\u9001\u5b8c\u6210\uff01", (String)"DispatchOrderListPlugin_2", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
    }

    protected void sendAmountMsg(Object saleorderid, StringBuffer errorMsg) {
        DynamicObject saleorder;
        CheckResult re;
        QFilter fs = new QFilter("id", "=", (Object)Long.parseLong(saleorderid.toString()));
        DynamicObject dispatchorder = BusinessDataServiceHelper.loadSingle((Object)saleorderid, (String)"mdr_dispatch_order");
        Set cols = QueryUtil.querySingleCol((String)"mdr_dispatch_order", (String)"itementry.sourcebillid", (QFilter[])fs.toArray());
        if (cols.isEmpty()) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u8ba2\u5355\uff1a%s\u5e94\u6536\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff1a\u6ca1\u6709\u627e\u5230\u539f\u5355\u4fe1\u606f\uff01", (String)"DispatchOrderListPlugin_3", (String)"drp-bbc-formplugin", (Object[])new Object[0]), dispatchorder.getString("number")));
        }
        if (!(re = this.checkCanSentMsg(saleorder = BusinessDataServiceHelper.loadSingle(new ArrayList(cols).get(0), (String)"mdr_saleorder"))).isSuccess()) {
            errorMsg.append(re.getMsg());
        }
        if (!SaleOrderConfirmStatus.AMOUNTCONFIRMED.getFlagStr().equals(saleorder.get("confirmstatus"))) {
            saleorder.set("confirmstatus", (Object)SaleOrderConfirmStatus.AMOUNTSENDED.getFlagStr());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleorder});
            QFilter filter = new QFilter("itementry.sourcebillid", "=", (Object)Long.parseLong(saleorder.get("id").toString()));
            DynamicObject[] orders = BusinessDataServiceHelper.load((String)"mdr_dispatch_order", (String)"id,confirmstatus", (QFilter[])filter.toArray());
            if (orders != null && orders.length > 0) {
                for (DynamicObject order : orders) {
                    order.set("confirmstatus", (Object)DispatchOrderConfirmStatus.AMOUNTSENDED.getFlagStr());
                }
                SaveServiceHelper.save((DynamicObject[])orders);
            }
        }
        ShortMessageUtil.sendAmountOrderMsg((Object)saleorder.get("id"));
    }

    private CheckResult checkCanSentMsg(DynamicObject order) {
        String amountstatus = order.getString("amountstatus");
        String confirmstatus = order.getString("confirmstatus");
        if ("C".equals(amountstatus) && !"E".equals(confirmstatus)) {
            return CheckResult.returnTrue();
        }
        String msg = String.format(ResManager.loadKDString((String)"%s\u53ea\u6709\u5e94\u6536\u72b6\u6001\u4e3a\u5df2\u5e94\u6536\u4e14\u786e\u8ba4\u72b6\u6001\u4e0d\u4e3a\u5e94\u6536\u5df2\u786e\u8ba4\u5355\u636e\u624d\u80fd\u53d1\u9001\u5e94\u6536\u77ed\u4fe1", (String)"DispatchOrderListPlugin_4", (String)"drp-bbc-formplugin", (Object[])new Object[0]), order.getString("billno"));
        return CheckResult.returnFalse((String)msg);
    }

    protected Object[] getSelectedOrderIds(boolean isSingle) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        int size = ids.length;
        if (size == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"DispatchOrderListPlugin_5", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        if (isSingle && size > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"DispatchOrderListPlugin_6", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        return ids;
    }

    private void showDispatchOrderInfo(Object dispatchOrder, boolean isView) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("mdr_dispatch_order");
        if (isView) {
            parameter.setStatus(OperationStatus.VIEW);
        } else {
            parameter.setStatus(OperationStatus.EDIT);
        }
        parameter.setPkId(dispatchOrder);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showDispatchOrderInfo"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String key;
        switch (key = e.getActionId()) {
            case "invalid": {
                Map param = (Map)e.getReturnData();
                if (param == null || param.get("isconfirm") == null) {
                    return;
                }
                DynamicObject order = BusinessDataServiceHelper.loadSingle(param.get("orderid"), (String)"mdr_dispatch_order");
                Object detail = param.get("detail");
                order.set("invalidreason", detail);
                order.set("operateremark", detail);
                OperationUtil.invokeOperation((DynamicObject)order, (String)TO_INVALID);
                this.getListView().refresh();
                break;
            }
            case "valid": {
                Map param = (Map)e.getReturnData();
                if (param == null || param.get("isconfirm") == null || !"true".equals(param.get("isconfirm"))) break;
                DynamicObject order = BusinessDataServiceHelper.loadSingle(param.get("orderid"), (String)"mdr_dispatch_order");
                String remark = (String)param.get("remark");
                order.set("operateremark", (Object)remark);
                OperationUtil.invokeOperation((DynamicObject)order, (String)TO_VALID);
                this.getListView().refresh();
                break;
            }
            case "unsubmit": 
            case "unaudit": 
            case "delete": 
            case "withdraw": {
                Map param = (Map)e.getReturnData();
                if (param == null || param.get("isconfirm") == null || !"true".equals(param.get("isconfirm"))) break;
                String remark = (String)param.get("remark");
                List list = (List)param.get("ids");
                DynamicObject[] orders = new DynamicObject[list.size()];
                for (int i = 0; i < orders.length; ++i) {
                    DynamicObject order = BusinessDataServiceHelper.loadSingle(list.get(i), (String)"mdr_dispatch_order");
                    order.set("operateremark", (Object)remark);
                    orders[i] = order;
                }
                OperationUtil.invokeOperation((DynamicObject[])orders, (String)key);
                this.getListView().refresh();
            }
        }
    }
}

