/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.bill.saleorder;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.bill.events.ConvertPkEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.handler.DispatchOrderHandler;
import kd.drp.mdr.common.handler.OrderOperateLogHandler;
import kd.drp.mdr.common.item.ConversionDirection;
import kd.drp.mdr.common.status.DispatchOrderStatus;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.util.DateUtil;
import kd.drp.mdr.common.util.ItemUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.ReceivingbillUtil;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.formplugin.MdrBillPlugin;

public class DispatchOrderPlugin
extends MdrBillPlugin
implements TabSelectListener,
IBillWebApiPlugin {
    protected static final String QTY = "qty";
    protected static final String BASE_QTY = "baseqty";
    protected static final String ASSIST_QTY = "assistqty";
    protected static final String ORDER_NEED_NUM = "orderneednum";
    protected static final String PRICE = "price";
    protected static final String ORDER_AMOUNT = "orderamount";
    protected static final String RECEIVED_AMOUNT = "receivedamount";
    protected static final String TOTAL_QTY = "totalqty";
    protected static final String TOTAL_PRIM_AMOUNT = "totalprimamount";
    protected static final String TOTAL_ITEM_AMOUT = "totalitemamount";
    protected static final String TOTAL_ORDER_AMOUNT = "totalorderamount";
    protected static final String AMOUNT_TO_BE_PAID = "amounttobepaid";
    protected static final String F7_ASSIST_UNIT = "assistunit";
    protected static final String TB_ITEM_ENTRY = "itementry";
    protected static final String PAGE_PAYTB = "paytb";
    protected static final String PAGE_DELIVERYRECORDTB = "deliveryrecordtb";
    protected static final String PAGE_OPLOGTB = "oplogtb";
    protected static final String CONFIRM_ARRIVAL_DATE = "confirmarrivaldate";
    protected static final String ENTRY_CONFIRM_ARRIVAL_DATE = "entryconfirmarrivaldate";
    protected static final String SOURCEBILLTYPE = "sourcebilltype";
    protected static final String SOURCEBILLID = "sourcebillid";
    protected static final String OP_DELENTRY = "delentry";
    protected static final String TABAP = "tabap";
    protected static final String BILL_DATE = "billdate";
    protected static final String ENTRY_CONFIRM_ARRIVALDATE = "entryconfirmarrivaldate";
    protected static final String TO_INVALID = "invalid";
    protected static final String TO_VALID = "valid";
    protected static final String RE_FRESH = "refresh";
    protected static final String UNSUBMIT = "unsubmit";
    protected static final String UNAUDIT = "unaudit";
    protected static final String DELETE = "delete";
    protected static final String WITHDRAW = "withdraw";

    public void afterCreateNewData(EventObject e) {
        this.initOrderData();
    }

    private void initOrderData() {
        this.initDefaultBillDate();
    }

    private void initDefaultBillDate() {
        Date billDate = DateUtil.getNowDate();
        this.setValue(BILL_DATE, billDate);
    }

    public void registerListener(EventObject e) {
        this.addTabSelectListener(this, new String[]{TABAP});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        int index = this.getRowIndex(e);
        switch (key) {
            case "billdate": {
                this.billDateChange();
                break;
            }
            case "entryconfirmarrivaldate": {
                this.entryArrivalDateChange(index);
                break;
            }
            case "assistqty": 
            case "qty": {
                this.handlerQty(key, index);
                this.calcuAmount(index);
                break;
            }
            case "orderneednum": {
                this.orderNeedNumChange(index);
                break;
            }
            case "confirmarrivaldate": {
                this.confirmArrivalDateChange();
            }
        }
    }

    private void confirmArrivalDateChange() {
        Date confirmDate = this.getDateFieldValue(CONFIRM_ARRIVAL_DATE);
        if (confirmDate == null) {
            return;
        }
        Date now = DateUtil.getNowDate();
        if (confirmDate.before(now)) {
            confirmDate = now;
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u4ea4\u8d27\u65e5\u671f\u4e0d\u65e9\u4e8e\uff1a%s", (String)"DispatchOrderPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]), DateUtil.getDateFormat((Date)now)));
        }
        this.setValue(CONFIRM_ARRIVAL_DATE, confirmDate);
        this.syncEntryConfirmArrivalDate(confirmDate);
    }

    private void syncEntryConfirmArrivalDate(Date confirmDate) {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount(TB_ITEM_ENTRY);
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            this.setRowValue("entryconfirmarrivaldate", confirmDate, i);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "delentry": {
                this.isAllDel();
                break;
            }
            case "invalid": {
                DynamicObject order = this.getModel().getDataEntity();
                SaleOrderStatus status = SaleOrderUtil.getOrderStatus((DynamicObject)order);
                if (!SaleOrderStatus.TEMP_SAVE.equals((Object)status)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6682\u5b58\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u4f5c\u5e9f\uff01", (String)"DispatchOrderPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                }
                this.showForm("mdr_saleorder_invalid", new HashMap(), new CloseCallBack((IFormPlugin)this, TO_INVALID), ShowType.Modal);
                e.setCancel(true);
                break;
            }
            case "unsubmit": 
            case "unaudit": 
            case "delete": 
            case "withdraw": 
            case "valid": {
                String opMessage = OrderOperateLogHandler.getOpMessage((String)key);
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("message", opMessage);
                this.showForm("mdr_operate_confirm", param, new CloseCallBack((IFormPlugin)this, key), ShowType.Modal);
                e.setCancel(true);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "invalid": {
                Map param = (Map)e.getReturnData();
                if (param == null) {
                    return;
                }
                Object detail = param.get("detail");
                this.setValue("invalidreason", detail);
                DynamicObject order = this.getModel().getDataEntity(true);
                order.set("operateremark", detail);
                OperationUtil.invokeOperation((DynamicObject)order, (String)actionId);
                this.reLoadPage();
                break;
            }
            case "unsubmit": 
            case "unaudit": 
            case "delete": 
            case "withdraw": 
            case "valid": {
                Map param = (Map)e.getReturnData();
                if (param == null || param.get("isconfirm") == null || !"true".equals(param.get("isconfirm"))) break;
                String remark = (String)param.get("remark");
                DynamicObject order = this.getModel().getDataEntity(true);
                order.set("operateremark", (Object)remark);
                OperationUtil.invokeOperation((DynamicObject)order, (String)actionId);
                this.reLoadPage();
            }
        }
    }

    private void isAllDel() {
        EntryGrid itemEntry = (EntryGrid)this.getControl(TB_ITEM_ENTRY);
        int itemEntrySize = this.getModel().getEntryRowCount(TB_ITEM_ENTRY);
        int itemSelectedSize = itemEntry.getSelectRows().length;
        if (itemSelectedSize == itemEntrySize) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u4fdd\u7559\u4e00\u6761\u5206\u5f55", (String)"DispatchOrderPlugin_2", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        switch (key = e.getOperateKey()) {
            case "delentry": {
                this.calcuTotalAmountAndQty();
            }
        }
    }

    private void orderNeedNumChange(int index) {
        BigDecimal orderNeedQty;
        DynamicObject rowInfo = this.getRowInfo(TB_ITEM_ENTRY, index);
        BigDecimal unitQty = rowInfo.getBigDecimal(QTY);
        if (unitQty.compareTo(orderNeedQty = rowInfo.getBigDecimal(ORDER_NEED_NUM)) < 0) {
            this.getModel().setValue(ORDER_NEED_NUM, (Object)unitQty, index);
            this.getView().showMessage(ResManager.loadKDString((String)"\u9700\u751f\u4ea7\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u6570\u91cf", (String)"DispatchOrderPlugin_3", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
    }

    private void handlerQty(String key, int index) {
        switch (key) {
            case "assistqty": {
                break;
            }
            default: {
                this.reCalcuAllQty(index);
            }
        }
    }

    private void reCalcuAllQty(int index) {
        DynamicObject assisUnit;
        Object itemId = this.getEntryF7PKValue(TB_ITEM_ENTRY, "item", index);
        DynamicObject rowInfo = this.getRowInfo(TB_ITEM_ENTRY, index);
        BigDecimal unitQty = rowInfo.getBigDecimal(QTY);
        this.getModel().setValue(ORDER_NEED_NUM, (Object)unitQty, index);
        DynamicObject unit = rowInfo.getDynamicObject("unit");
        BigDecimal baseQty = this.getUnitFormHandler().getBaseQty(itemId, unitQty, unit.getPkValue());
        this.getModel().setValue(BASE_QTY, (Object)baseQty, index);
        DynamicObject infoById = ItemUtil.getItemBizInfo((Object)itemId);
        String conversionfor = infoById.getString("conversionfor");
        BigDecimal assistQty = rowInfo.getBigDecimal(ASSIST_QTY);
        if ((ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_ASSISTUNIT.getConversionFor().equals(conversionfor)) && (assisUnit = rowInfo.getDynamicObject(F7_ASSIST_UNIT)) != null) {
            assistQty = this.getUnitFormHandler().getUnitQty(itemId, assisUnit.getPkValue(), baseQty);
        }
        this.getModel().setValue(ASSIST_QTY, (Object)assistQty, index);
    }

    private void calcuAmount(int index) {
        this.calcuAmount(index, true);
    }

    private void calcuAmount(int index, boolean needCalcuTotalAmount) {
        DynamicObject rowInfo = this.getRowInfo(TB_ITEM_ENTRY, index);
        BigDecimal unitQty = rowInfo.getBigDecimal(QTY);
        BigDecimal price = rowInfo.getBigDecimal(PRICE);
        BigDecimal orderAmount = price.multiply(unitQty);
        this.getModel().setValue(ORDER_AMOUNT, (Object)orderAmount, index);
        if (needCalcuTotalAmount) {
            this.calcuTotalAmountAndQty();
        }
    }

    private void calcuTotalAmountAndQty() {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount(TB_ITEM_ENTRY);
        BigDecimal orderAmount = BigDecimal.ZERO;
        BigDecimal totalQty = BigDecimal.ZERO;
        DynamicObject rowInfo = null;
        BigDecimal price = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            rowInfo = model.getEntryRowEntity(TB_ITEM_ENTRY, i);
            orderAmount = orderAmount.add(rowInfo.getBigDecimal(ORDER_AMOUNT));
            totalQty = totalQty.add(rowInfo.getBigDecimal(QTY));
            price = price.add(rowInfo.getBigDecimal(PRICE));
        }
        model.setValue(TOTAL_QTY, (Object)totalQty);
        model.setValue(TOTAL_ORDER_AMOUNT, (Object)orderAmount);
        BigDecimal receivedamount = this.getModel().getDataEntity().getBigDecimal(RECEIVED_AMOUNT);
        BigDecimal amountToBePaid = orderAmount.subtract(receivedamount);
        model.setValue(AMOUNT_TO_BE_PAID, (Object)amountToBePaid);
    }

    private void billDateChange() {
        Date limitDate;
        Date date = this.getDateFieldValue(BILL_DATE);
        if (date.before(limitDate = DateUtil.getNowDate())) {
            this.setValue(BILL_DATE, limitDate);
            this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65e5\u671f", (String)"DispatchOrderPlugin_4", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
    }

    private void entryArrivalDateChange(int index) {
        Date limitDate;
        Date date = (Date)this.getModel().getValue("entryconfirmarrivaldate", index);
        if (date.before(limitDate = DateUtil.getNowDate())) {
            this.getModel().setValue("entryconfirmarrivaldate", (Object)limitDate, index);
            this.setValue("entryconfirmarrivaldate", limitDate);
            this.getView().showMessage(ResManager.loadKDString((String)"\u786e\u8ba4\u5230\u8d27\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65e5\u671f", (String)"DispatchOrderPlugin_5", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
    }

    public void tabSelected(TabSelectEvent e) {
        String key;
        switch (key = e.getTabKey()) {
            case "paytb": 
            case "deliveryrecordtb": 
            case "oplogtb": {
                if (this.isLoaded(key)) {
                    return;
                }
                this.loadTb(key);
            }
        }
    }

    private boolean isLoaded(String key) {
        return null != this.getPageCache().get("loadtb-" + key);
    }

    private void loadTb(String key) {
        switch (key) {
            case "paytb": {
                this.loadPayTb();
                break;
            }
            case "deliveryrecordtb": {
                this.loadDeliveryRecordTb();
                break;
            }
            case "oplogtb": {
                this.loadOpLogTb();
            }
        }
    }

    private void loadOpLogTb() {
        if (this.isNewCreate()) {
            return;
        }
        ListFilterParameter filter = new ListFilterParameter();
        QFilter f = new QFilter("orderid", "=", (Object)this.getId().toString());
        f.and("ordertype", "=", (Object)"dispatchorder");
        filter.setFilter(f);
        this.showInnerTbPage("mdr_order_oplogtb", PAGE_OPLOGTB, filter);
    }

    private void loadPayTb() {
        Set billIds = ReceivingbillUtil.queryReceivingbillByDispatchOrder((Object)this.getId());
        ArrayList<QFilter> tbFilters = new ArrayList<QFilter>();
        tbFilters.add(new QFilter("id", "in", (Object)billIds));
        ListFilterParameter filter = new ListFilterParameter();
        filter.setQFilters(tbFilters);
        this.showInnerTbPage("mdr_orderreceiingbill", PAGE_PAYTB, filter);
    }

    private void loadDeliveryRecordTb() {
        ListFilterParameter filter = new ListFilterParameter();
        filter.setFilter(this.createDispatchOrderFilter());
        this.showInnerTbPage("mdr_orderdeliveryrecord", PAGE_DELIVERYRECORDTB, filter);
    }

    protected QFilter createDispatchOrderFilter() {
        QFilter filter = new QFilter(SOURCEBILLTYPE, "=", (Object)"dispatchorder");
        filter.and("deliverydetail.srcbillid", "=", this.getId());
        return filter;
    }

    protected void showInnerTbPage(String pageName, String tbName, ListFilterParameter filter) {
        String flag = "loadtb-" + tbName;
        String id = this.getPageCache().get(flag);
        if (id == null) {
            ListShowParameter parameter = new ListShowParameter();
            String pageId = parameter.getPageId();
            parameter.setFormId(pageName);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey(tbName);
            parameter.setListFilterParameter(filter);
            this.getView().showForm((FormShowParameter)parameter);
            this.getPageCache().put(flag, pageId);
        } else {
            this.getView().getView(id).invokeOperation(RE_FRESH);
            this.getView().sendFormAction(this.getView().getView(id));
        }
    }

    public void convertPk(ConvertPkEvent e) {
        Map param = e.getDataObject();
        if (param.get("easupdateorder") != null) {
            this.easAlterOrder(param);
        }
        super.convertPk(e);
    }

    private void easAlterOrder(Map<String, Object> param) {
        Boolean isEasUpdate = (Boolean)param.get("easupdateorder");
        if (isEasUpdate.booleanValue()) {
            String saleorderid = (String)param.get("orderid");
            ArrayList entrylist = (ArrayList)param.get("entry");
            String delids = (String)param.get("deleteentryids");
            String[] ids = delids.split(",");
            DynamicObject oldOrder = BusinessDataServiceHelper.loadSingle((Object)saleorderid, (String)"mdr_dispatch_order");
            if (oldOrder == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ebf\u4e0a\u8ba2\u5355\u4e0d\u5b58\u5728\uff01", (String)"DispatchOrderPlugin_6", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            }
            if (param.get("otherdate") != null) {
                String receivableDate = (String)param.get("otherdate");
                Date date = this.getDate(receivableDate);
                param.put("receivabledate", date);
            }
            DynamicObjectCollection entrys = oldOrder.getDynamicObjectCollection(TB_ITEM_ENTRY);
            for (DynamicObject entry : entrys) {
                for (int i = 0; i < entrylist.size(); ++i) {
                    String entryid = ((Map)entrylist.get(i)).get("orderentryid").toString();
                    if (!entryid.equals(entry.getPkValue().toString())) continue;
                    if (((Map)entrylist.get(i)).get(QTY) != null) {
                        BigDecimal qty = new BigDecimal(((Map)entrylist.get(i)).get(QTY).toString());
                        BigDecimal deliveredQty = (BigDecimal)entry.get("deliveredqty");
                        if (deliveredQty != null && deliveredQty.compareTo(qty) > 0) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u540e\u6570\u91cf\u5c0f\u4e8e\u5df2\u53d1\u8d27\u6570\u91cf\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01", (String)"DispatchOrderPlugin_7", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                        }
                        entry.set(QTY, (Object)qty);
                    }
                    if (((Map)entrylist.get(i)).get("amount") != null) {
                        entry.set(ORDER_AMOUNT, ((Map)entrylist.get(i)).get("amount"));
                    }
                    if (((Map)entrylist.get(i)).get("senddate") != null) {
                        entry.set("entryconfirmarrivaldate", (Object)this.getDate((String)((Map)entrylist.get(i)).get("senddate")));
                    }
                    if (((Map)entrylist.get(i)).get("alreadyreceqty") != null) {
                        entry.set("alreadyreceqty", ((Map)entrylist.get(i)).get("alreadyreceqty"));
                    }
                    if (((Map)entrylist.get(i)).get("alreadyreceamount") == null) continue;
                    entry.set("alreadyreceamount", ((Map)entrylist.get(i)).get("alreadyreceamount"));
                }
                for (String id : ids) {
                    if (!id.equals(entry.getPkValue().toString())) continue;
                    entry.set(QTY, (Object)0);
                    entry.set(ORDER_AMOUNT, (Object)0);
                }
            }
            DispatchOrderHandler.reHandleOrderQtysAndAmounts((DynamicObject)oldOrder, (String)ORDER_AMOUNT);
            DynamicObjectCollection newEntrys = oldOrder.getDynamicObjectCollection(TB_ITEM_ENTRY);
            param.put("id", oldOrder.getPkValue());
            param.put("orderstatus", DispatchOrderStatus.CHANGING.getFlagStr());
            Date confirmarrivaldate = null;
            boolean confirmarrivaldateDiff = false;
            ArrayList newEntryList = new ArrayList();
            for (DynamicObject newEntry : newEntrys) {
                HashMap<String, Object> entyMap = new HashMap<String, Object>();
                boolean isFind = false;
                for (int i = 0; i < entrylist.size(); ++i) {
                    String entryid = ((Map)entrylist.get(i)).get("orderentryid").toString();
                    if (!entryid.equals(newEntry.getPkValue().toString())) continue;
                    entyMap.put("id", newEntry.getPkValue());
                    entyMap.put(QTY, newEntry.get(QTY));
                    entyMap.put(PRICE, newEntry.get(PRICE));
                    entyMap.put(ORDER_AMOUNT, newEntry.get(ORDER_AMOUNT));
                    entyMap.put("entryconfirmarrivaldate", newEntry.get("entryconfirmarrivaldate"));
                    entyMap.put("alreadyreceqty", newEntry.get("alreadyreceqty"));
                    entyMap.put("alreadyreceamount", newEntry.get("alreadyreceamount"));
                    isFind = true;
                }
                for (String id : ids) {
                    if (!id.equals(newEntry.getPkValue().toString())) continue;
                    entyMap.put("id", newEntry.getPkValue());
                    entyMap.put(QTY, 0);
                    entyMap.put(ORDER_AMOUNT, 0);
                    isFind = true;
                }
                if (!isFind) {
                    entyMap.put("id", newEntry.getPkValue());
                }
                newEntryList.add(entyMap);
                if (confirmarrivaldateDiff) continue;
                Date entryconfirmarrivaldate = (Date)newEntry.get("entryconfirmarrivaldate");
                if (confirmarrivaldate == null) {
                    confirmarrivaldate = entryconfirmarrivaldate;
                    continue;
                }
                if (confirmarrivaldate.compareTo(entryconfirmarrivaldate) == 0) continue;
                confirmarrivaldateDiff = true;
            }
            if (!confirmarrivaldateDiff) {
                param.put(CONFIRM_ARRIVAL_DATE, confirmarrivaldate);
            }
            param.put(TB_ITEM_ENTRY, newEntryList);
            param.put("operateremark", ResManager.loadKDString((String)"EAS\u8ba2\u5355\u53d8\u66f4\u540c\u6b65", (String)"DispatchOrderPlugin_8", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
    }

    private Date getDate(String dateStr) {
        SimpleDateFormat simFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = simFormat.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }
}

