/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.bill.saleorder;

import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.drp.bbc.formplugin.filter.saleorder.OEMFilter;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrListPlugin;

public class OEMSaleOrderListPlugin
extends MdrListPlugin {
    public static final String PRODUCT_STATUS = "productstatus";
    public static final String SEND_STATUS = "sendstatus";

    public void filterContainerInit(FilterContainerInitArgs e) {
        this.initOwnerFilterComboItem(e, "owner.name");
    }

    public void setFilter(SetFilterEvent e) {
        List initQFilter = e.getQFilters();
        initQFilter.add(this.createOemSaleOrderFilter(UserUtil.getOwnerIDs()));
        e.setQFilters(initQFilter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "inventoryreport": 
            case "completereport": 
            case "pushdeliveryrecord": {
                this.getSelectedIds(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "inventoryreport": {
                if (!e.getOperationResult().isSuccess()) {
                    return;
                }
                Object[] pkId = this.getSelectedIds(true);
                BillShowParameter billparameter = new BillShowParameter();
                billparameter.setBillStatus(BillOperationStatus.AUDIT);
                billparameter.setFormId("bbc_oemsaleorder");
                billparameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                billparameter.setPkId(pkId[0]);
                this.getView().showForm((FormShowParameter)billparameter);
                break;
            }
        }
    }

    private QFilter createOemSaleOrderFilter(List<Object> owners) {
        QFilter f = null;
        QFilter orFilter = null;
        for (Object owner : owners) {
            orFilter = new OEMFilter(owner).getBillFilter();
            if (f == null) {
                f = orFilter;
                continue;
            }
            f.or(orFilter);
        }
        return f;
    }
}

