/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.bill.saleorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.util.BizValidateUtils;
import kd.drp.mdr.common.util.DateUtil;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.PriceUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.ValidateUtils;
import kd.drp.mdr.common.util.WarehouseRuleUtil;
import kd.drp.mdr.formplugin.MdrBillPlugin;

public class OrderAllotEditPlugin
extends MdrBillPlugin
implements BeforeF7SelectListener {
    private static final String CACHE_KEY_SETED_VALUE = "cache_key_seted_value";
    private static final String F7_TRANSPORTTYPE = "transporttype";
    private static final String TB_ENTRY = "allotentry";
    private static final String CONFIRMARRIVALDATE = "confirmarrivaldate";
    private static final String SOURCE_ORDER = "sourceorder";
    private static final String SOURCE_ENTRY = "sourceentry";
    private static final String QTY = "qty";
    private static final String TOTAL_QTY = "totalqty";
    private static final String ITEM_PRICE = "itemprice";
    private static final String PRICE = "price";
    private static final String CUST_CHANGE_PRICE = "custchangeprice";
    private static final String ORDER_AMOUNT = "orderamount";
    private static final String CURRENCY = "currency";
    private static final String OLD_QTY = "oldqty";
    private static final String NEW_QTY = "newqty";
    private static final String ALLOTEN_QTY = "allotenqty";
    private static final String CAN_ALLOT = "canallot";
    private static final String RE_SET_ENTRY = "resetentry";
    private static final String AUDIT = "audit";
    private static final String DELETE_ENTRY = "deleteentry";
    private static final String NEW_ENTRY = "newentry";
    private static final String ENTRY_SEQ = "entryseq";
    private static final String ENTRY_CONFIRMARRIVAL_DATE = "entryconfirmarrivaldate";
    private static final String ENTRY_ARRIVALDATE = "entryarrivaldate";
    private static final String ORDER_NEED_NUM = "orderneednum";
    private static final String ENTRY_WAREHOUSE = "entrywarehouse";
    private static final String RECEIVABLE_COMPANY = "receivablecompany";
    private static final String PASS_TYPE = "passtype";
    private static final String BIZTYPE = "biztype";
    private static final String CUSTOMER_PHONE = "customerphone";
    private static final String CAR_NO = "carno";
    private static final String DRIVER_TEL = "drivertel";
    private static final String ORDER_REMARK = "orderremark";
    private static final String ORDER_DATE = "orderdate";
    private static final String BILLING_TYPE = "billingtype";
    private static String[] cols = new String[]{"item", "entrywarehouse", "unit", "assistattr", "entryconfirmarrivaldate", "entryarrivaldate", "itemprice", "price", "orderamount", "qty", "custchangeprice", "allotenqty", "orderneednum"};
    private static String[] headCols = new String[]{"owner", "customer", "billingtype", "customerphone", "currency", "orderdate", "transporttype", "confirmarrivaldate", "saler", "receivablecompany", "passtype", "carno", "biztype", "drivertel", "orderremark"};
    private static String[] cols2 = new String[]{"sourceorder", "sourceentry", "entryseq", "item", "unit", "assistattr", "entryconfirmarrivaldate", "orderneednum", "entryarrivaldate", "qty", "totalqty", "oldqty", "allotenqty", "newqty", "canallot", "itemprice", "price", "orderamount", "custchangeprice"};
    protected static final String CACHE_KEY_USEWAREHOUSERULE = "cache_key_usewarehouserule";

    public void afterCreateNewData(EventObject e) {
        if (this.getPageCache().get(CACHE_KEY_SETED_VALUE) == null) {
            this.initSaleOrderInfo();
            this.getPageCache().put(CACHE_KEY_SETED_VALUE, "true");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{ENTRY_WAREHOUSE, "unit", RECEIVABLE_COMPANY, "item", "assistattr"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "audit": {
                int count = this.getModel().getEntryRowCount(TB_ENTRY);
                if (count <= 0) {
                    e.setCancel(true);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"OrderAllotEditPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!this.checkTel()) {
                    e.setCancel(true);
                    break;
                }
                CheckResult result = this.checkNeedNum();
                if (!result.isSuccess()) {
                    this.getView().showMessage(result.getMsg());
                    e.setCancel(true);
                    break;
                }
                result = this.checkAssistAttr();
                if (result.isSuccess()) break;
                this.getView().showMessage(result.getMsg());
                e.setCancel(true);
                break;
            }
        }
    }

    private CheckResult checkAssistAttr() {
        int count = this.getModel().getEntryRowCount(TB_ENTRY);
        for (int i = 0; i < count; ++i) {
            DynamicObject assistAttr;
            DynamicObject item = this.getEntryF7Value(TB_ENTRY, "item", i);
            CheckResult result = this.checkItemAttrValidate(item, assistAttr = this.getEntryF7Value(TB_ENTRY, "assistattr", i));
            if (result.isSuccess()) continue;
            return result;
        }
        return CheckResult.returnTrue();
    }

    private CheckResult checkItemAttrValidate(DynamicObject item, DynamicObject assistAttr) {
        boolean hasAssistAttr = this.hasAssistAttr(item);
        if (hasAssistAttr) {
            if (assistAttr == null) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5546\u54c1\u5f00\u542f\u8f85\u52a9\u5c5e\u6027\uff0c\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"OrderAllotEditPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            }
            if (!ItemAttrUtil.hasAssistAttr((Object)item.getPkValue(), (Object)assistAttr.getPkValue())) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5546\u54c1\u4e0d\u5b58\u5728\u5f53\u524d\u8f85\u52a9\u5c5e\u6027[%s]\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\uff01", (String)"OrderAllotEditPlugin_2", (String)"drp-bbc-formplugin", (Object[])new Object[0]), (Object[])new Object[]{assistAttr.getString("name")});
            }
        }
        return CheckResult.returnTrue();
    }

    private boolean hasAssistAttr(DynamicObject item) {
        boolean hasattr = false;
        if (item != null) {
            hasattr = item.getBoolean("hasattr");
        }
        return hasattr;
    }

    private CheckResult checkNeedNum() {
        int count = this.getModel().getEntryRowCount(TB_ENTRY);
        DynamicObject rowInfo = null;
        for (int i = 0; i < count; ++i) {
            rowInfo = this.getRowInfo(TB_ENTRY, i);
            if (rowInfo.getBigDecimal(NEW_QTY).compareTo(rowInfo.getBigDecimal(ORDER_NEED_NUM)) >= 0) continue;
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff1a\u9700\u751f\u4ea7\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u786e\u8ba4\u6570\u91cf", (String)"OrderAllotEditPlugin_3", (String)"drp-bbc-formplugin", (Object[])new Object[0]), (Object[])new Object[]{i + 1});
        }
        return CheckResult.returnTrue();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "resetentry": {
                this.reSetTb();
                break;
            }
            case "audit": {
                if (!e.getOperationResult().isSuccess()) break;
                this.getModel().setDataChanged(false);
                this.getView().close();
                break;
            }
            case "newentry": {
                this.setEnable(this.getModel().getEntryRowCount(TB_ENTRY), new String[]{"item"});
                break;
            }
        }
    }

    private void reSetTb() {
        IDataModel model = this.getModel();
        model.deleteEntryData(TB_ENTRY);
        this.initSaleOrderInfo(this.getF7PKValue("order"));
    }

    private void initSaleOrderInfo() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object orderId = fsp.getCustomParam("orderid");
        if (orderId == null) {
            return;
        }
        this.initSaleOrderInfo(orderId);
    }

    private void initSaleOrderInfo(Object orderId) {
        DynamicObject order = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"bbc_saleorder");
        this.loadHead(order);
        this.loadEntryTB(order);
    }

    private void loadEntryTB(DynamicObject order) {
        DynamicObjectCollection entrys = order.getDynamicObjectCollection("itementry");
        int count = entrys.size();
        for (int i = 0; i < count; ++i) {
            if (!this.canAllot((DynamicObject)entrys.get(i))) continue;
            this.createOneRow(this.getEntryVals((DynamicObject)entrys.get(i)));
        }
    }

    private boolean canAllot(DynamicObject entry) {
        BigDecimal qty = entry.getBigDecimal(QTY);
        BigDecimal allotenqty = entry.getBigDecimal(ALLOTEN_QTY);
        return allotenqty.compareTo(BigDecimal.ZERO) <= 0 && qty.compareTo(BigDecimal.ZERO) > 0;
    }

    private void setColsEnable(int index) {
        if (!this.isChangepriceoramount()) {
            this.setUnEnable(index, new String[]{PRICE, ORDER_AMOUNT});
        }
    }

    private int createOneRow(Map<String, Object> entryMap) {
        IDataModel model = this.getModel();
        int index = model.createNewEntryRow(TB_ENTRY);
        this.setUnEnable(index, new String[]{"item"});
        this.setUnEnable(index, new String[]{"unit"});
        this.setUnEnable(index, new String[]{"assistattr"});
        this.setColsEnable(index);
        for (Map.Entry<String, Object> entry : entryMap.entrySet()) {
            model.setValue(entry.getKey(), entry.getValue(), index);
        }
        return index;
    }

    private void entryConfirmArrivalDateChange(int index) {
        Date confirmDate = this.getRowInfo(TB_ENTRY, index).getDate(ENTRY_CONFIRMARRIVAL_DATE);
        if (confirmDate == null) {
            return;
        }
        Date now = new Date();
        if (confirmDate.before(now)) {
            confirmDate = now;
            this.getModel().setValue(ENTRY_CONFIRMARRIVAL_DATE, (Object)confirmDate, index);
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u4ea4\u8d27\u65e5\u671f\u4e0d\u65e9\u4e8e\uff1a%s", (String)"OrderAllotEditPlugin_4", (String)"drp-bbc-formplugin", (Object[])new Object[0]), DateUtil.getDateFormat((Date)now)));
        }
    }

    private Map<String, Object> getEntryVals(DynamicObject entry) {
        int size = cols.length + 6;
        HashMap<String, Object> vals = new HashMap<String, Object>(size);
        for (String col : cols) {
            vals.put(col, entry.get(col));
        }
        Object orderId = this.getF7PKValue("order");
        vals.put(SOURCE_ORDER, orderId);
        vals.put(SOURCE_ENTRY, entry.get("id"));
        vals.put(ENTRY_SEQ, entry.get("seq"));
        BigDecimal qty = entry.getBigDecimal(QTY);
        BigDecimal allotenqty = entry.getBigDecimal(ALLOTEN_QTY);
        BigDecimal totalqty = qty.subtract(allotenqty);
        vals.put(NEW_QTY, totalqty);
        vals.put(TOTAL_QTY, totalqty);
        vals.put(OLD_QTY, totalqty);
        return vals;
    }

    private void loadHead(DynamicObject order) {
        IDataModel model = this.getModel();
        model.setValue("order", order.get("id"));
        for (String col : headCols) {
            model.setValue(col, order.get(col));
        }
        model.setValue(ORDER_DATE, (Object)new Date());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (key.equals("item")) {
            this.triggerChangeEvent = true;
        }
        if (!this.triggerChangeEvent) {
            return;
        }
        this.triggerChangeEvent = false;
        int index = this.getRowIndex(e);
        switch (key) {
            case "item": {
                this.itemchanged(index);
                break;
            }
            case "unit": {
                this.unitChanged(index, key);
                break;
            }
            case "assistattr": {
                this.itemAssistAttrChanged(e);
                break;
            }
            case "entryconfirmarrivaldate": {
                break;
            }
            case "orderneednum": {
                break;
            }
            case "newqty": {
                this.handleQtyChange(index);
            }
            case "price": {
                this.handlePriceChange(index);
                break;
            }
            case "orderamount": {
                this.handleOrderAmountChange(index);
                break;
            }
            case "customerphone": {
                this.checkTel();
                break;
            }
            case "confirmarrivaldate": {
                this.handleConfirmArrivalDatechange();
                break;
            }
            default: {
                this.triggerChangeEvent = true;
            }
        }
    }

    private boolean checkTel() {
        String tel = this.getModel().getDataEntity().getString(CUSTOMER_PHONE);
        if (StringUtils.isEmpty((String)tel)) {
            return true;
        }
        tel = tel.trim();
        this.getModel().setValue(CUSTOMER_PHONE, (Object)tel);
        CheckResult check = ValidateUtils.validMobPhone((String)tel);
        if (!check.isSuccess()) {
            this.getView().showTipNotification(check.getMsg());
            return false;
        }
        return true;
    }

    private void unitChanged(int index, String key) {
        this.itemPropertyChanged(index, key);
    }

    private void itemAssistAttrChanged(PropertyChangedArgs e) {
        DynamicObject assistattr;
        int index = this.getRowIndex(e);
        String key = e.getProperty().getName();
        Object itemId = this.getEntryF7PKValue(TB_ENTRY, "item", index);
        if (!BizValidateUtils.itemAttrNullValidate((Object)itemId, (DynamicObject)(assistattr = (DynamicObject)e.getChangeSet()[0].getNewValue()))) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (oldValue != null) {
                this.setValue("assistattr", oldValue, index);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u5f00\u542f\u8f85\u52a9\u5c5e\u6027\uff0c\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"OrderAllotEditPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        this.itemPropertyChanged(index, key);
    }

    private void itemPropertyChanged(int index, String key) {
        this.setPrice(index);
        this.reHandleAmount(index);
    }

    private void itemchanged(int index) {
        Object itemPK = this.getEntryF7PKValue(TB_ENTRY, "item", index);
        if (itemPK == null) {
            return;
        }
        this.initRowUnits(index);
        this.initRowAssistAttrs(index);
        Date confirmArrivalDate = (Date)this.getValue(CONFIRMARRIVALDATE);
        this.setRowValue(ENTRY_CONFIRMARRIVAL_DATE, confirmArrivalDate, index);
        this.setRowValue(ENTRY_ARRIVALDATE, confirmArrivalDate, index);
    }

    private void initRowUnits(int index) {
        Object itemPK = this.getEntryF7PKValue(TB_ENTRY, "item", index);
        Object unitId = this.getUnitFormHandler().getSaleUnitId(itemPK);
        this.setValue("unit", unitId, index);
        DynamicObject assistAttr = this.getEntryF7Value(TB_ENTRY, "assistattr", index);
        Object assistAttrId = 0L;
        if (assistAttr != null) {
            assistAttrId = assistAttr.get("id");
        }
        this.setPrice(index, itemPK, unitId, assistAttrId);
    }

    private void initRowAssistAttrs(int index) {
        Object itemPK = this.getEntryF7PKValue(TB_ENTRY, "item", index);
        Object defaultAttr = ItemAttrUtil.getDefaultAttrId((Object)itemPK);
        this.setRowValue("assistattr", defaultAttr, index);
    }

    private void handleConfirmArrivalDatechange() {
        Date confirmArrivalDate = (Date)this.getValue(CONFIRMARRIVALDATE);
        int entryRowCount = this.getModel().getEntryRowCount(TB_ENTRY);
        for (int i = 0; i < entryRowCount; ++i) {
            this.setRowValue(ENTRY_CONFIRMARRIVAL_DATE, confirmArrivalDate, i);
        }
    }

    private void handleOrderAmountChange(int index) {
        this.setPrice(index);
        DynamicObject rowInfo = this.getRowInfo(TB_ENTRY, index);
        BigDecimal orderAmount = rowInfo.getBigDecimal(ORDER_AMOUNT);
        BigDecimal newQty = rowInfo.getBigDecimal(NEW_QTY);
        BigDecimal price = orderAmount.divide(newQty, this.getPrecision(), 4);
        this.setRowValue(PRICE, price, index);
        this.setRowValue(CUST_CHANGE_PRICE, Boolean.TRUE, index);
    }

    private void handlePriceChange(int index) {
        this.setRowValue(CUST_CHANGE_PRICE, Boolean.TRUE, index);
        this.reHandleAmount(index);
    }

    private void reHandleAmount(int index) {
        DynamicObject rowInfo = this.getRowInfo(TB_ENTRY, index);
        BigDecimal newQty = rowInfo.getBigDecimal(NEW_QTY);
        BigDecimal price = rowInfo.getBigDecimal(PRICE);
        BigDecimal orderAmount = newQty.multiply(price).setScale(this.getPrecision(), 4);
        this.setRowValue(ORDER_AMOUNT, orderAmount, index);
    }

    private int getPrecision() {
        int amtprecision = 2;
        DynamicObject currency = this.getF7Value(CURRENCY);
        if (currency != null) {
            amtprecision = currency.getInt("amtprecision");
        }
        return amtprecision;
    }

    private void setPrice(int index) {
        Object itemPK = this.getEntryF7PKValue(TB_ENTRY, "item", index);
        Object unitPK = this.getEntryF7PKValue(TB_ENTRY, "unit", index);
        DynamicObject assistAttr = this.getEntryF7Value(TB_ENTRY, "assistattr", index);
        Object assistAttrId = 0L;
        if (assistAttr != null) {
            assistAttrId = assistAttr.get("id");
        }
        this.setPrice(index, itemPK, unitPK, assistAttrId);
    }

    private void setPrice(int index, Object itemPK, Object unitPK, Object assistAttrId) {
        Object ownerId = this.getOwnerF7PKValue();
        Object customerId = this.getCustomerF7PKValue();
        BigDecimal qty = this.getRowInfo(TB_ENTRY, index).getBigDecimal(NEW_QTY);
        BigDecimal itemPrice = PriceUtil.getItemPrice((Object)ownerId, (Object)customerId, (Object)itemPK, (Object)unitPK, (Object)assistAttrId, (BigDecimal)qty);
        this.setRowValue(ITEM_PRICE, itemPrice, index);
        this.setRowValue(PRICE, itemPrice, index);
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        switch (e.getOperationKey()) {
            case "deleteentry": {
                CheckResult re = this.canDeleteEntry();
                if (re.isSuccess()) break;
                e.setCancel(true);
                this.getView().showMessage(re.getMsg());
                break;
            }
        }
    }

    private CheckResult canDeleteEntry() {
        EntryGrid entrys = (EntryGrid)this.getControl(TB_ENTRY);
        int[] rows = entrys.getSelectRows();
        int len = rows.length;
        for (int i = 0; i < len; ++i) {
            if (this.getRowInfo(TB_ENTRY, rows[i]).getBoolean(CAN_ALLOT)) continue;
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u4e0d\u80fd\u518d\u5206\u914d\u7684\u884c\u4e0d\u80fd\u5220\u9664\uff01", (String)"OrderAllotEditPlugin_5", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        return CheckResult.returnTrue();
    }

    private void checkOrderNeedNum(int index) {
        DynamicObject rowInfo = this.getRowInfo(TB_ENTRY, index);
        BigDecimal qty = rowInfo.getBigDecimal(QTY);
        BigDecimal needNum = rowInfo.getBigDecimal(ORDER_NEED_NUM);
        if (needNum.compareTo(qty) > 0 || needNum.compareTo(BigDecimal.ZERO) < 0) {
            this.getModel().setValue(ORDER_NEED_NUM, (Object)qty, index);
            this.getView().showMessage(ResManager.loadKDString((String)"\u9700\u751f\u4ea7\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5206\u914d\u6570\u91cf\u4e14\u4e0d\u80fd\u5c0f\u4e8e0\uff01", (String)"OrderAllotEditPlugin_6", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
    }

    private void handleQtyChange(int index) {
        IDataModel model = this.getModel();
        DynamicObject row = model.getEntryRowEntity(TB_ENTRY, index);
        BigDecimal newQty = row.getBigDecimal(NEW_QTY);
        BigDecimal oldQty = row.getBigDecimal(OLD_QTY);
        String sourceentryStr = (String)row.get(SOURCE_ENTRY);
        if (sourceentryStr == null || sourceentryStr.length() == 0 || sourceentryStr.equals("") || sourceentryStr.trim().isEmpty()) {
            model.setValue(QTY, (Object)newQty, index);
            this.reHandleAmount(index);
            return;
        }
        if (newQty.compareTo(BigDecimal.ZERO) <= 0) {
            this.getModel().setValue(QTY, (Object)oldQty, index);
            this.getView().showMessage(ResManager.loadKDString((String)"\u5206\u914d\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\uff01", (String)"OrderAllotEditPlugin_7", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            return;
        }
        if (newQty.compareTo(oldQty) < 0) {
            BigDecimal oddQty = oldQty.subtract(newQty);
            Map<String, Object> vals = this.getCopyRowVals(row);
            vals.put(NEW_QTY, oddQty);
            vals.put(OLD_QTY, oddQty);
            int rowIndex = index + 1;
            model.appendEntryRow(TB_ENTRY, rowIndex, 1);
            this.setUnEnable(rowIndex, new String[]{"item", "unit", "assistattr"});
            this.setColsEnable(rowIndex);
            this.initRowValue(vals, rowIndex);
            this.reHandleAmount(rowIndex);
        }
        model.setValue(OLD_QTY, (Object)newQty, index);
        this.reHandleAmount(index);
    }

    private void initRowValue(Map<String, Object> vals, int index) {
        IDataModel model = this.getModel();
        for (Map.Entry<String, Object> val : vals.entrySet()) {
            model.setValue(val.getKey(), val.getValue(), index);
        }
    }

    private Map<String, Object> getCopyRowVals(DynamicObject row) {
        int size = cols2.length + 1;
        HashMap<String, Object> vals = new HashMap<String, Object>(size);
        int len = cols2.length;
        for (int i = 0; i < len; ++i) {
            vals.put(cols2[i], row.get(cols2[i]));
        }
        vals.put(ORDER_NEED_NUM, 0);
        return vals;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int rowIndex = e.getRow();
        switch (key) {
            case "unit": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getUnitFilter(rowIndex));
                break;
            }
            case "item": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, this.getItemFilter());
                break;
            }
            case "assistattr": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getAssistAttrFilter(rowIndex));
                break;
            }
            case "receivablecompany": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getReceivableCompanyFitler());
                break;
            }
            case "entrywarehouse": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getEntryWareHouseFilter(rowIndex));
                FormShowParameter param = e.getFormShowParameter();
                param.setCustomParam("itemid", this.getEntryF7PKValue(TB_ENTRY, "item", rowIndex));
                param.setCustomParam("unitid", this.getEntryF7PKValue(TB_ENTRY, "unit", rowIndex));
                param.setCustomParam("customerid", this.getOwnerF7PKValue());
                e.setFormShowParameter(param);
                break;
            }
        }
    }

    private QFilter getReceivableCompanyFitler() {
        Object ownerId = this.getOwnerF7PKValue();
        QFilter fs = new QFilter("customer", "=", ownerId);
        Set ids = QueryUtil.querySingleCol((String)"mdr_warehouse_relation", (String)"warehouse.id", (QFilter[])fs.toArray());
        return new QFilter("id", "in", (Object)ids);
    }

    private List<QFilter> getItemFilter() {
        ArrayList<QFilter> fs = new ArrayList<QFilter>();
        fs.add(ItemSaleControlUtil.getItemFilterUsePageCache((Object)this.getOwnerF7PKValue(), (Object)this.getCustomerF7PKValue(), (IPageCache)this.getPageCache()));
        fs.add(new QFilter("isonsell", "=", (Object)"1"));
        return fs;
    }

    private QFilter getUnitFilter(int rowIndex) {
        List unitIds = this.getUnitFormHandler().getUnitIdList(this.getEntryF7PKValue(TB_ENTRY, "item", rowIndex));
        return new QFilter("id", "in", (Object)unitIds);
    }

    private QFilter getAssistAttrFilter(int rowIndex) {
        return ItemAttrUtil.getAttrFilter((Object)this.getEntryF7PKValue(TB_ENTRY, "item", rowIndex));
    }

    protected boolean isUseWareHouseRule() {
        IPageCache pc = this.getPageCache();
        String value = pc.get(CACHE_KEY_USEWAREHOUSERULE);
        if (StringUtils.isEmpty((String)value)) {
            Boolean useWareHouseRule = SysParamsUtil.isUseWareHouseRule();
            value = useWareHouseRule.toString();
            pc.put(CACHE_KEY_USEWAREHOUSERULE, value);
        }
        return Boolean.parseBoolean(value);
    }

    private QFilter getEntryWareHouseFilter(int rowIndex) {
        if (!this.isUseWareHouseRule()) {
            return null;
        }
        Object itemId = this.getEntryF7PKValue(TB_ENTRY, "item", rowIndex);
        List ids = WarehouseRuleUtil.getWarehouseList((Object)this.getOwnerF7PKValue(), (Object)this.getCustomerF7PKValue(), (Object)itemId);
        return new QFilter("id", "in", (Object)ids);
    }

    private boolean isChangepriceoramount() {
        String key = "changepriceoramount";
        String val = this.getPageCache().get(key);
        boolean re = false;
        if (StringUtils.isEmpty((String)val)) {
            re = SysParamsUtil.isChangepriceoramount();
            this.getPageCache().put(key, re ? "true" : "false");
        } else {
            re = Boolean.parseBoolean(val);
        }
        return re;
    }
}

