/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.bill.saleorder;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.apiclient.jdstore.JDStoreAPIInvokeService;
import kd.drp.mdr.common.matetype.Dto;
import kd.drp.mdr.common.util.DeliveryUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class OrderDeliveryPlugin
extends MdrFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"printbtn", "view", "showjdstore", "delete"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showBillEntry();
    }

    private void showBillEntry() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Long recordId = (Long)fsp.getCustomParam("id");
        DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)recordId, (String)"bbc_delivery_record", (String)"id,billno,sourcebillid,corebillid,sourcebilltype,billstatus,deliverdate,deliverydetail.item,deliverydetail.unit,deliverydetail.deliverqty,deliverydetail.warehouse,deliverydetail.sourcebillentryid,deliverydetail.corebillentryid,deliverydetail.srcbillid,deliverydetail.srcbillentryid");
        this.setValue("billnolable", record.get("billno"));
        this.setValue("billno", record.get("billno"));
        this.setValue("deliverdate", record.get("deliverdate"));
        String billstatus = record.getString("billstatus");
        String billstatusName = ResManager.loadKDString((String)"\u672a\u77e5", (String)"OrderDeliveryPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]);
        switch (billstatus) {
            case "A": {
                billstatusName = ResManager.loadKDString((String)"\u5f85\u53d1\u8d27", (String)"OrderDeliveryPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]);
                break;
            }
            case "B": {
                billstatusName = ResManager.loadKDString((String)"\u5f85\u7b7e\u6536", (String)"OrderDeliveryPlugin_2", (String)"drp-bbc-formplugin", (Object[])new Object[0]);
                break;
            }
            case "C": {
                billstatusName = ResManager.loadKDString((String)"\u5df2\u7b7e\u6536", (String)"OrderDeliveryPlugin_3", (String)"drp-bbc-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        this.setValue("billstatus", billstatusName);
        if ("A".equals(billstatus) || "B".equals(billstatus)) {
            this.setColor("billstatus", "#FF903D");
            this.setColor("billstatusvectorap", "#FF903D");
        } else {
            this.setColor("billstatus", "#26B175");
            this.setColor("billstatusvectorap", "#26B175");
        }
        String sourcebilltype = record.getString("sourcebilltype");
        if (!"saloutbill".equals(sourcebilltype)) {
            DynamicObjectCollection orderEntryInfo = record.getDynamicObjectCollection("deliverydetail");
            Map<Object, DynamicObject> ordersMap = this.getSourceOrder(sourcebilltype, orderEntryInfo);
            if (orderEntryInfo != null) {
                this.getModel().deleteEntryData("entryentity");
                for (int i = 0; i < orderEntryInfo.size(); ++i) {
                    DynamicObject deliverydetail = (DynamicObject)orderEntryInfo.get(i);
                    DynamicObject orderInfo = ordersMap.get(deliverydetail.get("srcbillid"));
                    DynamicObjectCollection saleorderEntryInfo = orderInfo.getDynamicObjectCollection("itementry");
                    Map saleorderEntryInfoMap = CommonUtils.collection2Map((String)"id", (List)saleorderEntryInfo);
                    String orderEntryId = deliverydetail.getString("srcbillentryid");
                    QFilter filer = new QFilter("id", "=", (Object)orderEntryId);
                    DynamicObject orderEntry = null;
                    BigDecimal qty = null;
                    switch (sourcebilltype) {
                        case "dispatchorder": {
                            orderEntry = QueryServiceHelper.queryOne((String)"mdr_dispatchorder_entry", (String)"id,item,unit,qty,deliveredqty", (QFilter[])filer.toArray());
                            qty = orderEntry.getBigDecimal("qty");
                            break;
                        }
                        case "saleorder": {
                            orderEntry = (DynamicObject)saleorderEntryInfoMap.get(Long.parseLong(orderEntryId));
                            qty = orderEntry.getBigDecimal("qty");
                            break;
                        }
                        case "oemorder": {
                            orderEntry = (DynamicObject)saleorderEntryInfoMap.get(Long.parseLong(orderEntryId));
                            qty = orderEntry.getBigDecimal("alterqty");
                            break;
                        }
                    }
                    if (orderEntry == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u8ba2\u5355\u5206\u5f55\u5931\u8d25\uff01", (String)"OrderDeliveryPlugin_5", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                    }
                    BigDecimal deliveredqty = (BigDecimal)orderEntry.get("deliveredqty");
                    int index = this.getModel().createNewEntryRow("entryentity");
                    this.setValue("itemname", deliverydetail.getDynamicObject("item").get("name"), index);
                    DynamicObject warehouse = deliverydetail.getDynamicObject("warehouse");
                    this.setValue("warehouse", warehouse == null ? "" : warehouse.get("name"), index);
                    this.setValue("qty", qty, index);
                    this.setValue("sendedqty", deliveredqty, index);
                    this.setValue("sendqty", deliverydetail.get("deliverqty"), index);
                    this.setValue("unit1", deliverydetail.get("unit"), index);
                    this.setValue("unit2", deliverydetail.get("unit"), index);
                    this.setValue("unit3", deliverydetail.get("unit"), index);
                }
            }
        }
    }

    private Map<Object, DynamicObject> getSourceOrder(String sourcebilltype, DynamicObjectCollection orderEntry) {
        if (orderEntry == null || orderEntry.size() == 0) {
            return new HashMap<Object, DynamicObject>(0);
        }
        HashMap<Object, DynamicObject> orderMap = new HashMap(orderEntry.size());
        HashSet<Long> ids = new HashSet<Long>();
        for (DynamicObject entry : orderEntry) {
            ids.add(entry.getLong("srcbillid"));
        }
        QFilter filer = new QFilter("id", "in", ids);
        String entityName = "bbc_saleorder";
        String selectProperties = "id,billno";
        switch (sourcebilltype) {
            case "dispatchorder": {
                entityName = "mdr_dispatch_order";
                break;
            }
            case "saleorder": {
                selectProperties = "id,billno,itementry.id,itementry.item,itementry.unit,itementry.qty,itementry.deliveredqty";
                break;
            }
            case "oemorder": {
                entityName = "bbc_oemsaleorder";
                selectProperties = "id,billno,itementry.id,itementry.item,itementry.unit,itementry.alterqty,itementry.deliveredqty";
                break;
            }
        }
        DynamicObject[] orders = BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])filer.toArray());
        if (orders == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6765\u6e90\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"OrderDeliveryPlugin_4", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            return orderMap;
        }
        orderMap = DeliveryUtil.array2Map((String)"id", (DynamicObject[])orders);
        return orderMap;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "view": {
                this.showBillEntry();
                IFormView parentView = this.getView().getParentView().getParentView();
                BillModel model = (BillModel)parentView.getModel();
                model.load(model.getPKValue());
                parentView.updateView();
                this.getView().sendFormAction(parentView);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Long recordId = (Long)fsp.getCustomParam("id");
        switch (key = this.getKey(evt)) {
            case "printbtn": {
                String createPdfUrl = PrintServiceHelper.createPdfUrl((String)this.getView().getPageId(), (String)"bbc_delivery_record", (String)"bbc_delivery_record_prt_s", (Object)recordId);
                this.getView().openUrl(createPdfUrl);
                break;
            }
            case "view": {
                BillShowParameter parameter = new BillShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setFormId("bbc_delivery_record");
                parameter.setStatus(OperationStatus.VIEW);
                parameter.setPkId((Object)recordId);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "view"));
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "showjdstore": {
                this.showJDStore(evt, recordId);
                break;
            }
            case "delete": {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("deleteCallBack", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u672c\u6761\u8bb0\u5f55\u5417", (String)"OrderDeliveryPlugin_6", (String)"drp-bbc-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("deleteCallBack".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            FormShowParameter fsp = this.getView().getFormShowParameter();
            Long recordId = (Long)fsp.getCustomParam("id");
            DynamicObject deliveryRecord = BusinessDataServiceHelper.loadSingle((Object)recordId, (String)"bbc_delivery_record");
            String easissuebillid = deliveryRecord.getString("easissuebillid");
            if (StringUtils.isNotEmpty((CharSequence)easissuebillid)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7531EAS\u540c\u6b65\u751f\u6210\u7684\u53d1\u8d27\u8bb0\u5f55\u4e0d\u5141\u8bb8\u5220\u9664", (String)"OrderDeliveryPlugin_7", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            }
            OperationUtil.invokeOperation((DynamicObject)deliveryRecord, (String)"delete");
            Object oemId = this.getView().getParentView().getParentView().getModel().getDataEntity().getPkValue();
            QFilter filter = new QFilter("sourcebilltype", "=", (Object)"oemorder");
            filter.and("sourcebillid", "=", oemId);
            FormShowParameter deliveryListFormShowParameter = new FormShowParameter();
            deliveryListFormShowParameter.setFormId("bbc_order_delivery_list");
            deliveryListFormShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            deliveryListFormShowParameter.getOpenStyle().setTargetKey("deliveryrecordtb");
            deliveryListFormShowParameter.setCustomParam("filterStr", (Object)filter.toSerializedString());
            this.getView().getParentView().getParentView().showForm(deliveryListFormShowParameter);
            this.getView().close();
        }
    }

    private void showJDStore(EventObject evt, Long recordId) {
        if (!SysParamsUtil.isUseJDStore()) {
            return;
        }
        QFilter fs = new QFilter("id", "=", (Object)recordId);
        DynamicObject info = QueryServiceHelper.queryOne((String)"bbc_delivery_record", (String)"logisticsbill", (QFilter[])fs.toArray());
        if (info == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u65e0\u53d1\u8d27\u4fe1\u606f", (String)"OrderDeliveryPlugin_8", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        String logisticsbill = info.getString("logisticsbill");
        if (logisticsbill == null || StringUtils.isEmpty((CharSequence)logisticsbill.trim())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u65e0\u4eac\u4e1c\u7269\u6d41\u5355\u53f7", (String)"OrderDeliveryPlugin_9", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        this.showWayBillDetail(logisticsbill);
    }

    private void showWayBillDetail(String logisticsbill) {
        Dto result = JDStoreAPIInvokeService.getWaybillTraceFromJDStore((String)logisticsbill);
        if (result.getSuccess().booleanValue()) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Floating);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("logisticsbill", logisticsbill);
            data.put("returnData", result.getAsString("returnData"));
            parameter.setCustomParams(data);
            parameter.setFormId("mdr_logisticsdetail");
            this.getView().showForm(parameter);
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4fe1\u606f\u5931\u8d25\uff1a%s", (String)"OrderDeliveryPlugin_10", (String)"drp-bbc-formplugin", (Object[])new Object[0]), result.getErrorMessage()));
        }
    }
}

