/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.bill.saleorder;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.BillList;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.apiclient.jdstore.JDStoreAPIInvokeService;
import kd.drp.mdr.common.matetype.Dto;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class OrderDeliveryRecordPlugin
extends MdrFormPlugin
implements Consumer<PackageDataEvent> {
    public static final String BILLLISTID = "billlistap";

    public void initialize() {
        super.initialize();
        this.addTBListener();
        BillList billList = (BillList)this.getControl(BILLLISTID);
        billList.addPackageDataListener((Consumer)this);
    }

    private void addTBListener() {
        BillList orderVersion = (BillList)this.getControl(BILLLISTID);
        final FormShowParameter fsp = this.getView().getFormShowParameter();
        String fStr = (String)fsp.getCustomParam("filterStr");
        if (StringUtils.isNotEmpty((CharSequence)fStr)) {
            orderVersion.addSetFilterListener(new SetFilterListener(){

                public void setFilter(SetFilterEvent evt) {
                    List fs = evt.getQFilters();
                    String fStr = (String)fsp.getCustomParam("filterStr");
                    fs.add(QFilter.fromSerializedString((String)fStr));
                }
            });
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addHyperClickListener();
        this.addListRowDoubleClickListener();
    }

    private void addListRowDoubleClickListener() {
        final BillList orderVersion = (BillList)this.getControl(BILLLISTID);
        orderVersion.addListRowDoubleClickListener(new ListRowClickListener(){

            public void listRowDoubleClick(ListRowClickEvent evt) {
                Object id = orderVersion.getFocusRowPkId();
                String fromId = orderVersion.getEntityType().getName();
                OrderDeliveryRecordPlugin.this.showViewBill(id, fromId);
            }
        });
    }

    private void addHyperClickListener() {
        final BillList orderVersion = (BillList)this.getControl(BILLLISTID);
        orderVersion.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                String key = evt.getFieldName();
                Object id = orderVersion.getFocusRowPkId();
                DynamicObject rowData = OrderDeliveryRecordPlugin.this.getModel().loadReferenceData((DynamicObjectType)orderVersion.getEntityType(), id);
                switch (key) {
                    case "logisticsbill": {
                        Dto result;
                        String logisticsbill = rowData.getString("logisticsbill");
                        if (!SysParamsUtil.isUseJDStore() || !(result = JDStoreAPIInvokeService.getWaybillTraceFromJDStore((String)logisticsbill)).getSuccess().booleanValue()) break;
                        OrderDeliveryRecordPlugin.this.showWayBillDetail(logisticsbill, result);
                        break;
                    }
                    default: {
                        String fromId = orderVersion.getEntityType().getName();
                        OrderDeliveryRecordPlugin.this.showViewBill(id, fromId);
                    }
                }
            }
        });
    }

    private void showWayBillDetail(String logisticsbill, Dto result) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("logisticsbill", logisticsbill);
        data.put("returnData", result.getAsString("returnData"));
        parameter.setCustomParams(data);
        parameter.setFormId("mdr_logisticsdetail");
        this.getView().showForm(parameter);
    }

    private void showViewBill(Object pk, String billFormId) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId(billFormId);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setPkId(pk);
        this.getView().showForm((FormShowParameter)parameter);
    }

    @Override
    public void accept(PackageDataEvent e) {
        Object formatValue = e.getFormatValue();
        Object source = e.getSource();
        DynamicObject rowData = e.getRowData();
        if (source instanceof ListOperationColumnDesc) {
            List items = (List)formatValue;
            for (OperationColItem item : items) {
                String signstatus = rowData.getString("signstatus");
                if ("0".equals(signstatus)) {
                    if (!item.getOperationKey().equals("unsign")) continue;
                    item.setVisible(false);
                    continue;
                }
                if (!"1".equals(signstatus)) continue;
                if (item.getOperationKey().equals("unsend")) {
                    item.setVisible(false);
                }
                if (!item.getOperationKey().equals("sign")) continue;
                item.setVisible(false);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String opKey = this.getOpKey(e);
        BillList billList = (BillList)this.getControl(BILLLISTID);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        int size = ids.length;
        if (size == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"OrderDeliveryRecordPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        if (size > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"OrderDeliveryRecordPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("DRP_OP_FROM_LIST", "DRP_OP_FROM_LIST");
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)ids[0], (String)"bbc_delivery_record", (String)"id,billno,billstatus,sourcebilltype,signer,signtime,signstatus,sourcebillid,deliverydetail.deliverqty,deliverydetail.corebillentryid,deliverydetail.signQty,deliverydetail.sourcebillentryidmodifier,auditdate,modifytime,auditor,billhead_lk,deliverydetail_lk");
        switch (opKey) {
            case "sign": {
                OperationUtil.invokeOperation((DynamicObject[])new DynamicObject[]{bill}, (String)"audit", (OperateOption)option);
                billList.refresh();
                break;
            }
            case "unsign": {
                OperationUtil.invokeOperation((DynamicObject[])new DynamicObject[]{bill}, (String)"unaudit", (OperateOption)option);
                billList.refresh();
                break;
            }
            case "unsend": {
                OperationUtil.invokeOperation((DynamicObject[])new DynamicObject[]{bill}, (String)"delete", (OperateOption)option);
                billList.refresh();
                break;
            }
            case "print": {
                String createPdfUrl = PrintServiceHelper.createPdfUrl((String)this.getView().getPageId(), (String)"bbc_delivery_record", (String)"bbc_delivery_record_prt_s", (Object)bill.get("id"));
                this.getView().openUrl(createPdfUrl);
                break;
            }
            case "showjdstore": {
                this.showJDStore(bill.getLong("id"));
                break;
            }
        }
    }

    private void showJDStore(Long recordId) {
        if (!SysParamsUtil.isUseJDStore()) {
            return;
        }
        QFilter fs = new QFilter("id", "=", (Object)recordId);
        DynamicObject info = QueryServiceHelper.queryOne((String)"bbc_delivery_record", (String)"logisticsbill", (QFilter[])fs.toArray());
        if (info == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u65e0\u53d1\u8d27\u4fe1\u606f", (String)"OrderDeliveryRecordPlugin_2", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        String logisticsbill = info.getString("logisticsbill");
        if (logisticsbill == null || StringUtils.isEmpty((CharSequence)logisticsbill.trim())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u65e0\u4eac\u4e1c\u7269\u6d41\u5355\u53f7", (String)"OrderDeliveryRecordPlugin_3", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        this.showWayBillDetail(logisticsbill);
    }

    private void showWayBillDetail(String logisticsbill) {
        Dto result = JDStoreAPIInvokeService.getWaybillTraceFromJDStore((String)logisticsbill);
        if (result.getSuccess().booleanValue()) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Floating);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("logisticsbill", logisticsbill);
            data.put("returnData", result.getAsString("returnData"));
            parameter.setCustomParams(data);
            parameter.setFormId("mdr_logisticsdetail");
            this.getView().showForm(parameter);
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4fe1\u606f\u5931\u8d25\uff1a%s", (String)"OrderDeliveryRecordPlugin_4", (String)"drp-bbc-formplugin", (Object[])new Object[0]) + result.getErrorMessage(), new Object[0]));
        }
    }
}

