/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.bill.saleorder;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.bbc.formplugin.bill.saleorder.SaleContractFormPlugin;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.status.SaleContractStatusEnum;
import kd.drp.mdr.common.util.BigDecimalUtil;
import kd.drp.mdr.common.util.CustomerSalerUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.UserUtil;

public class SaleContractEditFormPlugin
extends SaleContractFormPlugin
implements BeforeF7SelectListener {
    protected static final String SIGN_ADDRESS = "signaddress";
    protected static final String UNORDERQTY = "unorderqty";
    protected static final String DELIVERY_ADDRESS = "deliveryaddress";
    protected static final String FACTORY = "factory";
    protected static final String CUSTOMERG_ROUP = "customergroup";
    protected static final String BTN_SIGN = "btnsign";
    protected static final String BTN_SAVE_ATTACHMENT = "btnsaveattachment";
    protected static final String TBMAIN = "tbmain";
    protected static final String ATTACHMENTPANEL = "attachmentpanel";
    protected static final String TAXRATE = "taxrate";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TBMAIN});
        this.addF7Listener(this, new String[]{"customer", "item", "itemclass"});
    }

    public void initialize() {
        super.initialize();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int rowIndex = e.getRow();
        switch (key) {
            case "customer": {
                DynamicObject factory = this.getDynamicObject(FACTORY);
                if (factory == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5382\u522b\u4e0d\u80fd\u4e3a\u7a7a.", (String)"SaleContractEditFormPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCustomerFitler());
                break;
            }
            case "item": {
                if (this.getValue("itemclass", rowIndex) == null) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u7269\u6599\u548c\u7269\u6599\u5206\u7c7b\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a", (String)"SaleContractEditFormPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "itemclass": {
                if (this.getValue("item", rowIndex) == null) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u7269\u6599\u548c\u7269\u6599\u5206\u7c7b\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a", (String)"SaleContractEditFormPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    public Object getOwnerF7PKValue() {
        return this.getF7PKValue(FACTORY);
    }

    protected QFilter getCustomerFitler() {
        Set regionIds;
        Object ownerID = this.getOwnerF7PKValue();
        Object userId = UserUtil.getUserID();
        boolean isSaler = UserUtil.isSaler((Object)ownerID);
        Set ids = null;
        ids = isSaler ? CustomerSalerUtil.queryCustomerPKBySaler((Object)ownerID, (Object)userId) : ((regionIds = UserUtil.queryUserRegionsWithAllSubs((Object)ownerID)).isEmpty() ? CustomerUtil.getAuthSubsIds((Object)ownerID) : CustomerUtil.queryCustomerByRegion((Object)ownerID, (Object)regionIds));
        return new QFilter("id", "in", (Object)ids);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        int rowIndex = this.getRowIndex(e);
        switch (key) {
            case "customer": {
                this.customer_dataChange();
                break;
            }
            case "item": {
                this.item_dataChange(rowIndex);
                break;
            }
            case "qty": {
                this.qty_dataChange(rowIndex);
                break;
            }
            case "price": {
                this.calcByPrice(rowIndex);
                break;
            }
            case "taxprice": {
                this.calcByTaxPrice(rowIndex);
            }
        }
    }

    protected void calcTotalQty() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(this.getEntryKey());
        BigDecimal totalQty = BigDecimal.ZERO;
        for (DynamicObject entry : entrys) {
            totalQty = BigDecimalUtil.addObject((Object)totalQty, (Object)entry.getBigDecimal("qty"));
        }
        this.setValue("totalqty", totalQty);
    }

    protected void qty_dataChange(int rowIndex) {
        this.setValue(UNORDERQTY, this.getValue("qty", rowIndex), rowIndex);
        this.calcAmount(rowIndex);
        this.calcTaxAmount(rowIndex);
        this.calcTotalQty();
    }

    protected void calcByPrice(int rowIndex) {
        this.calcAmount(rowIndex);
    }

    protected void calcAmount(int rowIndex) {
        DynamicObject orderEntry = this.getRowInfo(this.getEntryKey(), rowIndex);
        if (orderEntry != null) {
            BigDecimal qty = orderEntry.getBigDecimal("qty");
            BigDecimal itemPrice = orderEntry.getBigDecimal("price");
            int amtprecision = 2;
            BigDecimal primAmount = BigDecimalUtil.multiplyObject((Object)itemPrice, (Object)qty, (int)amtprecision);
            this.setValue("amount", primAmount, rowIndex);
        }
    }

    protected void calcTaxAmount(int rowIndex) {
        DynamicObject orderEntry = this.getRowInfo(this.getEntryKey(), rowIndex);
        if (orderEntry != null) {
            BigDecimal qty = orderEntry.getBigDecimal("qty");
            BigDecimal taxPrice = orderEntry.getBigDecimal("taxprice");
            int amtprecision = 2;
            BigDecimal taxAmount = BigDecimalUtil.multiplyObject((Object)taxPrice, (Object)qty, (int)amtprecision);
            this.setValue("taxamount", taxAmount, rowIndex);
        }
    }

    protected void calcByTaxPrice(int rowIndex) {
        this.calcPrice(rowIndex);
        this.calcTaxAmount(rowIndex);
    }

    protected void calcPrice(int rowIndex) {
        DynamicObject orderEntry = this.getRowInfo(this.getEntryKey(), rowIndex);
        if (orderEntry != null) {
            BigDecimal taxPrice = orderEntry.getBigDecimal("taxprice");
            BigDecimal taxRate = orderEntry.getBigDecimal(TAXRATE);
            this.setValue("price", BigDecimalUtil.divideObject((Object)taxPrice, (Object)BigDecimalUtil.addObject((Object)1, (Object)BigDecimalUtil.divideObject((Object)taxRate, (Object)100, (int)4)), (int)2), rowIndex);
        }
    }

    protected void item_dataChange(int rowIndex) {
        this.initRowUnits(rowIndex);
    }

    protected void initRowUnits(int index) {
        Object itemPK = this.getEntryF7PKValue(this.getEntryKey(), "item", index);
        if (itemPK != null) {
            Object unit = SaleContractEditFormPlugin.queryBaseUnitId(itemPK);
            this.setValue("baseunit", unit, index);
            Object assistUnit = SaleContractEditFormPlugin.queryAssistUnitId(itemPK);
            if (assistUnit == null) {
                this.setUnEnable(index, new String[]{"assistunit"});
            } else {
                this.setRowValue("assistunit", assistUnit, index);
                this.setEnable(index, new String[]{"assistunit"});
            }
        }
    }

    public static Object queryBaseUnitId(Object itemPK) {
        if (itemPK == null) {
            return null;
        }
        QFilter f = new QFilter("id", "=", itemPK);
        DynamicObject item = QueryServiceHelper.queryOne((String)"mdr_item_info", (String)"baseunit", (QFilter[])f.toArray());
        return item.get("baseunit");
    }

    public static Object queryAssistUnitId(Object itemPK) {
        QFilter f = new QFilter("id", "=", itemPK);
        DynamicObject item = QueryServiceHelper.queryOne((String)"mdr_item_info", (String)"assistunit", (QFilter[])f.toArray());
        if (item == null) {
            return null;
        }
        return item.get("assistunit");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "submit": {
                this.getView().updateView();
                break;
            }
            case "audit": {
                this.getView().updateView();
                break;
            }
        }
    }

    public void customer_dataChange() {
        DynamicObject customer = this.getDynamicObject("customer");
        DynamicObject factory = this.getDynamicObject(FACTORY);
        if (customer != null) {
            QFilter qFilter = new QFilter("customer", "=", customer.getPkValue());
            QFilter qFilter2 = new QFilter("authowner", "=", factory.getPkValue());
            String selectFields = "id,customergroup.id,customergroup.number,customergroup.name,customer.id,customer.address";
            QFilter[] qFilters = new QFilter[]{qFilter, qFilter2};
            DynamicObject queryOne = QueryServiceHelper.queryOne((String)"mdr_customer_authorize", (String)selectFields, (QFilter[])qFilters);
            if (queryOne != null) {
                this.setValue(CUSTOMERG_ROUP, queryOne.get("customergroup.id"));
                this.setValue(DELIVERY_ADDRESS, queryOne.get("customer.address"));
            }
        } else {
            this.setValue(CUSTOMERG_ROUP, null);
            this.setValue(DELIVERY_ADDRESS, null);
        }
    }

    public void afterCopyData(EventObject e) {
        BillModel billModel = (BillModel)e.getSource();
        billModel.setValue("issigned", (Object)Boolean.FALSE);
        billModel.setValue("bizdate", (Object)new Date());
        billModel.setValue("billstatus", (Object)SaleContractStatusEnum.SAVED.getValue());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List myOwnerIds = UserUtil.getOwnerIDs();
        if (myOwnerIds.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u8fd8\u6ca1\u6709\u6240\u5c5e\u6e20\u9053\uff0c\u65e0\u6cd5\u4e0b\u5355\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"SaleContractEditFormPlugin_2", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            return;
        }
        if (myOwnerIds.size() == 1) {
            this.setUnEnable(new String[]{FACTORY});
        }
        this.setValue(FACTORY, myOwnerIds.get(0));
        this.setValue(SIGN_ADDRESS, ResManager.loadKDString((String)"\u897f\u738b", (String)"SaleContractEditFormPlugin_3", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (BTN_SIGN.equals(key)) {
            this.btnsign_itemClick(evt);
        }
        if (BTN_SAVE_ATTACHMENT.equals(key)) {
            this.btnSaveAttachment_itemClick(evt);
        }
    }

    protected void btnSaveAttachment_itemClick(ItemClickEvent evt) {
        if (!this.isAddNew()) {
            Object pkValue = ((BillModel)this.getModel()).getPKValue();
            StringBuilder selector = new StringBuilder();
            selector.append("id,");
            selector.append("issigned,");
            selector.append("billstatus");
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", pkValue)};
            DynamicObject dynInfo = BusinessDataServiceHelper.loadSingle((String)this.getModel().getDataEntityType().getName(), (String)selector.toString(), (QFilter[])filters);
            if (dynInfo != null) {
                if (!SaleContractStatusEnum.AUDIDPASS.getValue().equals(dynInfo.get("billstatus"))) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u975e\u5ba1\u6838\u901a\u8fc7\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u9644\u4ef6\u3002", (String)"SaleContractEditFormPlugin_4", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (Boolean.TRUE.equals(dynInfo.get("issigned"))) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u9500\u552e\u5408\u540c\u5df2\u7b7e\u8ba2\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u9644\u4ef6\u3002", (String)"SaleContractEditFormPlugin_5", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                    return;
                }
                AttachmentServiceHelper.saveTempAttachments((String)ATTACHMENTPANEL, (Object)pkValue);
                this.getView().showMessage(ResManager.loadKDString((String)"\u9644\u4ef6\u4fdd\u5b58\u6210\u529f\u3002", (String)"SaleContractEditFormPlugin_6", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected void btnsign_itemClick(ItemClickEvent evt) {
        if (this.isAddNew()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u3002", (String)"SaleContractEditFormPlugin_7", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            return;
        }
        Object pkValue = ((BillModel)this.getModel()).getPKValue();
        List attachs = AttachmentServiceHelper.getAttachments((String)this.getModel().getDataEntityType().getName(), (Object)pkValue, (String)ATTACHMENTPANEL);
        if (attachs == null || attachs.size() == 0) {
            ConfirmCallBackListener callBack = new ConfirmCallBackListener("sign");
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u672a\u4e0a\u4f20\u9644\u4ef6\uff0c\u662f\u5426\u7ee7\u7eed\u7b7e\u8ba2\uff1f", (String)"SaleContractEditFormPlugin_8", (String)"drp-bbc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, callBack);
        } else {
            ConfirmCallBackListener callBack = new ConfirmCallBackListener("sign");
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u8981\u7b7e\u8ba2\uff1f", (String)"SaleContractEditFormPlugin_9", (String)"drp-bbc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, callBack);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        DynamicObject dyn;
        OperationResult oprs;
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        if ("sign".equals(callBackId) && MessageBoxResult.Yes == result && (oprs = this.invokeOperation(new DynamicObject[]{dyn = this.getModel().getDataEntity()}, "sign")).isSuccess()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u7b7e\u8ba2\u6210\u529f.", (String)"SaleContractEditFormPlugin_10", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
    }
}

