/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.bill.saleorder;

import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.drp.mdr.common.constants.SaleContractConstants;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class SaleContractFormPlugin
extends MdrFormPlugin
implements SaleContractConstants {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Label label = (Label)this.getControl("title");
        if (label != null) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String title = formShowParameter.getCaption();
            if (StringUtils.isNotBlank((CharSequence)title)) {
                title = formShowParameter.getFormConfig().getCaption().toString();
            }
            label.setText(formShowParameter.getCaption());
        }
        this.setBillStatus();
    }

    private void setBillStatus() {
        IDataEntityProperty property = this.getModel().getProperty("billstatus");
        if (property != null) {
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            } else {
                String value = (String)this.getModel().getValue("billstatus");
                if ("A".equals(value)) {
                    boolean bFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
                    if (bFromDb) {
                        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
                    } else {
                        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.ADDNEW);
                    }
                } else if ("B".equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.SUBMIT);
                } else if ("D".equals(value) || "E".equals(value) || "F".equals(value) || "G".equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.AUDIT);
                    String[] entryActionControls = this.getEntryActionControl();
                    if (entryActionControls != null && entryActionControls.length > 0) {
                        this.setUnEnable(entryActionControls);
                        this.setVisible(entryActionControls);
                    }
                }
            }
        }
    }

    protected String[] getEntryActionControl() {
        return null;
    }

    protected String getEntryKey() {
        return "entryentity";
    }

    protected DynamicObject getDynamicObject(String key) {
        return (DynamicObject)this.getValue(key);
    }

    protected void setOuterCustomerFilter(String cusomter) {
        this.setOuterCustomerFilter(cusomter, "");
    }

    protected void setOuterCustomerFilter(String cusomter, String authowner) {
        if (kd.bos.util.StringUtils.isEmpty((String)authowner)) {
            HashSet<Object> innerorgs = new HashSet<Object>();
            QFilter filter = new QFilter("isinnerorg", "=", (Object)Boolean.FALSE);
            DynamicObjectCollection innerorgCustomerCollection = QueryServiceHelper.query((String)"mdr_customer", (String)"id", (QFilter[])filter.toArray());
            for (DynamicObject innerorgCustomer : innerorgCustomerCollection) {
                innerorgs.add(innerorgCustomer.get("id"));
            }
            filter = new QFilter("id", "in", innerorgs);
            this.setF7Filter(cusomter, filter);
        } else {
            DynamicObject value = this.getDynamicObject(authowner);
            QFilter filter = new QFilter("authowner.id", "=", (Object)value);
            DynamicObjectCollection customerCollection = QueryServiceHelper.query((String)"mdr_customer_authorize", (String)"customer.id", (QFilter[])filter.toArray());
            HashSet<Object> set = new HashSet<Object>(customerCollection.size());
            for (int i = 0; i < customerCollection.size(); ++i) {
                set.add(((DynamicObject)customerCollection.get(i)).getPkValue());
            }
            filter = new QFilter("id", "in", set);
            this.setF7Filter(cusomter, filter);
        }
    }

    protected OperationResult invokeOperation(DynamicObject[] objs, String operation) throws KDBizException {
        if (objs == null || objs.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", (String)"SaleContractFormPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)operation, (String)objs[0].getDataEntityType().getName(), (DynamicObject[])objs, (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            StringBuilder sb = new StringBuilder();
            List validResultList = result.getValidateResult().getValidateErrors();
            for (ValidateResult validation : validResultList) {
                validation.getAllErrorInfo().forEach(info -> {
                    sb.append(info.getMessage());
                    sb.append(',');
                });
            }
            if (sb.length() == 0) {
                throw new KDBizException(result.getMessage());
            }
            throw new KDBizException(MessageFormat.format("{0} - {1}", result.getMessage(), sb));
        }
        return result;
    }
}

