/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.bill.saleorder;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.bbc.formplugin.bill.saleorder.SaleContractFormMobPlugin;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.BigDecimalUtil;
import kd.drp.mdr.common.util.CustomerSalerUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.UserUtil;

public class SaleContractMobPlugin
extends SaleContractFormMobPlugin {
    protected static final String ADD_ITEM_MATERIAL = "additemmaterial";
    protected static final String ADD_ITEM_MATERIAL_GROUP = "additemmaterialgroup";
    protected static final String SIGN_ADDRESS = "signaddress";
    protected static final String UNORDERQTY = "unorderqty";
    protected static final String DELIVERY_ADDRESS = "deliveryaddress";
    protected static final String FACTORY = "factory";
    protected static final String CUSTOMERG_ROUP = "customergroup";
    protected static final String TAXRATE = "taxrate";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADD_ITEM_MATERIAL, ADD_ITEM_MATERIAL_GROUP});
        this.addF7Listener(this, new String[]{FACTORY, "customer", "item", "itemclass", CUSTOMERG_ROUP, "baseunit"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        int rowIndex = this.getRowIndex(e);
        switch (key) {
            case "customer": {
                this.customer_dataChange();
                break;
            }
            case "item": {
                this.item_dataChange(rowIndex);
                break;
            }
            case "qty": {
                this.qty_dataChange(rowIndex);
                break;
            }
            case "price": {
                this.calcByPrice(rowIndex);
                break;
            }
            case "taxprice": {
                this.calcByTaxPrice(rowIndex);
                break;
            }
            case "taxrate": {
                this.calcByTaxPrice(rowIndex);
            }
        }
    }

    protected void calcByTax(int rowIndex) {
        this.calcPrice(rowIndex);
        this.calcTaxAmount(rowIndex);
    }

    protected void calcByTaxPrice(int rowIndex) {
        this.calcPrice(rowIndex);
        this.calcTaxAmount(rowIndex);
    }

    protected void calcPrice(int rowIndex) {
        DynamicObject orderEntry = this.getRowInfo(this.getEntryKey(), rowIndex);
        if (orderEntry != null) {
            BigDecimal taxPrice = orderEntry.getBigDecimal("taxprice");
            BigDecimal taxRate = orderEntry.getBigDecimal(TAXRATE);
            this.setValue("price", BigDecimalUtil.divideObject((Object)taxPrice, (Object)BigDecimalUtil.addObject((Object)1, (Object)BigDecimalUtil.divideObject((Object)taxRate, (Object)100, (int)4)), (int)2), rowIndex);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int rowIndex = e.getRow();
        switch (key) {
            case "factory": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getOwnerFitler());
                break;
            }
            case "customer": {
                DynamicObject factory = this.getDynamicObject(FACTORY);
                if (factory == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5382\u522b\u4e0d\u80fd\u4e3a\u7a7a.", (String)"SaleContractMobPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCustomerFitler());
                break;
            }
            case "item": {
                if (this.getValue("itemclass", rowIndex) != null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u7269\u6599\u548c\u7269\u6599\u5206\u7c7b\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a", (String)"SaleContractMobPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                e.getFormShowParameter().setFormId("bos_moblistmodalf7");
                break;
            }
            case "itemclass": {
                if (this.getValue("item", rowIndex) != null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u7269\u6599\u548c\u7269\u6599\u5206\u7c7b\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a", (String)"SaleContractMobPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                e.getFormShowParameter().setFormId("bos_moblistmodalf7");
                break;
            }
            case "customergroup": {
                e.getFormShowParameter().setFormId("bos_moblistmodalf7");
                break;
            }
            case "baseunit": {
                e.getFormShowParameter().setFormId("bos_moblistmodalf7");
                break;
            }
        }
    }

    protected QFilter getOwnerFitler() {
        List myOwnerIds = UserUtil.getOwnerIDs();
        return new QFilter("id", "in", (Object)myOwnerIds);
    }

    private List<Object> getFactoryIDs() {
        return CustomerUtil.getAuthOwnerIDs((Object)this.getCustomerF7PKValue());
    }

    protected QFilter getCustomerFitler() {
        Set regionIds;
        Object ownerID = this.getOwnerF7PKValue();
        Object userId = UserUtil.getUserID();
        boolean isSaler = UserUtil.isSaler((Object)ownerID);
        Set ids = null;
        ids = isSaler ? CustomerSalerUtil.queryCustomerPKBySaler((Object)ownerID, (Object)userId) : ((regionIds = UserUtil.queryUserRegionsWithAllSubs((Object)ownerID)).isEmpty() ? CustomerUtil.getAuthSubsIds((Object)ownerID) : CustomerUtil.queryCustomerByRegion((Object)ownerID, (Object)regionIds));
        return new QFilter("id", "in", (Object)ids);
    }

    protected void calcTotalQty() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(this.getEntryKey());
        BigDecimal totalQty = BigDecimal.ZERO;
        for (DynamicObject entry : entrys) {
            totalQty = BigDecimalUtil.addObject((Object)totalQty, (Object)entry.getBigDecimal("qty"));
        }
        this.setValue("totalqty", totalQty);
    }

    protected void qty_dataChange(int rowIndex) {
        this.setValue(UNORDERQTY, this.getValue("qty", rowIndex), rowIndex);
        this.calcAmount(rowIndex);
        this.calcTaxAmount(rowIndex);
        this.calcTotalQty();
    }

    protected void calcByPrice(int rowIndex) {
        this.calcAmount(rowIndex);
    }

    protected void calcAmount(int rowIndex) {
        DynamicObject orderEntry = this.getRowInfo(this.getEntryKey(), rowIndex);
        if (orderEntry != null) {
            BigDecimal qty = orderEntry.getBigDecimal("qty");
            BigDecimal itemPrice = orderEntry.getBigDecimal("price");
            int amtprecision = 2;
            BigDecimal primAmount = BigDecimalUtil.multiplyObject((Object)itemPrice, (Object)qty, (int)amtprecision);
            this.setValue("amount", primAmount, rowIndex);
        }
    }

    protected void calcTaxAmount(int rowIndex) {
        DynamicObject orderEntry = this.getRowInfo(this.getEntryKey(), rowIndex);
        if (orderEntry != null) {
            BigDecimal qty = orderEntry.getBigDecimal("qty");
            BigDecimal taxPrice = orderEntry.getBigDecimal("taxprice");
            int amtprecision = 2;
            BigDecimal taxAmount = BigDecimalUtil.multiplyObject((Object)taxPrice, (Object)qty, (int)amtprecision);
            this.setValue("taxamount", taxAmount, rowIndex);
        }
    }

    protected void calcTaxPrice(int rowIndex) {
    }

    protected void item_dataChange(int rowIndex) {
        this.initRowUnits(rowIndex);
    }

    protected void initRowUnits(int index) {
        Object itemPK = this.getEntryF7PKValue(this.getEntryKey(), "item", index);
        if (itemPK != null) {
            Object unit = SaleContractMobPlugin.queryBaseUnitId(itemPK);
            this.setF7Value("baseunit", unit, index);
            Object assistUnit = SaleContractMobPlugin.queryAssistUnitId(itemPK);
            if (assistUnit == null) {
                this.setUnEnable(index, new String[]{"assistunit"});
            } else {
                this.setRowValue("assistunit", assistUnit, index);
                this.setEnable(index, new String[]{"assistunit"});
            }
        }
    }

    public static Object queryBaseUnitId(Object itemPK) {
        if (itemPK == null) {
            return null;
        }
        QFilter f = new QFilter("id", "=", itemPK);
        DynamicObject item = QueryServiceHelper.queryOne((String)"mdr_item_info", (String)"baseunit", (QFilter[])f.toArray());
        return item.get("baseunit");
    }

    public static Object queryAssistUnitId(Object itemPK) {
        QFilter f = new QFilter("id", "=", itemPK);
        DynamicObject item = QueryServiceHelper.queryOne((String)"mdr_item_info", (String)"assistunit", (QFilter[])f.toArray());
        if (item == null) {
            return null;
        }
        return item.get("assistunit");
    }

    public void customer_dataChange() {
        DynamicObject customer = this.getDynamicObject("customer");
        DynamicObject factory = this.getDynamicObject(FACTORY);
        if (customer != null) {
            QFilter qFilter = new QFilter("customer", "=", customer.getPkValue());
            QFilter qFilter2 = new QFilter("authowner", "=", factory.getPkValue());
            String selectFields = "id,customergroup.id,customergroup.number,customergroup.name,customer.id,customer.address";
            QFilter[] qFilters = new QFilter[]{qFilter, qFilter2};
            DynamicObject queryOne = QueryServiceHelper.queryOne((String)"mdr_customer_authorize", (String)selectFields, (QFilter[])qFilters);
            if (queryOne != null) {
                this.setValue(CUSTOMERG_ROUP, queryOne.get("customergroup.id"));
                this.setValue(DELIVERY_ADDRESS, queryOne.get("customer.address"));
            }
        } else {
            this.setValue(CUSTOMERG_ROUP, null);
            this.setValue(DELIVERY_ADDRESS, null);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "additemmaterial": {
                if (this.getCustomerF7PKValue() == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a.", (String)"SaleContractMobPlugin_2", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.getOwnerF7PKValue() == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5382\u522b\u4e0d\u80fd\u4e3a\u7a7a.", (String)"SaleContractMobPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.toAddItemMaterialPage();
                break;
            }
            case "additemmaterialgroup": {
                this.toAddItemMaterialGroup();
            }
        }
    }

    protected void toAddItemMaterialGroup() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("mdr_itemclass_addtoentry");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        HashMap map = new HashMap();
        parameter.setCustomParams(map);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addItemMaterialGroup"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected Object getOwnerF7PKValue() {
        return this.getF7PKValue(FACTORY);
    }

    protected void toAddItemMaterialPage() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("mdr_item_addtoentry");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customerid", this.getCustomerF7PKValue());
        map.put("ownerid", this.getOwnerF7PKValue());
        parameter.setCustomParams(map);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addItemMaterial"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        switch (actionId) {
            case "addItemMaterial": {
                this.addItemMaterial((List)returnData);
                break;
            }
            case "addItemMaterialGroup": {
                this.addItemMaterialGroup((List)returnData);
            }
        }
    }

    private void addItemMaterial(List<Map<String, Object>> itemlist) {
        if (itemlist == null) {
            return;
        }
        this.getModel().beginInit();
        for (Map<String, Object> item : itemlist) {
            this.addItemMaterial(item);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        this.calcTotalQty();
    }

    private void addItemMaterial(Map<String, Object> item) {
        IDataModel model = this.getModel();
        int rowIndex = model.createNewEntryRow("entryentity");
        model.setValue("item", item.get("itemid"), rowIndex);
        model.setValue("baseunit", item.get("unitid"), rowIndex);
        model.setValue("price", item.get("price"), rowIndex);
        model.setValue("qty", item.get("qty"), rowIndex);
        this.calcTaxPrice(rowIndex);
        this.calcAmount(rowIndex);
    }

    public static BigDecimal getItemPrice(Object itemPK, Object unitPK, Object assistattrPk, Object ownerPK) {
        DynamicObject priceObj = SaleContractMobPlugin.getItemPriceObject(itemPK, unitPK, assistattrPk, ownerPK);
        if (priceObj != null) {
            return priceObj.getBigDecimal("saleprice");
        }
        return BigDecimal.ZERO;
    }

    public static DynamicObject getItemPriceObject(Object itemPK, Object unitPK, Object assistattrPk, Object ownerPK) {
        QFilter filters = SaleContractMobPlugin.getFilters(itemPK, unitPK, assistattrPk, ownerPK);
        String selectField = SaleContractMobPlugin.getSelectField();
        DynamicObject price = QueryServiceHelper.queryOne((String)"mdr_item_price", (String)selectField, (QFilter[])filters.toArray());
        return price;
    }

    private static String getSelectField() {
        return "id,name,number,saleprice";
    }

    private static QFilter getFilters(Object itemPK, Object unitPK, Object assistattrPk, Object ownerPK) {
        QFilter filters = new QFilter("status", "=", (Object)"1");
        if (itemPK != null) {
            filters.and("itemid", "=", itemPK);
        }
        if (unitPK != null) {
            filters.and("unit", "=", unitPK);
        }
        if (assistattrPk != null) {
            filters.and("assistattr", "=", assistattrPk);
        }
        if (ownerPK != null) {
            filters.and("customer", "=", ownerPK);
        } else if (UserUtil.getUserID() != null) {
            filters.and("customer", "=", UserUtil.getDefaultOwnerID());
        }
        return filters;
    }

    public static DynamicObject getInfoById(Object itemId, String fields) {
        QFilter fs = new QFilter("id", "=", itemId);
        return QueryServiceHelper.queryOne((String)"mdr_item_info", (String)fields, (QFilter[])fs.toArray());
    }

    private void addItemMaterialGroup(List<Object> itemlist) {
        if (itemlist == null) {
            return;
        }
        this.getModel().beginInit();
        for (Object itempk : itemlist) {
            this.addItemMaterialGroup(itempk);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        this.calcTotalQty();
    }

    private void addItemMaterialGroup(Object itempk) {
        IDataModel model = this.getModel();
        int rowIndex = model.createNewEntryRow("entryentity");
        model.setValue("itemclass", itempk, rowIndex);
        model.setValue("qty", (Object)ONE, rowIndex);
        this.calcTaxPrice(rowIndex);
        this.calcAmount(rowIndex);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List myOwnerIds = UserUtil.getOwnerIDs();
        if (myOwnerIds.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u8fd8\u6ca1\u6709\u6240\u5c5e\u6e20\u9053\uff0c\u65e0\u6cd5\u4e0b\u5355\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"SaleContractMobPlugin_3", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            return;
        }
        if (myOwnerIds.size() == 1) {
            this.setUnEnable(new String[]{FACTORY});
        }
        this.setF7Value(FACTORY, myOwnerIds.get(0));
        Object customer = this.getView().getFormShowParameter().getCustomParam("customer4Salers");
        if (customer != null) {
            this.setF7Value("customer", BusinessDataServiceHelper.loadSingle((Object)customer, (String)"mdr_customer"));
        }
        this.setValue(SIGN_ADDRESS, ResManager.loadKDString((String)"\u897f\u738b", (String)"SaleContractMobPlugin_4", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        this.getModel().deleteEntryData("entryentity");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }
}

