/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.bill.saleorder;

import java.util.Arrays;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.ImageList;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SaleContractPicMobPlugin
extends AbstractMobFormPlugin {
    Log logger = LogFactory.getLog(SaleContractPicMobPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        SaleContractPicMobPlugin.initImgList(this.getView(), this.getModel(), "imagelist", "picentry");
    }

    protected void removeImages(UploadEvent evt) {
        this.logger.info("remove");
        Object[] indexes = evt.getIndexes();
        for (int i = 0; i < indexes.length; ++i) {
            int index = Integer.parseInt(indexes[0].toString());
            this.getModel().deleteEntryRow("picentry", index);
        }
        SaleContractPicMobPlugin.initImgList(this.getView(), this.getModel(), "imagelist", "picentry");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ImageList imageList = (ImageList)this.getControl("imagelist");
        imageList.addUploadListener(new UploadListener(){

            public void remove(UploadEvent evt) {
                SaleContractPicMobPlugin.this.removeImages(evt);
            }

            public void afterUpload(UploadEvent evt) {
                SaleContractPicMobPlugin.this.logger.info("afterUpload");
                super.afterUpload(evt);
            }

            public void upload(UploadEvent evt) {
                SaleContractPicMobPlugin.this.uploadImage(evt);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uploadImage(UploadEvent evt) {
        this.logger.info("upload");
        StringBuilder msg = new StringBuilder();
        msg.append("memUpload:start").append("\t\n");
        try {
            Object[] urls = evt.getUrls();
            msg.append("urls : ").append(Arrays.toString(urls)).append("\t\n");
            String url = urls[0].toString();
            Object[] urllist = url.split(",");
            msg.append("urllist : ").append(Arrays.toString(urllist)).append("\t\n");
            msg.append("urllist.length : ").append(urllist.length).append("\t\n");
            for (int i = 0; i < urllist.length; ++i) {
                Object eurl = urllist[i];
                int index = this.getModel().createNewEntryRow("picentry");
                msg.append("setValue thumbnailurl: eurl=").append((String)eurl).append(", index = ").append(index).append("\t\n");
                this.getModel().setValue("thumbnailurl", eurl, index);
                Object[] eurls = ((String)eurl).split("_thumbnails_scalePic");
                msg.append("eurls : ").append(Arrays.toString(eurls)).append("\t\n");
                if (eurls.length < 2) continue;
                String bigimurl = (String)eurls[0] + (String)eurls[1];
                msg.append("setValue picurl: bigimurl=").append(bigimurl).append(", index = ").append(index).append("\t\n");
                this.getModel().setValue("picurl", (Object)bigimurl, index);
            }
            SaleContractPicMobPlugin.initImgList(this.getView(), this.getModel(), "imagelist", "picentry");
        }
        catch (Exception e) {
            msg.append("Exception : ").append(e.getMessage()).append("\t\n");
            e.printStackTrace();
        }
        finally {
            msg.append("memUpload:end").append("\t\n");
            this.logger.info(msg.toString());
        }
    }

    public static void initImgList(IFormView view, IDataModel model, String controlKey, String entryKey) {
        ImageList imgList = (ImageList)view.getControl(controlKey);
        if (imgList == null) {
            return;
        }
        DynamicObjectCollection ec = model.getEntryEntity(entryKey);
        String[] urls = new String[ec.size()];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = ((DynamicObject)ec.get(i)).getString("thumbnailurl").trim();
        }
        imgList.setImageUrls(urls);
    }
}

