/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.bill.saleorder;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.constants.SaleOrderEntryType;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class SaleOrderApart
extends MdrFormPlugin {
    private static final Log logger = LogFactory.getLog(SaleOrderApart.class);
    private static final String ITEMENTRY = "itementry";
    private static final String PARENTQTY = "parentqty";
    private static final String CHILDQTY = "childqty";
    private static final String QTY = "qty";
    private static final String ENTRYID = "entryid";
    private static final String CONFIRMAPART = "confirmapart";
    private static final String APART = "apart";
    private static final String DEFAULT_NETCTRL = "default_netctrl";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildModelInfo(this.getSaleOrderInfo(this.getView().getFormShowParameter()));
    }

    public void propertyChanged(PropertyChangedArgs e, String key) {
        super.propertyChanged(e, key);
        int index = this.getRowIndex(e);
        Object oldvalue = e.getChangeSet()[0].getOldValue();
        if (key.equals(PARENTQTY)) {
            this.parentQtyChanged(oldvalue, index);
        }
        if (key.equals(CHILDQTY)) {
            this.childQtyChanted(oldvalue, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DataMutex mutex = DataMutex.create();
        try {
            mutex.forcerelease(this.getLockSaleOrderID(this.getView().getFormShowParameter()), "bbc_saleorder", APART);
        }
        catch (Exception e1) {
        }
        finally {
            try {
                mutex.close();
            }
            catch (IOException e1) {
                logger.error(e1.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        DataMutex mutex = DataMutex.create();
        try {
            String orderid = this.getLockSaleOrderID(e.getFormShowParameter());
            if (!mutex.require(orderid, DEFAULT_NETCTRL, "bbc_saleorder", APART, true)) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u9501\u5b9a\u6682\u65f6\u65e0\u6cd5\u62c6\u5206", (String)"SaleOrderApart_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e1) {
        }
        finally {
            try {
                mutex.close();
            }
            catch (IOException e1) {
                logger.error(e1.getMessage());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (this.getOperationResult(e) && CONFIRMAPART.equals(key)) {
            this.getView().close();
        }
    }

    protected void parentQtyChanged(Object oldvalue, int index) {
        BigDecimal qty;
        BigDecimal parentqty = (BigDecimal)this.getValue(PARENTQTY, index);
        if (parentqty.compareTo(qty = (BigDecimal)this.getValue(QTY, index)) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcd\u5355\u6570\u91cf\u4e0d\u5141\u8bb8\u5927\u4e8e\u786e\u8ba4\u6570\u91cf", (String)"SaleOrderApart_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            this.setValue(PARENTQTY, oldvalue, index);
        } else {
            this.setValue(CHILDQTY, qty.subtract(parentqty), index);
        }
    }

    protected void childQtyChanted(Object oldvalue, int index) {
        BigDecimal qty;
        BigDecimal childqty = (BigDecimal)this.getValue(CHILDQTY, index);
        if (childqty.compareTo(qty = (BigDecimal)this.getValue(QTY, index)) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b50\u5355\u6570\u91cf\u4e0d\u5141\u8bb8\u5927\u4e8e\u786e\u8ba4\u6570\u91cf", (String)"SaleOrderApart_2", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            this.setValue(CHILDQTY, oldvalue, index);
        } else {
            this.setValue(PARENTQTY, qty.subtract(childqty), index);
        }
    }

    protected void buildModelInfo(DynamicObject saleorder) {
        for (String headfield : this.getHeadFieldsNeedToDisplay()) {
            this.setValue(headfield, saleorder.get(headfield));
        }
        Object parentorderid = saleorder.get("parentorderid");
        parentorderid = Long.valueOf(0L).equals(parentorderid) ? saleorder.getPkValue() : parentorderid;
        this.setValue("parentorderid", parentorderid);
        this.setValue("billno", this.getChildNumber(parentorderid));
        DynamicObjectCollection itementry = saleorder.getDynamicObjectCollection(ITEMENTRY);
        for (int i = 0; i < itementry.size(); ++i) {
            DynamicObject entry = (DynamicObject)itementry.get(i);
            if (!SaleOrderEntryType.COMMON.getFlagStr().equals(entry.getString("entrytype"))) continue;
            int index = this.getModel().createNewEntryRow(ITEMENTRY);
            this.setValue(ENTRYID, entry.getPkValue(), index);
            this.setValue(PARENTQTY, entry.get(QTY), index);
            for (String entryfield : this.getEntryFieldsNeedToDisplay()) {
                this.setValue(entryfield, entry.get(entryfield), index);
            }
        }
    }

    private DynamicObject getSaleOrderInfo(FormShowParameter param) {
        Object orderid = this.getSaleOrderID(param);
        return BusinessDataServiceHelper.loadSingle((Object)orderid, (String)"bbc_saleorder");
    }

    private Object getSaleOrderID(FormShowParameter param) {
        return param.getCustomParam("orderId");
    }

    private String getLockSaleOrderID(FormShowParameter param) {
        Object orderid = this.getSaleOrderID(param);
        QFilter[] filters = new QFilter("id", "=", orderid).toArray();
        Long parentorderid = QueryServiceHelper.queryOne((String)"bbc_saleorder", (String)"parentorderid", (QFilter[])filters).getLong("parentorderid");
        return Long.valueOf(0L).equals(parentorderid) ? orderid.toString() : parentorderid.toString();
    }

    protected String[] getHeadFieldsNeedToDisplay() {
        return new String[]{"id", "billno", "owner", "customer", "currency"};
    }

    protected String[] getEntryFieldsNeedToDisplay() {
        return new String[]{"item", "assistattr", "unit", QTY, "baseunit", "baseqty", "assistunit", "assistqty"};
    }

    protected String getChildNumber(Object parentorderid) {
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bbc_saleorder", (String)"id", (QFilter[])new QFilter("parentorderid", "=", parentorderid).toArray());
        String number = QueryServiceHelper.queryOne((String)"bbc_saleorder", (String)"billno", (QFilter[])new QFilter("id", "=", parentorderid).toArray()).getString("billno");
        return number + "-" + (col.size() + 1);
    }
}

