/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.bill.saleorder;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.bbc.business.handle.SaleOrderUpgradeHandler;
import kd.drp.dpa.formplugin.bill.saleorder.PurOrderEditPlugin;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.UserUtil;

public class SaleOrderEditPlugin
extends PurOrderEditPlugin {
    protected static final String APART_CALLBACK = "apart_callback";
    protected static final String APART = "apart";

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "upgradedata": {
                new SaleOrderUpgradeHandler().upgrade();
            }
        }
    }

    private void initDefaultValue() {
        this.initDefaultOwner();
        this.initDefaultSaler();
        this.initOrderStatus();
        this.initBizType();
        this.initRebateInfo();
        this.setAmountLable(true);
        this.setSaleOrg();
    }

    public void afterCreateNewData(EventObject e) {
        this.initNumber();
        if (!this.isFromImport()) {
            this.initDefaultValue();
            this.setBillParameters();
        }
        this.setCurrencyByCustomer();
    }

    protected void initNumber() {
        DynamicObject purOrderEntry = BusinessDataServiceHelper.newDynamicObject((String)"dpa_purorder");
        this.copyOrderValue(purOrderEntry);
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)purOrderEntry.getDataEntityType().getName(), (DynamicObject)purOrderEntry, null);
        String number = "";
        if (codeRuleInfo != null) {
            try {
                number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)purOrderEntry);
            }
            catch (KDException e) {
                this.getView().showErrorNotification(e.getLocalizedMessage());
            }
            if (!StringUtils.isEmpty((String)number)) {
                this.getModel().setValue("billno", (Object)number);
                this.setEnable(new String[]{"billno"});
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8981\u8d27\u7533\u8bf7\u7684\u201c\u7f16\u7801\u89c4\u5219\u201d", (String)"SaleOrderEditPlugin_2", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        if (this.getModel().getValue("billno") == null || this.getModel().getValue("billno").toString().length() == 0) {
            this.setEnable(new String[]{"billno"});
        } else {
            this.setUnEnable(new String[]{"billno"});
        }
    }

    private void copyOrderValue(DynamicObject purOrderEntry) {
        DynamicObject saleOrderEntry = this.getModel().getDataEntity();
        DataEntityPropertyCollection purColl = purOrderEntry.getDataEntityType().getProperties();
        DataEntityPropertyCollection SaleColl = saleOrderEntry.getDataEntityType().getProperties();
        for (IDataEntityProperty property : purColl) {
            if (!SaleColl.containsKey((Object)property.getName())) continue;
            purOrderEntry.set(property.getName(), saleOrderEntry.get(property.getName()));
        }
    }

    protected boolean isOrderQuantityStrongControl() {
        return SysParamsUtil.isOrderQuantityStrongControl();
    }

    protected void initDefaultOwner() {
        Object ownerid = this.getOwnerFromCache();
        if (ownerid == null) {
            ownerid = UserUtil.getDefaultOwnerID();
        }
        if (ownerid != null && (Long)ownerid != 0L) {
            this.setOwner(ownerid);
            this.initDefaultCustomer();
            this.initCusOwnerFields();
            this.initUseableAccountInfo();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Set<String> fields = this.getCodeRuleRefetchFields();
        if (fields.contains(key) && this.getModel().getValue("billno") != null) {
            this.initNumber();
        }
    }

    protected Set<String> getCodeRuleRefetchFields() {
        HashSet<String> fields = new HashSet<String>();
        return fields;
    }

    protected void ownerChanged(PropertyChangedArgs e) {
        if (this.getOwnerF7Value() == null) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (oldValue != null) {
                this.setOwnerF7Value(oldValue);
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f9b\u8d27\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (String)"SaleOrderEditPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.initDefaultCustomer();
        this.initCusOwnerFields();
        this.initUseableAccountInfo();
        this.setSaleOrg();
        if (this.isReacquirePromotion()) {
            this.initAvailablePromotion();
        }
    }

    protected void customerChanged() {
        this.setCustomer(this.getCustomerF7Value());
        this.initCusOwnerFields();
        this.initUseableAccountInfo();
        if (this.isReacquirePromotion()) {
            this.initAvailablePromotion();
        }
    }

    protected void initDefaultCustomer() {
        List<Object> ids = this.getDefaultCustomerIds();
        Object id = null;
        if (ids.size() > 0) {
            id = ids.get(0);
        }
        if (ids.size() <= 1) {
            this.setUnEnable(new String[]{"owner"});
        } else {
            this.setEnable(new String[]{"owner"});
        }
        this.setCustomer(id);
    }

    protected void initDefaultSaler() {
        Object ownerid = this.getOwnerF7PKValue();
        if (UserUtil.isCusOrderProcessor((Object)ownerid)) {
            this.setSalerF7Value(this.getDefaultSalerByRelation());
        } else if (UserUtil.isSaler((Object)ownerid)) {
            this.setSalerF7Value(UserUtil.getUserID());
        } else {
            this.setSalerF7Value(null);
        }
    }

    protected QFilter getCustomerFitler() {
        return new QFilter("id", "in", this.getDefaultCustomerIds());
    }

    protected List<Object> getDefaultCustomerIds() {
        QFilter[] fs;
        Object ownerID = this.getOwnerF7PKValue();
        Object userId = UserUtil.getUserID();
        boolean isSaler = UserUtil.isSaler((Object)ownerID);
        boolean isCusOrderProcessor = UserUtil.isCusOrderProcessor((Object)ownerID);
        LinkedList<Object> ids = new LinkedList<Object>();
        if (isSaler) {
            fs = new QFilter[]{new QFilter("owner", "=", ownerID), new QFilter("user", "=", userId), new QFilter("enable", "=", (Object)"1")};
            Map custsalerinfo = BusinessDataServiceHelper.loadFromCache((String)"mdr_cust_saler_relation", (String)String.join((CharSequence)",", "customer.id", "isdefault"), (QFilter[])fs, (String)"isdefault desc");
            if (!custsalerinfo.isEmpty()) {
                for (DynamicObject custsaler : custsalerinfo.values()) {
                    ids.add(custsaler.get("customer.id"));
                }
            }
        }
        if (isCusOrderProcessor && null != ownerID) {
            fs = new QFilter("authowner", "=", ownerID).and("enable", "=", (Object)"1");
            DynamicObjectCollection customers = QueryServiceHelper.query((String)"mdr_customer_authorize", (String)String.join((CharSequence)",", "customer", "isdefault"), (QFilter[])fs.toArray(), (String)"isdefault desc");
            for (DynamicObject customer : customers) {
                ids.add(customer.get("customer"));
            }
        }
        return ids;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void beforeSalerSelected(BeforeF7SelectEvent e) {
        this.setNoTreeF7(e);
        Object ownerid = this.getOwnerF7PKValue();
        if (UserUtil.isCusOrderProcessor((Object)ownerid)) {
            CheckResult re = this.checkCustomerBeforeSelect();
            if (re.isSuccess()) {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getSalerFilter());
                return;
            }
            this.getView().showMessage(re.getMsg());
            e.setCancel(true);
            return;
        }
        if (UserUtil.isSaler((Object)ownerid)) {
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "=", UserUtil.getUserID()));
            return;
        }
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "=", (Object)0));
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (APART_CALLBACK.equals(actionId)) {
            this.refreshPage();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (this.getOperationResult(e)) {
            switch (key) {
                case "apart": {
                    this.toApartPage();
                    break;
                }
                case "audit": {
                    List errorsInfos;
                    if (!SysParamsUtil.isAuditThenSync() || CollectionUtils.isEmpty((Collection)(errorsInfos = e.getOperationResult().getAllErrorOrValidateInfo()))) break;
                    e.getOperationResult().setSuccess(false);
                    break;
                }
                case "printpreview": {
                    DynamicObject so = BusinessDataServiceHelper.loadSingle((Object)this.getId(), (String)"bbc_saleorder");
                    Date dt = new Date();
                    so.set("printtime", (Object)dt);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{so});
                    this.setValue("printtime", dt);
                    break;
                }
            }
        }
    }

    protected void loadVersionTb() {
        this.showInnerTbPage("mdr_orderversionpage", "versiontb", new QFilter("saleorderid", "=", this.getId()));
    }

    protected void toDeliveryPage() {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setFormId("bbc_delivery_record");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("todelivery");
        parameter.setCustomParam("orderId", this.getId());
        parameter.setCustomParam("orderType", (Object)"saleorder");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "deliveryrecordtb"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void toPayPage() {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("mdr_money_receivingbill");
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("orderid", this.getId());
        parameter.setCustomParam("ordertype", (Object)"saleorder");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "paytb"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void toApartPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bbc_saleorder_apart");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("orderId", this.getId());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, APART_CALLBACK));
        this.getView().showForm(parameter);
    }

    protected QFilter getOwnerFitler() {
        return this.getCommonOwnerFitler();
    }

    protected void initCombEntryView(int i, DynamicObject combItem) {
        super.initCombEntryView(i, combItem);
        this.setEnable(i, new String[]{"discounttype"});
        this.setEnable(i, new String[]{"taxrateid"});
    }

    protected void initHeadFromCopy() {
        super.initHeadFromCopy();
        this.setValue("printcount", BigDecimal.ZERO);
    }
}

