/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.bill.saleorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.MobileListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.drp.dpa.formplugin.bill.saleorder.PurOrderMobPlugin;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.UserUtil;

public class SaleOrderMobPlugin
extends PurOrderMobPlugin {
    public void afterCreateNewData(EventObject e) {
        this.addExecutrionListListener();
        this.initOwnerInfo();
        this.initCustomerInfo();
        if (this.isNewCreate()) {
            this.initItemInfoFromShoppcart();
        }
        SaleOrderStatus status = SaleOrderUtil.getOrderStatus((DynamicObject)this.getModel().getDataEntity());
        this.initFieldView(status);
        this.initDefaultSaler();
        this.initDefaultDepartment();
        this.initDefaultDispatcher();
        this.initRebate();
        this.hiddenFlex();
        this.initNumber();
        this.setBillParameters();
        this.initCustomerPhone();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    protected void initDefaultDepartment() {
        Object salerid = this.getF7PKValue("saler");
        if (salerid != null) {
            this.setValue("department", UserUtil.getDefaultAdminOrgID((Object)salerid));
        }
    }

    protected void initDefaultDispatcher() {
        Object departmentid = this.getF7PKValue("department");
        if (departmentid != null) {
            this.setValue("dispatcher", UserUtil.getDefaultDispatcherId((Object)departmentid));
        }
    }

    private void initOwnerInfo() {
        Object ownerid = this.getOwnerId();
        this.setOwnerF7Value(ownerid);
    }

    private void initCustomerInfo() {
        Object customerid = this.getCustomerId();
        this.setF7Value("directcustomer", customerid);
        this.setCustomerF7Value(customerid);
        this.setCustomerPhoneValue(customerid);
    }

    private void initItemInfoFromShoppcart() {
        List cartList = (List)this.getParameter("cartList");
        if (cartList != null && cartList.size() != 0) {
            Object amountObj = this.getParameter("amount");
            BigDecimal amount = BigDecimal.ZERO;
            amount = amountObj instanceof BigDecimal ? (BigDecimal)amountObj : new BigDecimal(amountObj.toString());
            this.getModel().setValue("totalitemamount", (Object)amount);
            this.getModel().setValue("totalorderamount", (Object)amount);
            this.getModel().setValue("amounttobepaid", (Object)amount);
            this.fromShoppingCart(cartList);
        }
    }

    private void setCustomerPhoneValue(Object customerid) {
        DynamicObject customer = QueryServiceHelper.queryOne((String)"mdr_customer", (String)"phone", (QFilter[])new QFilter[]{new QFilter("id", "=", customerid)});
        if (customer != null) {
            String phone = customer.getString("phone");
            if (StringUtils.isNotEmpty((String)phone)) {
                phone = phone.trim();
            }
            this.getModel().setValue("customerphone", (Object)phone);
        }
    }

    private Object getOwnerId() {
        Object ownerid = this.getParameter("ownerid");
        if (ownerid == null) {
            ownerid = UserUtil.getDefaultOwnerID();
            this.setEnable(new String[]{"owner"});
        } else {
            this.setUnEnable(new String[]{"owner"});
        }
        return ownerid;
    }

    private Object getCustomerId() {
        Object customerid = this.getParameter("customerid");
        if (customerid == null) {
            customerid = 0L;
            this.setEnable(new String[]{"customer"});
        } else {
            this.setUnEnable(new String[]{"customer"});
        }
        return customerid;
    }

    protected void initNumber() {
        String number;
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"dpa_purorder");
        this.copyOrderValue(obj);
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)obj.getDataEntityType().getName(), (DynamicObject)obj, null);
        if (codeRuleInfo != null && !StringUtils.isEmpty((String)(number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)obj)))) {
            this.getModel().setValue("billno", (Object)number);
            this.setEnable(new String[]{"billno"});
        }
    }

    private void copyOrderValue(DynamicObject purOrderEntry) {
        DynamicObject saleOrderEntry = this.getModel().getDataEntity();
        DataEntityPropertyCollection purColl = purOrderEntry.getDataEntityType().getProperties();
        DataEntityPropertyCollection SaleColl = saleOrderEntry.getDataEntityType().getProperties();
        for (IDataEntityProperty property : purColl) {
            if (!SaleColl.containsKey((Object)property.getName())) continue;
            purOrderEntry.set(property.getName(), saleOrderEntry.get(property.getName()));
        }
    }

    protected void initDefaultOwner() {
    }

    protected void deleteShoppingCart() {
        QFilter filter = new QFilter("1", "=", (Object)1);
        filter.and("owner.id", "=", this.getParameter("customerid"));
        filter.and("customer.id", "=", this.getParameter("ownerid"));
        filter.and("user.id", "=", UserUtil.getUserID());
        filter.and("ispurchasing", "=", (Object)"1");
        DeleteServiceHelper.delete((String)"mdr_shopping_cart", (QFilter[])filter.toArray());
    }

    protected void initDefaultSaler() {
        if (UserUtil.isSaler((Object)this.getOwnerF7PKValue())) {
            this.setSalerF7Value(UserUtil.getUserID());
        } else {
            super.initDefaultSaler();
        }
    }

    protected boolean isOrderQuantityStrongControl() {
        return SysParamsUtil.isOrderQuantityStrongControl();
    }

    protected void setPayrecordCount() {
        ArrayList<QFilter> tbFilters = new ArrayList<QFilter>();
        tbFilters.add(new QFilter("orderid", "=", (Object)this.getId().toString()));
        int count = ORM.create().count("MDR", "mdr_money_receivingbill", tbFilters.toArray(new QFilter[tbFilters.size()]));
        this.getModel().setValue("payrecordcount", (Object)count);
    }

    protected void toPayRecordPage() {
        MobileListShowParameter parameter = new MobileListShowParameter();
        parameter.setFormId("bos_moblist");
        parameter.setBillFormId("mdr_money_receivingbill");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCustomParam("orderid", (Object)this.getId());
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
    }
}

