/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.bill.saleorder;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.bbc.formplugin.filter.saleorder.NoDataFilter;
import kd.drp.bbc.formplugin.filter.saleorder.SaleOrderListFilter;
import kd.drp.dpa.formplugin.bill.saleorder.PurOrderNewListPlugin;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.UserUtil;

public class SaleOrderNewListPlugin
extends PurOrderNewListPlugin {
    protected static final String APART = "apart";

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] values;
        super.afterQueryOfExport(e);
        for (DynamicObject dynamicObject : values = e.getQueryValues()) {
            DynamicObjectCollection itementrys;
            if (dynamicObject.getDataEntityType().getProperties().get((Object)"itementry") == null || (itementrys = dynamicObject.getDynamicObjectCollection("itementry")) == null) continue;
            for (DynamicObject itementry : itementrys) {
                if (itementry.getDataEntityType().getProperties().get((Object)"botpdiscounttype") == null || itementry.getString("botpdiscounttype") == null) continue;
                itementry.set("botpdiscounttype", (Object)itementry.getString("botpdiscounttype").trim());
            }
        }
        e.setQueryValues(values);
    }

    protected void createListFilter(SetFilterEvent e) {
        this.createCustomerFilter(e);
        this.createTabFilter(e);
    }

    protected void setFilterName() {
        this.setFilterOwnerName("owner.id");
    }

    public void filterContainerInit(FilterContainerInitArgs e) {
        super.filterContainerInit(e);
        this.initOwnerFilterComboItem(e, "owner.name");
    }

    private void createCustomerFilter(SetFilterEvent e) {
        String key;
        List qFilters = e.getQFilters();
        Map fsMap = this.filter2Map(qFilters);
        QFilter tempQFilter = (QFilter)fsMap.get(key = "owner.id");
        if (null != tempQFilter) {
            Object ownerid = tempQFilter.getValue();
            QFilter filter = new SaleOrderListFilter(ownerid).getBillFilter();
            qFilters.add(filter);
        } else {
            Object ownerName;
            key = "owner.name";
            QFilter tempQfilter = (QFilter)fsMap.get(key);
            Object object = ownerName = null != tempQfilter ? tempQfilter.getValue() : null;
            if (StringUtils.isNotEmpty((Object)ownerName)) {
                QFilter qFilter;
                DynamicObjectCollection owners;
                List ownerIds = UserUtil.getOwnerIDs();
                if (null != ownerIds) {
                    QFilter filters = SaleOrderUtil.getSaleOrderSalerFilter((List)ownerIds);
                    qFilters.add(filters);
                }
                if (!(owners = QueryServiceHelper.query((String)"mdr_customer", (String)"id", (QFilter[])(qFilter = new QFilter("name", "like", ownerName)).toArray())).isEmpty()) {
                    QFilter filter = null;
                    for (DynamicObject owner : owners) {
                        SaleOrderListFilter saleOrderListFilter = new SaleOrderListFilter(owner.get("id"));
                        filter = saleOrderListFilter.mergeQFilter(filter, saleOrderListFilter.getBillFilter());
                    }
                    qFilters.add(filter);
                }
            } else {
                List ownerIds = UserUtil.getOwnerIDs();
                QFilter filter = SaleOrderUtil.getSaleOrderSalerFilter((List)ownerIds, (boolean)true);
                if (filter != null) {
                    qFilters.add(filter);
                } else {
                    qFilters.add(new NoDataFilter().getBillFilter());
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        List errorsInfos;
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "apart": {
                if (!this.getOperationResult(e)) break;
                this.toApartPage();
                break;
            }
            case "printpreview": {
                this.afterPreviewPrintProcess();
                break;
            }
        }
        if ("audit".equals(key) && SysParamsUtil.isAuditThenSync() && !CollectionUtils.isEmpty((Collection)(errorsInfos = e.getOperationResult().getAllErrorOrValidateInfo()))) {
            e.getOperationResult().setSuccess(false);
        }
    }

    private void afterPreviewPrintProcess() {
        Object[] ids = this.getSelectedOrderIds(false);
        DynamicObject[] sos = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bbc_saleorder").getDynamicObjectType());
        Date dt = new Date();
        for (DynamicObject tso : sos) {
            tso.set("printtime", (Object)dt);
        }
        SaveServiceHelper.save((DynamicObject[])sos);
        this.getListView().refresh();
    }

    protected void toPayPage() {
        Object[] ids = this.getSelectedOrderIds(true);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("mdr_money_receivingbill");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("topay");
        parameter.setCustomParam("orderid", ids[0]);
        parameter.setCustomParam("ordertype", (Object)"saleorder");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh"));
        this.getView().showForm(parameter);
    }

    protected void toDeliveryPage() {
        Object[] ids = this.getSelectedOrderIds(true);
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId("bbc_delivery_record");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.getOpenStyle().setTargetKey("todelivery");
        parameter.setCustomParam("orderId", ids[0]);
        parameter.setCustomParam("orderType", (Object)"saleorder");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void toApartPage() {
        Object[] ids = this.getSelectedOrderIds(true);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bbc_saleorder_apart");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("orderId", ids[0]);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh"));
        this.getView().showForm(parameter);
    }
}

