/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.bill.saleorder;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class SplitEntryParamFormPlugin
extends MdrFormPlugin {
    private static final String BTN_CONFIRM = "confirm";
    private static final String F_SPLITTYPE = "splittype";
    private static final String F_ROWQTY = "rowqty";
    private static final String F_ROWCOUNT = "rowcount";
    private static final String F_ROW_INDEX = "rowindex";

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "splittype": {
                this.splitTypeChange();
                break;
            }
            case "rowqty": {
                this.rowQtyChange(e);
                break;
            }
        }
    }

    private void rowQtyChange(PropertyChangedArgs e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        BigDecimal qty = (BigDecimal)fsp.getCustomParam("alterqty");
        BigDecimal rowQty = this.getModel().getDataEntity().getBigDecimal(F_ROWQTY);
        if (rowQty.compareTo(qty) >= 0) {
            this.getModel().setValue(F_ROWQTY, (Object)BigDecimal.ONE);
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u62c6\u5206\u6570\u91cf\u5fc5\u987b\u5728\uff080\uff0c%s\uff09\u8303\u56f4\u5185\uff01", (String)"SplitEntryParamFormPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]), qty));
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{F_ROWCOUNT});
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object unitId = fsp.getCustomParam("unit");
        this.getModel().setValue("unit", unitId);
        Object rowindex = fsp.getCustomParam(F_ROW_INDEX);
        this.getModel().setValue(F_ROW_INDEX, rowindex);
    }

    private void splitTypeChange() {
        String splitType = this.getModel().getDataEntity().getString(F_SPLITTYPE);
        IFormView view = this.getView();
        switch (splitType) {
            case "A": 
            case "B": {
                view.setVisible(Boolean.TRUE, new String[]{F_ROWCOUNT});
                view.setVisible(Boolean.FALSE, new String[]{F_ROWQTY});
                break;
            }
            case "C": {
                view.setVisible(Boolean.FALSE, new String[]{F_ROWCOUNT});
                view.setVisible(Boolean.TRUE, new String[]{F_ROWQTY});
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        String key = "";
        if (source instanceof Button) {
            key = ((Button)source).getKey();
        }
        switch (key) {
            case "confirm": {
                DynamicObject params = this.getModel().getDataEntity();
                this.getView().getParentView().setReturnData((Object)params);
                this.getView().invokeOperation("close");
            }
        }
    }
}

