/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.botp.returnorder;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.drp.mdr.formplugin.MdrBillConvertPlugin;
import org.apache.commons.lang3.StringUtils;

public class ReturnOrderPushSaloutbillPlugin
extends MdrBillConvertPlugin {
    private static final String SETTLEMENTTYPE = "bd_settlementtype";
    private static final String ISDEFAULT = "isdefault";
    private static final String SETTLETYPE = "settletype";
    private static final String BILLENTRY = "billentry";

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        if (entitySet == null) {
            return;
        }
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(tgtMainType);
        QFilter qfilter = new QFilter(ISDEFAULT, "=", (Object)Boolean.TRUE);
        DynamicObject settlementtype = BusinessDataServiceHelper.loadSingle((String)SETTLEMENTTYPE, (String)"id", (QFilter[])qfilter.toArray());
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            if (settlementtype != null) {
                bill.set(SETTLETYPE, (Object)settlementtype);
            }
            List srcRows = (List)entity.getValue("ConvertSource");
            for (int k = 0; k < srcRows.size(); ++k) {
                BigDecimal bigqty = (BigDecimal)((DynamicProperty)e.getFldProperties().get("qty")).getValue(srcRows.get(k));
                BigDecimal beforeQty = (BigDecimal)((DynamicObject)bill.getDynamicObjectCollection(BILLENTRY).get(k)).get("qty");
                if (beforeQty.compareTo(bigqty) == 0) continue;
                DynamicObject imBill = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvService", (String)"imBillAfterConvert", (Object[])new Object[]{tgtMainType, bill});
                DataEntityPropertyCollection properties = bill.getDataEntityType().getProperties();
                for (IDataEntityProperty dp : properties) {
                    bill.set(dp, imBill.get(dp));
                }
                entity.setDataEntity(imBill);
            }
            DynamicObjectCollection billentrys = bill.getDynamicObjectCollection(BILLENTRY);
            for (DynamicObject billentry : billentrys) {
                this.calActualPrice(billentry);
            }
        }
    }

    private void calActualPrice(DynamicObject billentry) {
        BigDecimal discountrate;
        BigDecimal price = billentry.getBigDecimal("price");
        String discounttype = billentry.getString("discounttype");
        if (StringUtils.isNotBlank((CharSequence)discounttype) && price != null && (discountrate = billentry.getBigDecimal("discountrate")) != null && discountrate.compareTo(BigDecimal.ZERO) > 0) {
            if ("A".equals(discounttype)) {
                BigDecimal actPrice = price.subtract(price.multiply(discountrate.divide(new BigDecimal(100))));
                if (discountrate.compareTo(BigDecimal.ZERO) > 0) {
                    billentry.set("actualprice", (Object)actPrice);
                }
            } else if ("B".equals(discounttype)) {
                BigDecimal actPrice = price.subtract(discountrate);
                billentry.set("actualprice", (Object)actPrice);
            }
            return;
        }
        billentry.set("actualprice", (Object)price);
    }
}

