/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.botp.saleorder;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.drp.mdr.formplugin.MdrBillConvertPlugin;
import org.apache.commons.lang3.StringUtils;

public class SaleOrderPushSaloutbillPlugin
extends MdrBillConvertPlugin {
    private static final String KEY_BILLNO = "billno";
    private static final String SETTLEMENTTYPE = "bd_settlementtype";
    private static final String SETTLETYPE = "settletype";
    private static final String CUSTOMER = "customer";
    private static final String BILLENTRY = "billentry";
    private static final String MDRCUSTOMERADDRESS = "mdr_customer_address";
    private static final String ISDEFAULT = "isdefault";
    private StringBuilder detailAddress;

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        if (entitySet == null) {
            return;
        }
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(tgtMainType);
        for (int i = 0; i < entitys.length; ++i) {
            ExtendedDataEntity entity = entitys[i];
            DynamicObject obj = entity.getDataEntity();
            List srcRows = (List)entity.getValue("ConvertSource");
            for (int k = 0; k < srcRows.size(); ++k) {
                BigDecimal bigqty = (BigDecimal)((DynamicProperty)e.getFldProperties().get("qty")).getValue(srcRows.get(k));
                BigDecimal beforeQty = (BigDecimal)((DynamicObject)obj.getDynamicObjectCollection(BILLENTRY).get(k)).get("qty");
                if (beforeQty.compareTo(bigqty) == 0) continue;
                DynamicObject imBill = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvService", (String)"imBillAfterConvert", (Object[])new Object[]{tgtMainType, obj});
                DataEntityPropertyCollection properties = obj.getDataEntityType().getProperties();
                for (IDataEntityProperty dp : properties) {
                    obj.set(dp, imBill.get(dp));
                }
                entity.setDataEntity(imBill);
            }
        }
        QFilter qfilter = new QFilter(ISDEFAULT, "=", (Object)Boolean.TRUE);
        DynamicObject settlementtype = BusinessDataServiceHelper.loadSingle((String)SETTLEMENTTYPE, (String)"id", (QFilter[])qfilter.toArray());
        for (ExtendedDataEntity entity : entitys) {
            List srcRows;
            DynamicObject srcRow;
            DynamicObject bill = entity.getDataEntity();
            if (settlementtype != null) {
                bill.set(SETTLETYPE, (Object)settlementtype);
            }
            if ((srcRow = (DynamicObject)(srcRows = (List)entity.getValue("ConvertSource")).get(0)) != null) {
                String billno = (String)((DynamicProperty)e.getFldProperties().get(KEY_BILLNO)).getValue((Object)srcRow);
                qfilter = new QFilter(KEY_BILLNO, "=", (Object)billno);
                DynamicObject customer = BusinessDataServiceHelper.loadSingle((String)"bbc_saleorder", (String)"customer.id", (QFilter[])qfilter.toArray());
                DynamicObject[] addresss = BusinessDataServiceHelper.load((String)MDRCUSTOMERADDRESS, (String)"contactname,telephone,detailaddress,isdefault", (QFilter[])(qfilter = new QFilter(CUSTOMER, "=", customer.get("customer.id"))).toArray());
                if (addresss != null && addresss.length > 0) {
                    Object add;
                    DynamicObject addObj = addresss[0];
                    if (addresss.length > 1 && !addObj.getBoolean(ISDEFAULT)) {
                        for (DynamicObject address : addresss) {
                            if (!address.getBoolean(ISDEFAULT)) continue;
                            addObj = address;
                        }
                    }
                    if ((add = addObj.get("detailaddress")) != null) {
                        this.detailAddress = new StringBuilder();
                        this.detailAddress.append(String.valueOf(add));
                    }
                }
            }
            int settlePrecision = 10;
            DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
            if (settleCurrency != null) {
                settlePrecision = settleCurrency.getInt("amtprecision");
            }
            DynamicObjectCollection billentrys = bill.getDynamicObjectCollection(BILLENTRY);
            for (DynamicObject billentry : billentrys) {
                billentry.set("receiveaddress", (Object)(this.detailAddress == null ? "" : this.detailAddress.toString()));
                this.calActualPrice(billentry, settlePrecision);
            }
        }
    }

    private void calActualPrice(DynamicObject billentry, int settlePrecision) {
        BigDecimal price = billentry.getBigDecimal("price");
        String discounttype = billentry.getString("discounttype");
        if (StringUtils.isNotBlank((CharSequence)discounttype) && discounttype.length() == 1 && price != null) {
            BigDecimal amount = billentry.getBigDecimal("amount");
            BigDecimal qty = billentry.getBigDecimal("qty");
            BigDecimal actPrice = amount.divide(qty, 10, 4);
            actPrice = actPrice.setScale(settlePrecision, RoundingMode.HALF_UP);
            billentry.set("actualprice", (Object)actPrice);
            return;
        }
        if (discounttype.length() != 1) {
            billentry.set("discounttype", (Object)"NULL");
        }
        billentry.set("actualprice", (Object)price);
    }
}

