/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.content;

import java.util.ArrayList;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrListPlugin;

public class NotiSendViewListPlugin
extends MdrListPlugin {
    private boolean isLink = false;
    private static final String OWNERNAME = "owner.name";
    private static final String OWNERID = "owner.id";

    public void filterContainerInit(FilterContainerInitArgs e) {
        super.filterContainerInit(e);
        this.initOwnerFilterComboItem(e, OWNERNAME);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter filter = new QFilter(OWNERID, "in", (Object)UserUtil.getOwnerIDs());
        e.getQFilters().add(filter);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName = args.getFieldName();
        if (OWNERNAME.equals(fieldName)) {
            List filters = args.getQfilters();
            QFilter filter = new QFilter("id", "in", (Object)UserUtil.getOwnerIDs());
            filters.add(filter);
            args.setQfilters(filters);
        }
        super.filterContainerBeforeF7Select(args);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        this.isLink = true;
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        if (this.isLink) {
            e.getParameter().setFormId("mdr_notice_sendview");
            e.getParameter().setStatus(OperationStatus.VIEW);
        }
        super.beforeShowBill(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "modify": {
                if (this.isLink) break;
                this.checkModify(args);
            }
        }
    }

    public void checkModify(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows();
        ArrayList<Object> ids = new ArrayList<Object>();
        for (ListSelectedRow row : listSelectedRowCollection) {
            ids.add(row.getPrimaryKeyValue());
        }
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"mdr_notification", (String)"id,status", (QFilter[])new QFilter("id", "in", ids).toArray());
        for (DynamicObject obj : objs) {
            if ("A".equals(obj.get("status"))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u5e03\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539\uff01", (String)"NotiSendViewListPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }
}

