/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.content;

import java.util.EventObject;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrBillPlugin;

public class NotiShowFormEditPlugin
extends MdrBillPlugin
implements BeforeF7SelectListener {
    private static final String CONTENT_TAG = "content_tag";
    private static final String CUSTOMER = "customer";
    private static final String SAVE = "save";
    private static final String SUBMIT = "submit";
    private static final String RICHTEXTEDITORAP = "richtexteditorap";
    private static final String RELEASEMODE = "releasemode";
    private static final String OWNERRANGE = "ownerrange";
    private static final String NOTIFICATIONENTRY = "notificationentry";
    private static final String SENDOBJECT = "sendobject";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"owner", CUSTOMER});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String f7Name = e.getProperty().getName();
        if ("owner".equals(f7Name)) {
            QFilter qFilter = UserUtil.getOwnerIdsQFilter((String)"id");
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)qFilter);
        } else if (CUSTOMER.equals(f7Name)) {
            Object ownerPk = this.getF7PKValue("owner");
            Set juniors = CustomerUtil.getAllAuthSubIdsById((Object)ownerPk);
            QFilter qFilter = new QFilter("id", "in", (Object)juniors);
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)qFilter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("owner", UserUtil.getDefaultOwnerID());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeData = e.getChangeSet();
        String fieldName = e.getProperty().getName();
        if (RELEASEMODE.equals(fieldName)) {
            for (ChangeData data : changeData) {
                String newValue = (String)data.getNewValue();
                if ("0".equals(newValue)) {
                    this.setVisible(new String[]{SENDOBJECT});
                    this.setDisVisible(new String[]{OWNERRANGE});
                    continue;
                }
                if (!"1".equals(newValue)) continue;
                this.setVisible(new String[]{OWNERRANGE});
                this.setDisVisible(new String[]{SENDOBJECT});
            }
        }
        if ("owner".equals(fieldName)) {
            this.getModel().deleteEntryData(NOTIFICATIONENTRY);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String releasemode = this.getTextFieldValue(RELEASEMODE);
        if ("0".equals(releasemode)) {
            this.setVisible(new String[]{SENDOBJECT});
            this.setDisVisible(new String[]{OWNERRANGE});
        } else if ("1".equals(releasemode)) {
            this.setVisible(new String[]{OWNERRANGE});
            this.setDisVisible(new String[]{SENDOBJECT});
        }
        String description = (String)this.getModel().getValue(CONTENT_TAG);
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl(RICHTEXTEDITORAP);
        if (StringUtils.isEmpty((String)richTextEditor.getText()) && StringUtils.isNotEmpty((String)description)) {
            richTextEditor.setText(description);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        RichTextEditor richTextEditor;
        String text;
        super.beforeDoOperation(args);
        String key = this.getOpKey(args);
        if (SAVE.equals(key) || SUBMIT.equals(key)) {
            String releasemode = this.getTextFieldValue(RELEASEMODE);
            if ("0".equals(releasemode)) {
                this.getModel().deleteEntryData(NOTIFICATIONENTRY);
            } else if ("1".equals(releasemode)) {
                this.setValue(SENDOBJECT, null);
            }
        }
        if ((text = (richTextEditor = (RichTextEditor)this.getControl(RICHTEXTEDITORAP)).getText()) == null && (SAVE.equalsIgnoreCase(key) || SUBMIT.equals(key))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u901a\u77e5\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (String)"NotiShowFormEditPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        } else if (SUBMIT.equals(key) || SAVE.equals(key)) {
            this.getModel().setValue(CONTENT_TAG, (Object)text);
        }
        if (text != null) {
            String description = (String)this.getModel().getValue(CONTENT_TAG);
            RichTextEditor richText = (RichTextEditor)this.getControl(RICHTEXTEDITORAP);
            richText.setText(description);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = this.getOpKey(args);
        if (SAVE.equals(key)) {
            super.reLoadPage();
        }
        super.afterDoOperation(args);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }
}

