/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.delivery;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.constants.SaleOrderEntryType;
import kd.drp.mdr.common.util.DeliveryUtil;
import kd.drp.mdr.formplugin.MdrBasePlugin;

public class DeliveryRecordEditPlugin
extends MdrBasePlugin {
    public static final String TOOL_BARAP = "toolbarap";
    public static final String SIGN = "sign";
    public static final String UNSIGN = "unsign";
    public static final String SRCBILLENTITY = "srcbillentity";
    public static final String SOURCEBILLID_NEW = "srcbillid";
    public static final String SRCBILLNUMBER = "srcbillnumber";
    public static final String SRCBILLENTRYID = "srcbillentryid";
    public static final String SRCBILLENTRYSEQ = "srcbillentryseq";
    public static final String MAINBILLENTITY = "mainbillentity";
    public static final String MAINBILLID_NEW = "mainbillid";
    public static final String MAINBILLNUMBER = "mainbillnumber";
    public static final String MAINBILLENTRYID = "mainbillentryid";
    public static final String MAINBILLENTRYSEQ = "mainbillentryseq";
    public static final String ORDERCHANNELID = "orderchannelid";
    public static final String SUPPLYCHANNELID = "supplychannelid";
    public static final String SALEORG = "saleorg";
    public static final String SALEORGCHANNELID = "saleorgchannelid";
    public static final String STOCKID = "stockid";
    public static final String STOCKADDRID = "stockaddrid";
    public static final String SOURCEBILLTYPE = "sourcebilltype";
    public static final String TB_DELIVER_DATE = "deliverdate";
    public static final String SIGNSTATUS = "signstatus";
    public static final String LOGISTICS = "logistics";
    public static final String LOGISTICSBILL = "logisticsbill";
    public static final String SETTLECURRENCY = "settlecurrency";
    public static final String ORDER_LIST = "deliverydetail";
    public static final String TB_ITEM = "item";
    public static final String TB_UNIT = "unit";
    public static final String TB_QTY = "qty";
    public static final String TB_DELIVERED_QTY = "deliveredqty";
    public static final String TB_DELIVER_QTY = "deliverqty";
    public static final String TB_DELIVER_STANDARD_QTY = "deliverstandardqty";
    public static final String TB_SIGN_QTY = "signqty";
    public static final String TB_SIGN_STANDARD_QTY = "signstandardqty";
    public static final String TB_WAREHOUSE = "warehouse";
    public static final String TB_RECEIVEWAREHOUSE = "receivewarehouse";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object orderId = this.getView().getFormShowParameter().getCustomParam("orderId");
        Object orderType = this.getView().getFormShowParameter().getCustomParam("orderType");
        if (orderId == null || orderType == null) {
            return;
        }
        if ("dispatchOrder".equals(orderType)) {
            this.creatOrderByDispatchOrder(orderId);
        } else if ("saleorder".equals(orderType)) {
            this.creatNewOrderBySaleOrder(orderId);
        }
        this.setUnEnable(new String[]{"sourcebillnumber"});
        this.initQuantities();
    }

    private void creatNewOrderBySaleOrder(Object orderId) {
        DynamicObject orderInfo = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"bbc_saleorder", (String)"id,billno,currency,saleorgid,owner,itementry.id,itementry.item,itementry.unit,itementry.assistattr,itementry.qty,itementry.deliveredqty,itementry.entrywarehouse,itementry.entryreceivewarehouse,itementry.entrytype,itementry.itemamount,itementry.ispresent,itementry.price,itementry.taxrate,itementry.taxprice,itementry.discounttype,itementry.discount,itementry.discountamount,itementry.taxamount,itementry.baseunit,itementry.tax,itementry.assistunit,itementry.entryid,itementry.seq,itementry.sourcebillid,itementry.sourcebillentryid,itementry.consigneecutomer,itementry.sendcustomer,itementry.stockid,itementry.entryclosestatus ");
        if (orderInfo == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8981\u8d27\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"DeliveryRecordEditPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setValue(SOURCEBILLTYPE, "saleorder");
        this.setValue(SETTLECURRENCY, orderInfo.get("currency"));
        String orderNumber = orderInfo.getString("billno");
        long saleOrgId = orderInfo.getLong("saleorgid_id");
        DynamicObject customerBelongSaleOrg = BusinessDataServiceHelper.loadSingle((String)"mdr_customer", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizgroup", "=", (Object)saleOrgId), new QFilter("isinnerorg", "=", (Object)Character.valueOf('1'))});
        DynamicObjectCollection orderEntryInfo = orderInfo.getDynamicObjectCollection("itementry");
        int i = 0;
        for (DynamicObject orderEntry : orderEntryInfo) {
            BigDecimal qty = orderEntry.getBigDecimal(TB_QTY);
            BigDecimal deliveredqty = orderEntry.getBigDecimal(TB_DELIVERED_QTY);
            BigDecimal toDeliveredqty = qty;
            String entrytype = orderEntry.getString("entrytype");
            if (orderEntry.getString("entryclosestatus").compareTo("0") == 0 || SaleOrderEntryType.COMBINATION.getFlagStr().equals(entrytype) || toDeliveredqty == null) continue;
            if (deliveredqty != null) {
                toDeliveredqty = toDeliveredqty.subtract(deliveredqty);
            }
            if (BigDecimal.ZERO.compareTo(toDeliveredqty) < 0) {
                int newRowIndex = this.getModel().createNewEntryRow(ORDER_LIST);
                this.setValue(SRCBILLENTITY, "saleorder", i);
                this.setValue(SRCBILLNUMBER, orderNumber, i);
                this.setValue(SOURCEBILLID_NEW, orderId, i);
                this.setValue(SRCBILLENTRYID, orderEntry.getString("id"), i);
                this.setValue(SRCBILLENTRYSEQ, orderEntry.getString("seq"), i);
                this.setValue(MAINBILLENTITY, "saleorder", i);
                this.setValue(MAINBILLID_NEW, orderId, i);
                this.setValue(MAINBILLNUMBER, orderNumber, i);
                this.setValue(MAINBILLENTRYID, orderEntry.getString("id"), i);
                this.setValue(MAINBILLENTRYSEQ, orderEntry.getString("seq"), i);
                this.setValue(ORDERCHANNELID, orderEntry.get("consigneecutomer_id"), i);
                this.setValue(SUPPLYCHANNELID, orderEntry.get("sendcustomer_id"), i);
                this.setValue(SALEORG, saleOrgId, i);
                this.setValue(SALEORGCHANNELID, customerBelongSaleOrg, i);
                this.setValue(STOCKID, 0, i);
                this.setValue(STOCKADDRID, 0, i);
                DynamicObject item = orderEntry.getDynamicObject(TB_ITEM);
                if (item instanceof DynamicObject) {
                    this.setValue(TB_ITEM, item.getLong("id"), i);
                    this.setValue("material", item.get("material.id"), i);
                }
                this.setValue(TB_UNIT, orderEntry.get(TB_UNIT), i);
                this.setValue("assistattr", orderEntry.get("assistattr"), i);
                this.setValue(TB_QTY, qty, i);
                this.setValue(TB_DELIVERED_QTY, deliveredqty, i);
                this.setValue(TB_DELIVER_QTY, toDeliveredqty, i);
                this.setValue(TB_WAREHOUSE, orderEntry.get("entrywarehouse_id"), i);
                this.setValue(TB_RECEIVEWAREHOUSE, orderEntry.get("entryreceivewarehouse_id"), i);
                this.setValue("amount", orderEntry.get("itemamount"), i);
                this.setValue("ispresent", orderEntry.get("ispresent"), i);
                this.setValue("price", orderEntry.get("price"), i);
                this.setValue("taxrate", orderEntry.get("taxrate"), i);
                this.setValue("taxprice", orderEntry.get("taxprice"), i);
                this.setValue("discounttype", orderEntry.get("discounttype"), i);
                this.setValue("discount", orderEntry.get("discount"), i);
                this.setValue("discountamount", orderEntry.get("discountamount"), i);
                this.setValue("taxamount", orderEntry.get("tax"), i);
                this.setValue("amountandtax", orderEntry.get("taxamount"), i);
                this.setValue("baseunit", orderEntry.get("baseunit"), i);
                this.setValue("assistunit", orderEntry.get("assistunit"), i);
            }
            ++i;
        }
    }

    private void creatOrderByDispatchOrder(Object orderId) {
        QFilter filer = new QFilter("id", "=", orderId);
        DynamicObject orderInfo = QueryServiceHelper.queryOne((String)"mdr_dispatch_order", (String)"id,billno", (QFilter[])filer.toArray());
        if (orderInfo == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u8d27\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"DeliveryRecordEditPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(SOURCEBILLTYPE, (Object)"dispatchorder");
        filer = new QFilter("order", "=", orderId);
        DynamicObjectCollection orderEntryInfo = QueryServiceHelper.query((String)"mdr_dispatchorder_entry", (String)"id,item,unit,assistattr,qty,deliveredqty,entrywarehouse,entryreceivewarehouse", (QFilter[])filer.toArray());
        IDataModel model = this.getModel();
        int i = 0;
        for (DynamicObject orderEntry : orderEntryInfo) {
            BigDecimal qty = orderEntry.getBigDecimal(TB_QTY);
            BigDecimal deliveredqty = orderEntry.getBigDecimal(TB_DELIVERED_QTY);
            BigDecimal toDeliveredqty = qty;
            if (toDeliveredqty == null) continue;
            if (deliveredqty != null) {
                toDeliveredqty = toDeliveredqty.subtract(deliveredqty);
            }
            if (BigDecimal.ZERO.compareTo(toDeliveredqty) >= 0) continue;
            model.createNewEntryRow(ORDER_LIST);
            model.setValue(TB_ITEM, orderEntry.get(TB_ITEM), i);
            model.setValue(TB_UNIT, orderEntry.get(TB_UNIT), i);
            model.setValue("assistattr", orderEntry.get("assistattr"), i);
            model.setValue(TB_QTY, (Object)qty, i);
            model.setValue(TB_DELIVERED_QTY, (Object)deliveredqty, i);
            model.setValue(TB_DELIVER_QTY, (Object)toDeliveredqty, i);
            model.setValue(TB_WAREHOUSE, orderEntry.get("entrywarehouse"), i);
            model.setValue(TB_RECEIVEWAREHOUSE, orderEntry.get("entryreceivewarehouse"), i);
            ++i;
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.reLoadBill();
    }

    private void reLoadBill() {
        String sourcebilltype = this.getModel().getDataEntity().getString(SOURCEBILLTYPE);
        String signstatus = this.getModel().getDataEntity().getString(SIGNSTATUS);
        DynamicObject delivery = this.getModel().getDataEntity();
        Map ordersMap = DeliveryUtil.getOrdersMap((DynamicObject)delivery, (String)sourcebilltype, (String)"");
        DynamicObject orderInfo = null;
        if (StringUtils.isNotEmpty((String)signstatus)) {
            DynamicObjectCollection deliveryEntryInfo = this.getModel().getDataEntity().getDynamicObjectCollection(ORDER_LIST);
            DynamicObjectCollection saleorderEntryInfo = null;
            if (deliveryEntryInfo != null) {
                for (int i = 0; i < deliveryEntryInfo.size(); ++i) {
                    Long orderEntryId;
                    DynamicObject deliveryEntry = (DynamicObject)deliveryEntryInfo.get(i);
                    orderInfo = (DynamicObject)ordersMap.get(deliveryEntry.getLong(MAINBILLID_NEW));
                    if (orderInfo == null) continue;
                    saleorderEntryInfo = orderInfo.getDynamicObjectCollection("itementry");
                    Map saleorderEntryInfoMap = CommonUtils.collection2Map((String)"id", (List)saleorderEntryInfo);
                    DynamicObject orderEntry = (DynamicObject)saleorderEntryInfoMap.get(orderEntryId = Long.valueOf(deliveryEntry.getLong(MAINBILLENTRYID)));
                    if (orderEntry == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u8ba2\u5355\u5206\u5f55\u5931\u8d25\uff01", (String)"DeliveryRecordEditPlugin_3", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                    }
                    BigDecimal qty = orderEntry.getBigDecimal(TB_QTY);
                    BigDecimal deliveredqty = orderEntry.getBigDecimal(TB_DELIVERED_QTY);
                    this.getModel().setValue(TB_QTY, (Object)qty, i);
                    this.getModel().setValue(TB_DELIVERED_QTY, (Object)deliveredqty, i);
                    this.getModel().setValue(TB_SIGN_QTY, deliveryEntry.get(TB_DELIVER_QTY), i);
                }
            }
            if ("1".equals(signstatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{UNSIGN});
                this.getView().setVisible(Boolean.FALSE, new String[]{SIGN});
                this.getView().setEnable(Boolean.FALSE, new String[]{LOGISTICSBILL});
                this.getView().setEnable(Boolean.FALSE, new String[]{LOGISTICS});
            } else if ("0".equals(signstatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{SIGN});
                this.getView().setVisible(Boolean.FALSE, new String[]{UNSIGN});
            }
            this.getModel().setDataChanged(false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("submit".equals(operateKey) || "save".equals(operateKey)) {
            this.reLoadBill();
        } else if ("unaudit".equals(operateKey) || "audit".equals(operateKey)) {
            this.getView().updateView(SIGNSTATUS);
            this.getView().updateView("signer");
            this.getView().updateView("signtime");
            this.getView().updateView("billstatus");
            this.getView().updateView("auditor");
            this.getView().updateView("auditdate");
            this.getView().updateView(ORDER_LIST);
            this.getView().updateView("deliverydetail.signbaseqty");
            this.getView().updateView("deliverydetail.signassitqty");
            this.getView().updateView("deliverydetail.signstandardqty");
        }
        this.initButton();
        this.initSignQty();
    }

    private void initSignQty() {
        String billstatus = (String)this.getValue("billstatus");
        if ("C".equals(billstatus)) {
            this.setVisible(new String[]{TB_SIGN_QTY});
            this.setValue(SIGNSTATUS, "1");
        } else {
            this.setDisVisible(new String[]{TB_SIGN_QTY});
            this.setValue(SIGNSTATUS, "0");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initButton();
        this.initSignQty();
    }

    private void initButton() {
        String billstatus = (String)this.getValue("billstatus");
        if ("B".equals(billstatus)) {
            this.setVisible(new String[]{"bar_audit"});
            this.setDisVisible(new String[]{"bar_unaudit"});
        } else if ("C".equals(billstatus)) {
            this.setVisible(new String[]{"bar_unaudit"});
            this.setDisVisible(new String[]{"bar_audit"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.triggerChangeEvent) {
            return;
        }
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int i = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "deliverqty": {
                this.calculateQuantities(newValue, i);
                this.reCalculateAmount(newValue, i);
            }
        }
    }

    private void reCalculateAmount(Object newValue, int i) {
        BigDecimal qty = ((DynamicObject)this.getModel().getEntryEntity(ORDER_LIST).get(i)).getBigDecimal(TB_QTY);
        if (BigDecimal.ZERO.compareTo(qty) >= 0) {
            this.getView().showErrorNotification("\u8ba2\u8d27\u6570\u91cf\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5");
            return;
        }
        if (BigDecimal.ZERO.compareTo((BigDecimal)newValue) >= 0 || qty.compareTo((BigDecimal)newValue) < 0) {
            this.setAssistantAndBaseQtyValue(BigDecimal.ZERO, BigDecimal.ZERO, i);
            this.triggerChangeEvent = false;
            this.setValue("amount", BigDecimal.ZERO, i);
            this.triggerChangeEvent = false;
            this.setValue("amountandtax", BigDecimal.ZERO, i);
            return;
        }
        BigDecimal price = ((DynamicObject)this.getModel().getEntryEntity(ORDER_LIST).get(i)).getBigDecimal("price");
        BigDecimal taxprice = ((DynamicObject)this.getModel().getEntryEntity(ORDER_LIST).get(i)).getBigDecimal("taxprice");
        BigDecimal amount = price.multiply((BigDecimal)newValue);
        BigDecimal amountAndTax = taxprice.multiply((BigDecimal)newValue);
        this.setValue("amount", amount, i);
        this.setValue("amountandtax", amountAndTax, i);
    }

    private void initQuantities() {
        DynamicObjectCollection entries = this.getModel().getEntryEntity(ORDER_LIST);
        int i = 0;
        for (DynamicObject entry : entries) {
            BigDecimal deliverqty = entry.getBigDecimal(TB_DELIVER_QTY);
            this.calculateQuantities(deliverqty, i);
            ++i;
        }
    }

    private void calculateQuantities(Object newValue, int i) {
        BigDecimal qty = ((DynamicObject)this.getModel().getEntryEntity(ORDER_LIST).get(i)).getBigDecimal(TB_QTY);
        if (BigDecimal.ZERO.compareTo(qty) >= 0) {
            this.getView().showErrorNotification(String.format("\u7b2c%s\u884c\uff0c\u8ba2\u8d27\u6570\u91cf\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5", i + 1));
            return;
        }
        if (null == newValue || !(newValue instanceof BigDecimal)) {
            this.setAssistantAndBaseQtyValue(BigDecimal.ZERO, BigDecimal.ZERO, i);
            this.getView().showMessage(String.format("\u7b2c%s\u884c\uff0c\u8bf7\u68c0\u67e5\u672c\u6b21\u53d1\u8d27\u6570\u91cf", i + 1));
            return;
        }
        if (BigDecimal.ZERO.compareTo((BigDecimal)newValue) >= 0 || qty.compareTo((BigDecimal)newValue) < 0) {
            this.setAssistantAndBaseQtyValue(BigDecimal.ZERO, BigDecimal.ZERO, i);
            this.getView().showMessage(String.format("\u7b2c%s\u884c\uff0c\u53d1\u8d27\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\uff0c\u4e14\u5c0f\u4e8e\u8ba2\u8d27\u6570\u91cf", i + 1));
            return;
        }
        Long materialId = 0L;
        Object material = this.getValue("material", i);
        if (!(material instanceof DynamicObject)) {
            this.getView().showMessage(String.format("\u7b2c%s\u884c\uff0c\u5546\u54c1\u65e0\u7269\u6599\u4fe1\u606f\uff0c\u627e\u4e0d\u5230\u5355\u4f4d\u6362\u7b97\u5173\u7cfb\uff1b\u8bf7\u68c0\u67e5\u5546\u54c1\u662f\u5426\u6b63\u786e\u3002", i + 1));
            return;
        }
        materialId = ((DynamicObject)material).getLong("id");
        Long baseUnitId = 0L;
        Object baseUnit = this.getValue("baseunit", i);
        if (baseUnit instanceof DynamicObject) {
            baseUnitId = ((DynamicObject)baseUnit).getLong("id");
        }
        Long normalUnitId = 0L;
        Object normalUnit = this.getValue(TB_UNIT, i);
        if (normalUnit instanceof DynamicObject) {
            normalUnitId = ((DynamicObject)normalUnit).getLong("id");
        }
        Long assistantUnitId = 0L;
        Object assistantUnit = this.getValue("assistunit", i);
        if (assistantUnit instanceof DynamicObject) {
            assistantUnitId = ((DynamicObject)assistantUnit).getLong("id");
        }
        BigDecimal assistQty = BigDecimal.ZERO;
        if (null != assistantUnit) {
            assistQty = UnitConvertHelper.calculateNewQty((BigDecimal)((BigDecimal)newValue), (Long)assistantUnitId, (Long)normalUnitId, (Long)materialId, null);
        }
        BigDecimal baseQty = BigDecimal.ZERO;
        if (null != baseUnit) {
            baseQty = UnitConvertHelper.calculateNewQty((BigDecimal)((BigDecimal)newValue), (Long)baseUnitId, (Long)normalUnitId, (Long)materialId, null);
        }
        this.setAssistantAndBaseQtyValue(assistQty, baseQty, i);
    }

    private void setAssistantAndBaseQtyValue(BigDecimal assistantQty, BigDecimal baseQty, int i) {
        this.setValue("deliverassitqty", assistantQty, i);
        this.setValue("deliverbaseqty", baseQty, i);
    }
}

