/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.evaluate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.form.control.Video;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.util.EvaluateUtil;
import kd.drp.mdr.common.util.ItemUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class ItemEvaluateEditPlugin
extends MdrFormPlugin
implements UploadListener {
    private static final String TAG = "tag";
    private static final String LABEL = "label";
    private static final String STAR = "star";
    private static final String SCORE = "score";
    private static final String shixin = "kdfont kdfont-xingxing_shixin";
    private static final String kongxin = "kdfont kdfont-xingxing_xianxing";
    private static final String BTN_SAVE = "btnsave";
    private static final String BTN_CANCEL = "btncancel";
    private static final String EVALTAGFLEX = "evaltagflex";
    private static final String EVALLABELFLEX = "evallabelflex";
    private static final String KEY_ATTACHMENTPANEL = "attachmentpanelap";
    private static final String VIDEO = "video";
    private static final String KEY_ATTACHMENTURLS = "attachmenturls";
    private static final String EVALUATEGRADE = "evaluategrade";
    private static final String defaultUrl = "images/pc/emotion/No_picture.png";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        FlexPanelAp labelap;
        super.loadCustomControlMetas(e);
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        FlexPanelAp tagap = this.createEvalTagsAp(showParameter);
        if (tagap != null) {
            HashMap<String, String> mapHead = new HashMap<String, String>();
            mapHead.put("id", EVALTAGFLEX);
            mapHead.put("items", (String)tagap.createControl().get("items"));
            e.getItems().add(mapHead);
        }
        if ((labelap = this.createEvalLabelsAp(showParameter)) != null) {
            HashMap<String, String> mapHead = new HashMap<String, String>();
            mapHead.put("id", EVALLABELFLEX);
            mapHead.put("items", (String)labelap.createControl().get("items"));
            e.getItems().add(mapHead);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        List<Map<String, Object>> tags = this.getTagList(this.getView().getFormShowParameter());
        JSONArray tagids = new JSONArray();
        for (int i = 0; i < tags.size(); ++i) {
            Map<String, Object> tag = tags.get(i);
            tagids.add((Object)(TAG + tag.get("id")));
        }
        String pageid = this.getView().getPageId();
        this.getPageCache().put(pageid + TAG, tagids.toString());
        List<Map<String, Object>> labels = this.getLabelList(this.getView().getFormShowParameter());
        JSONArray labelids = new JSONArray();
        for (int i = 0; i < labels.size(); ++i) {
            Map<String, Object> label = labels.get(i);
            labelids.add((Object)(LABEL + label.get("id")));
        }
        this.getPageCache().put(pageid + LABEL, labelids.toString());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ItemEntryInfo entryinfo = new ItemEntryInfo(this.getView().getFormShowParameter().getCustomParams());
        DynamicObject item = ItemUtil.loadInfoById((Object)entryinfo.getItemid(), (String)"thumbnail");
        String url = (String)item.get("thumbnail");
        if (StringUtils.isEmpty((String)url)) {
            url = defaultUrl;
        }
        this.setValue("image", url);
        if (this.isView(this.getView().getFormShowParameter())) {
            Object evalid = this.getView().getFormShowParameter().getCustomParam("evalid");
            DynamicObject eval = BusinessDataServiceHelper.loadSingle((Object)evalid, (String)"mdr_item_evaluate");
            this.setValue("evaltext", eval.get("evaluatecontent"));
            this.initPic("pic1", "picture1", eval);
            this.initPic("pic2", "picture2", eval);
            this.initPic("pic3", "picture3", eval);
            this.initPic("pic4", "picture4", eval);
            this.initPic("pic5", "picture5", eval);
            this.getView().setVisible(Boolean.FALSE, new String[]{"opflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ATTACHMENTPANEL});
            this.getView().setEnable(Boolean.FALSE, new String[]{"evaltext"});
            List attachments = AttachmentServiceHelper.getAttachments((String)"mdr_item_evaluate", (Object)evalid, (String)"attachmentpanel");
            if (attachments.size() > 0) {
                String attachurl = (String)((Map)attachments.get(0)).get("url");
                Video video = (Video)this.getControl(VIDEO);
                video.setSrc(attachurl);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{VIDEO});
            }
            int score = eval.getBigDecimal(EVALUATEGRADE).intValue();
            for (int i = score + 1; i <= 5; ++i) {
                Vector v = (Vector)this.getView().getControl("score_" + i);
                v.setUrl(kongxin);
            }
            this.setValue(EVALUATEGRADE, score);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{VIDEO});
        }
    }

    private void initPic(String pic, String picture, DynamicObject eval) {
        String picurl = eval.getString(picture);
        if (!StringUtils.isEmpty((String)picurl)) {
            this.setValue(pic, picurl);
            this.getView().setEnable(Boolean.FALSE, new String[]{pic});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{pic});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SAVE, BTN_CANCEL});
        this.addUploadListener(this, new String[]{KEY_ATTACHMENTPANEL});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_SAVE.equals(key)) {
            this.saveItemEval();
            this.getView().close();
        }
        if (BTN_CANCEL.equals(key)) {
            this.getView().close();
        }
        if (key.startsWith(STAR)) {
            String[] split = key.split("_");
            String id = split[0].substring(4, split[0].length());
            Integer index = Integer.parseInt(split[1]);
            this.setValue(TAG + id, index);
            for (int i = 1; i <= 5; ++i) {
                String starKey = STAR + id + "_" + i;
                Vector v = (Vector)this.getControl(starKey);
                if (i <= index) {
                    v.setFontClass(shixin);
                    continue;
                }
                v.setFontClass(kongxin);
            }
        }
    }

    public void afterRemove(UploadEvent evt) {
        this.refreshAttachmentUrls(evt);
    }

    public void afterUpload(UploadEvent evt) {
        this.refreshAttachmentUrls(evt);
    }

    private void refreshAttachmentUrls(UploadEvent evt) {
        Object[] objs = evt.getUrls();
        JSONArray array = new JSONArray();
        for (int i = 0; i < objs.length; ++i) {
            Map map = (Map)objs[i];
            JSONObject obj = new JSONObject();
            for (Map.Entry entry : map.entrySet()) {
                obj.put(entry.getKey(), entry.getValue());
            }
            array.add((Object)obj);
        }
        this.getPageCache().put(KEY_ATTACHMENTURLS + this.getView().getPageId(), array.toString());
    }

    public void onGetControl(OnGetControlArgs e) {
        FieldEdit fe;
        super.onGetControl(e);
        String key = e.getKey();
        if (key.startsWith(TAG)) {
            ComboEdit co = new ComboEdit();
            co.setKey(key);
            co.setView(this.getView());
            e.setControl((Control)co);
        }
        if (key.startsWith(LABEL)) {
            fe = new FieldEdit();
            fe.setKey(key);
            fe.setView(this.getView());
            e.setControl((Control)fe);
        }
        if (key.startsWith(STAR)) {
            fe = new Vector();
            fe.setKey(key);
            fe.setView(this.getView());
            e.setControl((Control)fe);
            if (!this.isView(this.getView().getFormShowParameter())) {
                fe.addClickListener((ClickListener)this);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key.startsWith(TAG)) {
            this.refreshTotalScore();
        }
    }

    private void refreshTotalScore() {
        JSONArray array = this.getEvalTags();
        int score = 5;
        if (array == null || array.isEmpty()) {
            this.setValue(EVALUATEGRADE, score);
        } else {
            BigDecimal totalscore = BigDecimal.ZERO;
            for (int i = 0; i < array.size(); ++i) {
                totalscore = totalscore.add(new BigDecimal(this.getValue(array.get(i).toString()).toString()));
            }
            score = totalscore.divide(new BigDecimal(array.size()), 0, RoundingMode.HALF_UP).intValue();
            this.setValue(EVALUATEGRADE, score);
        }
        for (int i = 1; i <= 5; ++i) {
            String starKey = "score_" + i;
            Vector v = (Vector)this.getControl(starKey);
            if (i <= score) {
                v.setFontClass(shixin);
                continue;
            }
            v.setFontClass(kongxin);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        Map fieldmap = newMainType.getAllFields();
        JSONArray tagids = this.getEvalTags();
        for (int i = 0; i < tagids.size(); ++i) {
            String id = tagids.get(i).toString();
            if (fieldmap.get(id) != null) continue;
            ComboProp prop = new ComboProp();
            prop.setName(id);
            prop.setDbIgnore(true);
            prop.setDefaultValue((Object)"5");
            fieldmap.put(id, prop);
            newMainType.registerSimpleProperty((DynamicSimpleProperty)prop);
        }
        JSONArray labelids = this.getEvalLabels();
        for (int i = 0; i < labelids.size(); ++i) {
            String id = (String)labelids.get(i);
            if (fieldmap.get(id) != null) continue;
            BooleanProp prop = new BooleanProp();
            prop.setName(id);
            prop.setDbIgnore(true);
            prop.setDefaultValue((Object)Boolean.TRUE);
            fieldmap.put(id, prop);
            newMainType.registerSimpleProperty((DynamicSimpleProperty)prop);
        }
        e.setNewEntityType(newMainType);
    }

    private void saveItemEval() {
        DynamicObject eval = BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_evaluate");
        ItemEntryInfo entryinfo = new ItemEntryInfo(this.getView().getFormShowParameter().getCustomParams());
        this.saveEvalTag(eval);
        this.saveEvalLabel(eval);
        eval.set("evaluatecontent", this.getValue("evaltext"));
        eval.set("picture1", this.getValue("pic1"));
        eval.set("picture2", this.getValue("pic2"));
        eval.set("picture3", this.getValue("pic3"));
        eval.set("picture4", this.getValue("pic4"));
        eval.set("picture5", this.getValue("pic5"));
        eval.set("isanonymity", this.getValue("isanonymity"));
        eval.set("billstatus", (Object)Character.valueOf('B'));
        eval.set("creator", UserUtil.getUserID());
        eval.set("createtime", (Object)new Date());
        eval.set("evaluateshoworhide", (Object)Character.valueOf('1'));
        eval.set(EVALUATEGRADE, this.getValue(EVALUATEGRADE));
        eval.set("ordernumber", (Object)BusinessDataServiceHelper.loadSingle((Object)entryinfo.getOrderid(), (String)"mdr_order_f7", (String)"id"));
        eval.set("orderentryid", entryinfo.getEntryid());
        eval.set("item", entryinfo.getItemid());
        eval.set("unit", entryinfo.getUnitid());
        eval.set("assistattr", entryinfo.getAttrid());
        eval.set("qty", (Object)entryinfo.getQty());
        eval.set("price", (Object)entryinfo.getPrice());
        eval.set("amount", (Object)entryinfo.getAmount());
        String number = CodeRuleServiceHelper.getNumber((String)"mdr_item_evaluate", (DynamicObject)eval, null);
        if (number == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5546\u54c1\u8bc4\u4ef7\u7684\u7f16\u7801\u89c4\u5219", (String)"ItemEvaluateEditPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        eval.set("billno", (Object)number);
        OperationUtil.invokeOperation((DynamicObject)eval, (String)"submit");
        this.saveAttachment(eval);
    }

    private void saveAttachment(DynamicObject eval) {
        String jsonstr = this.getPageCache().get(KEY_ATTACHMENTURLS + this.getView().getPageId());
        if (!StringUtils.isEmpty((String)jsonstr)) {
            JSONArray array = JSONArray.fromObject((Object)jsonstr);
            ArrayList attachments = new ArrayList(array.size());
            for (int i = 0; i < array.size(); ++i) {
                JSONObject obj = array.getJSONObject(i);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("uid", obj.get("uid"));
                map.put("size", obj.get("size"));
                map.put("name", obj.get("name"));
                map.put("url", obj.get("url"));
                attachments.add(map);
            }
            AttachmentServiceHelper.upload((String)"mdr_item_evaluate", (Object)eval.getPkValue(), (String)"attachmentpanel", attachments);
        }
    }

    private JSONArray getEvalTags() {
        String pageid = this.getView().getPageId();
        String jsonstr = this.getPageCache().get(pageid + TAG);
        JSONArray array = new JSONArray();
        if (!StringUtils.isEmpty((String)jsonstr)) {
            array = JSONArray.fromObject((Object)jsonstr);
        }
        return array;
    }

    private JSONArray getEvalLabels() {
        String pageid = this.getView().getPageId();
        String jsonstr = this.getPageCache().get(pageid + LABEL);
        JSONArray array = new JSONArray();
        if (!StringUtils.isEmpty((String)jsonstr)) {
            array = JSONArray.fromObject((Object)jsonstr);
        }
        return array;
    }

    private void saveEvalTag(DynamicObject eval) {
        String pageid = this.getView().getPageId();
        JSONArray tagids = JSONArray.fromObject((Object)this.getPageCache().get(pageid + TAG));
        if (tagids.isEmpty()) {
            return;
        }
        for (int i = 0; i < tagids.size(); ++i) {
            DynamicObject entry = eval.getDynamicObjectCollection("entryentity").addNew();
            String number = tagids.get(i).toString();
            entry.set("evaluatetag", (Object)number.substring(3, number.length()));
            entry.set(SCORE, this.getValue(number));
        }
    }

    private void saveEvalLabel(DynamicObject eval) {
        String pageid = this.getView().getPageId();
        JSONArray labelids = JSONArray.fromObject((Object)this.getPageCache().get(pageid + LABEL));
        if (labelids.isEmpty()) {
            return;
        }
        for (int i = 0; i < labelids.size(); ++i) {
            String number = labelids.getString(i);
            if (!((Boolean)this.getModel().getValue(number)).booleanValue()) continue;
            DynamicObject entry = eval.getDynamicObjectCollection("evaluatelabels").addNew();
            entry.set("fbasedataid", (Object)number.substring(5, number.length()));
        }
    }

    private FlexPanelAp createEvalLabelsAp(FormShowParameter param) {
        FlexPanelAp evallabelflex = new FlexPanelAp();
        evallabelflex.setKey("headevallabelflex");
        List<Map<String, Object>> labels = this.getLabelList(param);
        if (labels == null || labels.isEmpty()) {
            evallabelflex.getItems().add(this.createNoContentLabel("nolabel", ResManager.loadKDString((String)"\u65e0\u8bc4\u4ef7\u6807\u7b7e", (String)"ItemEvaluateEditPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0])));
            return evallabelflex;
        }
        JSONArray labelids = new JSONArray();
        for (int i = 0; i < labels.size(); ++i) {
            Map<String, Object> label = labels.get(i);
            FieldAp field = this.createLabelField(label.get("id").toString(), (String)label.get("name"), param);
            evallabelflex.getItems().add(field);
            labelids.add((Object)(LABEL + label.get("id")));
        }
        return evallabelflex;
    }

    private FieldAp createLabelField(String id, String name, FormShowParameter param) {
        FieldAp field = new FieldAp();
        CheckBoxField co = new CheckBoxField();
        co.setKey(LABEL + id);
        co.setMustInput(true);
        co.setName(new LocaleString(name));
        co.setDefValue(true);
        co.setShowStyle(1);
        if (this.isView(param)) {
            field.setLock("new,edit");
        }
        field.setId(LABEL + id);
        field.setKey(LABEL + id);
        field.setField((Field)co);
        field.setName(new LocaleString(name));
        field.setLabelDirection("h");
        field.setWidth(new LocaleString("100px"));
        field.setLabelWidth(new LocaleString("60px"));
        field.setComboShowStyle(0);
        field.setComboShowType(0);
        field.setFireUpdEvt(true);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("0px");
        margin.setLeft("0px");
        style.setMargin(margin);
        field.setStyle(style);
        return field;
    }

    private FlexPanelAp createEvalTagsAp(FormShowParameter param) {
        FlexPanelAp evaltagflex = new FlexPanelAp();
        evaltagflex.setKey("headevaltagflex");
        List<Map<String, Object>> tags = this.getTagList(param);
        if (tags == null || tags.isEmpty()) {
            evaltagflex.getItems().add(this.createNoContentLabel("notag", ResManager.loadKDString((String)"\u65e0\u8bc4\u4ef7\u9879", (String)"ItemEvaluateEditPlugin_2", (String)"drp-bbc-formplugin", (Object[])new Object[0])));
            return evaltagflex;
        }
        JSONArray tagids = new JSONArray();
        for (int i = 0; i < tags.size(); ++i) {
            Map<String, Object> tag = tags.get(i);
            FieldAp field = this.createTagField(tag.get("id").toString(), (String)tag.get("name"), param);
            evaltagflex.getItems().add(field);
            tagids.add((Object)(TAG + tag.get("id")));
            LabelAp label = this.createTagLabel(tag.get("id").toString(), (String)tag.get("name"));
            evaltagflex.getItems().add(label);
            for (int j = 1; j <= 5; ++j) {
                VectorAp v = this.createTagStar(tag.get("id").toString(), (String)tag.get("name"), j, ((BigDecimal)tag.get(SCORE)).intValue());
                evaltagflex.getItems().add(v);
            }
        }
        return evaltagflex;
    }

    private List<Map<String, Object>> getTagList(FormShowParameter param) {
        ArrayList<Map<String, Object>> list = null;
        if (this.isView(param)) {
            list = new ArrayList();
            Object evalid = param.getCustomParam("evalid");
            DynamicObjectCollection evalcol = QueryServiceHelper.query((String)"mdr_item_evaluate", (String)"entryentity.evaluatetag.id,entryentity.evaluatetag.number,entryentity.evaluatetag.name,entryentity.score", (QFilter[])new QFilter("id", "=", evalid).toArray());
            for (DynamicObject eval : evalcol) {
                HashMap<String, Object> tag = new HashMap<String, Object>();
                tag.put("id", eval.get("entryentity.evaluatetag.id"));
                tag.put("name", eval.get("entryentity.evaluatetag.name"));
                tag.put("number", eval.get("entryentity.evaluatetag.number"));
                tag.put(SCORE, eval.get("entryentity.score"));
                list.add(tag);
            }
        } else {
            list = EvaluateUtil.getEvaluateTagsByItemId((Object)param.getCustomParam("itemid"));
        }
        return list;
    }

    private List<Map<String, Object>> getLabelList(FormShowParameter param) {
        ArrayList<Map<String, Object>> list = null;
        if (this.isView(param)) {
            list = new ArrayList();
            Object evalid = param.getCustomParam("evalid");
            DynamicObject eval = BusinessDataServiceHelper.loadSingle((String)"mdr_item_evaluate", (String)"evaluatelabels", (QFilter[])new QFilter("id", "=", evalid).toArray());
            for (DynamicObject evallabel : eval.getDynamicObjectCollection("evaluatelabels")) {
                HashMap<String, Object> tag = new HashMap<String, Object>();
                tag.put("id", evallabel.getDynamicObject("fbasedataid").getPkValue());
                tag.put("name", evallabel.getDynamicObject("fbasedataid").getString("name"));
                tag.put("number", evallabel.getDynamicObject("fbasedataid").getString("number"));
                list.add(tag);
            }
        } else {
            list = EvaluateUtil.getEvaluateLabelsByItemId((Object)param.getCustomParam("itemid"));
        }
        return list;
    }

    private LabelAp createNoContentLabel(String id, String text) {
        LabelAp label = new LabelAp();
        label.setId(id);
        label.setKey(id);
        label.setName(new LocaleString(text));
        label.setFontSize(15);
        return label;
    }

    private LabelAp createTagLabel(String id, String name) {
        LabelAp Label2 = new LabelAp();
        Label2.setName(new LocaleString(name));
        Label2.setId(LABEL + id);
        Label2.setKey(LABEL + id);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("0px");
        margin.setLeft("10px");
        margin.setRight("5px");
        style.setMargin(margin);
        Label2.setStyle(style);
        return Label2;
    }

    private VectorAp createTagStar(String id, String name, int j, int score) {
        VectorAp v = new VectorAp();
        if (j <= score) {
            v.setfontClass(shixin);
        } else {
            v.setfontClass(kongxin);
        }
        v.setId(STAR + id + "_" + j);
        v.setKey(STAR + id + "_" + j);
        v.setClickable(true);
        v.setForeColor("#ffaa56");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("0px");
        margin.setLeft("3px");
        style.setMargin(margin);
        v.setStyle(style);
        return v;
    }

    private FieldAp createTagField(String id, String name, FormShowParameter param) {
        FieldAp field = new FieldAp();
        ComboField co = new ComboField();
        co.setItems(this.buildComboItems());
        co.setKey(TAG + id);
        co.setDefValue("5");
        co.setMustInput(true);
        if (this.isView(param)) {
            field.setLock("new,edit");
        }
        field.setVisible("");
        field.setId(TAG + id);
        field.setKey(TAG + id);
        field.setField((Field)co);
        field.setName(new LocaleString(name));
        field.setLabelDirection("h");
        field.setWidth(new LocaleString("100px"));
        field.setLabelWidth(new LocaleString("60px"));
        field.setComboShowStyle(0);
        field.setComboShowType(0);
        field.setFireUpdEvt(true);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("0px");
        style.setMargin(margin);
        field.setStyle(style);
        return field;
    }

    private List<ComboItem> buildComboItems() {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(8);
        for (int i = 1; i <= 5; ++i) {
            ComboItem item = new ComboItem();
            String value = String.valueOf(i);
            item.setCaption(new LocaleString(value));
            item.setValue(value);
            list.add(item);
        }
        return list;
    }

    private boolean isView(FormShowParameter param) {
        return param.getCustomParam("evalid") != null;
    }

    private static class ItemEntryInfo {
        private Object orderid;
        private Object entryid;
        private Object itemid;
        private Object unitid;
        private Object attrid;
        private BigDecimal qty;
        private BigDecimal price;
        private BigDecimal amount;

        private ItemEntryInfo(Map<String, Object> params) {
            this.orderid = params.get("orderid");
            this.entryid = params.get("entryid");
            this.itemid = params.get("itemid");
            this.unitid = params.get("unitid");
            this.attrid = params.get("attrid");
            this.qty = (BigDecimal)params.get("qty");
            this.price = (BigDecimal)params.get("price");
            this.amount = (BigDecimal)params.get("amount");
        }

        public Object getOrderid() {
            return this.orderid;
        }

        public Object getEntryid() {
            return this.entryid;
        }

        public Object getItemid() {
            return this.itemid;
        }

        public Object getUnitid() {
            return this.unitid;
        }

        public Object getAttrid() {
            return this.attrid;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }
    }
}

