/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class CustomerStorePlugin
extends MdrFormPlugin
implements BeforeF7SelectListener,
SearchEnterListener {
    private static final String LIST = "customerstorelist";
    private static final String CUSTOMER_F7 = "customerf7";
    private static final String ITEMCLASS_F7 = "itemclassf7";
    private static final String SEARCH = "search";
    public static final String TOOL_BARAP = "toolbarap";
    public static final String TOOL_REFRESH = "refresh";

    public void initialize() {
        super.initialize();
        this.addF7Listener(this, new String[]{CUSTOMER_F7, ITEMCLASS_F7});
    }

    public void afterCreateNewData(EventObject e) {
        BillList list = (BillList)this.getControl(LIST);
        ArrayList<QFilter> tbFilters = new ArrayList<QFilter>();
        Set ids = CustomerUtil.getAllAuthSubsIdsByIds((Collection)UserUtil.getOwnerIDs());
        QFilter q = new QFilter("customer.id", "in", (Object)ids);
        tbFilters.add(q);
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setQFilters(tbFilters);
        list.setQueryFilterParameter(filterParameter);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BARAP});
        Search search = (Search)this.getView().getControl(SEARCH);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "refresh": {
                this.refreshlist();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        if (CUSTOMER_F7.equals(e.getProperty().getName())) {
            Set ids = CustomerUtil.getAllAuthSubsIdsByIds((Collection)UserUtil.getOwnerIDs());
            QFilter q = new QFilter("id", "in", (Object)ids);
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)q);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.refreshlist();
    }

    private void refreshlist() {
        DynamicObject customer = super.getF7Value(CUSTOMER_F7);
        DynamicObject itemclass = super.getF7Value(ITEMCLASS_F7);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        Set ids = CustomerUtil.getAllAuthSubsIdsByIds((Collection)UserUtil.getOwnerIDs());
        if (customer != null) {
            filters.add(new QFilter("customer", "=", customer.get("id")));
        } else {
            filters.add(new QFilter("customer", "in", (Object)ids));
        }
        if (itemclass != null) {
            filters.add(new QFilter("item.itemclass", "=", itemclass.get("id")));
        }
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setQFilters(filters);
        BillList bill = (BillList)this.getControl(LIST);
        bill.setQueryFilterParameter(filterParameter);
        bill.refresh();
    }

    public void search(SearchEnterEvent paramSearchEnterEvent) {
        Search search = (Search)paramSearchEnterEvent.getSource();
        if (SEARCH.equals(search.getKey())) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            Set ids = CustomerUtil.getAllAuthSubsIdsByIds((Collection)UserUtil.getOwnerIDs());
            filters.add(new QFilter("customer", "in", (Object)ids));
            QFilter filter = new QFilter("1", "!=", (Object)1);
            List list = paramSearchEnterEvent.getSearchFields();
            if (list != null) {
                for (Map map : list) {
                    ArrayList fields = (ArrayList)map.get("fieldName");
                    ArrayList values = (ArrayList)map.get("value");
                    for (Object field : fields) {
                        if (field == null) break;
                        for (Object value : values) {
                            filter.or(QMatches.match((String[])new String[]{value.toString()}, (String[])new String[]{field.toString()}));
                        }
                    }
                }
                filters.add(filter);
            }
            FilterParameter filterParameter = new FilterParameter();
            filterParameter.setQFilters(filters);
            BillList bill = (BillList)this.getControl(LIST);
            bill.setQueryFilterParameter(filterParameter);
            bill.refresh();
        }
    }
}

