/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.inventory;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.mdr.common.util.BizValidateUtils;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.ItemStoreUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.common.util.WarehouseRuleUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class ItemStoreAdjustEditPlugin
extends MdrFormPlugin
implements BeforeF7SelectListener {
    public static final String ENTRY_KEY = "entry";
    public static final String FILTER_ITEM = "item";
    public static final String FILTER_MEASUREUNIT = "measureunit";
    public static final String FILTER_WAREHOUSE = "warehouse";
    public static final String ENTRY_BEFOREQTY = "beforeqty";
    public static final String ENTRY_AFTERQTY = "afterqty";
    public static final String ENTRY_ITEMSTORE = "itemstore";
    public static final String BILL_STATUS = "billstatus";
    public static final String HEAD_WAREHOUSE = "headwarehouse";
    public static final String ENTRYBAR_NEW = "entrybar_new";
    public static final String ENTRYBAR_DELETE = "entrybar_delete";
    public static final String NUMBER = "number";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{FILTER_MEASUREUNIT, HEAD_WAREHOUSE, "customer", FILTER_ITEM, FILTER_WAREHOUSE, HEAD_WAREHOUSE, "assistattr"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BillModel bill = (BillModel)e.getSource();
        if ("mdr_itemstore_adjust".equals(bill.getDataEntityType().getName())) {
            Object ownerid = UserUtil.getDefaultOwnerID();
            this.setValue("customer", ownerid);
        }
        this.SetOwnerFromCache("customer");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.refreshLockable();
    }

    private void refreshLockable() {
        String status = this.getModel().getDataEntity().getString(BILL_STATUS);
        if ("D".equals(status)) {
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{ENTRY_AFTERQTY});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{ENTRY_BEFOREQTY, FILTER_ITEM, FILTER_MEASUREUNIT, "assistattr", FILTER_WAREHOUSE});
            this.getView().setEnable(Boolean.FALSE, new String[]{HEAD_WAREHOUSE, "customer", ENTRYBAR_NEW, ENTRYBAR_DELETE, NUMBER});
        } else if ("B".equals(status) || "C".equals(status) || "E".equals(status)) {
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{ENTRY_AFTERQTY, ENTRY_BEFOREQTY, FILTER_ITEM, FILTER_MEASUREUNIT, "assistattr", FILTER_WAREHOUSE});
            this.getView().setEnable(Boolean.FALSE, new String[]{HEAD_WAREHOUSE, "customer", ENTRYBAR_NEW, ENTRYBAR_DELETE, NUMBER});
        } else if ("A".equals(status)) {
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{ENTRY_AFTERQTY, ENTRY_BEFOREQTY});
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{FILTER_ITEM, FILTER_MEASUREUNIT, "assistattr", FILTER_WAREHOUSE});
            this.getView().setEnable(Boolean.TRUE, new String[]{HEAD_WAREHOUSE, "customer", ENTRYBAR_NEW, ENTRYBAR_DELETE, NUMBER});
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] addRows;
        super.afterAddRow(e);
        for (RowDataEntity rowDataEntity : addRows = e.getRowDataEntities()) {
            this.getModel().setValue(FILTER_WAREHOUSE, super.getModel().getValue(HEAD_WAREHOUSE), rowDataEntity.getRowIndex());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        int rowindex = this.getRowIndex(e);
        this.dataChange(rowindex, propertyName, e);
    }

    private void dataChange(int rowindex, String propertyName, PropertyChangedArgs e) {
        DynamicObject assistattr;
        Object itemId;
        if (FILTER_ITEM.equals(propertyName)) {
            DynamicObject item = this.getEntryF7Value(ENTRY_KEY, FILTER_ITEM, rowindex);
            if (item == null) {
                super.getModel().setValue(FILTER_MEASUREUNIT, null, rowindex);
                super.getModel().setValue("assistattr", null, rowindex);
            } else {
                Object baseunitId = this.getUnitFormHandler().getBaseUnitId(item.getPkValue());
                super.getModel().setValue(FILTER_MEASUREUNIT, baseunitId, rowindex);
                Object assistattrId = ItemAttrUtil.getDefaultAttrId((Object)item.get("id"));
                super.getModel().setValue("assistattr", assistattrId, rowindex);
            }
        }
        if (HEAD_WAREHOUSE.equals(propertyName)) {
            DynamicObjectCollection entries = super.getModel().getEntryEntity(ENTRY_KEY);
            for (int i = 0; i < entries.size(); ++i) {
                super.getModel().setValue(FILTER_WAREHOUSE, super.getModel().getValue(HEAD_WAREHOUSE), i);
            }
        }
        if ("assistattr".equals(propertyName) && !BizValidateUtils.itemAttrNullValidate((Object)(itemId = this.getEntryF7PKValue(ENTRY_KEY, FILTER_ITEM, rowindex)), (DynamicObject)(assistattr = (DynamicObject)e.getChangeSet()[0].getNewValue()))) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (oldValue != null) {
                this.setValue("assistattr", oldValue, rowindex);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u5f00\u542f\u8f85\u52a9\u5c5e\u6027\uff0c\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"ItemStoreAdjustEditPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        if (Arrays.asList(FILTER_ITEM, "assistattr", FILTER_MEASUREUNIT, FILTER_WAREHOUSE).contains(propertyName)) {
            this.refreshItemStore(rowindex);
        }
    }

    private void refreshItemStore(int rowindex) {
        DynamicObject customer = super.getCustomerF7Value();
        DynamicObject item = super.getEntryF7Value(ENTRY_KEY, FILTER_ITEM, rowindex);
        DynamicObject measureunit = super.getEntryF7Value(ENTRY_KEY, FILTER_MEASUREUNIT, rowindex);
        DynamicObject warehouse = super.getEntryF7Value(ENTRY_KEY, FILTER_WAREHOUSE, rowindex);
        DynamicObject assistAttr = super.getEntryF7Value(ENTRY_KEY, "assistattr", rowindex);
        if (item == null || measureunit == null) {
            return;
        }
        if (!BizValidateUtils.itemAttrNullValidate((Object)item.get("id"), (DynamicObject)assistAttr)) {
            return;
        }
        DynamicObject o = ItemStoreUtil.queryItemStore((Object)customer.getString("id"), (Object)item.getString("id"), (Object)measureunit.getString("id"), (Object)(assistAttr == null ? Long.valueOf(0L) : assistAttr.getString("id")), (Object)(warehouse == null ? "0" : warehouse.getString("id")));
        if (o != null) {
            super.getModel().setValue(ENTRY_BEFOREQTY, (Object)o.getBigDecimal("qty"), rowindex);
            super.getModel().setValue(ENTRY_AFTERQTY, (Object)o.getBigDecimal("qty"), rowindex);
            super.getModel().setValue(ENTRY_ITEMSTORE, (Object)o.getLong("id"), rowindex);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject item;
        DynamicObject customer;
        int rowIndex = e.getRow();
        if ("customer".equals(e.getProperty().getName())) {
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)UserUtil.getOwnerIdsQFilter((String)"id"));
        }
        if (FILTER_ITEM.equals(e.getProperty().getName())) {
            customer = super.getCustomerF7Value();
            if (customer == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e20\u9053", (String)"ItemStoreAdjustEditPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            }
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)ItemSaleControlUtil.getItemFilterUsePageCache((Object)super.getCustomerF7Value().get("id"), (IPageCache)this.getPageCache()));
        }
        if (FILTER_WAREHOUSE.equals(e.getProperty().getName()) || HEAD_WAREHOUSE.equals(e.getProperty().getName())) {
            customer = super.getCustomerF7Value();
            if (customer == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e20\u9053", (String)"ItemStoreAdjustEditPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            }
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)WarehouseRuleUtil.queryWarehouse((Object)this.getCustomerF7Value().get("id"))));
        }
        if (FILTER_MEASUREUNIT.equals(e.getProperty().getName())) {
            item = this.getEntryF7Value(ENTRY_KEY, FILTER_ITEM, rowIndex);
            if (item == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1", (String)"ItemStoreAdjustEditPlugin_2", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            }
            List unitIds = this.getUnitFormHandler().getUnitIdList(this.getEntryF7PKValue(ENTRY_KEY, FILTER_ITEM, rowIndex));
            QFilter q = new QFilter("id", "in", (Object)unitIds);
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)q);
        }
        if ("assistattr".equals(e.getProperty().getName())) {
            item = this.getEntryF7Value(ENTRY_KEY, FILTER_ITEM, rowIndex);
            if (item == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1", (String)"ItemStoreAdjustEditPlugin_2", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            }
            QFilter q = ItemAttrUtil.getAttrFilter((Object)this.getEntryF7PKValue(ENTRY_KEY, FILTER_ITEM, rowIndex));
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)q);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (!"refresh".equals(e.getOperateKey())) {
            this.refreshLockable();
        }
    }
}

