/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.inventory;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class WarehouseAuthEditPlugin
extends MdrFormPlugin
implements BeforeF7SelectListener {
    public static final String OWNER = "owner";
    public static final String CUSTOMER = "customer";
    public static final String WAREHOUSE = "warehouse";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue(OWNER, UserUtil.getDefaultOwnerID());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setF7Filter(OWNER, UserUtil.getOwnerIdsQFilter((String)"id"));
        this.setCustomerFilter();
        this.setWarehouseFilter();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "owner": {
                this.setValue(CUSTOMER, null);
                this.setValue(WAREHOUSE, null);
                this.setCustomerFilter();
                break;
            }
        }
    }

    private void setCustomerFilter() {
        Object ownerId = this.getF7PKValue(OWNER);
        if (ownerId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6388\u6743\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u6388\u6743\u6e20\u9053\uff01", (String)"WarehouseAuthEditPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        this.setF7Filter(CUSTOMER, CustomerUtil.getAuthSubsIdsAndSelfQFilter((Object)ownerId));
    }

    private QFilter setWarehouseFilter() {
        DynamicObjectCollection warehouse;
        Object ownerId = this.getF7PKValue(OWNER);
        Object customerId = this.getF7PKValue(CUSTOMER);
        if (ownerId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6388\u6743\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u6388\u6743\u6e20\u9053\uff01", (String)"WarehouseAuthEditPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        QFilter filter1 = new QFilter(CUSTOMER, "=", ownerId);
        DynamicObjectCollection customers = QueryServiceHelper.query((String)"mdr_warehouse_relation", (String)"warehouse.id", (QFilter[])filter1.toArray());
        HashSet<Object> warehouseIds = new HashSet<Object>(customers.size());
        if (customers.size() > 0) {
            for (DynamicObject customerObj : customers) {
                warehouseIds.add(customerObj.get("warehouse.id"));
            }
        }
        if (customerId != null & ownerId.equals(customerId) && (warehouse = QueryServiceHelper.query((String)"mdr_warehouse", (String)"id", (QFilter[])new QFilter(OWNER, "=", ownerId).toArray())).size() > 0) {
            for (DynamicObject warehouseObj : warehouse) {
                Object id = warehouseObj.get("id");
                if (warehouseIds.remove(id)) continue;
                warehouseIds.add(id);
            }
        }
        QFilter filter = new QFilter("id", "in", warehouseIds);
        return filter;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "warehouse": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.setWarehouseFilter());
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{WAREHOUSE});
    }
}

