/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.inventory;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class WarehouseRulePlugin
extends MdrFormPlugin
implements BeforeF7SelectListener {
    public static final String TOOL_BARAP = "toolbarap";
    public static final String ADVCONTOOLBARAP = "advcontoolbarap";
    public static final String TOOL_SAVE = "save";
    public static final String TOOL_RESET = "reset";
    public static final String OWNER = "owner";
    public static final String RULE_LIST = "rulelist";
    public static final String TB_CUSTOMER = "customer";
    public static final String TB_CUSTOMER_GROUP = "customergroup";
    public static final String TB_ITEM = "item";
    public static final String TB_ITEM_CLASS = "itemclass";
    public static final String TB_WAREHOUSE = "warehouse";
    public static final String TB_ENABLE = "enable";
    public static final String TB_ISDEFAULT = "isdefault";
    public static final String TB_RULE = "rule";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BARAP, ADVCONTOOLBARAP});
        this.addF7Listener(this, new String[]{TB_ITEM, TB_CUSTOMER_GROUP});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "save": {
                this.save();
                break;
            }
            case "reset": {
                this.getModel().deleteEntryData(RULE_LIST);
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent e) {
        super.beforeClick(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.isAddNew()) {
            IPageCache pageCache;
            String ownerId;
            this.getModel().setValue(OWNER, UserUtil.getDefaultOwnerID());
            IFormView parentView = this.getView().getParentView();
            if (parentView != null && (ownerId = (pageCache = (IPageCache)parentView.getService(IPageCache.class)).get(parentView.getPageId() + "ownerId")) != null && !ownerId.toString().trim().equals("")) {
                this.setOwnerF7Value(ownerId);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        List ids = UserUtil.getOwnerIDs();
        QFilter fliter = new QFilter("id", "in", (Object)ids);
        this.setF7Filter(OWNER, fliter);
        if (ids.size() == 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{OWNER});
        }
        this.setFilter();
    }

    private void setFilter() {
        Object owner = this.getF7PKValue(OWNER);
        if (owner == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u5c5e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u5f52\u5c5e\u6e20\u9053\u3002", (String)"WarehouseRulePlugin_5", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            QFilter filter = new QFilter("1", "=", (Object)"0");
            this.setF7Filter(TB_CUSTOMER, filter);
            this.setF7Filter(TB_CUSTOMER_GROUP, filter);
            return;
        }
        this.setF7Filter(TB_CUSTOMER, CustomerUtil.getAuthSubsIdsQFilter((Object)owner));
        HashSet<Object> warehouseIds = new HashSet<Object>();
        QFilter filter = new QFilter(TB_CUSTOMER, "=", owner);
        DynamicObjectCollection customers = QueryServiceHelper.query((String)"mdr_warehouse_relation", (String)"warehouse.id", (QFilter[])filter.toArray());
        if (customers.size() > 0) {
            for (DynamicObject customerObj : customers) {
                warehouseIds.add(customerObj.get("warehouse.id"));
            }
        }
        filter = new QFilter("id", "in", warehouseIds);
        this.setF7Filter(TB_WAREHOUSE, filter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object value = e.getChangeSet()[0].getNewValue();
        Object oldvalue = e.getChangeSet()[0].getOldValue();
        if (value != null) {
            int i = this.getModel().getEntryCurrentRowIndex(RULE_LIST);
            if (TB_CUSTOMER.equalsIgnoreCase(key)) {
                this.getModel().setValue(TB_CUSTOMER_GROUP, null, i);
            } else if (TB_CUSTOMER_GROUP.equalsIgnoreCase(key)) {
                this.getModel().setValue(TB_CUSTOMER, null, i);
            } else if (TB_ITEM.equalsIgnoreCase(key)) {
                this.getModel().setValue(TB_ITEM_CLASS, null, i);
            } else if (TB_ITEM_CLASS.equalsIgnoreCase(key)) {
                this.getModel().setValue(TB_ITEM, null, i);
            }
        }
        if (OWNER.equalsIgnoreCase(key)) {
            if (this.getF7PKValue(OWNER) == null) {
                this.getModel().setValue(OWNER, oldvalue);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u5c5e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WarehouseRulePlugin_6", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().deleteEntryData(RULE_LIST);
            this.setFilter();
        }
    }

    private void save() {
        int rows = this.getModel().getEntryRowCount(RULE_LIST);
        if (rows == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u8981\u4fdd\u5b58\u7684\u89c4\u5219\u3002", (String)"WarehouseRulePlugin_4", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            return;
        }
        StringBuilder sb = new StringBuilder();
        try (TXHandle h = TX.beginRequired();){
            try {
                DynamicObject obj = null;
                for (int row = 0; row < rows; ++row) {
                    obj = null;
                    obj = BusinessDataServiceHelper.newDynamicObject((String)"mdr_warehouse_rule");
                    obj.set(TB_CUSTOMER, this.getModel().getValue(TB_CUSTOMER, row));
                    obj.set(TB_CUSTOMER_GROUP, this.getModel().getValue(TB_CUSTOMER_GROUP, row));
                    obj.set(TB_ITEM, this.getModel().getValue(TB_ITEM, row));
                    obj.set(TB_ITEM_CLASS, this.getModel().getValue(TB_ITEM_CLASS, row));
                    obj.set(TB_WAREHOUSE, this.getModel().getValue(TB_WAREHOUSE, row));
                    obj.set(TB_ENABLE, this.getModel().getValue(TB_ENABLE, row));
                    obj.set(TB_ISDEFAULT, this.getModel().getValue(TB_ISDEFAULT, row));
                    obj.set(OWNER, (Object)this.getF7Value(OWNER));
                    OperationUtil.addDefaultInfo((DynamicObject)obj);
                    OperationResult result = OperationServiceHelper.executeOperate((String)TOOL_SAVE, (String)obj.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)OperateOption.create());
                    if (result.isSuccess()) continue;
                    if (sb.length() > 0) {
                        sb.append('\n');
                    }
                    sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u89c4\u5219\uff1a%s - ", (String)"WarehouseRulePlugin_3", (String)"drp-bbc-formplugin", (Object[])new Object[0]), row + 1, result.getMessage().replaceAll("\uff01", "\u3002")));
                    List validResultList = result.getValidateResult().getValidateErrors();
                    for (ValidateResult validation : validResultList) {
                        Iterator iter = validation.getAllErrorInfo().iterator();
                        while (iter.hasNext()) {
                            OperateErrorInfo info = (OperateErrorInfo)iter.next();
                            sb.append(info.getMessage());
                            if (iter.hasNext()) {
                                sb.append(',');
                                continue;
                            }
                            sb.append('\u3002');
                        }
                    }
                }
                if (sb.length() > 0) {
                    throw new KDBizException(sb.toString());
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        this.getView().close();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        Object owner = this.getF7PKValue(OWNER);
        switch (key) {
            case "item": {
                QFilter filter = F7Utils.buildMultiF7QFitler((String)"mulowner", (Object)owner);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
                break;
            }
            case "customergroup": {
                QFilter customerGroupFilter = new QFilter(TB_ENABLE, "=", (Object)"1");
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)customerGroupFilter);
            }
        }
    }
}

