/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.inventory;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.common.util.WebUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class WarehouseUserEditPlugin
extends MdrFormPlugin {
    public static final String OWNER = "owner";
    public static final String USER = "user";
    public static final String WAREHOUSE = "warehouse";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue(OWNER, UserUtil.getDefaultOwnerID());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setF7Filter(OWNER, UserUtil.getOwnerIdsQFilter((String)"id"));
        this.setUserFilter();
        this.setWarehouseFilter();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "owner": {
                this.setValue(USER, null);
                this.setValue(WAREHOUSE, null);
                this.setUserFilter();
                this.setWarehouseFilter();
                break;
            }
        }
    }

    private void setUserFilter() {
        Object ownerId = this.getF7PKValue(OWNER);
        if (ownerId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f52\u5c5e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u5f52\u5c5e\u6e20\u9053\uff01", (String)"WarehouseUserEditPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        QFilter fs = new QFilter(OWNER, "=", ownerId);
        Set ids = QueryUtil.querySingleCol((String)"dbd_drp_user", (String)"sysuser", (QFilter[])fs.toArray());
        this.setF7Filter(USER, WebUtil.getIdQFilter((Collection)ids));
    }

    private void setWarehouseFilter() {
        Object ownerId = this.getF7PKValue(OWNER);
        if (ownerId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f52\u5c5e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u5f52\u5c5e\u6e20\u9053\uff01", (String)"WarehouseUserEditPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        HashSet<Object> warehouseIds = new HashSet<Object>();
        QFilter filter1 = new QFilter("customer", "=", ownerId);
        DynamicObjectCollection customers = QueryServiceHelper.query((String)"mdr_warehouse_relation", (String)"warehouse.id", (QFilter[])filter1.toArray());
        if (customers.size() > 0) {
            for (DynamicObject customerObj : customers) {
                warehouseIds.add(customerObj.get("warehouse.id"));
            }
        }
        QFilter filter = new QFilter("id", "in", warehouseIds);
        this.setF7Filter(WAREHOUSE, filter);
    }
}

