/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.item;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class ItemPriceBatchChangeEditPlugin
extends MdrFormPlugin
implements BeforeF7SelectListener {
    public static final String ITEM_CLASS = "itemclass";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{ITEM_CLASS});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "itemclass": {
                DynamicObject itemClassStandard = BusinessDataServiceHelper.loadSingle((Object)7L, (String)"mdr_classstandardapply");
                long standardId = itemClassStandard.getLong("classstandardid_id");
                ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
                listShowParameter.setCustomParam("groupStandard", (Object)standardId);
                listShowParameter.setMultiSelect(false);
                QFilter standardFilter = new QFilter("standard", "=", (Object)standardId);
                listShowParameter.getListFilterParameter().getQFilters().add(standardFilter);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        if (propertyName.length() == 0) {
            return;
        }
        switch (propertyName) {
            case "pricerate": {
                BigDecimal pricerate = (BigDecimal)model.getValue("pricerate");
                if (pricerate.compareTo(BigDecimal.ZERO) != 0) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"priceamount"});
                    this.getModel().setValue("priceamount", null);
                    break;
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{"priceamount"});
                break;
            }
            case "priceamount": {
                BigDecimal priceamount = (BigDecimal)model.getValue("priceamount");
                if (priceamount.compareTo(BigDecimal.ZERO) != 0) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"pricerate"});
                    this.getModel().setValue("pricerate", null);
                    break;
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{"pricerate"});
                break;
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("donothing".equals(operateKey)) {
            BigDecimal priceRate = (BigDecimal)this.getModel().getValue("pricerate");
            BigDecimal priceAmount = (BigDecimal)this.getModel().getValue("priceamount");
            String changemode = (String)this.getModel().getValue("changemode");
            DynamicObjectCollection itemClass = (DynamicObjectCollection)this.getModel().getValue(ITEM_CLASS);
            if (priceRate.abs().compareTo(new BigDecimal("100")) > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u4ef7\u683c\u6bd4\u7387!", (String)"ItemPriceBatchChangeEditPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put("itemClass", null == itemClass ? Long.valueOf(0L) : ItemPriceBatchChangeEditPlugin.toSet(itemClass));
            returnData.put("priceRate", priceRate);
            returnData.put("priceAmount", priceAmount);
            returnData.put("changemode", changemode);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public static Set<Object> toSet(DynamicObjectCollection result) {
        HashSet<Object> values = new HashSet<Object>(result.size());
        int len = result.size();
        for (int i = 0; i < len; ++i) {
            values.add(((DynamicObject)result.get(i)).get(2));
        }
        return values;
    }
}

