/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.enums.Enable;
import kd.drp.mdr.common.enums.Status;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.mdr.common.util.BizValidateUtils;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.PriceUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class ItemPriceChangeEditPlugin
extends MdrFormPlugin
implements BeforeF7SelectListener {
    private static final String OWNER = "owner";
    private static final String F7_PRICE = "itemprice";
    private static final String NEW_PRICE = "newprice";
    private static final String OLD_PRICE = "oldprice";
    private static final String PRICE_FLOAT = "pricefloat";
    private static final String NEW_LOWPRICE = "newlowprice";
    private static final String OLD_LOWPRICE = "oldlowprice";
    private static final String LOWPRICE_FLOAT = "lowpricefloat";
    private static final String F7_ITEM = "item";
    private static final String F7_UNIT = "unit";
    private static final String F7_ASSISTATTR = "assistattr";
    private static final String ENTRY = "entrys";
    private static final String STATUS = "status";
    private static final String OP_BATCHCHANGE = "batchchange";
    private static final String OP_CHECKSUBMIT = "checksubmit";
    private static final String OP_SUBMIT = "submit";
    private static final String OP_UNSUBMIT = "unsubmit";
    private static final String OP_AUDIT = "audit";
    private static final String OP_UNAUDIT = "unaudit";
    private static final String OP_SAVE = "save";
    private static final String ITEMCLASS_NAME = "itemclass";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{F7_ITEM, F7_UNIT, F7_ASSISTATTR, OWNER});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int row = e.getRow();
        Object itemId = null;
        switch (key) {
            case "item": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, this.getItemFitler());
                break;
            }
            case "unit": {
                itemId = this.getEntryF7PKValue(ENTRY, F7_ITEM, row);
                if (itemId == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1\u3002", (String)"ItemPriceChangeEditPlugin_15", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getUnitFilter(row));
                break;
            }
            case "assistattr": {
                itemId = this.getEntryF7PKValue(ENTRY, F7_ITEM, row);
                if (itemId == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1\u3002", (String)"ItemPriceChangeEditPlugin_15", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)ItemAttrUtil.getAttrFilter((Object)itemId));
                break;
            }
            case "owner": {
                QFilter onwerFilter = new QFilter("id", "in", (Object)UserUtil.getOwnerIDs());
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)onwerFilter);
                break;
            }
        }
    }

    private QFilter getUnitFilter(int rowIndex) {
        List ids = this.getUnitFormHandler().getUnitIdList(this.getEntryF7PKValue(ENTRY, F7_ITEM, rowIndex));
        return new QFilter("id", "in", (Object)ids);
    }

    private List<QFilter> getItemFitler() {
        ArrayList<QFilter> tbFilters = new ArrayList<QFilter>();
        Object ownerid = this.getOwnerF7PKValue();
        if (ownerid == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u9500\u552e\u6e20\u9053\u3002", (String)"ItemPriceChangeEditPlugin_16", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        tbFilters.add(ItemSaleControlUtil.getItemFilterUsePageCache((Object)ownerid, (IPageCache)this.getPageCache()));
        tbFilters.add(new QFilter("isonsell", "=", (Object)Character.valueOf('1')));
        return tbFilters;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (!this.isFromImport()) {
            IPageCache pageCache;
            String ownerId;
            IFormView parentView = this.getView().getParentView();
            if (parentView != null && (ownerId = (pageCache = (IPageCache)parentView.getService(IPageCache.class)).get(parentView.getPageId() + "ownerId")) != null && !ownerId.toString().trim().equals("")) {
                this.getModel().setValue(OWNER, (Object)ownerId);
                return;
            }
            this.getModel().setValue(OWNER, UserUtil.getDefaultOwnerID());
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        List ids = UserUtil.getOwnerIDs();
        QFilter fliter = new QFilter("id", "in", (Object)ids);
        this.setF7Filter(OWNER, fliter);
        if (ids.size() == 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{OWNER});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        if (propertyName.length() == 0) {
            return;
        }
        Object oldvalue = e.getChangeSet()[0].getOldValue();
        int index = e.getChangeSet()[0].getRowIndex();
        DynamicObject row = model.getEntryRowEntity(ENTRY, index);
        switch (propertyName) {
            case "item": {
                this.setBaseUnit(row, index);
                this.setBaseAttr(index);
                this.setItemClass(row, index);
                break;
            }
            case "unit": {
                this.setItemPrice(index);
                break;
            }
            case "assistattr": {
                this.validateAttrIsNotNull(index, e);
                this.setItemPrice(index);
                break;
            }
            case "newprice": {
                if (row.get(OLD_PRICE) == null) {
                    return;
                }
                row.set(PRICE_FLOAT, (Object)row.getBigDecimal(NEW_PRICE).subtract(row.getBigDecimal(OLD_PRICE)));
                this.getView().updateView(ENTRY);
                this.getModel().setDataChanged(false);
                break;
            }
            case "pricefloat": {
                if (row.get(OLD_PRICE) == null) {
                    return;
                }
                row.set(NEW_PRICE, (Object)row.getBigDecimal(PRICE_FLOAT).add(row.getBigDecimal(OLD_PRICE)));
                this.getView().updateView(ENTRY);
                this.getModel().setDataChanged(false);
                break;
            }
            case "newlowprice": {
                if (row.get(OLD_LOWPRICE) == null) {
                    return;
                }
                row.set(LOWPRICE_FLOAT, (Object)row.getBigDecimal(NEW_LOWPRICE).subtract(row.getBigDecimal(OLD_LOWPRICE)));
                this.getView().updateView(ENTRY);
                this.getModel().setDataChanged(false);
                break;
            }
            case "lowpricefloat": {
                if (row.get(OLD_LOWPRICE) == null) {
                    return;
                }
                row.set(NEW_LOWPRICE, (Object)row.getBigDecimal(LOWPRICE_FLOAT).add(row.getBigDecimal(OLD_LOWPRICE)));
                this.getView().updateView(ENTRY);
                this.getModel().setDataChanged(false);
                break;
            }
            case "owner": {
                if (this.getF7PKValue(OWNER) == null) {
                    this.getModel().setValue(OWNER, oldvalue);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ItemPriceChangeEditPlugin_17", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getModel().deleteEntryData(ENTRY);
                break;
            }
        }
    }

    private void setItemClass(DynamicObject row, int index) {
        DynamicObject item = row.getDynamicObject(F7_ITEM);
        if (item != null) {
            DynamicObject itemClassStandard = BusinessDataServiceHelper.loadSingle((Object)7L, (String)"mdr_classstandardapply");
            long standardId = itemClassStandard.getLong("classstandardid_id");
            DynamicObjectCollection itemClassColl = item.getDynamicObjectCollection("itemclassentity");
            DynamicObject itemClassObj = null;
            if (!CommonUtils.isNull((Object)itemClassColl)) {
                for (DynamicObject dynamicObject : itemClassColl) {
                    if (standardId != dynamicObject.getLong("classstandardid_id")) continue;
                    itemClassObj = dynamicObject.getDynamicObject("goodsclasssid");
                    break;
                }
            }
            item.set(ITEMCLASS_NAME, itemClassObj);
            this.setValue(F7_ITEM, item, index);
            this.getView().updateView(ITEMCLASS_NAME, index);
        }
    }

    private void setBaseUnit(DynamicObject row, int index) {
        DynamicObject item = row.getDynamicObject(F7_ITEM);
        if (item != null) {
            this.setValue(F7_UNIT, this.getUnitFormHandler().getBaseUnitId(item.get("id")), index);
        }
    }

    private void setBaseAttr(int index) {
        Object itemId = this.getEntryF7PKValue(ENTRY, F7_ITEM, index);
        Object attrid = ItemAttrUtil.getDefaultAttrId((Object)itemId);
        this.setValue(F7_ASSISTATTR, attrid, index);
        if (attrid == null) {
            this.setUnEnable(index, new String[]{F7_ASSISTATTR});
        } else {
            this.setEnable(index, new String[]{F7_ASSISTATTR});
        }
    }

    private void validateAttrIsNotNull(int index, PropertyChangedArgs e) {
        DynamicObject assistattr;
        Object itemId = this.getEntryF7PKValue(ENTRY, F7_ITEM, index);
        if (!BizValidateUtils.itemAttrNullValidate((Object)itemId, (DynamicObject)(assistattr = (DynamicObject)e.getChangeSet()[0].getNewValue()))) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (oldValue != null) {
                this.setValue(F7_ASSISTATTR, oldValue, index);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u5f00\u542f\u8f85\u52a9\u5c5e\u6027\uff0c\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ItemPriceChangeEditPlugin_18", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
    }

    private void setItemPrice(int row) {
        Object owneId = this.getOwnerF7PKValue();
        Object itemPk = this.getEntryF7PKValue(ENTRY, F7_ITEM, row);
        Object unitPk = this.getEntryF7PKValue(ENTRY, F7_UNIT, row);
        Object assistattrPk = this.getEntryF7PKValue(ENTRY, F7_ASSISTATTR, row);
        if (assistattrPk == null) {
            assistattrPk = 0L;
        }
        if (itemPk != null && unitPk != null) {
            DynamicObject rs = PriceUtil.getPriceDynamicObject((Object)itemPk, (Object)unitPk, (Object)assistattrPk, (Object)owneId);
            if (rs != null) {
                this.getModel().setValue(F7_PRICE, (Object)rs, row);
                this.getModel().setValue(OLD_PRICE, rs.get("saleprice"), row);
                this.getModel().setValue(OLD_LOWPRICE, rs.get("lowprice"), row);
                BigDecimal oldPrice = rs.getBigDecimal("saleprice");
                BigDecimal price = (BigDecimal)this.getModel().getValue(NEW_PRICE, row);
                BigDecimal priceFloat = (BigDecimal)this.getModel().getValue(PRICE_FLOAT, row);
                if (BigDecimal.ZERO.compareTo(price) != 0 && BigDecimal.ZERO.compareTo(priceFloat) != 0) {
                    this.getModel().setValue(NEW_PRICE, (Object)oldPrice.add(priceFloat), row);
                }
            } else {
                this.clearRowPrice(row);
            }
        } else {
            this.clearRowPrice(row);
        }
    }

    private void clearRowPrice(int row) {
        this.getModel().setValue(F7_PRICE, null, row);
        this.getModel().setValue(OLD_PRICE, (Object)new BigDecimal(0), row);
        this.getModel().setValue(OLD_LOWPRICE, null, row);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (key.isEmpty()) {
            return;
        }
        switch (key) {
            case "batchchange": {
                this.openBatchChange();
                break;
            }
            case "checksubmit": {
                this.checkSave(args);
                if (args.isCancel()) break;
                this.checkSubmit();
                break;
            }
            case "audit": {
                this.checkAudit();
                break;
            }
            case "unaudit": {
                this.checkUnAudit();
                break;
            }
            case "save": {
                this.checkSave(args);
                break;
            }
        }
    }

    private void openBatchChange() {
        this.showForm("mdr_item_pricebatch", null, new CloseCallBack((IFormPlugin)this, "comfirmaction"), ShowType.Modal);
    }

    private void checkSubmit() {
        if (!"1".equals(this.getBillStatus())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u4fdd\u5b58\u72b6\u6001\u7684\u5355\u636e\u624d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"ItemPriceChangeEditPlugin_19", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection rows = this.getBillEntrys();
        if (rows.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u4ef7\u683c\u8c03\u6574\u5355\u5206\u5f55\u3002", (String)"ItemPriceChangeEditPlugin_20", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rows.size(); ++i) {
            if (((DynamicObject)rows.get(i)).getBigDecimal(PRICE_FLOAT).compareTo(BigDecimal.ZERO) != 0) continue;
            sb.append(i + 1 + 44);
        }
        Object number = this.getModel().getValue("number");
        if (number == null || "".equals(number.toString())) {
            return;
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submitCallBack", (IFormPlugin)this);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4ef7\u683c\u6d6e\u52a8\u4e3a0,\u662f\u5426\u63d0\u4ea4\uff1f", (String)"ItemPriceChangeEditPlugin_6", (String)"drp-bbc-formplugin", (Object[])new Object[0]), sb.toString()), MessageBoxOptions.YesNo, ConfirmTypes.Wait, confirmCallBacks);
        } else {
            this.getView().invokeOperation(OP_SUBMIT);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("submitCallBack".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getView().invokeOperation(OP_SUBMIT);
            } else {
                return;
            }
        }
    }

    private void checkAudit() {
        if (!"2".equals(this.getBillStatus())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u63d0\u4ea4\u72b6\u6001\u7684\u5355\u636e\u624d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"ItemPriceChangeEditPlugin_21", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkUnAudit() {
        if (!"3".equals(this.getBillStatus())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u5ba1\u6838\u72b6\u6001\u7684\u5355\u636e\u624d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ItemPriceChangeEditPlugin_22", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkSave(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection rows = this.getBillEntrys();
        if (rows.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u4ef7\u683c\u8c03\u6574\u5355\u5206\u5f55\u3002", (String)"ItemPriceChangeEditPlugin_20", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        ArrayList<Integer> rowList = new ArrayList<Integer>();
        StringBuilder emptyLineMessage = new StringBuilder();
        for (int i = 0; i < rows.size(); ++i) {
            BigDecimal lowprice;
            if (((DynamicObject)rows.get(i)).getBigDecimal(NEW_PRICE) == null || ((DynamicObject)rows.get(i)).getBigDecimal(NEW_PRICE).compareTo(BigDecimal.ZERO) == 0 && ((DynamicObject)rows.get(i)).getBigDecimal(PRICE_FLOAT).compareTo(BigDecimal.ZERO) == 0) {
                rowList.add(i);
                continue;
            }
            BigDecimal saleprice = (BigDecimal)((DynamicObject)rows.get(i)).get(NEW_PRICE);
            if (saleprice.compareTo(lowprice = (BigDecimal)((DynamicObject)rows.get(i)).get(NEW_LOWPRICE)) < 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u6700\u4f4e\u9650\u4ef7\u4e0d\u80fd\u9ad8\u4e8e\u9500\u552e\u4ef7\u683c\u3002", (String)"ItemPriceChangeEditPlugin_23", (String)"drp-bbc-formplugin", (Object[])new Object[0]), i + 1));
            }
            if (((DynamicObject)rows.get(i)).get(F7_ITEM) == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ItemPriceChangeEditPlugin_24", (String)"drp-bbc-formplugin", (Object[])new Object[0]), i + 1));
            }
            if (((DynamicObject)rows.get(i)).get(F7_UNIT) != null) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ItemPriceChangeEditPlugin_25", (String)"drp-bbc-formplugin", (Object[])new Object[0]), i + 1));
        }
        ArrayList noblankrowsList = new ArrayList();
        for (int i = 0; i < rowList.size(); ++i) {
            DynamicObject rowDy = (DynamicObject)rows.get(Integer.parseInt(rowList.get(i).toString()));
            if (rowDy.get(F7_ITEM) == null) continue;
            noblankrowsList.add(rowList.get(i));
            emptyLineMessage.append(rowDy.get("seq"));
            emptyLineMessage.append(',');
        }
        if (noblankrowsList.size() > 0) {
            String showTipMessage = emptyLineMessage.toString();
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u4ef7\u683c\u4e3a0 \u6216 \u4ef7\u683c\u6d6e\u52a8\u4e3a0\u3002", (String)"ItemPriceChangeEditPlugin_26", (String)"drp-bbc-formplugin", (Object[])new Object[0]), showTipMessage.substring(0, showTipMessage.length() - 1)));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (key.isEmpty()) {
            return;
        }
        switch (key) {
            case "save": {
                if (!args.getOperationResult().isSuccess()) {
                    return;
                }
                this.getView().invokeOperation("refresh");
                this.getView().setStatus(OperationStatus.EDIT);
                this.getView().invokeOperation("refresh");
                break;
            }
            case "submit": {
                if (!args.getOperationResult().isSuccess()) {
                    return;
                }
                this.getModel().setValue(STATUS, (Object)"2");
                this.getModel().setDataChanged(false);
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().invokeOperation("refresh");
                break;
            }
            case "unsubmit": {
                if (!args.getOperationResult().isSuccess()) {
                    return;
                }
                this.getModel().setValue(STATUS, (Object)"1");
                this.getModel().setDataChanged(false);
                this.getView().invokeOperation("refresh");
                break;
            }
            case "audit": {
                if (!args.getOperationResult().isSuccess()) {
                    return;
                }
                this.getModel().setValue(STATUS, (Object)"3");
                this.getModel().setDataChanged(false);
                this.getView().invokeOperation("refresh");
                break;
            }
            case "unaudit": {
                if (!args.getOperationResult().isSuccess()) {
                    return;
                }
                this.getModel().setValue(STATUS, (Object)"1");
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("comfirmaction".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            String changemode;
            Object batchChangeData = closedCallBackEvent.getReturnData();
            if (null == batchChangeData) {
                return;
            }
            Map batchChangeMap = (Map)batchChangeData;
            Set itemClass = (Set)batchChangeMap.get("itemClass");
            BigDecimal priceRate = (BigDecimal)batchChangeMap.get("priceRate");
            BigDecimal priceAmount = (BigDecimal)batchChangeMap.get("priceAmount");
            switch (changemode = (String)batchChangeMap.get("changemode")) {
                case "1": {
                    if (this.isEntryRowEmpty(ENTRY)) {
                        return;
                    }
                    this.updateEntrysPrice(itemClass, priceRate, priceAmount);
                    break;
                }
                case "2": {
                    this.generateEntrys(itemClass, priceRate, priceAmount, "2");
                    break;
                }
                case "3": {
                    this.generateEntrys(itemClass, priceRate, priceAmount, "3");
                    break;
                }
            }
            this.getView().updateView(ENTRY);
        }
    }

    private boolean isEntryRowEmpty(String entryName) {
        if (this.getModel().getEntryRowCount(entryName) == 0) {
            return true;
        }
        DynamicObjectCollection entryRow = this.getModel().getEntryEntity(entryName);
        return entryRow.stream().filter(row -> row.getLong("item_id") > 0L).count() == 0L;
    }

    private void generateEntrys(Set<Object> classSet, BigDecimal priceRate, BigDecimal priceAmount, String mode) {
        IDataModel model = this.getModel();
        if (model.getEntryRowCount(ENTRY) != 0) {
            // empty if block
        }
        model.deleteEntryData(ENTRY);
        if (mode.equals("2")) {
            this.generateEntrysByPrice(classSet, priceRate, priceAmount);
        }
        if (mode.equals("3")) {
            this.generateEntrysByItem(classSet, priceRate, priceAmount);
        }
    }

    private void generateEntrysByItem(Set<Object> classSet, BigDecimal priceRate, BigDecimal priceAmount) {
        Object owneId = this.getOwnerF7PKValue();
        QFilter q1 = new QFilter("isonsell", "=", (Object)Character.valueOf('1'));
        q1.and(new QFilter(OWNER, "=", owneId));
        q1.and(new QFilter("enable", "=", (Object)Enable.ENABLE));
        q1.and(new QFilter(STATUS, "=", (Object)Status.AUDITED));
        long standardId = 0L;
        if (!classSet.isEmpty()) {
            q1.and(new QFilter("itemclassentity.goodsclasssid", "in", classSet));
        } else {
            DynamicObject itemClassStandard = BusinessDataServiceHelper.loadSingle((Object)7L, (String)"mdr_classstandardapply");
            standardId = itemClassStandard.getLong("classstandardid_id");
        }
        Map itemMap = BusinessDataServiceHelper.loadFromCache((String)"mdr_item_info", (String)"id,itemclassentity.goodsclasssid,itemclassentity.classstandardid", (QFilter[])q1.toArray(), (String)"serialnumber desc, selltime desc");
        this.getUnitFormHandler().batchLoad(new ArrayList(itemMap.keySet()));
        if (!CommonUtils.isNull((Object)itemMap)) {
            int count = 0;
            DynamicObject entry = null;
            List unitIds = null;
            DynamicObjectCollection itemClassColl = null;
            DynamicObject itemClassObj = null;
            DynamicObject itemObj = null;
            for (Map.Entry itemEntry : itemMap.entrySet()) {
                unitIds = this.getUnitFormHandler().getUnitIdList(itemEntry.getKey());
                if (unitIds.isEmpty()) continue;
                for (Object unitId : unitIds) {
                    this.getModel().createNewEntryRow(ENTRY);
                    this.getModel().setValue(F7_ITEM, itemEntry.getKey(), count);
                    itemObj = (DynamicObject)this.getModel().getValue(F7_ITEM, count);
                    if (itemObj != null) {
                        itemClassColl = ((DynamicObject)itemMap.get(itemEntry.getKey())).getDynamicObjectCollection("itemclassentity");
                        if (!CommonUtils.isNull((Object)itemClassColl)) {
                            for (DynamicObject dynamicObject : itemClassColl) {
                                if (!classSet.isEmpty()) {
                                    if (!classSet.contains(dynamicObject.get("goodsclasssid_id"))) continue;
                                    itemClassObj = dynamicObject.getDynamicObject("goodsclasssid");
                                    break;
                                }
                                if (standardId != dynamicObject.getLong("classstandardid_id")) continue;
                                itemClassObj = dynamicObject.getDynamicObject("goodsclasssid");
                                break;
                            }
                        }
                        itemObj.set(ITEMCLASS_NAME, itemClassObj);
                    }
                    this.getModel().setValue(F7_UNIT, unitId, count);
                    entry = this.getModel().getEntryRowEntity(ENTRY, count);
                    BigDecimal oldPrice = entry.getBigDecimal(OLD_PRICE);
                    this.changePrice(entry, oldPrice, priceRate, priceAmount);
                    ++count;
                }
            }
        }
    }

    private void generateEntrysByPrice(Set<Object> classSet, BigDecimal priceRate, BigDecimal priceAmount) {
        Object owneId = this.getOwnerF7PKValue();
        QFilter q1 = new QFilter(OWNER, "=", owneId);
        long standardId = 0L;
        if (!classSet.isEmpty()) {
            q1.and(new QFilter("itemclassentity.goodsclasssid", "in", classSet));
        } else {
            DynamicObject itemClassStandard = BusinessDataServiceHelper.loadSingle((Object)7L, (String)"mdr_classstandardapply");
            standardId = itemClassStandard.getLong("classstandardid_id");
        }
        Map itemMap = BusinessDataServiceHelper.loadFromCache((String)"mdr_item_info", (String)"id,itemclassentity.goodsclasssid,itemclassentity.classstandardid", (QFilter[])q1.toArray(), (String)"serialnumber desc, selltime desc");
        Set itemIds = itemMap.keySet();
        if (!itemIds.isEmpty()) {
            QFilter q2 = new QFilter("itemid", "in", (Object)itemIds.toArray());
            q2.and("customer", "=", owneId);
            q2.and(new QFilter(STATUS, "=", (Object)"1"));
            DynamicObject[] prices = BusinessDataServiceHelper.load((String)"mdr_item_price", (String)"id,saleprice,lowprice,pricefloat,itemid,unit", (QFilter[])q2.toArray());
            long itemId = 0L;
            DynamicObjectCollection itemClassColl = null;
            DynamicObject itemClassObj = null;
            DynamicObject itemObj = null;
            for (int i = 0; i < prices.length; ++i) {
                this.getModel().createNewEntryRow(ENTRY);
                this.getModel().setValue(F7_PRICE, prices[i].getPkValue(), i);
                itemId = prices[i].getDynamicObject("itemid").getLong("id");
                this.getModel().setValue(F7_ITEM, (Object)itemId, i);
                itemObj = (DynamicObject)this.getModel().getValue(F7_ITEM, i);
                if (itemObj != null) {
                    itemClassColl = ((DynamicObject)itemMap.get(itemId)).getDynamicObjectCollection("itemclassentity");
                    if (!CommonUtils.isNull((Object)itemClassColl)) {
                        for (DynamicObject dynamicObject : itemClassColl) {
                            if (!classSet.isEmpty()) {
                                if (!classSet.contains(dynamicObject.get("goodsclasssid_id"))) continue;
                                itemClassObj = dynamicObject.getDynamicObject("goodsclasssid");
                                break;
                            }
                            if (standardId != dynamicObject.getLong("classstandardid_id")) continue;
                            itemClassObj = dynamicObject.getDynamicObject("goodsclasssid");
                            break;
                        }
                    }
                    itemObj.set(ITEMCLASS_NAME, itemClassObj);
                }
                this.getModel().setValue(F7_UNIT, prices[i].getDynamicObject(F7_UNIT).getPkValue(), i);
                this.getModel().setValue(OLD_PRICE, prices[i].get("saleprice"), i);
                this.getModel().setValue(OLD_LOWPRICE, prices[i].get("lowprice"), i);
                this.changePrice(this.getModel().getEntryRowEntity(ENTRY, i), prices[i].getBigDecimal("saleprice"), priceRate, priceAmount);
            }
        }
    }

    private void updateEntrysPrice(Set<Object> classSet, BigDecimal priceRate, BigDecimal priceAmount) {
        QFilter q1;
        DynamicObjectCollection itemClassCollection;
        IDataModel model = this.getModel();
        DynamicObject itemInfoObj = null;
        Map<Object, Object> itemClassMap = new HashMap();
        if (!classSet.isEmpty() && !CommonUtils.isNull((Object)(itemClassCollection = QueryServiceHelper.query((String)"mdr_itemclassentry", (String)"goodsclasssid,id", (QFilter[])(q1 = new QFilter("goodsclasssid", "in", classSet)).toArray(), (String)"")))) {
            itemClassMap = itemClassCollection.stream().collect(Collectors.groupingBy(obj -> obj.getLong("id")));
        }
        Set itemClassObjSet = null;
        for (int i = 0; i < model.getEntryRowCount(ENTRY); ++i) {
            BigDecimal oldPrice;
            DynamicObject entry = model.getEntryRowEntity(ENTRY, i);
            itemInfoObj = entry.getDynamicObject(F7_ITEM);
            if (itemInfoObj == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5728\u5206\u5f55\u4e2d\u9009\u62e9\u5546\u54c1\u3002", (String)"ItemPriceChangeEditPlugin_27", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            }
            if (classSet.isEmpty()) {
                oldPrice = entry.getBigDecimal(OLD_PRICE);
                this.changePrice(entry, oldPrice, priceRate, priceAmount);
                continue;
            }
            if (!itemClassMap.containsKey(itemInfoObj.getPkValue()) || CommonUtils.isNull(itemClassObjSet = ((List)itemClassMap.get(itemInfoObj.getPkValue())).stream().filter(itemClassObj -> classSet.contains(itemClassObj.get("goodsclasssid"))).collect(Collectors.toSet()))) continue;
            oldPrice = entry.getBigDecimal(OLD_PRICE);
            this.changePrice(entry, oldPrice, priceRate, priceAmount);
        }
    }

    private void changePrice(DynamicObject entry, BigDecimal oldPrice, BigDecimal priceRate, BigDecimal priceAmount) {
        BigDecimal newprice = BigDecimal.ZERO;
        newprice = oldPrice.add(priceAmount);
        entry.set(NEW_PRICE, (Object)newprice);
        entry.set(PRICE_FLOAT, (Object)newprice.subtract(oldPrice));
    }

    private String getBillStatus() {
        if (this.getModel().getValue(STATUS) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u636e\u72b6\u6001\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"ItemPriceChangeEditPlugin_28", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        return this.getModel().getValue(STATUS).toString();
    }

    private DynamicObjectCollection getBillEntrys() {
        return this.getModel().getEntryEntity(ENTRY);
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection entrys;
        String status;
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        switch (status = dataEntity.getString(STATUS)) {
            case "1": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"btnsave"});
                this.getView().setVisible(Boolean.TRUE, new String[]{OP_CHECKSUBMIT});
                this.getView().setVisible(Boolean.FALSE, new String[]{"btnaudit"});
                break;
            }
            case "2": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btnsave"});
                this.getView().setVisible(Boolean.FALSE, new String[]{OP_CHECKSUBMIT});
                this.getView().setVisible(Boolean.TRUE, new String[]{"btnaudit"});
                break;
            }
            case "3": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btnsave"});
                this.getView().setVisible(Boolean.FALSE, new String[]{OP_CHECKSUBMIT});
                this.getView().setVisible(Boolean.FALSE, new String[]{"btnaudit"});
                break;
            }
        }
        if (!"3".equals(this.getBillStatus()) && (entrys = this.getBillEntrys()) != null && entrys.size() > 0) {
            for (DynamicObject entry : entrys) {
                DynamicObject price = entry.getDynamicObject(F7_PRICE);
                if (price == null) continue;
                BigDecimal oldPrice = price.getBigDecimal("saleprice");
                BigDecimal oldLowprice = price.getBigDecimal("lowprice");
                entry.set(OLD_PRICE, (Object)oldPrice);
                entry.set(OLD_LOWPRICE, (Object)oldLowprice);
                if (entry.getBigDecimal(NEW_PRICE) != null && oldPrice != null) {
                    BigDecimal priceFloat = entry.getBigDecimal(NEW_PRICE).subtract(entry.getBigDecimal(OLD_PRICE));
                    if (entry.getBigDecimal(PRICE_FLOAT) == null || entry.getBigDecimal(PRICE_FLOAT).compareTo(priceFloat) != 0) {
                        entry.set(PRICE_FLOAT, (Object)priceFloat);
                    }
                }
                if (entry.getBigDecimal(NEW_LOWPRICE) == null || oldLowprice == null) continue;
                BigDecimal lowpriceFloat = entry.getBigDecimal(NEW_LOWPRICE).subtract(entry.getBigDecimal(OLD_LOWPRICE));
                if (entry.getBigDecimal(LOWPRICE_FLOAT) != null && entry.getBigDecimal(LOWPRICE_FLOAT).compareTo(lowpriceFloat) == 0) continue;
                entry.set(LOWPRICE_FLOAT, (Object)lowpriceFloat);
            }
            this.getView().updateView(ENTRY);
        }
    }
}

