/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.fs.util.StringUtils;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.mdr.common.util.BizValidateUtils;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.common.util.WebUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class ItemPriceEditPlugin
extends MdrFormPlugin
implements BeforeF7SelectListener {
    private static final String PRICE_LIST = "pricelist";
    private static final String TOOL = "toolbarap";
    private static final String ENTRY_TOOL = "entrytoolbar";
    private static final String BAR_GENERATE = "bar_generate";
    private static final String BTN_SAVE = "btnsave";
    private static final String BTN_AUDIT = "btnaudit";
    private static final String BTN_BAR_ADD = "bar_add";
    private static final String BTN_BAR_DEL = "bar_del";
    private static final String SALEPRICE = "saleprice";
    private static final String LOWPRICE = "lowprice";
    private static final String STATUS = "status";
    private static final String ITEMPRICEID = "itempriceid";
    private static final String ITEMCLASS_NAME = "basedatapropfield2";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{ENTRY_TOOL, TOOL, BTN_BAR_DEL});
        this.addF7Listener(this, new String[]{"item", "unit", "assistattr"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List params = (List)this.getView().getFormShowParameter().getCustomParam("price");
        if (null != params) {
            this.initList(params);
        } else {
            Object customerId = this.getView().getFormShowParameter().getCustomParam("customerId");
            if (customerId == null || customerId.toString().trim().equals("")) {
                this.getModel().setValue("owner", UserUtil.getDefaultOwnerID());
            } else {
                this.getModel().setValue("owner", customerId);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Set ids = UserUtil.getAuthorizedOwnerIDs();
        QFilter fliter = new QFilter("id", "in", (Object)ids);
        this.setF7Filter("owner", fliter);
        List params = (List)this.getView().getFormShowParameter().getCustomParam("price");
        if (ids.size() == 0 || null != params) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"owner"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object oldvalue = e.getChangeSet()[0].getOldValue();
        if (propertyName.length() == 0) {
            return;
        }
        int index = e.getChangeSet()[0].getRowIndex();
        DynamicObject row = this.getModel().getEntryRowEntity(PRICE_LIST, index);
        switch (propertyName) {
            case "item": {
                this.setBaseUnit(index);
                this.setBaseAttr(index);
                this.setItemClass(row, index);
                break;
            }
            case "owner": {
                if (this.getF7PKValue("owner") == null) {
                    this.getModel().setValue("owner", oldvalue);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ItemPriceEditPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getModel().deleteEntryData(PRICE_LIST);
                break;
            }
            case "saleprice": {
                if (this.getValue(SALEPRICE, index).toString().compareTo("0") > 0) break;
                this.setValue(SALEPRICE, null, index);
                return;
            }
            case "assistattr": {
                this.validateAttrIsNotNull(index, e);
                break;
            }
        }
    }

    private void setItemClass(DynamicObject row, int index) {
        DynamicObject item = row.getDynamicObject("item");
        if (item != null) {
            DynamicObject itemClassStandard = BusinessDataServiceHelper.loadSingle((Object)7L, (String)"mdr_classstandardapply");
            long standardId = itemClassStandard.getLong("classstandardid_id");
            DynamicObjectCollection itemClassColl = item.getDynamicObjectCollection("itemclassentity");
            DynamicObject itemClassObj = null;
            if (!CommonUtils.isNull((Object)itemClassColl)) {
                for (DynamicObject dynamicObject : itemClassColl) {
                    if (standardId != dynamicObject.getLong("classstandardid_id")) continue;
                    itemClassObj = dynamicObject.getDynamicObject("goodsclasssid");
                    break;
                }
            }
            item.set("itemclass", itemClassObj);
            this.setValue("item", item, index);
            this.getView().updateView(ITEMCLASS_NAME, index);
        }
    }

    private void setBaseUnit(int index) {
        Object itemId = this.getEntryF7PKValue(PRICE_LIST, "item", index);
        if (itemId != null) {
            this.setValue("unit", this.getUnitFormHandler().getSaleUnitId(itemId), index);
        }
    }

    private void setBaseAttr(int index) {
        Object ownerId = this.getOwnerF7PKValue();
        Object itemId = this.getEntryF7PKValue(PRICE_LIST, "item", index);
        Object unitId = this.getEntryF7PKValue(PRICE_LIST, "unit", index);
        QFilter f = new QFilter("customer", "=", (Object)Long.parseLong(ownerId.toString()));
        f.and("itemid", "=", (Object)Long.parseLong(itemId.toString()));
        f.and("unit", "=", (Object)Long.parseLong(unitId.toString()));
        Set priceAttr = QueryUtil.querySingleCol((String)"mdr_item_price", (String)"assistattr", (QFilter[])f.toArray());
        Object defaultAttrId = ItemAttrUtil.getDefaultAttrId((Object)itemId);
        if (!priceAttr.contains(defaultAttrId)) {
            this.setValue("assistattr", defaultAttrId, index);
        }
        if (defaultAttrId == null) {
            super.setUnEnable(index, new String[]{"assistattr"});
        } else {
            super.setEnable(index, new String[]{"assistattr"});
        }
    }

    private void validateAttrIsNotNull(int index, PropertyChangedArgs e) {
        Object itemId = this.getEntryF7PKValue(PRICE_LIST, "item", index);
        DynamicObject assistattr = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (itemId != null && !BizValidateUtils.itemAttrNullValidate((Object)itemId, (DynamicObject)assistattr)) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (oldValue != null) {
                this.setValue("assistattr", oldValue, index);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u5f00\u542f\u8f85\u52a9\u5c5e\u6027\uff0c\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ItemPriceEditPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
    }

    protected void itemF7Select(BeforeF7SelectEvent evt) {
        Map<String, Object> itemList = this.getItemList();
        HashSet<Object> values = new HashSet<Object>(itemList.values());
        F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)WebUtil.getIdQFilter(values));
    }

    protected void unitF7Select(BeforeF7SelectEvent evt) {
        List ids = this.getUnitFormHandler().getUnitIdList(this.getEntryF7PKValue(PRICE_LIST, "item", evt.getRow()));
        QFilter f1 = new QFilter("id", "in", (Object)ids);
        F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)f1);
    }

    private void attrF7Select(BeforeF7SelectEvent evt) {
        Object itemId = this.getEntryF7PKValue(PRICE_LIST, "item", evt.getRow());
        if (itemId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1", (String)"ItemPriceEditPlugin_2", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        Object unitId = this.getEntryF7PKValue(PRICE_LIST, "unit", evt.getRow());
        if (unitId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u91cf\u5355\u4f4d", (String)"ItemPriceEditPlugin_3", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        Set ids = ItemAttrUtil.getAttrIds((Object)itemId);
        Object ownerId = this.getOwnerF7PKValue();
        QFilter f = new QFilter("customer", "=", (Object)Long.parseLong(ownerId.toString()));
        f.and("itemid", "=", (Object)Long.parseLong(itemId.toString()));
        f.and("unit", "=", (Object)Long.parseLong(unitId.toString()));
        Set priceUnits = QueryUtil.querySingleCol((String)"mdr_item_price", (String)"assistattr", (QFilter[])f.toArray());
        ids.removeAll(priceUnits);
        QFilter f1 = new QFilter("id", "in", (Object)ids);
        F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)f1);
    }

    private Map<String, Object> getItemList() {
        Object ownerId = this.getOwnerF7PKValue();
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        String key = null;
        ArrayList<QFilter> tbFilters = new ArrayList<QFilter>();
        Object ownerid = this.getOwnerF7PKValue();
        if (ownerid == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u9500\u552e\u6e20\u9053\u3002", (String)"ItemPriceEditPlugin_4", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        tbFilters.add(ItemSaleControlUtil.getItemFilterUsePageCache((Object)ownerid, (IPageCache)this.getPageCache()));
        tbFilters.add(new QFilter("isonsell", "=", (Object)String.valueOf(1)));
        DynamicObjectCollection infos = QueryServiceHelper.query((String)"mdr_item_info", (String)"id,material", (QFilter[])tbFilters.toArray(new QFilter[tbFilters.size()]));
        if (null != infos) {
            Object itemId;
            HashMap<Object, Object> itemTempMap = new HashMap<Object, Object>();
            HashSet<Object> materialIds = new HashSet<Object>();
            HashSet<Object> itemIds = new HashSet<Object>();
            for (DynamicObject info : infos) {
                materialIds.add(info.get("material"));
                itemIds.add(info.get("id"));
                itemTempMap.put(info.get("id"), info.get("material"));
            }
            HashMap<Object, HashSet<Object>> materialUnitMap = new HashMap<Object, HashSet<Object>>();
            DynamicObjectCollection materials = QueryServiceHelper.query((String)"bd_material", (String)"id,baseunit", (QFilter[])WebUtil.getIdQFilter(materialIds).toArray());
            for (Object material : materials) {
                Object materialId = material.get("id");
                HashSet<Object> unitSet = (HashSet<Object>)materialUnitMap.get(materialId);
                if (unitSet == null) {
                    unitSet = new HashSet<Object>();
                }
                unitSet.add(material.get("baseunit"));
                materialUnitMap.put(materialId, unitSet);
            }
            DynamicObjectCollection multimeasureunits = QueryServiceHelper.query((String)"bd_multimeasureunit", (String)"materialid,measureunitid", (QFilter[])new QFilter("materialid", "in", materialIds).toArray());
            for (DynamicObject multimeasureunit : multimeasureunits) {
                Iterator materialId = multimeasureunit.get("materialid");
                HashSet<Object> unitSet = (HashSet<Object>)materialUnitMap.get(materialId);
                if (unitSet == null) {
                    unitSet = new HashSet<Object>();
                }
                unitSet.add(multimeasureunit.get("measureunitid"));
                materialUnitMap.put(materialId, unitSet);
            }
            HashMap<Object, HashSet<Object>> assistAttrMap = new HashMap<Object, HashSet<Object>>();
            DynamicObjectCollection assistAttrs = QueryServiceHelper.query((String)"mdr_item_attrvalue", (String)"item,id", (QFilter[])new QFilter("item", "in", itemIds).toArray());
            for (DynamicObject assistAttr : assistAttrs) {
                itemId = assistAttr.get("item");
                HashSet<Object> assistSet = (HashSet<Object>)assistAttrMap.get(itemId);
                if (assistSet == null) {
                    assistSet = new HashSet<Object>();
                }
                assistSet.add(assistAttr.get("id"));
                assistAttrMap.put(itemId, assistSet);
            }
            for (Map.Entry itemEntry : itemTempMap.entrySet()) {
                itemId = itemEntry.getKey();
                Object materialid = itemEntry.getValue();
                Set unitSet = (Set)materialUnitMap.get(materialid);
                if (unitSet == null) continue;
                for (Object unit : unitSet) {
                    Set assistAttrSet = (Set)assistAttrMap.get(itemId);
                    if (assistAttrSet != null && assistAttrSet.size() > 0) {
                        for (Object assistAttr : assistAttrSet) {
                            key = this.itemAndUnitToString(itemId, unit, assistAttr);
                            itemMap.put(key, itemId);
                        }
                        continue;
                    }
                    key = this.itemAndUnitToString(itemId, unit, 0L);
                    itemMap.put(key, itemId);
                }
            }
            DynamicObjectCollection result = QueryServiceHelper.query((String)"mdr_item_price", (String)"id,itemid,unit,assistattr", (QFilter[])new QFilter("customer", "=", (Object)Long.parseLong(ownerId.toString())).toArray());
            for (DynamicObject price : result) {
                key = this.itemAndUnitToString(price.get("itemid"), price.get("unit"), price.get("assistattr"));
                itemMap.keySet().remove(key);
            }
        }
        return itemMap;
    }

    private String itemAndUnitToString(Object itemId, Object unitId, Object assistattrId) {
        return itemId + "-" + unitId + '-' + assistattrId;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        ListView list = (ListView)this.getView().getParentView();
        switch (itemKey) {
            case "bar_generate": {
                int addRow = this.generateList();
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5171\u751f\u6210%s\u6761\u6570\u636e", (String)"ItemPriceEditPlugin_5", (String)"drp-bbc-formplugin", (Object[])new Object[0]), addRow));
                break;
            }
            case "btnsave": {
                this.saveList(false);
                list.showSuccessNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u751f\u6210\u6210\u529f\u3002", (String)"ItemPriceEditPlugin_6", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                list.refresh();
                this.getView().close();
                break;
            }
            case "btnaudit": {
                IDataModel model = this.getModel();
                DynamicObjectCollection prices = model.getEntryEntity(PRICE_LIST);
                if (prices.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u751f\u6210\u4ef7\u683c\u3002", (String)"ItemPriceEditPlugin_7", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                }
                StringBuilder str = new StringBuilder();
                int rownum = 0;
                for (DynamicObject price : prices) {
                    BigDecimal saleprice = (BigDecimal)price.get(SALEPRICE);
                    if (saleprice.compareTo(BigDecimal.ZERO) == 0) {
                        str.append(rownum + 1);
                        str.append(rownum == prices.size() - 1 ? "" : ",");
                    }
                    ++rownum;
                }
                if (!StringUtils.isEmpty((String)str.toString())) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bb0\u5f55\u9500\u552e\u4ef7\u683c\u4e0d\u80fd\u4e3a0\u3002", (String)"ItemPriceEditPlugin_8", (String)"drp-bbc-formplugin", (Object[])new Object[0]), str.toString()));
                }
                this.saveList(true);
                list.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5e76\u5ba1\u6838\u6210\u529f\u3002", (String)"ItemPriceEditPlugin_9", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                list.refresh();
                this.getView().close();
                break;
            }
        }
    }

    private void repeatValidate(DynamicObjectCollection prices) {
        HashSet<String> items = new HashSet<String>();
        for (DynamicObject data : prices) {
            DynamicObject attr;
            Object attrId;
            Object unitId;
            Object itemId = data.getDynamicObject("item").getPkValue();
            String itemKey = this.itemAndUnitToString(itemId, unitId = data.getDynamicObject("unit").getPkValue(), attrId = (attr = data.getDynamicObject("assistattr")) != null ? attr.getPkValue() : Long.valueOf(0L));
            if (items.contains(itemKey)) {
                Object seq = data.get("seq");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4e0e\u5176\u4ed6\u5185\u5bb9\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u91cd\u65b0\u4fdd\u5b58\u3002", (String)"ItemPriceEditPlugin_10", (String)"drp-bbc-formplugin", (Object[])new Object[0]), seq));
            }
            items.add(itemKey);
        }
    }

    private void saveList(boolean isAudit) {
        IDataModel model = this.getModel();
        DynamicObjectCollection prices = model.getEntryEntity(PRICE_LIST);
        if (prices.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u751f\u6210\u4ef7\u683c\u3002", (String)"ItemPriceEditPlugin_7", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (DynamicObject price : prices) {
            this.saveCheck(price);
        }
        this.repeatValidate(prices);
        try (TXHandle h = TX.required();){
            try {
                ArrayList<DynamicObject> itemPricelist = new ArrayList<DynamicObject>();
                for (DynamicObject price : prices) {
                    sb.setLength(0);
                    sb.append(price.getDynamicObject("item").getPkValue());
                    sb.append(price.getDynamicObject("unit").getPkValue());
                    DynamicObject assistattr = price.getDynamicObject("assistattr");
                    sb.append(assistattr == null ? null : assistattr.getPkValue());
                    if (list != null && list.contains(sb.toString())) continue;
                    DynamicObject itemPrice = null;
                    if (!WebUtil.isEmptyId((Object)price.get(ITEMPRICEID))) {
                        itemPrice = BusinessDataServiceHelper.loadSingle((Object)price.get(ITEMPRICEID).toString(), (String)"mdr_item_price");
                        itemPrice.set(SALEPRICE, price.get(SALEPRICE));
                        itemPrice.set(LOWPRICE, price.get(LOWPRICE));
                    } else {
                        itemPrice = BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_price");
                        itemPrice.set("itemid", price.get("item"));
                        itemPrice.set(SALEPRICE, price.get(SALEPRICE));
                        itemPrice.set(LOWPRICE, price.get(LOWPRICE));
                        itemPrice.set(STATUS, isAudit ? Integer.valueOf(1) : price.get(STATUS));
                        itemPrice.set("unit", price.get("unit"));
                        itemPrice.set("assistattr", price.get("assistattr"));
                        itemPrice.set("customer", this.getOwnerF7PKValue());
                    }
                    itemPricelist.add(itemPrice);
                    list.add(sb.toString());
                }
                if (itemPricelist != null && itemPricelist.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])itemPricelist.toArray(new DynamicObject[itemPricelist.size()]));
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void saveCheck(DynamicObject price) {
        BigDecimal lowprice;
        Object ownerId = this.getOwnerF7PKValue();
        DynamicObject item = (DynamicObject)price.get("item");
        DynamicObject unit = (DynamicObject)price.get("unit");
        DynamicObject assistAttr = (DynamicObject)price.get("assistattr");
        BigDecimal saleprice = (BigDecimal)price.get(SALEPRICE);
        if (saleprice.compareTo(lowprice = (BigDecimal)price.get(LOWPRICE)) < 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u6700\u4f4e\u9650\u4ef7\u4e0d\u80fd\u9ad8\u4e8e\u9500\u552e\u4ef7\u683c\u3002", (String)"ItemPriceEditPlugin_13", (String)"drp-bbc-formplugin", (Object[])new Object[0]), price.get("seq")));
        }
        if (item == null || unit == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u4e3a\u7a7a\u7684\u5546\u54c1\u6216\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"ItemPriceEditPlugin_11", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        boolean hasAssistAttr = ItemAttrUtil.hasAssistAttr((Object)item.get("id"));
        if (hasAssistAttr && assistAttr == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u5f00\u542f\u8f85\u52a9\u5c5e\u6027\uff0c\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ItemPriceEditPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        if (WebUtil.isEmptyId((Object)price.get(ITEMPRICEID))) {
            QFilter f1 = new QFilter("itemid", "=", item.getPkValue());
            f1.and("unit", "=", unit.getPkValue());
            f1.and("assistattr", "=", assistAttr == null ? Long.valueOf(0L) : assistAttr.getPkValue());
            f1.and(new QFilter("customer", "=", ownerId));
            if (QueryServiceHelper.exists((String)"mdr_item_price", (QFilter[])f1.toArray())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u91cd\u590d\u7684\u5546\u54c1\u4ef7\u683c\u3002", (String)"ItemPriceEditPlugin_12", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private int generateList() {
        IDataModel model = this.getModel();
        Set<Object> itemSet = new HashSet();
        Map<String, Object> itemMap = this.getItemList();
        if (itemMap != null) {
            itemSet = itemMap.keySet();
        }
        int addCount = 0;
        model.deleteEntryData(PRICE_LIST);
        this.getModel().beginInit();
        DynamicObjectCollection priceList = this.getModel().getDataEntity().getDynamicObjectCollection(PRICE_LIST);
        priceList.clear();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("item", new Object[0]);
        vs.addField(SALEPRICE, new Object[0]);
        vs.addField(LOWPRICE, new Object[0]);
        vs.addField("unit", new Object[0]);
        vs.addField("assistattr", new Object[0]);
        vs.addField(STATUS, new Object[0]);
        vs.addField(ITEMPRICEID, new Object[0]);
        String itemId = null;
        String unitId = null;
        String assistAttrId = null;
        String[] itemUnit = null;
        for (String string : itemSet) {
            itemUnit = string.split("-");
            itemId = itemUnit[0];
            unitId = itemUnit[1];
            assistAttrId = itemUnit[2];
            vs.addRow(new Object[]{itemId, BigDecimal.ZERO, BigDecimal.ZERO, unitId, assistAttrId, 0, 0});
            ++addCount;
        }
        AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
        dataModel.batchCreateNewEntryRow(PRICE_LIST, vs);
        this.getModel().endInit();
        this.getView().updateView(PRICE_LIST);
        return addCount;
    }

    private void initList(List<Object> params) {
        this.setDisVisible(new String[]{BAR_GENERATE, BTN_BAR_DEL, BTN_BAR_ADD});
        IDataModel model = this.getModel();
        int i = 0;
        QFilter filter = QueryUtil.getIdQFilter(params);
        DynamicObject[] prices = BusinessDataServiceHelper.load((String)"mdr_item_price", (String)"id,itemid.id,saleprice,lowprice,unit.id,assistattr.id,status,customer", (QFilter[])filter.toArray());
        if (prices.length > 0) {
            this.getModel().setValue("owner", prices[0].get("customer"));
        }
        for (DynamicObject price : prices) {
            model.createNewEntryRow(PRICE_LIST);
            model.setValue(ITEMPRICEID, (Object)price.get("id").toString(), i);
            model.setValue("item", price.get("itemid.id"), i);
            model.setValue(SALEPRICE, price.get(SALEPRICE), i);
            model.setValue(LOWPRICE, price.get(LOWPRICE), i);
            model.setValue("unit", price.get("unit.id"), i);
            model.setValue("assistattr", price.get("ASSISTATTR.id"), i);
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"unit"});
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"item"});
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"assistattr"});
            model.setValue(STATUS, price.get(STATUS), i);
            ++i;
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "item": {
                this.itemF7Select(evt);
                break;
            }
            case "unit": {
                this.unitF7Select(evt);
                break;
            }
            case "assistattr": {
                this.attrF7Select(evt);
            }
        }
    }
}

