/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.formplugin.MdrListPlugin;
import kd.drp.mdr.formplugin.template.BeForeF7Template;

public class ItemPriceListPlugin
extends MdrListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "new": {
                args.setCancel(true);
                this.openGenerate(null);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        switch (key = e.getOperateKey()) {
            case "custommodify": {
                if (e.getOperationResult().isSuccess()) {
                    this.openModify();
                }
            }
            case "customaudit": {
                this.getListView().refresh();
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs e) {
        super.filterContainerInit(e);
        this.initAuthoriedOwnerFilterComboItem(e, "customer.name");
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (!this.isLookup()) {
            List fs = e.getQFilters();
            HashMap<String, QFilter> fsMap = new HashMap<String, QFilter>(fs.size());
            for (QFilter f : fs) {
                fsMap.put(f.getProperty(), f);
            }
            QFilter filter = (QFilter)fsMap.get("customer.id");
            if (null != filter) {
                this.getPageCache().put(this.getView().getPageId() + "customerId", filter.getValue().toString());
            } else {
                filter = new QFilter("customer.id", "in", (Object)this.getAuthoriedOwnerIDs());
                fs.add(filter);
                this.getPageCache().put(this.getView().getPageId() + "customerId", "");
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        String key;
        switch (key = e.getFieldName()) {
            case "customer.id": {
                BeForeF7Template.fastAddListF7Filter((BeforeFilterF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)this.getAuthoriedOwnerIDs()));
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if ("changecount".equals(args.getHyperLinkClickEvent().getFieldName())) {
            Object pk = this.getListView().getFocusRowPkId();
            this.openChangeRecord(pk);
            args.setCancel(true);
        }
    }

    private void openChangeRecord(Object pkObject) {
        QFilter f = new QFilter("itempriceid", "=", pkObject);
        String order = "modifytime desc";
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("mdr_item_changerecord");
        parameter.setFormId("bos_list");
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(f);
        listFilterParameter.setOrderBy(order);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void openModify() {
        ListSelectedRowCollection listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows();
        if (listSelectedRowCollection.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"ItemPriceListPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        } else {
            HashSet<Object> customers = new HashSet<Object>();
            ArrayList<Object> ids = new ArrayList<Object>();
            for (ListSelectedRow row : listSelectedRowCollection) {
                ids.add(row.getPrimaryKeyValue());
            }
            DynamicObjectCollection objs = QueryServiceHelper.query((String)"mdr_item_price", (String)"id,status,customer", (QFilter[])new QFilter("id", "in", ids).toArray());
            for (DynamicObject obj : objs) {
                customers.add(obj.get("customer"));
                if ("0".equals(obj.get("status"))) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u72b6\u6001\u624d\u80fd\u4fee\u6539\uff01", (String)"ItemPriceListPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            }
            if (customers.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u540c\u65f6\u4fee\u6539\u4e00\u4e2a\u5f52\u5c5e\u6e20\u9053\u4e0b\u7684\u4ef7\u683c\uff01", (String)"ItemPriceListPlugin_2", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            }
            this.openGenerate(ids);
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        ListSelectedRow row = evt.getCurrentListSelectedRow();
        Object pkArray = row.getPrimaryKeyValue();
        DynamicObject obj = QueryServiceHelper.queryOne((String)"mdr_item_price", (String)"id,status", (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(pkArray.toString())).toArray());
        if (!"0".equals(obj.get("status"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u72b6\u6001\u624d\u80fd\u4fee\u6539\uff01", (String)"ItemPriceListPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        ArrayList<Object> ids = new ArrayList<Object>();
        ids.add(pkArray);
        this.openGenerate(ids);
        evt.setCancel(true);
    }

    private void openGenerate(List<Object> params) {
        FormShowParameter parameter = new FormShowParameter();
        if (null != params) {
            parameter.setCustomParam("price", params);
        } else {
            parameter.setCustomParam("customerId", (Object)this.getPageCache().get(this.getView().getPageId() + "customerId"));
        }
        parameter.setFormId("mdr_item_price_generate");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("tabap");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("close".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }
}

