/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;
import org.apache.commons.lang.StringUtils;

public class ItemPricePolicyEditPlugin
extends MdrFormPlugin
implements BeforeF7SelectListener {
    private Log log = LogFactory.getLog(ItemPricePolicyEditPlugin.class);
    private static final String OWNER = "owner";
    private static final String TOP_CUSTOMER = "top_customer";
    private static final String TOP_CUSTOMERGROUP = "top_customergroup";
    private static final String TOP_REGION = "top_region";
    private static final String TOP_BEGINDATE = "top_begindate";
    private static final String TOP_ENDDATE = "top_enddate";
    private static final String TOP_PRIORITY = "top_priority";
    private static final String CURRENCY = "currency";
    private static final String ITEM_ENTITY = "itementity";
    private static final String ITEM = "item";
    private static final String UNIT = "unit";
    private static final String ASSISTATTR = "assistattr";
    private static final String CUSTOMER = "customer";
    private static final String CUSTOMERGROUP = "customergroup";
    private static final String REGION = "region";
    private static final String PRIORITY = "priority";
    private static final String QTYFROM = "qtyfrom";
    private static final String QTYTO = "qtyto";
    private static final String PRICE = "price";
    private static final String LOWESTPRICE = "lowestprice";
    private static final String BEGINDATE = "begindate";
    private static final String ENDDATE = "enddate";
    private static final String PRICEPOLICY = "pricepolicy";
    private static final String TOOLBARAP = "toolbarap";
    private static final String TB_SAVE = "tb_save";
    private static final String OP_SAVE = "save";
    private static final String OP_INSERTENTRY = "insertentry";
    private static String[] keys = new String[]{"id", "owner", "customer", "customergroup", "region", "item", "unit", "assistattr", "qtyfrom", "qtyto", "price", "lowestprice", "begindate", "enddate", "priority"};
    private static String[] keys1 = new String[]{"customer", "customergroup", "region", "item", "unit", "begindate", "enddate", "priority"};
    private static String[] keys2 = new String[]{"customer", "customergroup", "region", "item", "unit", "assistattr", "qtyfrom", "qtyto", "price", "lowestprice", "begindate", "enddate", "priority"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{TB_SAVE});
        this.addItemClickListeners(new String[]{TOOLBARAP});
        this.addF7Listener(this, new String[]{OWNER, ITEM, UNIT, ASSISTATTR, CUSTOMERGROUP});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object ids = params.get("ids");
        if (ids != null) {
            this.setDisVisible(new String[]{"advconbaritemap", "advconbaritemap1"});
            String[] pks = ids.toString().split(",");
            QFilter f = new QFilter("id", "in", Arrays.stream(pks).map(strId -> Long.parseLong(strId)).collect(Collectors.toList()));
            String fields = StringUtils.join((Object[])keys, (String)",");
            DynamicObjectCollection pricePlicys = QueryServiceHelper.query((String)"mdr_price_policy", (String)fields, (QFilter[])f.toArray());
            if (pricePlicys == null || pricePlicys.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u672a\u627e\u5230\u4fee\u6539\u7684\u4ef7\u683c\u653f\u7b56\uff0c\u8bf7\u5148\u5237\u65b0\u5217\u8868\u540e\u518d\u64cd\u4f5c\uff01", (String)"ItemPricePolicyEditPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            }
            this.getModel().setValue(OWNER, ((DynamicObject)pricePlicys.get(0)).get(OWNER));
            this.getModel().deleteEntryData(ITEM_ENTITY);
            this.getModel().batchCreateNewEntryRow(ITEM_ENTITY, pricePlicys.size());
            for (int i = 0; i < pricePlicys.size(); ++i) {
                DynamicObject pricePlicy = (DynamicObject)pricePlicys.get(i);
                for (String key : keys) {
                    if ("id".equals(key)) {
                        this.getModel().setValue(PRICEPOLICY, pricePlicy.get(key), i);
                        continue;
                    }
                    if (OWNER.equals(key)) continue;
                    this.getModel().setValue(key, pricePlicy.get(key), i);
                }
            }
        } else {
            IPageCache pageCache;
            String ownerId;
            IFormView parentView = this.getView().getParentView();
            if (parentView != null && (ownerId = (pageCache = (IPageCache)parentView.getService(IPageCache.class)).get(parentView.getPageId() + "ownerId")) != null && !ownerId.toString().trim().equals("")) {
                this.getModel().setValue(OWNER, (Object)ownerId);
                return;
            }
            this.getModel().setValue(OWNER, UserUtil.getDefaultOwnerID());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setF7Filter(OWNER, UserUtil.getAuthorizedCommonUserOwnersFilter());
        this.setFilterByOwner();
    }

    private void setFilterByOwner() {
        Object owner = this.getOwnerF7PKValue();
        this.setF7Filter(CUSTOMER, CustomerUtil.getAuthSubsIdsQFilter((Object)owner));
    }

    private void item_beforeF7Select(BeforeF7SelectEvent evt) {
        this.setItemFilter(evt);
    }

    private void unit_beforeF7Select(BeforeF7SelectEvent evt) {
        Object itemId = this.getEntryF7PKValue(ITEM_ENTITY, ITEM, evt.getRow());
        if (itemId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1\uff01", (String)"ItemPricePolicyEditPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        } else {
            List ids = this.getUnitFormHandler().getUnitIdList(itemId);
            QFilter f1 = new QFilter("id", "in", (Object)ids);
            F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)f1);
        }
    }

    private void assistattr_beforef7select(BeforeF7SelectEvent evt) {
        DynamicObject item = (DynamicObject)this.getModel().getValue(ITEM, evt.getRow());
        if (item == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1!", (String)"ItemPricePolicyEditPlugin_2", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)ItemAttrUtil.getAttrFilter((Object)item.get("id")));
    }

    private void setItemFilter(BeforeF7SelectEvent evt) {
        ArrayList<QFilter> tbFilters = new ArrayList<QFilter>();
        Object ownerid = this.getOwnerF7PKValue();
        if (ownerid == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u9500\u552e\u6e20\u9053\uff01", (String)"ItemPricePolicyEditPlugin_3", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        tbFilters.add(ItemSaleControlUtil.getItemFilterUsePageCache((Object)ownerid, (IPageCache)this.getPageCache()));
        tbFilters.add(new QFilter("isonsell", "=", (Object)Character.valueOf('1')));
        F7Utils.addF7Filter((BeforeF7SelectEvent)evt, tbFilters);
    }

    private void setRegionFilter(BeforeF7SelectEvent evt) {
        IDataModel model = this.getModel();
        Object ownerId = this.getOwnerF7PKValue();
        QFilter f = QueryUtil.getOwnerIdQFilter((Object)ownerId);
        if (model.getValue(CUSTOMER, evt.getRow()) != null) {
            Object customerId = this.getEntryF7PKValue(ITEM_ENTITY, CUSTOMER, evt.getRow());
            Object customerRegion = CustomerUtil.queryCustomerRegion((Object)ownerId, (Object)customerId);
            f = new QFilter("id", "=", customerRegion);
        }
        F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)f);
    }

    private void setTopRegionFilter(BeforeF7SelectEvent evt) {
        IDataModel model = this.getModel();
        Object ownerId = this.getOwnerF7PKValue();
        QFilter f = QueryUtil.getOwnerIdQFilter((Object)ownerId);
        if (model.getValue(TOP_CUSTOMER) != null) {
            Object customerId = this.getF7PKValue(TOP_CUSTOMER);
            Object customerRegion = CustomerUtil.queryCustomerRegion((Object)ownerId, (Object)customerId);
            f = new QFilter("id", "=", customerRegion);
        }
        F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)f);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        int index = this.getRowIndex(e);
        Object ownerId = this.getOwnerF7PKValue();
        switch (key) {
            case "customer": {
                Object obj = this.getModel().getValue(CUSTOMER, index);
                if (obj != null) {
                    this.getModel().setValue(CUSTOMERGROUP, null, index);
                    Object customerId = this.getEntryF7PKValue(ITEM_ENTITY, CUSTOMER, index);
                    Object regionId = CustomerUtil.queryCustomerRegion((Object)ownerId, (Object)customerId);
                    DynamicObject region = null;
                    if (regionId != null && (Long)regionId != 0L) {
                        region = BusinessDataServiceHelper.loadSingle((Object)regionId, (String)"mdr_region");
                    }
                    this.getModel().setValue(REGION, region, index);
                    this.setUnEnable(index, new String[]{REGION});
                    break;
                }
                this.setEnable(index, new String[]{REGION});
                break;
            }
            case "customergroup": {
                Object obj = this.getModel().getValue(CUSTOMERGROUP, index);
                if (obj == null) break;
                this.getModel().setValue(CUSTOMER, null, index);
                break;
            }
            case "top_customer": {
                Object obj = this.getModel().getValue(TOP_CUSTOMER);
                if (obj != null) {
                    this.getModel().setValue(TOP_CUSTOMERGROUP, null);
                    Object customerId = this.getF7PKValue(TOP_CUSTOMER);
                    Object regionId = CustomerUtil.queryCustomerRegion((Object)ownerId, (Object)customerId);
                    DynamicObject region = null;
                    if (regionId != null && (Long)regionId != 0L) {
                        region = BusinessDataServiceHelper.loadSingle((Object)regionId, (String)"mdr_region");
                    }
                    this.getModel().setValue(TOP_REGION, region);
                    this.setUnEnable(new String[]{TOP_REGION});
                } else {
                    this.setEnable(new String[]{TOP_REGION});
                }
                int entryRowCount = this.getModel().getEntryRowCount(ITEM_ENTITY);
                for (int i = 0; i < entryRowCount; ++i) {
                    this.getModel().setValue(CUSTOMER, obj, i);
                }
                break;
            }
            case "top_customergroup": {
                Object obj = this.getModel().getValue(TOP_CUSTOMERGROUP);
                if (obj != null) {
                    this.getModel().setValue(TOP_CUSTOMER, null);
                }
                int entryRowCount = this.getModel().getEntryRowCount(ITEM_ENTITY);
                for (int i = 0; i < entryRowCount; ++i) {
                    this.getModel().setValue(CUSTOMERGROUP, obj, i);
                }
                break;
            }
            case "top_region": {
                Object obj = this.getModel().getValue(TOP_REGION);
                int entryRowCount = this.getModel().getEntryRowCount(ITEM_ENTITY);
                for (int i = 0; i < entryRowCount; ++i) {
                    this.getModel().setValue(REGION, obj, i);
                }
                break;
            }
            case "top_priority": {
                Object obj = this.getModel().getValue(TOP_PRIORITY);
                int entryRowCount = this.getModel().getEntryRowCount(ITEM_ENTITY);
                for (int i = 0; i < entryRowCount; ++i) {
                    this.getModel().setValue(PRIORITY, obj, i);
                }
                break;
            }
            case "top_begindate": {
                Object obj = this.getModel().getValue(TOP_BEGINDATE);
                int entryRowCount = this.getModel().getEntryRowCount(ITEM_ENTITY);
                for (int i = 0; i < entryRowCount; ++i) {
                    this.getModel().setValue(BEGINDATE, obj, i);
                }
                break;
            }
            case "top_enddate": {
                Object obj = this.getModel().getValue(TOP_ENDDATE);
                int entryRowCount = this.getModel().getEntryRowCount(ITEM_ENTITY);
                for (int i = 0; i < entryRowCount; ++i) {
                    this.getModel().setValue(ENDDATE, obj, i);
                }
                break;
            }
            case "qtyfrom": {
                this.qtyChange(e);
                break;
            }
            case "qtyto": {
                this.qtyChange(e);
                break;
            }
            case "price": {
                this.priceChange(e);
                break;
            }
            case "lowestprice": {
                this.priceChange(e);
                break;
            }
            case "begindate": {
                this.dateChange(e);
                break;
            }
            case "enddate": {
                this.dateChange(e);
                break;
            }
            case "item": {
                this.itemChange(e);
                break;
            }
            case "owner": {
                this.ownerChange(e);
                break;
            }
        }
    }

    private void qtyChange(PropertyChangedArgs e) {
        int index = this.getRowIndex(e);
        BigDecimal qtyForm = (BigDecimal)this.getValue(QTYFROM, index);
        BigDecimal qtyTo = (BigDecimal)this.getValue(QTYTO, index);
        if (qtyForm != null && qtyTo != null && qtyTo.compareTo(qtyForm) < 0 && qtyTo.compareTo(BigDecimal.ZERO) != 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55,\u9500\u552e\u91cf(\u4ece)\u4e0d\u80fd\u5c0f\u4e8e\u9500\u552e\u91cf(\u5230)\uff01", (String)"ItemPricePolicyEditPlugin_4", (String)"drp-bbc-formplugin", (Object[])new Object[0]), index + 1));
        }
    }

    private void priceChange(PropertyChangedArgs e) {
        int index = this.getRowIndex(e);
        BigDecimal price = (BigDecimal)this.getValue(PRICE, index);
        BigDecimal lowestprice = (BigDecimal)this.getValue(LOWESTPRICE, index);
        if (price != null && lowestprice != null && price.compareTo(lowestprice) < 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55,\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u6700\u4f4e\u9650\u4ef7\uff01", (String)"ItemPricePolicyEditPlugin_5", (String)"drp-bbc-formplugin", (Object[])new Object[0]), index + 1));
        }
    }

    private void dateChange(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        int index = this.getRowIndex(e);
        Date begindate = (Date)this.getValue(BEGINDATE, index);
        Date enddate = (Date)this.getValue(ENDDATE, index);
        if (enddate != null && begindate != null && begindate.after(enddate)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55,\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u751f\u6548\u65e5\u671f\uff01", (String)"ItemPricePolicyEditPlugin_6", (String)"drp-bbc-formplugin", (Object[])new Object[0]), index + 1));
        }
        int entryRowCount = this.getModel().getEntryRowCount(ITEM_ENTITY);
        Object date = this.getValue(key, index);
        for (int i = index; i < entryRowCount; ++i) {
            this.setValue(key, date, i);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate source = (FormOperate)e.getSource();
        String operateKey = source.getOperateKey();
        if (OP_INSERTENTRY.equals(operateKey)) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(ITEM_ENTITY);
            int rowKey = grid.getEntryState().getFocusRow();
            if (rowKey >= 0) {
                IDataModel model = (IDataModel)this.getView().getService(IDataModel.class);
                model.insertEntryRow(ITEM_ENTITY, rowKey + 1);
                this.copyRow(rowKey, rowKey + 1);
            }
            e.setCancel(true);
        } else if (OP_SAVE.equals(operateKey)) {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity(ITEM_ENTITY);
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                BigDecimal qtyForm = entry.getBigDecimal(QTYFROM);
                BigDecimal qtyTo = entry.getBigDecimal(QTYTO);
                if (qtyForm == null || qtyTo == null || qtyTo.compareTo(qtyForm) >= 0 || qtyTo.compareTo(BigDecimal.ZERO) == 0) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55,\u9500\u552e\u91cf(\u4ece)\u4e0d\u80fd\u5c0f\u4e8e\u9500\u552e\u91cf(\u5230)\uff01", (String)"ItemPricePolicyEditPlugin_4", (String)"drp-bbc-formplugin", (Object[])new Object[0]), i + 1));
                e.setCancel(true);
                break;
            }
        }
    }

    private void copyRow(int fromIndex, int toIndex) {
        for (String key : keys1) {
            this.setValue(key, this.getValue(key, fromIndex), toIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String opKey = e.getOperateKey();
        if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) {
            return;
        }
        if (OP_SAVE.equals(opKey)) {
            int i;
            DynamicObjectCollection priceCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(ITEM_ENTITY);
            if (priceCollection == null || priceCollection.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u4ef7\u683c\u653f\u7b56\u5206\u5f55\uff0c\u8bf7\u5148\u6dfb\u52a0\u4e4b\u540e\u518d\u4fdd\u5b58\uff01", (String)"ItemPricePolicyEditPlugin_7", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            }
            DynamicObject owner = this.getF7Value(OWNER);
            if (owner == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f52\u5c5e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u6dfb\u52a0\u4e4b\u540e\u518d\u4fdd\u5b58\uff01", (String)"ItemPricePolicyEditPlugin_8", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            }
            int size = priceCollection.size();
            DynamicObject[] pricePolicys = new DynamicObject[size];
            StringBuilder reuslt = new StringBuilder();
            for (i = 0; i < size; ++i) {
                DynamicObject pricePolicy = null;
                DynamicObject priceEntry = (DynamicObject)priceCollection.get(i);
                if (priceEntry.get(PRICEPOLICY) != null) {
                    pricePolicy = BusinessDataServiceHelper.loadSingle((Object)priceEntry.getDynamicObject(PRICEPOLICY).get("id"), (String)"mdr_price_policy");
                    this.log.info("Policy Entry exist! status is " + pricePolicy.getString("status"));
                } else {
                    pricePolicy = BusinessDataServiceHelper.newDynamicObject((String)"mdr_price_policy");
                    OperationUtil.addDefaultInfo((DynamicObject)pricePolicy);
                    pricePolicy.set("status", (Object)"A");
                    this.log.info("Policy --> set status is A");
                }
                for (String key : keys2) {
                    pricePolicy.set(key, priceEntry.get(key));
                }
                pricePolicy.set(CURRENCY, (Object)this.getF7Value(CURRENCY));
                pricePolicy.set(OWNER, (Object)owner);
                pricePolicys[i] = pricePolicy;
                String opReuslt = OperationUtil.invokeOperationToStr((DynamicObject)pricePolicy, (String)OP_SAVE);
                if (opReuslt == null) continue;
                reuslt.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4fdd\u5b58\u5931\u8d25\uff1a%s\n", (String)"ItemPricePolicyEditPlugin_9", (String)"drp-bbc-formplugin", (Object[])new Object[0]), i + 1, opReuslt));
            }
            for (i = 0; i < size; ++i) {
                DynamicObject priceEntry = (DynamicObject)priceCollection.get(i);
                priceEntry.set(PRICEPOLICY, (Object)pricePolicys[i]);
            }
            if (reuslt != null && reuslt.length() > 0) {
                this.getView().showErrorNotification(reuslt.toString());
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff01", (String)"ItemPricePolicyEditPlugin_10", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void ownerChange(PropertyChangedArgs e) {
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        Object oldValue = changeSet.getOldValue();
        if (newValue == null) {
            this.setValue(OWNER, oldValue);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u5c5e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"ItemPricePolicyEditPlugin_11", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setFilterByOwner();
        this.setValue(TOP_CUSTOMER, null);
        this.setValue(TOP_CUSTOMERGROUP, null);
        this.setValue(TOP_REGION, null);
        this.setValue(TOP_PRIORITY, null);
        this.getModel().deleteEntryData(ITEM_ENTITY);
        this.getModel().createNewEntryRow(ITEM_ENTITY);
    }

    private void itemChange(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = this.getRowIndex(e);
        Object value = this.getEntryF7PKValue(ITEM_ENTITY, ITEM, rowIndex);
        if (value == null) {
            this.getModel().setValue(UNIT, null, rowIndex);
            this.getModel().setValue(ASSISTATTR, null, rowIndex);
        } else {
            Object saleUnitId = null;
            saleUnitId = this.getUnitFormHandler().getSaleUnitId(value);
            if (saleUnitId == null) {
                this.getModel().setValue(UNIT, null, rowIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5546\u54c1\u9500\u552e\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u5546\u54c1\u9500\u552e\u5355\u4f4d!", (String)"ItemPricePolicyEditPlugin_12", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue(UNIT, saleUnitId, changeSet[0].getRowIndex());
            this.setBaseAttr(rowIndex);
        }
    }

    private void setBaseAttr(int index) {
        Object itemId = this.getEntryF7PKValue(ITEM_ENTITY, ITEM, index);
        Object attrid = ItemAttrUtil.getDefaultAttrId((Object)itemId);
        this.setValue(ASSISTATTR, attrid, index);
        if (attrid == null) {
            this.setUnEnable(index, new String[]{ASSISTATTR});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "item": {
                this.item_beforeF7Select(evt);
                break;
            }
            case "unit": {
                this.unit_beforeF7Select(evt);
                break;
            }
            case "assistattr": {
                this.assistattr_beforef7select(evt);
                break;
            }
            case "region": {
                this.setRegionFilter(evt);
                break;
            }
            case "top_region": {
                this.setTopRegionFilter(evt);
                break;
            }
            case "owner": {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("changeOwnerCallBack", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u5f52\u5c5e\u6e20\u9053\u5c06\u6e05\u7a7a\u6240\u6709\u5206\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5207\u6362\uff1f", (String)"ItemPricePolicyEditPlugin_13", (String)"drp-bbc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
                evt.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("changeOwnerCallBack".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            BasedataEdit owenr = (BasedataEdit)this.getView().getControl(OWNER);
            owenr.click();
        }
    }
}

