/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.PriceUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class ItemPricePolicyTestEditPlugin
extends MdrFormPlugin
implements BeforeF7SelectListener {
    private static final String OWNER = "owner";
    private static final String CUSTOMER = "customer";
    private static final String ITEM_ENTITY = "itementity";
    private static final String ITEM = "item";
    private static final String QTY = "qty";
    private static final String UNIT = "unit";
    private static final String PRICE = "price";
    private static final String DATE = "date";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{ITEM, UNIT, "assistattr", OWNER});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue(OWNER, UserUtil.getDefaultOwnerID());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setF7Filter(OWNER, UserUtil.getOwnerIdsQFilter((String)"id"));
        this.setFilterByOwner();
    }

    private void setFilterByOwner() {
        Object owner = this.getOwnerF7PKValue();
        this.setF7Filter(CUSTOMER, CustomerUtil.getAuthSubsIdsQFilter((Object)owner));
    }

    private void item_beforeF7Select(BeforeF7SelectEvent evt) {
        IDataModel model = this.getModel();
        if (model.getValue(OWNER) == null || model.getValue(CUSTOMER) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f52\u5c5e\u6e20\u9053\u548c\u6e20\u9053!", (String)"ItemPricePolicyTestEditPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        this.setItemFilter(evt);
    }

    private void unit_beforeF7Select(BeforeF7SelectEvent evt) {
        List ids = this.getUnitFormHandler().getUnitIdList(this.getEntryF7PKValue(ITEM_ENTITY, UNIT, evt.getRow()));
        F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)new QFilter("id", "in", (Object)ids));
    }

    private void assistAttr_beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        listShowParameter.setMultiSelect(false);
        DynamicObject item = (DynamicObject)this.getModel().getValue(ITEM, evt.getRow());
        if (item == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1!", (String)"ItemPricePolicyTestEditPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)ItemAttrUtil.getAttrFilter((Object)item.get("id")));
    }

    private void setItemFilter(BeforeF7SelectEvent evt) {
        ArrayList<QFilter> tbFilters = new ArrayList<QFilter>();
        tbFilters.add(ItemSaleControlUtil.getItemFilterUsePageCache((Object)this.getOwnerF7PKValue(), (IPageCache)this.getPageCache()));
        tbFilters.add(new QFilter("isonsell", "=", (Object)1));
        F7Utils.addF7Filter((BeforeF7SelectEvent)evt, tbFilters);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "owner": {
                this.ownerChange(e);
                break;
            }
            case "customer": {
                this.customerChange(e);
                break;
            }
            case "item": {
                this.itemChange(e);
                break;
            }
            case "unit": 
            case "assistattr": 
            case "qty": 
            case "date": {
                this.getPrice(e);
                break;
            }
        }
    }

    private void getPrice(PropertyChangedArgs e) {
        int index = this.getRowIndex(e);
        Object ownerId = this.getOwnerF7PKValue();
        Object customerId = this.getCustomerF7PKValue();
        Object itemId = this.getEntryF7PKValue(ITEM_ENTITY, ITEM, index);
        Object unitId = this.getEntryF7PKValue(ITEM_ENTITY, UNIT, index);
        Object assistattrId = this.getEntryF7PKValue(ITEM_ENTITY, "assistattr", index);
        BigDecimal qty = (BigDecimal)this.getModel().getValue(QTY, index);
        Date date = (Date)this.getModel().getValue(DATE, index);
        BigDecimal itemPrice = PriceUtil.getItemPrice((Object)ownerId, (Object)customerId, (Object)itemId, (Object)unitId, (Object)assistattrId, (BigDecimal)qty, (Date)date);
        this.setValue(PRICE, itemPrice, index);
    }

    private void itemChange(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = this.getRowIndex(e);
        Object value = this.getEntryF7PKValue(ITEM_ENTITY, ITEM, rowIndex);
        if (value == null) {
            this.getModel().setValue(UNIT, null, rowIndex);
        } else {
            Object baseUnitId = null;
            baseUnitId = this.getUnitFormHandler().getBaseUnitId(value);
            if (baseUnitId == null) {
                this.getModel().setValue(UNIT, null, rowIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5546\u54c1\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u5546\u54c1\u5355\u4f4d!", (String)"ItemPricePolicyTestEditPlugin_2", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue(UNIT, baseUnitId, changeSet[0].getRowIndex());
        }
    }

    private void ownerChange(PropertyChangedArgs e) {
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        Object oldValue = changeSet.getOldValue();
        if (newValue == null) {
            this.setValue(OWNER, oldValue);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u5c5e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"ItemPricePolicyTestEditPlugin_3", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setFilterByOwner();
        this.getModel().deleteEntryData(ITEM_ENTITY);
        this.getModel().createNewEntryRow(ITEM_ENTITY);
    }

    private void customerChange(PropertyChangedArgs e) {
        this.getModel().deleteEntryData(ITEM_ENTITY);
        this.getModel().createNewEntryRow(ITEM_ENTITY);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "item": {
                this.item_beforeF7Select(evt);
                break;
            }
            case "unit": {
                this.unit_beforeF7Select(evt);
                break;
            }
            case "assistattr": {
                this.assistAttr_beforeF7Select(evt);
                break;
            }
            case "owner": {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("changeOwnerCallBack", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u5f52\u5c5e\u6e20\u9053\u5c06\u6e05\u7a7a\u6240\u6709\u5206\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5207\u6362\uff1f", (String)"ItemPricePolicyTestEditPlugin_4", (String)"drp-bbc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
                evt.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("changeOwnerCallBack".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            BasedataEdit owenr = (BasedataEdit)this.getView().getControl(OWNER);
            owenr.click();
        }
    }
}

