/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.logistics;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class LogisticsSendEditPlugin
extends MdrFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTRY = "entryentity";
    private static final String TRANSPORTAMOUNT = "transportamount";
    private static final String TEANSPORTPRICE = "transportprice";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        if (fsp.getCustomParams() == null) {
            return;
        }
        Long orderid = (Long)fsp.getCustomParam("orderid");
        if (orderid == null) {
            return;
        }
        this.getModel().setValue("order", (Object)orderid);
        this.getView().setEnable(Boolean.FALSE, new String[]{"order"});
        this.setPageValue();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"order"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String OpString = afterDoOperationEventArgs.getOperateKey();
        OperationResult OperationResult2 = afterDoOperationEventArgs.getOperationResult();
        boolean success = OperationResult2.isSuccess();
        if (success && "audit".equals(OpString)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f", (String)"LogisticsSendEditPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
        if (success && "unaudit".equals(OpString)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u529f", (String)"LogisticsSendEditPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "order": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.f7orderfilter());
            }
        }
    }

    public QFilter f7orderfilter() {
        QFilter qFilter = new QFilter("id", ">", (Object)0);
        QFilter[] Filter = new QFilter[]{qFilter};
        DynamicObject[] logisticsInfos = BusinessDataServiceHelper.load((String)"mdr_logistics_send", (String)"id,order", (QFilter[])Filter);
        if (logisticsInfos.length > 0) {
            long[] orderid = new long[logisticsInfos.length];
            int i = 0;
            for (DynamicObject logisticsInfo : logisticsInfos) {
                orderid[i] = (Long)logisticsInfo.getDynamicObject("order").getPkValue();
                ++i;
            }
            if (orderid != null) {
                qFilter = new QFilter("id", "not in", (Object)orderid);
            }
        }
        return qFilter;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (!this.triggerChangeEvent) {
            return;
        }
        this.triggerChangeEvent = false;
        switch (key) {
            case "order": {
                this.setPageValue();
                break;
            }
            case "transportamount": {
                this.getModel().setValue(TEANSPORTPRICE, (Object)0);
                break;
            }
            case "transportprice": {
                this.getModel().setValue(TRANSPORTAMOUNT, (Object)0);
                break;
            }
            default: {
                this.triggerChangeEvent = true;
            }
        }
    }

    private void setPageValue() {
        DynamicObject order = (DynamicObject)this.getModel().getValue("order");
        IDataModel model = this.getModel();
        if (order == null) {
            return;
        }
        model.setValue("transporttype", order.get("transporttype"));
        model.setValue(TRANSPORTAMOUNT, order.get(TRANSPORTAMOUNT));
        model.setValue(TEANSPORTPRICE, order.get(TEANSPORTPRICE));
        model.setValue("createtime", order.get("createtime"));
        QFilter filter = new QFilter("id", "=", order.getDynamicObject("customer").getPkValue());
        QFilter[] qfilter = new QFilter[]{filter};
        DynamicObject customer = BusinessDataServiceHelper.loadSingle((String)"mdr_customer", (String)"id,phone", (QFilter[])qfilter);
        if (customer != null) {
            model.setValue("customer", (Object)customer);
        }
        model.setValue("confirmarrivaldate", order.get("confirmarrivaldate"));
        QFilter filters = new QFilter("id", "=", order.getPkValue());
        QFilter[] qfilters = new QFilter[]{filters};
        DynamicObject saleorderInfo = BusinessDataServiceHelper.loadSingle((String)"mdr_saleorder", (String)"id,saler", (QFilter[])qfilters);
        if (saleorderInfo != null && saleorderInfo.getDynamicObject("saler") != null) {
            model.setValue("saler", saleorderInfo.getDynamicObject("saler").getPkValue());
        }
        model.deleteEntryData(ENTRY);
        DynamicObject[] entrys = BusinessDataServiceHelper.load((String)"mdr_saleorder_entry", (String)this.getSelectEntry(), (QFilter[])this.getFilter(order.getPkValue()));
        if (entrys != null && entrys.length > 0) {
            for (int i = 0; i < entrys.length; ++i) {
                model.createNewEntryRow(ENTRY);
                model.setValue("ownername", order.get("owner"), i);
                model.setValue("orderentry", entrys[i].get("id"), i);
            }
        }
    }

    private String getSelectEntry() {
        return "item,unit,price,qty,orderamount,alterqty";
    }

    private QFilter[] getFilter(Object pk) {
        QFilter f = new QFilter("order", "=", pk);
        return f.toArray();
    }
}

