/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.money;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.bill.events.ConvertPkEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class MoneyEnsureEditPlugin
extends MdrFormPlugin
implements IBillWebApiPlugin {
    private static final String ENSURE_TIME = "ensuretime";
    private static final String ENSURE_AMOUNT = "ensureamount";
    private static final String COMPANY = "company";
    private static final String ENSURE_PERSON = "ensureperson";
    private static final String SALE_NUMBER = "salesnumber";
    private static final String PREPARED = "prepared";
    private static final String PREPARE_TIME = "preparetime";
    private static final String DEBT_ID = "debtid";
    private static final String BEGINTIME = "begintime";
    private static final String ENDTIME = "endtime";
    private static final String SUPPLY = "supply";
    private static final String ENSURE_CLIENT = "ensureclient";
    private static final String UNPAID_AMOUNT = "unpaidamount";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String id = this.getView().getFormShowParameter().getCustomParam("id").toString();
        if (id == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4e0b\u63a8\u7684\u6570\u636e", (String)"MoneyEnsureEditPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        DynamicObject entry = BusinessDataServiceHelper.loadSingle((Object)id.substring(1, id.length() - 1), (String)"mdr_money_debt");
        Date nowtime = new Date();
        if (entry != null) {
            this.getModel().setValue(ENSURE_TIME, (Object)nowtime);
            this.getModel().setValue(UNPAID_AMOUNT, entry.get(UNPAID_AMOUNT));
            this.getModel().setValue(ENSURE_AMOUNT, entry.get("debtmoney"));
            this.getModel().setValue(ENSURE_CLIENT, entry.get("user"));
            this.getModel().setValue(COMPANY, entry.get("owner"));
            this.getModel().setValue(ENSURE_PERSON, entry.get("saler"));
            this.getModel().setValue(SALE_NUMBER, entry.get("ordernumber"));
            this.getModel().setValue(PREPARED, UserUtil.getUserInfo().get("name"));
            this.getModel().setValue(PREPARE_TIME, (Object)nowtime);
            this.getModel().setValue(DEBT_ID, (Object)id.substring(1, id.length() - 1));
            this.getModel().setValue(BEGINTIME, (Object)nowtime);
            this.getModel().setValue(ENDTIME, (Object)entry.getDate("expiretime"));
            this.getModel().setValue(SUPPLY, entry.get(SUPPLY));
            BigDecimal unpaidamount = new BigDecimal("0.0");
            if (entry.get("ordernumber") != null) {
                DynamicObject orderInfo = BusinessDataServiceHelper.loadSingle((Object)entry.getDynamicObject("ordernumber").getPkValue(), (String)"mdr_saleorder");
                if (orderInfo != null) {
                    unpaidamount = orderInfo.getBigDecimal("amounttobepaid");
                    this.getModel().setValue(UNPAID_AMOUNT, (Object)unpaidamount);
                }
            } else {
                this.getModel().setValue(UNPAID_AMOUNT, (Object)unpaidamount);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs ags) {
        super.afterDoOperation(ags);
        String key = ags.getOperateKey();
        if ("save".equals(key) || "submit".equals(key)) {
            if (ags.getOperationResult().isSuccess()) {
                this.getView().close();
                this.getView().getParentView().invokeOperation("refresh");
            } else {
                throw new KDBizException(ags.getOperationResult().getMessage());
            }
        }
    }

    public void convertPk(ConvertPkEvent e) {
        super.convertPk(e);
        Map param = e.getDataObject();
        if (param == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7ebf\u4e0a\u7684\u6570\u636e\u4e3a\u7a7a,\u8bf7\u8054\u7cfb\u5ba2\u670d\u4eba\u5458\uff01", (String)"MoneyEnsureEditPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        Object ensureid = param.get("ensureid");
        DynamicObject ensureInfo = BusinessDataServiceHelper.loadSingle(ensureid, (String)"mdr_money_ensure");
        if (ensureInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ebf\u4e0a\u62c5\u4fdd\u5355\u5df2\u4e0d\u5b58\u5728\uff01", (String)"MoneyEnsureEditPlugin_2", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        Integer status = null;
        Map map = (Map)param.get("mapInfo");
        if (map != null) {
            if (map.get("payAmount") != null) {
                ensureInfo.set("payamount", map.get("payAmount"));
            }
            if (map.get("soUnSettleAmt") != null) {
                ensureInfo.set(UNPAID_AMOUNT, map.get("soUnSettleAmt"));
            }
            status = (Integer)map.get("billStatus");
        }
        if ((Integer)param.get("operation") > 0 && (status = (Integer)param.get("billStatus")) > 0) {
            switch (status) {
                case 50: {
                    ensureInfo.set("examinestatus", (Object)2);
                    break;
                }
                case 60: {
                    ensureInfo.set("examinestatus", (Object)3);
                }
            }
        }
        SaveServiceHelper.save((IDataEntityType)ensureInfo.getDataEntityType(), (Object[])new DynamicObject[]{ensureInfo});
    }

    public String getFormId() {
        return null;
    }

    public void setFormId(String arg0) {
    }
}

