/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.money;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.util.CustomerAdminUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrListPlugin;

public class MoneyEnsureListPlugin
extends MdrListPlugin {
    public static final String MODIFY = "btnmodify";
    public static final String BTN_SYN = "btnsyn";
    public static final String BTN_MOBLIE_MODIFY = "btnmbmodify";

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        String source = e.getSource().toString();
        String[] sourceArray = source.split("-");
        if (sourceArray.length > 0 && sourceArray[0].equals("MobileListView")) {
            return;
        }
        BillShowParameter parameter = e.getParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_MOBLIE_MODIFY});
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Object owenrid = UserUtil.getDefaultOwnerID();
        Object userid = UserUtil.getUserID();
        boolean isSaler = UserUtil.isSaler((Object)owenrid);
        boolean isAdmin = CustomerAdminUtil.isAdmin((Object)owenrid);
        List qFilters = e.getQFilters();
        if (!isSaler && !isAdmin) {
            QFilter qf = new QFilter("id", "=", (Object)0);
            qFilters.add(qf);
            e.setQFilters(qFilters);
            return;
        }
        QFilter f = new QFilter("id", ">", (Object)0);
        if (!isAdmin) {
            if (isSaler) {
                f.and("ensureperson.id", "=", userid);
            }
        } else {
            f.and("supply", "in", (Object)CustomerUtil.getAuthSubsIds((Object)owenrid));
        }
        qFilters.add(f);
        e.setQFilters(qFilters);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (MODIFY.equalsIgnoreCase(evt.getItemKey())) {
            this.modifyCheck();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_MOBLIE_MODIFY.equals(key)) {
            this.modifyCheck();
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        ListSelectedRowCollection selectRows = ((IListView)this.getView()).getSelectedRows();
        if (!this.ensurestatus(selectRows)) {
            evt.setCancel(true);
            this.getView().invokeOperation("view");
        }
    }

    private boolean ensurestatus(ListSelectedRowCollection selectRows) {
        boolean status = true;
        QFilter qFilter = new QFilter("id", "=", (Object)selectRows.getPrimaryKeyValues());
        QFilter[] filters = new QFilter[]{qFilter};
        DynamicObject[] entrys = BusinessDataServiceHelper.load((String)"mdr_money_ensure", (String)"examinestatus", (QFilter[])filters);
        if (entrys != null) {
            for (DynamicObject entry : entrys) {
                if (entry.get("examinestatus").equals("0")) continue;
                status = false;
            }
        }
        return status;
    }

    protected final ListSelectedRowCollection getSelectedRows() {
        BillList billList = (BillList)this.getControl("billlistap");
        return billList.getSelectedRows();
    }

    public void afterDoOperation(AfterDoOperationEventArgs ags) {
        String key;
        super.afterDoOperation(ags);
        switch (key = ags.getOperateKey()) {
            case "btnsyn": {
                this.getView().invokeOperation("refresh");
                if (ags.getOperationResult().isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f", (String)"MoneyEnsureListPlugin_0", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
                    break;
                }
                ags.getOperationResult().getMessage();
            }
        }
    }

    private void modifyCheck() {
        if (this.getSelectedRows().size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u7f16\u8f91\u7684\u6570\u636e", (String)"MoneyEnsureListPlugin_1", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
        if (!this.ensurestatus(this.getSelectedRows())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u4fdd\u5b58\u72b6\u6001\u4e0b\u7684\u624d\u80fd\u7f16\u8f91\uff01", (String)"MoneyEnsureListPlugin_2", (String)"drp-bbc-formplugin", (Object[])new Object[0]));
        }
    }
}

