/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.formplugin.returnorder;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dpa.formplugin.returnorder.ReturnOrderReqEditPlugin;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.enums.Status;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.common.util.WebUtil;

public class ReturnOrderEditPlugin
extends ReturnOrderReqEditPlugin {
    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if (entryName.equals("itementry")) {
            this.reCalRebAmountSum();
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObject assistBillType = (DynamicObject)this.getModel().getValue("assistbilltype");
        if (null == assistBillType && this.isGenerateOrder()) {
            this.setBillParameter();
        }
        this.initBillPropertiesLockByBillStatus();
        String area = this.getStringValue("area");
        if (StringUtils.isEmpty((String)area)) {
            this.setValue("area", 0);
        }
        if (Status.SAVED.toString().equalsIgnoreCase(this.getStringValue("billstatus"))) {
            this.lockEntryColumn();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        this.lockEntryColumn();
    }

    protected void unLockColumnIfNotPresentItem(int index) {
        super.unLockColumnIfNotPresentItem(index);
        this.lockEntryRowColumn(index);
    }

    private void lockEntryColumn() {
        int rowCount = this.getModel().getEntryRowCount("itementry");
        for (int i = 0; i < rowCount; ++i) {
            this.lockEntryRowColumn(i);
        }
    }

    private void lockEntryRowColumn(int index) {
        if (!this.isPresentItem(index)) {
            if (this.isHasTax()) {
                this.setEnable(index, new String[]{"taxprice"});
                this.setUnEnable(index, new String[]{"itemprice"});
            } else {
                this.setEnable(index, new String[]{"itemprice"});
                this.setUnEnable(index, new String[]{"taxprice"});
            }
        }
    }

    public QFilter getOwnerFilter() {
        QFilter customerFilter = WebUtil.getIdQFilter((Collection)UserUtil.getOwnerIDs());
        return customerFilter;
    }

    public QFilter getCustomerFilter() {
        DynamicObject owner = (DynamicObject)this.getValue("owner");
        if (StringUtils.isNotEmpty((Object)owner)) {
            Set authOwnerIDs = CustomerUtil.getAuthSubsIds((Object)owner.get("id"));
            return new QFilter("id", "in", (Object)authOwnerIDs);
        }
        return new QFilter("1", "=", (Object)"0");
    }

    protected void initDefaultVals() {
        List ownerIDs = UserUtil.getOwnerIDs();
        if (ownerIDs != null && ownerIDs.size() > 0) {
            this.setValue("owner", ownerIDs.get(0));
            this.setCustomerByOwner();
        }
        if (ownerIDs == null || ownerIDs.size() == 1) {
            this.setUnEnable(new String[]{"owner"});
        }
        super.setSaleOrg();
        this.setSaler();
    }

    public void clearCustomer() {
        this.clearTB(new String[]{"itementry"});
    }

    public void clearOwner() {
        this.setValue("customer", null, true);
        this.setValue("saler", null);
        this.clearCustomer();
    }

    protected void setSaleOrg() {
        DynamicObject owner = this.getOwnerF7Value();
        if (null != owner) {
            long bizGroup = owner.getLong("bizgroup.id");
            this.setValue("saleorg", bizGroup);
            this.setSettleOrg(this.getF7Value("saleorg"));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (key.equalsIgnoreCase("customer")) {
            if (null == this.getOwnerF7Value()) {
                e.setCancel(true);
                this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u201c\u9500\u552e\u6e20\u9053\u201d");
            }
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCustomerFilter());
        } else {
            super.beforeF7Select(e);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("owner".equalsIgnoreCase(key)) {
            this.clearOwner();
            this.setSaleOrg();
            this.setSaler();
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (newValue instanceof DynamicObject) {
                this.setCustomerByOwner();
            }
        } else {
            super.propertyChanged(e);
            if ("customer".equalsIgnoreCase(key)) {
                this.setSaler();
            }
            if ("hastax".equalsIgnoreCase(key)) {
                this.lockEntryColumn();
            }
            if ("qty".equalsIgnoreCase(key)) {
                this.reCalRebAmountSum();
            }
        }
    }

    private void reCalRebAmountSum() {
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObjectCollection coll = data.getDynamicObjectCollection("itementry");
        BigDecimal rebAmt = BigDecimal.ZERO;
        int currencyPrecision = 2;
        DynamicObject localcurrency = data.getDynamicObject("localcurrency");
        if (localcurrency != null) {
            currencyPrecision = localcurrency.getInt("amtprecision");
        }
        for (DynamicObject row : coll) {
            BigDecimal baseUnitReb = row.getBigDecimal("rebbackdeductamount");
            BigDecimal baseQty = row.getBigDecimal("baseqty");
            rebAmt = rebAmt.add(baseQty.multiply(baseUnitReb));
        }
        rebAmt = rebAmt.setScale(currencyPrecision, RoundingMode.HALF_UP);
        this.getModel().setValue("currentbackrebamount", (Object)rebAmt);
    }

    private void setCustomerByOwner() {
        DynamicObject owner = this.getOwnerF7Value();
        if (null != owner) {
            QFilter fs = new QFilter("authowner", "=", owner.getPkValue()).and("enable", "=", (Object)"1");
            DynamicObjectCollection customers = QueryServiceHelper.query((String)"mdr_customer_authorize", (String)String.join((CharSequence)",", "customer", "isdefault"), (QFilter[])fs.toArray(), (String)"isdefault desc");
            if (!CollectionUtils.isEmpty((Collection)customers)) {
                if (1 == customers.size()) {
                    this.setValue("customer", ((DynamicObject)customers.get(0)).get("customer"), true);
                } else if (((DynamicObject)customers.get(0)).getBoolean("isdefault")) {
                    this.setValue("customer", ((DynamicObject)customers.get(0)).get("customer"), true);
                }
            }
        }
    }
}

