/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.business.handle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;

public class SaleOrderUpgradeHandler {
    private DBRoute drpDBRoute;

    private DBRoute getDRPDBRoute() {
        if (this.drpDBRoute == null) {
            this.drpDBRoute = DBRoute.of((String)"drp");
        }
        return this.drpDBRoute;
    }

    public void upgrade() {
        Map<Long, Long> historySaleOrders = this.getHistorySaleOrders();
        if (CollectionUtils.isEmpty(historySaleOrders)) {
            return;
        }
        Map<Long, Long> orderIdAndSaleOrgId = this.assembledOrderIdAndSaleOrgId(historySaleOrders);
        this.doUpgradeSaleOrgIds(orderIdAndSaleOrgId);
    }

    private void doUpgradeSaleOrgIds(Map<Long, Long> orderIdAndSaleOrgIdMap) {
        StringBuilder saleOrderSql = new StringBuilder();
        StringBuilder saleOrderVerSql = new StringBuilder();
        saleOrderSql.append("UPDATE T_BBC_SALEORDER SET ");
        saleOrderVerSql.append("UPDATE T_BBC_SALEORDER_VER SET ");
        saleOrderSql.append("FSALEORGID = ? ");
        saleOrderVerSql.append("FSALEORGID = ? ");
        saleOrderSql.append(" WHERE FORDERID = ?");
        saleOrderVerSql.append(" WHERE FORDERID = ?");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(orderIdAndSaleOrgIdMap.size());
        ArrayList<Long> dataValue = null;
        for (Map.Entry<Long, Long> orderIdAndSaleOrgId : orderIdAndSaleOrgIdMap.entrySet()) {
            dataValue = new ArrayList<Long>(2);
            dataValue.add(orderIdAndSaleOrgId.getValue());
            dataValue.add(orderIdAndSaleOrgId.getKey());
            paramsList.add(dataValue.toArray());
        }
        if (!CollectionUtils.isEmpty(paramsList)) {
            DB.executeBatch((DBRoute)this.getDRPDBRoute(), (String)saleOrderSql.toString(), paramsList);
            DB.executeBatch((DBRoute)this.getDRPDBRoute(), (String)saleOrderVerSql.toString(), paramsList);
        }
    }

    private Map<Long, Long> assembledOrderIdAndSaleOrgId(Map<Long, Long> historySaleOrders) {
        Map<Object, Map<Object, Object>> relationCustomerInfos = this.getRelationCustomerInfos();
        Map<Object, Object> customerId2OrgIdMap = this.getCustomerId2OrgIdMap(relationCustomerInfos);
        Map<Object, Object> customerId2OrderCustomerIdMap = this.getCustomerId2OrderCustomerIdMap();
        Map<Long, Long> fixedCustomerAndBizGroupIdMap = this.getFixedCustomerAndBizGroupIdMap(relationCustomerInfos, customerId2OrgIdMap, customerId2OrderCustomerIdMap);
        return this.getFixedSaleOrderIdAndSaleOrgId(historySaleOrders, fixedCustomerAndBizGroupIdMap);
    }

    private Map<Long, Long> getFixedSaleOrderIdAndSaleOrgId(Map<Long, Long> historySaleOrders, Map<Long, Long> fixedCustomerAndBizGroupIdMap) {
        HashMap<Long, Long> fixedOrderIdAndOrgId = new HashMap<Long, Long>();
        for (Map.Entry<Long, Long> entry : historySaleOrders.entrySet()) {
            Long saleOrgId = fixedCustomerAndBizGroupIdMap.get(entry.getValue());
            if (null == saleOrgId) continue;
            fixedOrderIdAndOrgId.putIfAbsent(entry.getKey(), saleOrgId);
        }
        return fixedOrderIdAndOrgId;
    }

    private Map<Long, Long> getFixedCustomerAndBizGroupIdMap(Map<Object, Map<Object, Object>> relationCustomerInfos, Map<Object, Object> customerId2OrgIdMap, Map<Object, Object> customerId2OrderCusotmerIdMap) {
        long defaultSaleOrgId = 100000L;
        HashMap<Long, Long> fixedMap = new HashMap<Long, Long>(customerId2OrgIdMap.size());
        for (Map.Entry<Object, Map<Object, Object>> relationCustomer : relationCustomerInfos.entrySet()) {
            boolean isinnerorg = "1".equals(relationCustomer.getValue().get("FISINNERORG"));
            Long customerId = (Long)relationCustomer.getKey();
            if (isinnerorg) {
                if (null != customerId2OrgIdMap.get(customerId)) {
                    fixedMap.putIfAbsent(customerId, (Long)customerId2OrgIdMap.get(customerId));
                    continue;
                }
                fixedMap.putIfAbsent(customerId, defaultSaleOrgId);
                continue;
            }
            Object orderCustomerId = this.getOrderCustomerId(customerId, customerId2OrderCusotmerIdMap);
            if (null != customerId2OrgIdMap.get(orderCustomerId)) {
                fixedMap.putIfAbsent(customerId, (Long)customerId2OrgIdMap.get(orderCustomerId));
                continue;
            }
            fixedMap.putIfAbsent(customerId, defaultSaleOrgId);
        }
        return fixedMap;
    }

    private Object getOrderCustomerId(Object customerId, Map<Object, Object> customerId2OrderCustomerIdMap) {
        Object result = customerId2OrderCustomerIdMap.get(customerId);
        return null == result ? Long.valueOf(0L) : result;
    }

    private Map<Long, Long> getHistorySaleOrders() {
        return (Map)DB.query((DBRoute)this.getDRPDBRoute(), (String)"SELECT FORDERID, FOWNERID FROM T_BBC_SALEORDER WHERE FSALEORGID = 0", rs -> {
            HashMap<Long, Long> result = new HashMap<Long, Long>(1024);
            while (rs.next()) {
                result.put(rs.getLong("FORDERID"), rs.getLong("FOWNERID"));
            }
            return result;
        });
    }

    private Map<Object, Map<Object, Object>> getRelationCustomerInfos() {
        return (Map)DB.query((DBRoute)this.getDRPDBRoute(), (String)"SELECT FCUSTOMERID,FPARTNERID,FISINNERORG FROM T_MDR_CUSTOMER WHERE FCUSTOMERID IN (SELECT FOWNERID FROM T_BBC_SALEORDER WHERE FSALEORGID = 0 GROUP BY FOWNERID)", rs -> {
            HashMap customerInfos = new HashMap();
            HashMap<String, Object> result = null;
            while (rs.next()) {
                result = new HashMap<String, Object>();
                result.put("FCUSTOMERID", rs.getLong("FCUSTOMERID"));
                result.put("FPARTNERID", rs.getLong("FPARTNERID"));
                result.put("FISINNERORG", rs.getObject("FISINNERORG"));
                customerInfos.putIfAbsent(rs.getLong("FCUSTOMERID"), result);
            }
            return customerInfos;
        });
    }

    private Map<Object, Object> getCustomerId2OrgIdMap(Map<Object, Map<Object, Object>> customers) {
        Map<Object, Object> customerId2PartnerIdMap = this.getCustomerId2PartnerIdMap(customers);
        if (!customerId2PartnerIdMap.isEmpty()) {
            HashSet<Object> partnerIds = new HashSet<Object>();
            partnerIds.addAll(customerId2PartnerIdMap.values());
            if (partnerIds.contains(null)) {
                partnerIds.remove(null);
            }
            Map<Object, Object> partnerId2InternalCompanyIdMap = this.getPartnerId2InternalCompanyIdMap(partnerIds.toArray());
            Object partnerId = null;
            Object orgId = null;
            for (Map.Entry<Object, Object> customerId2PartnerIdEntry : customerId2PartnerIdMap.entrySet()) {
                partnerId = customerId2PartnerIdEntry.getValue();
                if (partnerId == null || (orgId = partnerId2InternalCompanyIdMap.get(partnerId)) == null) continue;
                customerId2PartnerIdEntry.setValue(orgId);
            }
        }
        return customerId2PartnerIdMap;
    }

    private Map<Object, Object> getPartnerId2InternalCompanyIdMap(Object[] partnerIds) {
        if (null == partnerIds || 1 > partnerIds.length) {
            return new HashMap<Object, Object>(0);
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>(partnerIds.length);
        String algokey = this.getClass().getName();
        DataSet ds = QueryServiceHelper.queryDataSet((String)algokey, (String)"bd_bizpartner", (String)F7Utils.appendSelectCols((String)"id", (String[])new String[]{"internal_company.id"}), (QFilter[])new QFilter("id", "in", (Object)partnerIds).toArray(), null);
        for (Row row : ds) {
            result.put(row.get(0), row.get(1));
        }
        return result;
    }

    private Map<Object, Object> getCustomerId2PartnerIdMap(Map<Object, Map<Object, Object>> customers) {
        if (CollectionUtils.isEmpty(customers) || CollectionUtils.isEmpty(customers.values())) {
            return new HashMap<Object, Object>(0);
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>(customers.size());
        for (Map<Object, Object> customer : customers.values()) {
            map.put(customer.get("FCUSTOMERID"), customer.get("FPARTNERID"));
        }
        return map;
    }

    private Map<Object, Object> getCustomerId2OrderCustomerIdMap() {
        StringBuilder sql = new StringBuilder(256);
        sql.append("SELECT T1.FCUSTOMERID,T1.FAUTHOWNERID ");
        sql.append("FROM T_MDR_CUSTOMER_AUTHORIZE T1 ");
        sql.append("INNER JOIN T_MDR_CUSTOMER T2 ON T1.FAUTHOWNERID = T2.FCUSTOMERID ");
        sql.append("WHERE T2.FISINNERORG = '1' ");
        return (Map)DB.query((DBRoute)this.getDRPDBRoute(), (String)sql.toString(), rs -> {
            HashMap<Long, Long> result = new HashMap<Long, Long>(128);
            while (rs.next()) {
                result.put(rs.getLong("FCUSTOMERID"), rs.getLong("FAUTHOWNERID"));
            }
            return result;
        });
    }
}

