/*
 * Decompiled with CFR 0.152.
 */
package gds.drp.bbc.opplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.iAlgorithm.LocalPageCache;
import kd.drp.mdr.iAlgorithm.OrderAlgorithm;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class SaleOrderDividePlugin
extends MdrBaseOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        if (this.isFromListPage()) {
            return;
        }
        DynamicObject saleorder = e.getDataEntities()[0];
        DynamicObjectCollection entrys = saleorder.getDynamicObjectCollection("itementry");
        BigDecimal oldamount = BigDecimal.ZERO;
        BigDecimal newamount = BigDecimal.ZERO;
        int maxindex = 0;
        BigDecimal maxamount = BigDecimal.ZERO;
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            BigDecimal amount = this.getAmount(entry);
            if (entry.getDynamicObject("presenttype") == null) {
                newamount = newamount.add(amount);
            }
            if (amount.compareTo(maxamount) >= 0) {
                maxindex = i;
                maxamount = amount;
            }
            oldamount = oldamount.add(amount);
        }
        BigDecimal totaldivideamount = BigDecimal.ZERO;
        int scale = saleorder.getDynamicObject("currency").getInt("amtprecision");
        for (int i = 0; i < entrys.size(); ++i) {
            if (i == maxindex) continue;
            DynamicObject entry = (DynamicObject)entrys.get(i);
            totaldivideamount = totaldivideamount.add(this.divideAndSetAmount(entry, oldamount, newamount, scale));
        }
        this.setAmount((DynamicObject)entrys.get(maxindex), newamount.subtract(totaldivideamount));
        this.reCalWholeOrderByItemAmount(saleorder);
        String msg = OperationUtil.invokeOperationToStr((DynamicObject)saleorder, (String)"save");
        if (StringUtils.isNotEmpty((String)msg)) {
            throw new KDBizException(msg);
        }
    }

    private BigDecimal divideAndSetAmount(DynamicObject entry, BigDecimal oldamount, BigDecimal newamoumt, int scale) {
        BigDecimal dividedamount = this.getAmount(entry).multiply(newamoumt).divide(oldamount, scale, RoundingMode.HALF_UP);
        this.setAmount(entry, dividedamount);
        return dividedamount;
    }

    private void setAmount(DynamicObject entry, BigDecimal amount) {
        entry.set("itemamount", (Object)amount);
        entry.set("promotionamount", (Object)amount);
        entry.set("rebateamount", (Object)amount);
        entry.set("taxAmount", (Object)amount);
        entry.set("discountamount", (Object)this.getAmount(entry).subtract(amount));
        entry.set("discounttype", (Object)"A");
    }

    private BigDecimal getAmount(DynamicObject entry) {
        return entry.getBigDecimal("qty").multiply(entry.getBigDecimal("taxprice"));
    }

    private void reCalWholeOrderByItemAmount(DynamicObject saleorder) {
        OrderAlgorithm al = new OrderAlgorithm(saleorder, (IPageCache)new LocalPageCache());
        for (int i = 0; i < al.getEntrySize(); ++i) {
            al.calDiscountByDiscountAmount(i);
            al.calItemAmount(i);
        }
        al.calDealPriceAmount();
        al.calTotalFields();
    }
}

