/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.delivery;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.util.DeliveryUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class DeliveryRecordSavePlugin
extends MdrBaseOperationServicePlugIn {
    private static final String ENTITYID = "bbc_delivery_record";
    private static final String MOVEDIRECT = "A";
    private static final String DELIVERYDETAIL = "deliverydetail";
    private static final String SNSTATUS = "1";
    private static final String SUBENTRYENTITY = "subentryentity";
    private static final String BILLTYPE_SALOUTBILL = "saloutbill";

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        if ("save".equals(e.getOperationKey()) || "submit".equals(e.getOperationKey())) {
            DynamicObject[] dataEntities = e.getDataEntities();
            DynamicObject brand = null;
            for (int i = 0; i < dataEntities.length; ++i) {
                brand = dataEntities[i];
                DynamicObjectCollection deliverydetails = brand.getDynamicObjectCollection(DELIVERYDETAIL);
                HashSet<Long> soeids = new HashSet<Long>();
                for (DynamicObject dd : deliverydetails) {
                    soeids.add(dd.getLong("mainbillentryid"));
                }
                brand.set("billstatus", (Object)"B");
                String easIssueBillid = brand.getString("easissuebillid");
                if (StringUtils.isNotEmpty((String)easIssueBillid)) {
                    QFilter filter = new QFilter("easissuebillid", "=", (Object)easIssueBillid);
                    DynamicObjectCollection deliveryRecordCollection = QueryServiceHelper.query((String)ENTITYID, (String)"id", (QFilter[])(filter = filter.and(new QFilter("deliverydetail.mainbillentryid", "in", soeids))).toArray());
                    if (deliveryRecordCollection != null && deliveryRecordCollection.size() > 0) {
                        e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524dEAS\u8ba2\u5355\u5df2\u7ecf\u751f\u6210\u53d1\u8d27\u8bb0\u5f55\uff0c\u4e0d\u91cd\u590d\u751f\u6210\uff01", (String)"DeliveryRecordSavePlugin_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
                        e.cancel = true;
                        return;
                    }
                }
                this.orderCheck(brand);
                boolean isautosigndeliveryrecord = brand.getBoolean("isautosigndeliveryrecord");
                if (!isautosigndeliveryrecord) continue;
                brand.set("signstatus", (Object)SNSTATUS);
                brand.set("billstatus", (Object)"C");
                brand.set("signer", UserUtil.getUserID());
                brand.set("signtime", (Object)new Date());
                DynamicObjectCollection deliveryDetails = brand.getDynamicObjectCollection(DELIVERYDETAIL);
                for (DynamicObject deliveryDetail : deliveryDetails) {
                    BigDecimal deliverqty = (BigDecimal)deliveryDetail.get("deliverqty");
                    deliveryDetail.set("signQty", (Object)deliverqty);
                }
                brand.set(DELIVERYDETAIL, (Object)deliveryDetails);
            }
        }
    }

    private void orderCheck(DynamicObject brand) {
        DynamicObjectCollection deliverydetailCollection = brand.getDynamicObjectCollection(DELIVERYDETAIL);
        if (deliverydetailCollection.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51fa\u5e93\u5931\u8d25\uff0c\u672a\u8bbe\u7f6e\u53d1\u8d27\u6570\u91cf\uff0c\u8bf7\u5148\u8bbe\u7f6e\u5546\u54c1\u672c\u6b21\u53d1\u8d27\u6570\u91cf\uff01", (String)"DeliveryRecordSavePlugin_1", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        HashSet<Long> mainBillIds = new HashSet<Long>(deliverydetailCollection.size());
        for (DynamicObject deliveryDetail : deliverydetailCollection) {
            if (deliveryDetail.getLong("mainbillid") <= 0L) continue;
            mainBillIds.add(deliveryDetail.getLong("mainbillid"));
        }
        DynamicObject[] orders = null;
        DynamicObject order = new DynamicObject();
        DynamicObjectCollection itementry = null;
        Map ordersMap = null;
        Map itementryMap = null;
        if ("dispatchorder".equals(brand.get("sourcebilltype"))) {
            orders = BusinessDataServiceHelper.load((Object[])mainBillIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"mdr_dispatch_order"));
        } else if ("saleorder".equals(brand.get("sourcebilltype"))) {
            orders = BusinessDataServiceHelper.load((Object[])mainBillIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bbc_saleorder"));
        } else {
            if ("oemorder".equals(brand.get("sourcebilltype"))) {
                return;
            }
            if (BILLTYPE_SALOUTBILL.equals(brand.get("sourcebilltype"))) {
                return;
            }
        }
        ordersMap = DeliveryUtil.array2Map((String)"id", (DynamicObject[])orders);
        boolean isUncontrlDeliveryQty = SysParamsUtil.isUnContrlDeliveyQTY();
        int j = 0;
        while (j < deliverydetailCollection.size()) {
            DynamicObject deliverydetail = (DynamicObject)deliverydetailCollection.get(j);
            BigDecimal deliverqty = (BigDecimal)deliverydetail.get("deliverqty");
            if (deliverqty == null || BigDecimal.ZERO.compareTo(deliverqty) == 0) {
                deliverydetailCollection.remove(j);
                continue;
            }
            if (BigDecimal.ZERO.compareTo(deliverqty) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u51fa\u5e93\u5931\u8d25\uff0c\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\uff0c\u8bf7\u786e\u8ba4\u6570\u76ee\u540e\u518d\u53d1\u8d27\uff01", (String)"DeliveryRecordSavePlugin_2", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            order = (DynamicObject)ordersMap.get(deliverydetail.get("mainbillid"));
            itementry = order.getDynamicObjectCollection("itementry");
            itementryMap = CommonUtils.collection2Map((String)"id", (List)itementry);
            this.dataInit(itementryMap, deliverydetail, deliverqty, isUncontrlDeliveryQty, brand.getString("sourcebilltype"));
            deliverydetailCollection.set(j, (Object)deliverydetail);
            ++j;
        }
    }

    private void dataInit(Map<Object, DynamicObject> itementryMap, DynamicObject deliverydetail, BigDecimal deliverqty, boolean isUncontrlDeliveryQty, String billType) {
        Object entryreceivewarehouse;
        Object entrywarehouse;
        Object assistattr;
        String orderentryId = deliverydetail.getString("mainbillentryid");
        if (orderentryId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51fa\u5e93\u5931\u8d25\uff0c\u83b7\u53d6\u8ba2\u5355\u5206\u5f55\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"DeliveryRecordSavePlugin_3", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        DynamicObject orderentry = itementryMap.get(Long.parseLong(orderentryId));
        if (orderentry == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51fa\u5e93\u5931\u8d25\uff0c\u83b7\u53d6\u8ba2\u5355\u5206\u5f55\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"DeliveryRecordSavePlugin_3", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        BigDecimal qty = orderentry.getBigDecimal("qty");
        BigDecimal deliveredqty = orderentry.getBigDecimal("deliveredqty");
        if (qty == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51fa\u5e93\u5931\u8d25\uff0c\u83b7\u53d6\u8ba2\u5355\u5206\u5f55\u6570\u91cf\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"DeliveryRecordSavePlugin_4", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        if (deliveredqty != null) {
            qty = qty.subtract(deliveredqty);
        }
        if (!isUncontrlDeliveryQty && qty.compareTo(deliverqty) < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51fa\u5e93\u5931\u8d25\uff0c\u5f53\u524d\u53d1\u8d27\u6570\u91cf\u52a0\u4e0a\u5df2\u53d1\u8d27\u6570\u91cf\u5927\u4e8e\u8ba2\u8d27\u6570\u91cf\uff0c\u4e0d\u5141\u8bb8\u8d85\u91cf\u53d1\u8d27\uff01", (String)"DeliveryRecordSavePlugin_5", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        if (deliverydetail.get("item") == null) {
            Object item = orderentry.get("item");
            if (item == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u51fa\u5e93\u5931\u8d25\uff0c\u83b7\u53d6\u8ba2\u5355\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"DeliveryRecordSavePlugin_6", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            deliverydetail.set("item", item);
        }
        if (deliverydetail.get("unit") == null) {
            Object unit = orderentry.get("unit");
            if (unit == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u51fa\u5e93\u5931\u8d25\uff0c\u83b7\u53d6\u8ba2\u5355\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"DeliveryRecordSavePlugin_7", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            deliverydetail.set("unit", unit);
        }
        if (deliverydetail.get("assistattr") == null && (assistattr = orderentry.get("assistattr")) != null) {
            deliverydetail.set("assistattr", assistattr);
        }
        if (deliverydetail.get("warehouse") == null && (entrywarehouse = orderentry.get("entrywarehouse")) != null) {
            deliverydetail.set("warehouse", entrywarehouse);
        }
        if (deliverydetail.get("receivewarehouse") == null && (entryreceivewarehouse = orderentry.get("entryreceivewarehouse")) != null) {
            deliverydetail.set("receivewarehouse", entryreceivewarehouse);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        if ("save".equals(e.getOperationKey()) || "submit".equals(e.getOperationKey())) {
            DynamicObject[] dataEntities = e.getDataEntities();
            DynamicObject deliveryRecord = null;
            for (int i = 0; i < dataEntities.length; ++i) {
                deliveryRecord = dataEntities[i];
                DeliveryUtil.send((DynamicObject)deliveryRecord, (boolean)false);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] deliverRecords = e.getDataEntities();
        if (deliverRecords != null && deliverRecords.length > 0) {
            ArrayList<DynamicObject> deliverList = new ArrayList<DynamicObject>(deliverRecords.length);
            for (DynamicObject dynamicObject : deliverRecords) {
                if (!BILLTYPE_SALOUTBILL.equals(dynamicObject.getString("sourcebilltype"))) continue;
                deliverList.add(dynamicObject);
            }
            if (deliverList.size() > 0) {
                Map<Object, Object> lotMap = this.getItemLots(deliverList);
                Map<Object, Object> snmainMap = this.getItemSnmains(deliverList, lotMap);
                this.saveSnMainFile(deliverList, snmainMap);
                SaveServiceHelper.update((DynamicObject[])e.getDataEntities());
            }
        }
    }

    private Map<Object, Object> getItemLots(List<DynamicObject> deliverList) {
        if (deliverList != null && deliverList.size() > 0) {
            ArrayList<JSONObject> lotJsonObjList = new ArrayList<JSONObject>(16);
            for (DynamicObject dynamicObject : deliverList) {
                this.getItemJsonList(lotJsonObjList, dynamicObject);
            }
            if (lotJsonObjList.size() == 0) {
                return new HashMap<Object, Object>(0);
            }
            List resultJsons = (List)DispatchServiceHelper.invokeBizService((String)"drp", (String)"ocic", (String)"LotService", (String)"saveLot", (Object[])new Object[]{lotJsonObjList});
            if (resultJsons == null || resultJsons.size() == 0) {
                return new HashMap<Object, Object>(0);
            }
            Map<Object, Object> lotMap = resultJsons.stream().collect(Collectors.toMap(i -> i.get((Object)"lotnumber").toString() + "_" + i.get((Object)"billentryid").toString(), i -> i.get((Object)"lotid")));
            return lotMap;
        }
        return new HashMap<Object, Object>(0);
    }

    private List<JSONObject> getItemJsonList(List<JSONObject> lotJsonObjList, DynamicObject deliverRecord) {
        if (deliverRecord != null) {
            DynamicObjectCollection deliveryDetails = deliverRecord.getDynamicObjectCollection(DELIVERYDETAIL);
            if (deliveryDetails == null || deliveryDetails.size() == 0) {
                return lotJsonObjList;
            }
            for (DynamicObject deliveryDetail : deliveryDetails) {
                if (!this.checkParams(deliveryDetail)) continue;
                JSONObject jsonobj = new JSONObject();
                jsonobj.put("number", deliveryDetail.get("lotnumber"));
                jsonobj.put("scmlotid", deliveryDetail.get("scmlot"));
                jsonobj.put("itemid", deliveryDetail.get("item_id"));
                jsonobj.put("materialid", deliveryDetail.get("material_id"));
                jsonobj.put("auxptyid", deliveryDetail.get("auxpty_id"));
                jsonobj.put("productdate", deliveryDetail.get("producedate"));
                jsonobj.put("expiredate", deliveryDetail.get("expirydate"));
                jsonobj.put("movedirect", (Object)MOVEDIRECT);
                jsonobj.put("billentityid", (Object)ENTITYID);
                jsonobj.put("billno", deliverRecord.get("billno"));
                jsonobj.put("billdate", deliverRecord.get("createtime"));
                jsonobj.put("qty", deliveryDetail.get("deliverqty"));
                jsonobj.put("unit", deliveryDetail.get("unit_id"));
                jsonobj.put("billid", deliverRecord.get("id"));
                jsonobj.put("billentryid", deliveryDetail.get("id"));
                jsonobj.put("channelid", deliveryDetail.get("orderchannelid.id"));
                lotJsonObjList.add(jsonobj);
            }
        }
        return lotJsonObjList;
    }

    private boolean checkParams(DynamicObject deliveryDetail) {
        boolean result = true;
        if (deliveryDetail.get("lotnumber") == null) {
            result = false;
        }
        return result;
    }

    private Map<Object, Object> getItemSnmains(List<DynamicObject> deliverList, Map<Object, Object> lotMap) {
        if (deliverList != null && deliverList.size() > 0) {
            ArrayList<JSONObject> jsonObjList = new ArrayList<JSONObject>(16);
            for (DynamicObject dynamicObject : deliverList) {
                this.getItemSnmainJsonList(dynamicObject, lotMap, jsonObjList);
            }
            if (jsonObjList.size() == 0) {
                return new HashMap<Object, Object>(0);
            }
            List resultJsons = (List)DispatchServiceHelper.invokeBizService((String)"drp", (String)"ocic", (String)"SnMainFileService", (String)"saveSnMainFile", (Object[])new Object[]{jsonObjList});
            if (resultJsons == null || resultJsons.size() == 0) {
                return new HashMap<Object, Object>(0);
            }
            Map<Object, Object> map = resultJsons.stream().collect(Collectors.toMap(i -> i.get((Object)"snmainfilenumber"), i -> i.get((Object)"snmainfileid")));
            return map;
        }
        return new HashMap<Object, Object>(0);
    }

    private List<JSONObject> getItemSnmainJsonList(DynamicObject deliverRecord, Map<Object, Object> lotMap, List<JSONObject> jsonObjList) {
        if (deliverRecord != null) {
            DynamicObjectCollection deliveryDetails = deliverRecord.getDynamicObjectCollection(DELIVERYDETAIL);
            if (deliveryDetails == null || deliveryDetails.size() == 0) {
                return jsonObjList;
            }
            for (DynamicObject deliveryDetail : deliveryDetails) {
                String lotKey = deliveryDetail.getString("lotnumber") + "_" + deliveryDetail.get("id");
                deliveryDetail.set("ociclot", lotMap.get(lotKey));
                DynamicObjectCollection subentrys = deliveryDetail.getDynamicObjectCollection(SUBENTRYENTITY);
                for (DynamicObject subentry : subentrys) {
                    JSONObject jsonobj = new JSONObject();
                    jsonobj.put("number", subentry.get("serialnumber"));
                    jsonobj.put("materialid", deliveryDetail.get("material_id"));
                    jsonobj.put("itemid", deliveryDetail.get("item_id"));
                    jsonobj.put("snstatus", (Object)SNSTATUS);
                    jsonobj.put("scmsnid", subentry.get("scmserialid"));
                    jsonobj.put("lotid", lotMap.get(lotKey));
                    jsonobj.put("lotnum", deliveryDetail.get("lotnumber"));
                    jsonobj.put("auxptyid", deliveryDetail.get("auxpty_id"));
                    jsonobj.put("productdate", deliveryDetail.get("producedate"));
                    jsonobj.put("effectivedate", deliveryDetail.get("expirydate"));
                    jsonobj.put("movedirect", (Object)MOVEDIRECT);
                    jsonobj.put("billentityid", (Object)ENTITYID);
                    jsonobj.put("billno", deliverRecord.get("billno"));
                    jsonobj.put("billdate", deliverRecord.get("createtime"));
                    jsonobj.put("movedate", deliverRecord.get("createtime"));
                    jsonobj.put("billid", deliverRecord.get("id"));
                    jsonobj.put("billentryid", deliveryDetail.get("id"));
                    jsonobj.put("channelid", deliveryDetail.get("orderchannelid.id"));
                    jsonObjList.add(jsonobj);
                }
            }
        }
        return jsonObjList;
    }

    private void saveSnMainFile(List<DynamicObject> deliverList, Map<Object, Object> snMainMap) {
        if (deliverList == null || deliverList.size() == 0) {
            return;
        }
        for (DynamicObject deliverRecord : deliverList) {
            DynamicObjectCollection deliveryDetails = deliverRecord.getDynamicObjectCollection(DELIVERYDETAIL);
            if (deliveryDetails == null || deliveryDetails.size() == 0) continue;
            for (DynamicObject deliveryDetail : deliveryDetails) {
                DynamicObjectCollection subentrys = deliveryDetail.getDynamicObjectCollection(SUBENTRYENTITY);
                for (DynamicObject subentry : subentrys) {
                    subentry.set("ocicserialid", snMainMap.get(subentry.get("serialnumber")));
                }
            }
        }
    }
}

