/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.dispatchorder;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.jobthread.AllotDispatchOrderThread;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class AutoAllotDispatchOrderPlugin
extends MdrBaseOperationServicePlugIn {
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"allotDispatchOrder", (int)12);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        ArrayList<String> orderStatus = new ArrayList<String>();
        orderStatus.add(SaleOrderStatus.TEMP_SAVE.getFlagStr());
        orderStatus.add(SaleOrderStatus.SUBMITTED.getFlagStr());
        orderStatus.add(SaleOrderStatus.PENDING_DISPATCH.getFlagStr());
        orderStatus.add(SaleOrderStatus.PART_DISPATCH.getFlagStr());
        orderStatus.add(SaleOrderStatus.DISPATCHED.getFlagStr());
        QFilter fs = new QFilter("orderstatus", "not in", orderStatus);
        DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)"mdr_saleorder", (String)"id,billno", (QFilter[])fs.toArray());
        HashMap<Object, Object> billMap = new HashMap<Object, Object>();
        int count = 1;
        for (int i = 0; i < sourceBills.size(); ++i) {
            DynamicObject sourceBill = (DynamicObject)sourceBills.get(i);
            if (count > 100 || i == sourceBills.size() - 1) {
                if (!billMap.isEmpty()) {
                    threadPool.execute((Runnable)new AllotDispatchOrderThread(RequestContext.get(), billMap));
                }
                billMap.clear();
                count = 1;
            }
            billMap.put(sourceBill.get("id"), sourceBill.get("billno"));
            ++count;
        }
    }
}

