/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.dispatchorder;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.handler.DispatchOrderHandler;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.status.DispatchOrderConfirmStatus;
import kd.drp.mdr.common.status.DispatchOrderStatus;
import kd.drp.mdr.common.status.DispatchOrderSyncStatus;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.util.DispatchOrderUtil;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.SynDispatchOrderUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class DispatchOrderSavePlugin
extends MdrBaseOperationServicePlugIn {
    private volatile boolean isAuditThenSync = false;
    private volatile boolean isOpenEasSync = false;
    private volatile boolean isUnWriteConfirmQty = false;
    private volatile boolean isNeedConfirmAfterAllot = false;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("orderstatus");
        fieldKeys.add("sync");
        fieldKeys.add("customer");
        fieldKeys.add("owner");
        fieldKeys.add("itementry.item");
        fieldKeys.add("itementry.unit");
        fieldKeys.add("itementry.assistattr");
        fieldKeys.add("itementry.qty");
        fieldKeys.add("itementry.sourceentryid");
        fieldKeys.add("itementry.sourcebillid");
        fieldKeys.add("itementry.entrywarehouse");
        fieldKeys.add("biztype.isupdatestore");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        CheckResult result = this.checkOrderData(datas);
        if (!result.isSuccess()) {
            e.cancel = true;
            e.setCancelMessage(result.getMsg());
            return;
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        switch (key) {
            case "save": {
                this.handleSave(datas);
                break;
            }
            case "submit": {
                this.handleSubmit(datas);
                break;
            }
            case "audit": {
                this.handleAudit(datas);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        switch (key) {
            case "audit": {
                this.handleAfterAudit(datas);
            }
        }
    }

    private void handleAfterAudit(DynamicObject[] datas) {
        boolean isNeedSync = this.isOpenEasSync && this.isAuditThenSync && "dispatchorder".equals(SysParamsUtil.getTosyncbill());
        for (int i = 0; i < datas.length; ++i) {
            if (isNeedSync) {
                SynDispatchOrderUtil.SynSaleOrder((Object)datas[i].get("id"));
            }
            this.unWriteQty4Audit(datas[i]);
        }
    }

    private CheckResult checkOrderData(DynamicObject[] datas) {
        if (this.isFromListPage()) {
            return CheckResult.returnTrue();
        }
        CheckResult result = null;
        for (DynamicObject data : datas) {
            result = this.checkOrderEntryData(data);
            if (result.isSuccess()) continue;
            return result;
        }
        return CheckResult.returnTrue();
    }

    private CheckResult checkOrderEntryData(DynamicObject data) {
        DynamicObjectCollection entry = data.getDynamicObjectCollection("itementry");
        if (entry.size() == 0) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u81f3\u5c11\u8981\u6709\u4e00\u6761\u5206\u5f55\uff01", (String)"DispatchOrderSavePlugin_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        BigDecimal qty = null;
        int index = 1;
        for (DynamicObject tow : entry) {
            qty = tow.getBigDecimal("qty");
            if (!DispatchOrderStatus.CHANGING.getFlagStr().equals(data.getString("orderstatus")) && qty.compareTo(BigDecimal.ZERO) <= 0) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5546\u54c1\u5206\u5f55%s\uff1a\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0", (String)"DispatchOrderSavePlugin_1", (String)"drp-bbc-opplugin", (Object[])new Object[0]), (Object[])new Object[]{index});
            }
            ++index;
        }
        return CheckResult.returnTrue();
    }

    private void handleSave(DynamicObject[] datas) {
        this.isNeedConfirmAfterAllot = SysParamsUtil.isNeedConfirmAfterAllot();
        for (DynamicObject order : datas) {
            if (DispatchOrderStatus.CHANGING.getFlagStr().equals(order.getString("orderstatus"))) {
                this.updateSaleOrderByAleter(order);
                DispatchOrderHandler.reHandleOrderQtysAndAmounts((DynamicObject)order, (String)"orderamount");
                Date receivableDate = order.getDate("receivabledate");
                if (receivableDate != null) {
                    DispatchOrderHandler.changeReceivableDate((DynamicObject)order);
                }
                DispatchOrderHandler.reHandleOrderPayStatus((DynamicObject)order);
                DispatchOrderHandler.handleStatusAfterSignOrDelivery((DynamicObject)order);
                DispatchOrderHandler.handleOrderIsOverByQty((DynamicObject)order);
                boolean isCustomerConfirmChange = SysParamsUtil.isCustomerConfirmChange();
                if (!isCustomerConfirmChange) continue;
                DispatchOrderHandler.setOrderStatus((DynamicObject)order, (DispatchOrderStatus)DispatchOrderStatus.CHANGING);
                continue;
            }
            this.unWriteQty4SaveAndSubmit(order);
            if (!this.isNeedConfirmAfterAllot || !DispatchOrderConfirmStatus.EMPTY.getFlagStr().equals(order.getString("confirmstatus"))) continue;
            order.set("confirmstatus", (Object)DispatchOrderConfirmStatus.ALLOTSENDED.getFlagStr());
        }
    }

    private void unWriteQty4SaveAndSubmit(DynamicObject data) {
        HashMap<Object, BigDecimal> saleOrderTamountMap = new HashMap<Object, BigDecimal>();
        DynamicObject order = data;
        DynamicObjectCollection entry = order.getDynamicObjectCollection("itementry");
        BigDecimal qty = null;
        BigDecimal allotenQty = null;
        Object entryId = null;
        Object sourceEntryId = null;
        Object sourceBillId = null;
        DynamicObjectCollection dispatchorderentry = null;
        Map dispatchorderentryMap = null;
        DynamicObject cartItem4dispatchorder = null;
        DynamicObject cartItem4saleorder = null;
        for (DynamicObject tow : entry) {
            if (sourceBillId == null) {
                sourceBillId = tow.get("sourcebillid");
                dispatchorderentry = QueryServiceHelper.query((String)"mdr_dispatchorder_entry", (String)"id,sourceentryid,qty", (QFilter[])new QFilter("order", "=", order.getPkValue()).toArray());
                dispatchorderentryMap = CommonUtils.collection2Map((String)"id", (List)dispatchorderentry);
            }
            qty = tow.getBigDecimal("qty");
            sourceEntryId = tow.get("sourceentryid");
            entryId = tow.getPkValue();
            if (dispatchorderentryMap.containsKey(entryId)) {
                dispatchorderentryMap.remove(entryId);
            }
            BigDecimal dValue = qty;
            cartItem4saleorder = BusinessDataServiceHelper.loadSingle((Object)sourceEntryId, (String)"mdr_saleorder_entry");
            BigDecimal saleorderQty = cartItem4saleorder.getBigDecimal("qty");
            allotenQty = cartItem4saleorder.getBigDecimal("allotenqty");
            if (entryId != null && (cartItem4dispatchorder = QueryServiceHelper.queryOne((String)"mdr_dispatchorder_entry", (String)"qty", (QFilter[])new QFilter("id", "=", entryId).toArray())) != null) {
                dValue = qty.subtract(cartItem4dispatchorder.getBigDecimal("qty"));
            }
            if ((allotenQty = allotenQty.add(dValue)).compareTo(saleorderQty) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u5df2\u5206\u8d27\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u786e\u8ba4\u6570\u91cf\uff01", (String)"DispatchOrderSavePlugin_2", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            cartItem4saleorder.set("allotenqty", (Object)allotenQty);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cartItem4saleorder});
        }
        if (dispatchorderentryMap != null) {
            this.unWriteQty4Delete(dispatchorderentryMap, dispatchorderentry);
        }
        DynamicObject saleorder = BusinessDataServiceHelper.loadSingle(sourceBillId, (String)"mdr_saleorder");
        if (SysParamsUtil.isDispatch()) {
            DispatchOrderHandler.reHandleSaleOrderStatus((DynamicObject)saleorder);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleorder});
        if (DynamicObjectUtils.isNewCreate((DynamicObject)order)) {
            this.setTransportamount(order, saleorder, saleOrderTamountMap);
        }
    }

    private void setTransportamount(DynamicObject order, DynamicObject saleorder, Map<Object, BigDecimal> saleOrderTamountMap) {
        BigDecimal saleOrderTamount = saleorder.getBigDecimal("transportamount");
        BigDecimal dpOrderTamount = order.getBigDecimal("transportamount");
        if (saleOrderTamount != null && saleOrderTamount.compareTo(BigDecimal.ZERO) > 0 && (dpOrderTamount == null || BigDecimal.ZERO.compareTo(dpOrderTamount) >= 0)) {
            Object sourceBillId = saleorder.get("id");
            BigDecimal disOrdertotalqty = order.getBigDecimal("totalqty");
            BigDecimal saleOrderTotalqty = saleorder.getBigDecimal("totalqty");
            if (saleOrderTotalqty.compareTo(BigDecimal.ZERO) > 0 && saleOrderTamount.compareTo(BigDecimal.ZERO) > 0) {
                if (SaleOrderStatus.PART_DISPATCH.getFlagStr().equals(saleorder.get("orderstatus"))) {
                    dpOrderTamount = disOrdertotalqty.divide(saleOrderTotalqty, 2, 4).multiply(saleOrderTamount).setScale(2, 4);
                    order.set("transportamount", (Object)dpOrderTamount);
                    BigDecimal saleOrderTamountTemp = saleOrderTamountMap.get(sourceBillId);
                    saleOrderTamountTemp = saleOrderTamountTemp != null ? saleOrderTamountTemp.add(dpOrderTamount) : dpOrderTamount;
                    saleOrderTamountMap.put(sourceBillId, saleOrderTamountTemp);
                } else if (SaleOrderStatus.DISPATCHED.getFlagStr().equals(saleorder.get("orderstatus"))) {
                    BigDecimal saleOrderTamountTemp;
                    QFilter qfilter = new QFilter("itementry.sourcebillid", "=", sourceBillId);
                    DynamicObject[] dispatchInfos = BusinessDataServiceHelper.load((String)"mdr_dispatch_order", (String)"transportamount", (QFilter[])qfilter.toArray());
                    BigDecimal transportamountsum = BigDecimal.ZERO;
                    if (dispatchInfos != null && dispatchInfos.length > 0) {
                        for (DynamicObject dispatchInfo : dispatchInfos) {
                            BigDecimal transportamount = dispatchInfo.getBigDecimal("transportamount");
                            if (transportamount == null || transportamount.compareTo(BigDecimal.ZERO) <= 0) continue;
                            transportamountsum = transportamountsum.add(transportamount);
                        }
                    }
                    if ((saleOrderTamountTemp = saleOrderTamountMap.get(sourceBillId)) != null) {
                        transportamountsum = transportamountsum.add(saleOrderTamountTemp);
                        saleOrderTamountMap.put(sourceBillId, saleOrderTamount);
                    }
                    dpOrderTamount = saleOrderTamount.subtract(transportamountsum);
                    order.set("transportamount", (Object)dpOrderTamount);
                }
            }
        }
    }

    private void unWriteQty4Delete(Map<Object, DynamicObject> dispatchorderentryMap, DynamicObjectCollection dispatchorderentrys) {
        Object id = null;
        Object sourceEntryId = null;
        BigDecimal allotenQty = null;
        DynamicObject entry = null;
        DynamicObject cartItem4saleorder = null;
        for (DynamicObject dispatchorderentry : dispatchorderentrys) {
            id = dispatchorderentry.get("id");
            if (CollectionUtils.isEmpty(dispatchorderentryMap) || null == (entry = dispatchorderentryMap.get(id))) continue;
            sourceEntryId = entry.get("sourceentryid");
            BigDecimal qty = entry.getBigDecimal("qty");
            cartItem4saleorder = BusinessDataServiceHelper.loadSingle((Object)sourceEntryId, (String)"mdr_saleorder_entry");
            allotenQty = cartItem4saleorder.getBigDecimal("allotenqty");
            cartItem4saleorder.set("allotenqty", (Object)allotenQty.subtract(qty));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cartItem4saleorder});
        }
    }

    private void updateSaleOrderByAleter(DynamicObject order) {
        HashMap<Object, DynamicObject> saleOrderMap = new HashMap<Object, DynamicObject>();
        HashMap<Object, DynamicObject> saleOrderEntryMap = new HashMap<Object, DynamicObject>();
        HashMap<Object, DynamicObject> oldDispatchOrderEntryMap = new HashMap<Object, DynamicObject>();
        DynamicObject oldOrder = BusinessDataServiceHelper.loadSingle((Object)order.get("id"), (String)"mdr_dispatch_order");
        DynamicObjectCollection oldOrderEntrys = oldOrder.getDynamicObjectCollection("itementry");
        for (DynamicObject orderEntry : oldOrderEntrys) {
            oldDispatchOrderEntryMap.put(orderEntry.get("id"), orderEntry);
        }
        DynamicObjectCollection orderEntrys = order.getDynamicObjectCollection("itementry");
        for (DynamicObject orderEntry : orderEntrys) {
            this.alterSaleOrderEntry(saleOrderMap, saleOrderEntryMap, oldDispatchOrderEntryMap, orderEntry);
        }
        for (DynamicObject saleOrder : saleOrderMap.values()) {
            saleOrder.set("orderstatus", (Object)SaleOrderStatus.CHANGING.getFlagStr());
            saleOrder.set("operateremark", (Object)ResManager.loadKDString((String)"EAS\u53d8\u66f4\u540c\u6b65\u914d\u8d27\u8ba2\u5355\uff0c\u9500\u552e\u8ba2\u5355", (String)"DispatchOrderSavePlugin_3", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            OperationUtil.invokeOperation((DynamicObject)saleOrder, (String)"save");
        }
    }

    private void alterSaleOrderEntry(Map<Object, DynamicObject> saleOrderMap, Map<Object, DynamicObject> saleOrderEntryMap, Map<Object, DynamicObject> oldDispatchOrderEntryMap, DynamicObject orderEntry) {
        BigDecimal newAmount;
        BigDecimal oldAmount;
        BigDecimal amount;
        BigDecimal newQty;
        BigDecimal oldQty;
        BigDecimal qty;
        Object saleOrderId = orderEntry.get("sourcebillid");
        DynamicObject saleOrder = saleOrderMap.get(saleOrderId);
        if (saleOrder == null) {
            saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)"mdr_purorder");
            if (saleOrder == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u9500\u552e\u8ba2\u5355\u5931\u8d25\uff0c\u83b7\u53d6\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"DispatchOrderSavePlugin_4", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            saleOrderMap.put(saleOrderId, saleOrder);
            DynamicObjectCollection saleOrderEntrys = saleOrder.getDynamicObjectCollection("itementry");
            saleOrderEntryMap.putAll(CommonUtils.collection2Map((String)"id", (List)saleOrderEntrys));
        }
        DynamicObject saleOrderEntry = saleOrderEntryMap.get(orderEntry.getLong("sourceentryid"));
        DynamicObject oldOrderEntry = oldDispatchOrderEntryMap.get(orderEntry.get("id"));
        if (orderEntry.get("qty") != null) {
            qty = saleOrderEntry.getBigDecimal("qty");
            oldQty = oldOrderEntry.getBigDecimal("qty");
            newQty = orderEntry.getBigDecimal("qty");
            qty = this.alterBigDecimal(qty, oldQty, newQty);
            saleOrderEntry.set("qty", (Object)qty);
            saleOrderEntry.set("allotedqty", (Object)qty);
            saleOrderEntry.set("allotenqty", (Object)qty);
        }
        if (orderEntry.get("alreadyreceqty") != null) {
            qty = saleOrderEntry.getBigDecimal("alreadyreceqty");
            oldQty = oldOrderEntry.getBigDecimal("alreadyreceqty");
            newQty = orderEntry.getBigDecimal("alreadyreceqty");
            qty = this.alterBigDecimal(qty, oldQty, newQty);
            saleOrderEntry.set("alreadyreceqty", (Object)qty);
        }
        if (orderEntry.get("orderamount") != null) {
            amount = saleOrderEntry.getBigDecimal("orderamount");
            oldAmount = oldOrderEntry.getBigDecimal("orderamount");
            newAmount = orderEntry.getBigDecimal("orderamount");
            amount = this.alterBigDecimal(amount, oldAmount, newAmount);
            saleOrderEntry.set("orderamount", orderEntry.get("orderamount"));
        }
        if (orderEntry.get("alreadyreceamount") != null) {
            amount = saleOrderEntry.getBigDecimal("alreadyreceamount");
            oldAmount = oldOrderEntry.getBigDecimal("alreadyreceamount");
            newAmount = orderEntry.getBigDecimal("alreadyreceamount");
            amount = this.alterBigDecimal(amount, oldAmount, newAmount);
            saleOrderEntry.set("alreadyreceamount", (Object)amount);
        }
        if (orderEntry.get("entryconfirmarrivaldate") != null) {
            saleOrderEntry.set("entryconfirmarrivaldate", orderEntry.get("entryconfirmarrivaldate"));
        }
    }

    private BigDecimal alterBigDecimal(BigDecimal value, BigDecimal oldValue, BigDecimal newValue) {
        if (oldValue != null) {
            value = value.subtract(oldValue);
        }
        if (newValue != null) {
            value = value.add(newValue);
        }
        return value;
    }

    private void handleSubmit(DynamicObject[] datas) {
        this.isOpenEasSync = SysParamsUtil.isOpenEasSync();
        int len = datas.length;
        for (int i = 0; i < len; ++i) {
            DispatchOrderUtil.handleStoreForward((DynamicObject)datas[i]);
            datas[i].set("orderstatus", (Object)DispatchOrderStatus.SUBMITTED.getFlagStr());
            if (this.isOpenEasSync && "dispatchorder".equals(SysParamsUtil.getTosyncbill())) {
                datas[i].set("sync", (Object)DispatchOrderSyncStatus.NOT_SYNC.getFlagStr());
            }
            this.unWriteQty4SaveAndSubmit(datas[i]);
        }
    }

    private void handleAudit(DynamicObject[] datas) {
        this.isAuditThenSync = SysParamsUtil.isAuditThenSync();
        this.isOpenEasSync = SysParamsUtil.isOpenEasSync();
        int len = datas.length;
        for (int i = 0; i < len; ++i) {
            DispatchOrderUtil.handleStoreForward((DynamicObject)datas[i]);
            datas[i].set("orderstatus", (Object)DispatchOrderStatus.PENDING_DELIVERY.getFlagStr());
            this.unWriteQty4SaveAndSubmit(datas[i]);
        }
    }

    private void unWriteQty4Audit(DynamicObject data) {
        this.isUnWriteConfirmQty = SysParamsUtil.isUnWriteConfirmQty();
        DynamicObjectCollection entry = data.getDynamicObjectCollection("itementry");
        Object ownerId = data.getDynamicObject("owner").get("id");
        boolean isChange = false;
        BigDecimal qty = null;
        BigDecimal allotedQty = null;
        BigDecimal confirmQty = null;
        Object sourceEntryId = null;
        Object sourceBillId = null;
        DynamicObject cartItem = null;
        for (DynamicObject tow : entry) {
            if (sourceBillId == null) {
                sourceBillId = tow.get("sourcebillid");
            }
            qty = tow.getBigDecimal("qty");
            sourceEntryId = tow.get("sourceentryid");
            cartItem = BusinessDataServiceHelper.loadSingle((Object)sourceEntryId, (String)"mdr_saleorder_entry");
            allotedQty = cartItem.getBigDecimal("allotedqty");
            confirmQty = cartItem.getBigDecimal("qty");
            qty = allotedQty.add(qty);
            BigDecimal dValue = BigDecimal.ZERO;
            if (this.isUnWriteConfirmQty && qty.compareTo(confirmQty) > 0) {
                cartItem.set("qty", (Object)qty);
                isChange = true;
            }
            cartItem.set("allotedqty", (Object)qty);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cartItem});
        }
        DynamicObject order = BusinessDataServiceHelper.loadSingle(sourceBillId, (String)"mdr_saleorder");
        if (isChange) {
            // empty if block
        }
        if (SysParamsUtil.isDispatch()) {
            DispatchOrderHandler.reHandleSaleOrderStatus((DynamicObject)order);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{order});
    }
}

