/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.dispatchorder;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.drp.mdr.common.model.SynResult;
import kd.drp.mdr.common.status.DispatchOrderStatus;
import kd.drp.mdr.common.status.DispatchOrderSyncStatus;
import kd.drp.mdr.common.util.SynDispatchOrderUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class DispatchOrderSyncPlugin
extends MdrBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("orderstatus");
        fieldKeys.add("sync");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String opString = e.getOperationKey();
        if (!SysParamsUtil.isOpenEasSync()) {
            throw new KDBizException(ResManager.loadKDString((String)"\"EAS\"\u540c\u6b65\u53c2\u6570\u672a\u5f00\u542f\uff0c\u8bf7\u5f00\u542f\u540e\u91cd\u8bd5", (String)"DispatchOrderSyncPlugin_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        switch (opString) {
            case "tosync": {
                this.syncCheckOrder(e);
                break;
            }
            case "cancelsync": {
                this.cancelSyncCheckOrder(e);
            }
        }
    }

    private void cancelSyncCheckOrder(BeforeOperationArgs e) {
        DynamicObject[] datas;
        for (DynamicObject data : datas = e.getDataEntities()) {
            String orderstatus = data.getString("orderstatus");
            String sync = data.getString("sync");
            if (DispatchOrderStatus.PENDING_DELIVERY.getFlagStr().equals(orderstatus) && DispatchOrderSyncStatus.ALREADY_SYNC.getFlagStr().equals(sync)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u5f85\u53d1\u8d27\u4e14\u5df2\u540c\u6b65\u5355\u636e\u624d\u80fd\u53d6\u6d88\u540c\u6b65\uff01", (String)"DispatchOrderSyncPlugin_1", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
    }

    private void syncCheckOrder(BeforeOperationArgs e) {
        DynamicObject[] datas;
        for (DynamicObject data : datas = e.getDataEntities()) {
            if (!"dispatchorder".equals(SysParamsUtil.getTosyncbill())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u540c\u6b65\u5355\u636e\u4e0d\u4e3a\u914d\u8d27\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u4ece\u914d\u8d27\u8ba2\u5355\u540c\u6b65\u6570\u636e\uff01", (String)"DispatchOrderSyncPlugin_2", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            String orderstatus = data.getString("orderstatus");
            String sync = data.getString("sync");
            if (DispatchOrderStatus.PENDING_DELIVERY.getFlagStr().equals(orderstatus) && DispatchOrderSyncStatus.NOT_SYNC.getFlagStr().equals(sync)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u72b6\u6001\u4e14\u5f85\u540c\u6b65\u8ba2\u5355\u624d\u80fd\u540c\u6b65\uff01", (String)"DispatchOrderSyncPlugin_3", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String opString;
        DynamicObject[] datas = e.getDataEntities();
        switch (opString = e.getOperationKey()) {
            case "tosync": {
                this.syncOrder(datas, e);
                break;
            }
            case "cancelsync": {
                this.cancelSync(datas);
            }
        }
    }

    private void syncOrder(DynamicObject[] datas, BeginOperationTransactionArgs e) {
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        for (int i = 0; i < datas.length; ++i) {
            Object orderId = datas[i].getPkValue();
            SynResult result = SynDispatchOrderUtil.SynSaleOrder((Object)orderId);
            if (!result.isSuccess()) {
                this.operationResult.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", datas[i].getPkValue(), i, 0, "500", ResManager.loadKDString((String)" \u540c\u6b65EAS ", (String)"DispatchOrderSyncPlugin_4", (String)"drp-bbc-opplugin", (Object[])new Object[0]), datas[i].getString("billno") + ":" + result.getMsg(), ErrorLevel.Error));
            } else {
                successObjs.add(datas[i]);
            }
            e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
        }
    }

    private void cancelSync(DynamicObject[] datas) {
        for (int i = 0; i < datas.length; ++i) {
            Object orderId = datas[i].getPkValue();
            SynResult result = SynDispatchOrderUtil.CancelSynOrder((Object)orderId);
            if (result.isSuccess()) continue;
            throw new KDBizException(result.getMsg());
        }
    }
}

